<?php

class Model_Stores_Purchase_Elements_Returned extends ORM {

    protected $_table_name = 'stores_purchase_elements_returned';
    protected $_belongs_to = array(
        'Stores_Purchase_Element' => array('model' => 'Stores_Purchase_Elements', 'foreign_key' => 'element'),
        'Created_BY' => array('model' => 'User', 'foreign_key' => 'Created_by'),
    );
    protected $_has_many = array(
    );

    public function rules() {
        //Check _belongs_to if exist
        $Auto_arr = array();
        $belongs_to = $this->_belongs_to;
        foreach ($belongs_to as $key => $value) {
            if (!empty($value['model']) && !empty($value['foreign_key'])) {
                $Auto_arr[$value['foreign_key']] = array(
                    array('Model_Rules::CheckLoaded', array($value['model'], ':field', ':validation', ':value')),
                );
            }
        }
        //End Check _belongs_to if exist
        $A = array_merge_recursive($Auto_arr, array(
            'element' => array(
                array('not_empty'),
            ),
            'returned_date' => array(
                array('date'),
            ),
            'quantity' => array(
                array('not_empty'),
                array('numeric'),
                array('Model_Rules::positive_number_nonzero', array(':field', ':validation', ':value')),
                array('Model_Stores_Purchase_Elements_Returned::CheckAvaliableQty', array(':field', ':validation', ':value', ':model')),
            ),
        ));
        return $A;
    }

    /*
     * return array of errors
     * or return true if no errors
     */

    public function CheckDeleteRules() {
        $This_ORM = $this->_object; //array_of_this_orm
        $errors = array();

        if ((!$this->_loaded) || !empty($This_ORM['is_deleted'])) {
            array_push($errors, Lang::__('Not_found_the_desired_item'));
        } else {
            foreach ($this->_has_many as $key => $value) {
                if ($this->$key->count_all() > 0) {
                    array_push($errors, Lang::__('Unable_to_deletion_because_it_linked_with') . ' ' . Lang::__($key));
                }
            }
        }

        return (!empty($errors)) ? $errors : TRUE;
    }

    public static function CheckLoaded($model, $field, $validation, $id) {
        if (!empty($id)) {
            $R = ORM::factory($model, $id);
            if ($R->loaded()) {
                return TRUE;
            } else {
                $validation->error($field, 'Not_Loaded_In_Database');
            }
        }
    }

    /*
     * لفحص الكمية المتوفرة 
     */

    public static function CheckAvaliableQty($field, $validation, $value, $model) {

        $Avaaliable_quantity = Model_Stores_Purchase_Elements_Returned::CheckAvaliableQuant($model);
        if ($value > $Avaaliable_quantity) {
            $validation->error($field, 'No_quantities_are_available_for_this_item');
        }
    }

    /*
     * لفحص الكمية المعادة 
     */

    public function CheckReturnedQty() {
        $Returned_quantity = 0;
        $Elements_Returned = $this->Stores_Purchase_Element->Elements_Returned->where("id", "!=", $this->id)->where("is_deleted", "=", NULL)->find_all();
        foreach ($Elements_Returned as $value1) {
            $Returned_quantity += $value1->quantity;
        }

        return $Returned_quantity;
    }
    
       /*
     * لفحص الكمية المتوفرة 
     */

    public static function CheckAvaliableQuant($model) {
        $Avaaliable_quantity = $model->Stores_Purchase_Element->quantity;

        $Avaaliable_quantity -= $model->CheckReturnedQty();

        return $Avaaliable_quantity;
    }

}
