<?php

class Model_Stores_Purchase_Elements extends ORM {

    protected $_table_name = 'stores_purchase_elements';
    protected $_belongs_to = array(
        'Purchase' => array('model' => 'Stores_Purchase', 'foreign_key' => 'purchase_number'),
        'Item' => array('model' => 'Stores_Inventory', 'foreign_key' => 'item'),
    );
    protected $_has_many = array(
        'Elements_Returned' => array('model' => 'Stores_Purchase_Elements_Returned', 'foreign_key' => 'element'),
    );

    public function rules() {
        //Check _belongs_to if exist
        $Auto_arr = array();
        $belongs_to = $this->_belongs_to;
        foreach ($belongs_to as $key => $value) {
            if (!empty($value['model']) && !empty($value['foreign_key'])) {
                $Auto_arr[$value['foreign_key']] = array(
                    array('Model_Rules::CheckLoaded', array($value['model'], ':field', ':validation', ':value')),
                );
            }
        }
        //End Check _belongs_to if exist
        $A = array_merge_recursive($Auto_arr, array(
            'item' => array(
                array('not_empty'),
            ),
            'purchase_number' => array(
                array('not_empty'),
            ),
            'quantity' => array(
                array('not_empty'),
                array('Model_Rules::positive_number', array(':field', ':validation', ':value')),
            ),
        ));
        return $A;
    }

    /*
     * return array of errors
     * or return true if no errors
     */

    public function CheckDeleteRules() {
        $This_ORM = $this->_object; //array_of_this_orm
        $errors = array();

        if ((!$this->_loaded) || !empty($This_ORM['is_deleted'])) {
            array_push($errors, Lang::__('Not_found_the_desired_item'));
        } else {
            foreach ($this->_has_many as $key => $value) {
                if ($this->$key->count_all() > 0) {
                    array_push($errors, Lang::__('Unable_to_deletion_because_it_linked_with') . ' ' . Lang::__($key));
                }
            }
        }

        return (!empty($errors)) ? $errors : TRUE;
    }

    public static function CheckLoaded($model, $field, $validation, $id) {
        if (!empty($id)) {
            $R = ORM::factory($model, $id);
            if ($R->loaded()) {
                return TRUE;
            } else {
                $validation->error($field, 'Not_Loaded_In_Database');
            }
        }
    }

    /*
     * لفحص الكمية المتوفرة 
     */

    public static function CheckAvaliableQuant($model) {
        $Avaaliable_quantity = $model->quantity;

        $Avaaliable_quantity -= $model->CheckReturnedQty();

        return $Avaaliable_quantity;
    }

    /*
     * لفحص الكمية المعادة 
     */

    public function CheckReturnedQty() {
        $Returned_quantity = 0;
        $Elements_Returned = $this->Elements_Returned->where("is_deleted", "=", NULL)->find_all();
        foreach ($Elements_Returned as $value1) {
            $Returned_quantity += $value1->quantity;
        }

        return $Returned_quantity;
    }

}
