<?php

class Model_Letters_Letters extends ORM {

    protected $_table_name = 'letters';
    protected $_belongs_to = array(
    );
    protected $_has_many = array(
        'Fields' => array('model' => 'Letters_Fields', 'foreign_key' => 'letter'),
        'ApprovalStep' => array('model' => 'Letters_Approvals', 'foreign_key' => 'letter'),
    );
    protected $_has_one = array(
    );

    public function rules() {
        //Check _belongs_to if exist
        $Auto_arr = array();
        $belongs_to = $this->_belongs_to;
        foreach ($belongs_to as $key => $value) {
            if (!empty($value['model']) && !empty($value['foreign_key'])) {
                $Auto_arr[$value['foreign_key']] = array(
                    array('Model_Rules::CheckLoaded', array($value['model'], ':field', ':validation', ':value')),
                );
            }
        }
        //End Check _belongs_to if exist
        return array_merge_recursive($Auto_arr, array(
            'is_active' => array(
                array('not_empty'),
            ),
            'target' => array(
                array('not_empty'),
            ),
            'name_en' => array(
                array('not_empty'),
                array('Model_Rules::englishonly', array(':field', ':validation', ':value')),
                array('max_length', array(':value', 255)),
            ),
            'name_ar' => array(
                array('not_empty'),
                array('Model_Rules::arabiconly', array(':field', ':validation', ':value')),
                array('max_length', array(':value', 255)),
            ),
        ));
    }

    /*
     * نفحص في حال كان هنالك مدير ونائب مدير غير معين لقسم مطلوب
     */

    public function CheckApprovalsStaff($Letter, $User_Online, $Debugging_Mode = FALSE,$lang = 'ar') {
        $Letters_Applications = $Letter;
        $Approval_with_no_d = array();
        $Debugging_Array = array();

        $ApprovalStep = $Letters_Applications->ApprovalStep->order_by('order')->where('is_deleted', '=', NULL)->find_all();
        $deps_array = array();
        foreach ($ApprovalStep as $Approval) {
            if (!empty($Approval->department)) {
                $Department = $Approval->Department;
            } else {
                // في حال كان فارغ يعني ان الموافقة مطلوبة من رئيس قسم الموظف نفسه
                if (empty($User_Online->Employee_Information->id)) {
                    array_push($Approval_with_no_d, $Approval);
                    $Department = NULL;
                } else {
                    $Department = $User_Online->Employee_Information->Department;
                }
            }
            
           
            if (!empty($Department) ) {
                
                $Director = $Department->Director; //المدير في المواقع الوظيفية
                $Deputy_Director = $Department->Deputy_Director; //نائب المدير في المواقع الوظيفية

                if (empty($Director->id) && empty($Deputy_Director->id)) {
                    array_push($Approval_with_no_d, $Approval);
                } else {
                    if (!empty($Director->id)) {
                        //لفحص كم موظف في هذا الموقع الوظيفي
                        $Director_Employee = ORM::factory('Hr_Employment_Applications')->where('hr_position', '=', $Director->id)->where('user_id', '!=', NULL)->where('app_status', '=', 1)->where('is_deleted', '=', NULL)->find_all();
                        $Count_Director_Employee = count($Director_Employee);
                        if ($Count_Director_Employee > 0) {
                            $Names_Of_Head = '';
                            $i = 1;
                            foreach ($Director_Employee as $value) {
                              $Names_Of_Head.= $value->{'name_first_'.$lang}.' '.$value->{'name_father_'.$lang}.' '.$value->{'name_grandfather_'.$lang}.' '.$value->{'name_last_'.$lang};  
                              if($Count_Director_Employee > $i){
                                $Names_Of_Head.= ' '. Lang::__('Or').' ';  
                              }
                              $i++;
                            }
                            array_push($Debugging_Array, $Department->{'name_'.$lang}.' ( '.Lang::__('Director').' ) '.$Names_Of_Head);
                        } else {
                            //ما في اي مدير لهذا القسم
                            array_push($Approval_with_no_d, $Approval);
                        }
                    } elseif (!empty($Deputy_Director->id)) {

                        //لفحص كم موظف في هذا الموقع الوظيفي
                        $Director_Employee = ORM::factory('Hr_Employment_Applications')->where('hr_position', '=', $Deputy_Director->id)->where('user_id', '!=', NULL)->where('app_status', '=', 1)->where('is_deleted', '=', NULL)->find_all();
                        $Count_Director_Employee = count($Director_Employee);
                        if ($Count_Director_Employee > 0) {
                            $Names_Of_Head = '';
                            $i = 1;
                            foreach ($Director_Employee as $value) {
                              $Names_Of_Head.= $value->{'name_first_'.$lang}.' '.$value->{'name_father_'.$lang}.' '.$value->{'name_grandfather_'.$lang}.' '.$value->{'name_last_'.$lang};  
                              if($Count_Director_Employee > $i){
                                $Names_Of_Head.= ' '. Lang::__('Or').' ';  
                              }
                              $i++;
                            }
                            array_push($Debugging_Array, $Department->{'name_'.$lang}.' ( '.Lang::__('Director').' ) '.$Names_Of_Head);
                        } else {
                            //ما في اي نائب مدير لهذا القسم
                            array_push($Approval_with_no_d, $Approval);
                        }
                    }
                }
                array_push($deps_array, $Department->id);
                // print_r($deps_array);
            //echo '<br>';
            }
        }
        
        if($Debugging_Mode){
          return  $Debugging_Array;
        }else{
          return $Approval_with_no_d;  
        }
        
    }

    /*
     * return array of errors
     * or return true if no errors
     */

    public function CheckDeleteRules() {
        $This_ORM = $this->_object; //array_of_this_orm
        $errors = array();

        if ((!$this->_loaded) || !empty($This_ORM['is_deleted'])) {
            array_push($errors, Lang::__('Not_found_the_desired_item'));
        } else {
            foreach ($this->_has_many as $key => $value) {
                if ($this->$key->count_all() > 0) {
                    array_push($errors, Lang::__('Unable_to_deletion_because_it_linked_with') . ' ' . Lang::__($key));
                }
            }
        }

        return (!empty($errors)) ? $errors : TRUE;
    }

    /*
     * Jquery Plugin Rules when admin add/modify row...
     */

    public static function AdminRules($ORM) {

        $RulesJquery = array(
            'is_active' => array(
                'required' => TRUE,
            ),
            'target' => array(
                'required' => TRUE,
            ),
            'name_ar' => array(
                'required' => TRUE,
                'arabiconly' => TRUE,
                'maxlength' => 255,
            ),
            'name_en' => array(
                'required' => TRUE,
                'englishonly' => TRUE,
                'maxlength' => 255,
            ),
        );

        return $RulesJquery;
    }

}
