<?php

class Model_Letters_Applications extends ORM {

    protected $_table_name = 'letters_applications';
    protected $_belongs_to = array(
        'Letter' => array('model' => 'Letters_Letters', 'foreign_key' => 'letter'),
        'Created_User' => array('model' => 'User', 'foreign_key' => 'Created_by'),
    );
    protected $_has_many = array(
        'Letter_Application_Approvals' => array('model' => 'Letters_Applications_Approvals', 'foreign_key' => 'application_id'),
    );
    protected $_has_one = array(
    );

    public function rules() {
        //Check _belongs_to if exist
        $Auto_arr = array();
        $belongs_to = $this->_belongs_to;
        foreach ($belongs_to as $key => $value) {
            if (!empty($value['model']) && !empty($value['foreign_key'])) {
                $Auto_arr[$value['foreign_key']] = array(
                    array('Model_Rules::CheckLoaded', array($value['model'], ':field', ':validation', ':value')),
                );
            }
        }
        //End Check _belongs_to if exist
        return array_merge_recursive($Auto_arr, array(
        ));
    }

    /*
     * بنفحص اذا الطلب موافق عليه من جميع الجهات 
     */

    public function CheckIfApproved() {
        $Approvals_ALL = $this->Letter_Application_Approvals
                ->where('is_deleted', '=', NULL)
                ->count_all();
         $Approvals_Approved = $this->Letter_Application_Approvals
                ->where('is_deleted', '=', NULL)
                ->where('app_status', '=', 1)
                ->count_all();
        if ($Approvals_ALL == $Approvals_Approved) {
            return TRUE;
        }
        
        return FALSE;
    }

    /*
     * return array of errors
     * or return true if no errors
     */

    public function CheckDeleteRules() {
        $This_ORM = $this->_object; //array_of_this_orm
        $errors = array();

        if ((!$this->_loaded) || !empty($This_ORM['is_deleted'])) {
            array_push($errors, Lang::__('Not_found_the_desired_item'));
        } else {
            $CApp = $this->Letter_Application_Approvals
                    ->and_where_open()
                    ->or_where('app_status', '=', 1)
                    ->or_where('app_status', '=', 2)
                    ->and_where_close()
                    ->where('is_deleted', '=', NULL)
                    ->count_all();
            if ($CApp > 0) {
                array_push($errors, Lang::__('Could not delete because element affected'));
            }
//            foreach ($this->_has_many as $key => $value) {
//                if ($this->$key->count_all() > 0) {
//                    array_push($errors, Lang::__('Unable_to_deletion_because_it_linked_with') . ' ' . Lang::__($key));
//                }
//            }
        }

        return (!empty($errors)) ? $errors : TRUE;
    }

    /*
     * Jquery Plugin Rules when admin add/modify row...
     */

    public static function AdminRules($Applications, $Letter, $For_jquery = TRUE) {

        $Fields = $Letter->Fields->where("is_deleted", "=", NULL)->find_all();

        $RulesJquery = array(
        );
        foreach ($Fields as $Field) {
            switch ($Field->type) {
                case 1:
                    $col_name = $Field->col_name;
                    $RulesJquery = array_merge_recursive($RulesJquery, array(
                        $col_name => array(
                            'required' => empty($Field->required) ? FALSE : TRUE,
                            'date' => TRUE,
                        ),
                    ));

                    break;
                case 2:
                    $col_name = $Field->col_name;
                    $RulesJquery = array_merge_recursive($RulesJquery, array(
                        $col_name => array(
                            'required' => empty($Field->required) ? FALSE : TRUE,
                            'maxlength' => 20,
                        ),
                    ));
                    break;
                case 3:
                    $col_name = $Field->col_name;
                    $RulesJquery = array_merge_recursive($RulesJquery, array(
                        $col_name => array(
                            'required' => empty($Field->required) ? FALSE : TRUE,
                            'number' => TRUE,
                        ),
                    ));
                    break;
                case 4:
                    $col_name = $Field->col_name;
                    $RulesJquery = array_merge_recursive($RulesJquery, array(
                        $col_name => array(
                            'required' => empty($Field->required) ? FALSE : TRUE,
                            'maxlength' => 255,
                        ),
                    ));
                    break;
                case 5:
                    $col_name = $Field->col_name;
                    $RulesJquery = array_merge_recursive($RulesJquery, array(
                        $col_name => array(
                            'required' => empty($Field->required) ? FALSE : TRUE,
                        ),
                    ));
                    break;
                case 6:
                    $col_name = $Field->col_name;
                    $RulesJquery = array_merge_recursive($RulesJquery, array(
                        $col_name => array(
                            'required' => empty($Field->required) ? FALSE : TRUE,
                        ),
                    ));
                    break;

                default:
                    break;
            }
        }


        return $RulesJquery;
    }

    /*
     *  نفحص اذا الطلب خاص برؤساء الاقسام فقط
     */

    public function CheckUserApplicationAccess($objj, $Letter, $user) {

        $Departments = ORM::factory('General_Hr_Departments')->where('deleted_by', '=', NULL)->find_all();
        $DPosition = array(); // المناصب الادارية
        foreach ($Departments as $Department) {
            array_push($DPosition, $Department->director); //لاضافة المدير الى قائمة الطلبات
        }

        if ($Letter->loaded() && empty($Letter->is_deleted) && (($objj->loaded()) || ((!$objj->loaded()) && ($Letter->target == 1) || (($Letter->target == 2) && in_array($user->Employee_Information->hr_position, $DPosition))))) {
            return TRUE;
        } else {
            return FALSE;
        }
    }

}
