<?php

class Model_Hr_Fineswarnings extends ORM {

    protected $_table_name = 'hr_fines_warnings';
    protected $_belongs_to = array(
        'Employment_Applications' => array('model' => 'Hr_Employment_Applications', 'foreign_key' => 'employee'),
        'Fine_Type' => array('model' => 'General_Hr_Fines_Types', 'foreign_key' => 'fine_type'),
        'Warning_Type' => array('model' => 'General_Hr_Warnings_Types', 'foreign_key' => 'warning_type'),
        'Approved_By' => array('model' => 'User', 'foreign_key' => 'approved_by'),
    );
    protected $_has_many = array(
        
    );
    protected $_has_one = array(
    );

    public function rules() {
        //Check _belongs_to if exist
        $Auto_arr = array();
        $belongs_to = $this->_belongs_to;
        foreach ($belongs_to as $key => $value) {
            if (!empty($value['model']) && !empty($value['foreign_key'])) {
                $Auto_arr[$value['foreign_key']] = array(
                    array('Model_Rules::CheckLoaded', array($value['model'], ':field', ':validation', ':value')),
                );
            }
        }
        //End Check _belongs_to if exist
        return array_merge_recursive($Auto_arr, array(
            'id' => array(
                array('Model_Hr_Fineswarnings::CheckRequired', array(':field', ':validation', ':value')),
            ),
            'employee' => array(
                array('not_empty'),
                array('Model_Hr_Fineswarnings::is_employee', array(':field', ':validation', ':value')),
            ),
            'fine_type' => array(
                
            ),
            'warning_type' => array(
                
            ),
            'type' => array(
                array('not_empty'),
            ),
            'month' => array(
                array('numeric'),
                array('range', array(':value', 1, 12)),
            ),
            'year' => array(
                array('numeric'),
                array('date'),
            ),
            
        ));
    }

    /*
     * return array of errors
     * or return true if no errors
     */

    public function CheckDeleteRules() {
        $This_ORM = $this->_object; //array_of_this_orm
        $errors = array();

        if ((!$this->_loaded) || !empty($This_ORM['is_deleted'])) {
            array_push($errors, Lang::__('Not_found_the_desired_item'));
        } else {
            foreach ($this->_has_many as $key => $value) {
                if ($this->$key->count_all() > 0) {
                    array_push($errors, Lang::__('Unable_to_deletion_because_it_linked_with') . ' ' . Lang::__($key));
                }
            }
        }

        return (!empty($errors)) ? $errors : TRUE;
    }

    /*
     * Jquery Plugin Rules when admin add/modify row...
     */

    public static function AdminRules($ORM) {

        $RulesJquery = array(
            'employee' => array(
                'required' => TRUE,
            ),
            'type' => array(
                'required' => TRUE,
            ),
            'month' => array(
                'number' => TRUE,
                'range' => [1, 12]
            ),
            'year' => array(
                'number' => TRUE,
                'date' => TRUE,
            ),
            'fine_type' => array(
                'number' => TRUE,
            ),
            'warning_type' => array(
                'number' => TRUE,
            ),
            'reason' => array(
                
            ),
        );

        return $RulesJquery;
    }

    public static function CheckRequired($field, $validation, $id) {
        $data = $validation->data();
        if ($data['type'] == 1 && empty($data['fine_type'])) {
            $validation->error('fine_type', 'Required');
        }
        if ($data['type'] == 1 && !empty($data['warning_type'])) {
            $validation->error('warning_type', 'Must_be_Undefined');
        }
        if ($data['type'] == 2 && empty($data['warning_type'])) {
            $validation->error('warning_type', 'Required');
        }
        if ($data['type'] == 2 && !empty($data['fine_type'])) {
            $validation->error('fine_type', 'Must_be_Undefined');
        }
    }
    public static function is_employee($field, $validation, $id) {
        $data = $validation->data();
        if (!empty($data['employee'])) {
            $Employees = ORM::factory('Hr_Employment_Applications',$data['employee']);
            if(!($Employees->loaded() && ($Employees->app_status == 1) && empty($Employees->is_deleted))){
                $validation->error('employee', 'Not_Loaded_In_Database');
            }

        }
     
    }

}
