<?php

class Model_Financials_Sponsorships extends ORM {

    protected $_table_name = 'financials_sponsorships';
    protected $_belongs_to = array(
        'Term' => array('model' => 'Study_Terms', 'foreign_key' => 'term'),
        'Sponsor' => array('model' => 'Financials_Sponsors', 'foreign_key' => 'sponsor'),
        'Student' => array('model' => 'User', 'foreign_key' => 'student'),
    );
    protected $_has_many = array(
    );

    public function rules() {
        return array(
            'term' => array(
                array('not_empty'),
                array('Model_Financials_Sponsorships::CheckLoaded', array('Study_Terms', ':field', ':validation', ':value')),
            ),
            'sponsor' => array(
                array('not_empty'),
                array('Model_Financials_Sponsorships::CheckLoaded', array('Financials_Sponsors', ':field', ':validation', ':value')),
            ),
            'student' => array(
                array('not_empty'),
                array('Model_Financials_Sponsorships::CheckStudent', array('User', ':field', ':validation', ':value')),
                array('Model_Financials_Sponsorships::CheckExists', array(':field', ':validation', ':value')),
            ),
        );
    }

    /*
     * return array of errors
     * or return true if no errors
     */

    public function CheckDeleteRules() {
        $This_ORM = $this->_object; //array_of_this_orm
        $errors = array();

        if ((!$this->_loaded) || !empty($This_ORM['is_deleted'])) {
            array_push($errors, Lang::__('Not_found_the_desired_item'));
        } else {
            foreach ($this->_has_many as $key => $value) {
                if ($this->$key->count_all() > 0) {
                    array_push($errors, Lang::__('Unable_to_deletion_because_it_linked_with') . ' ' . Lang::__($key));
                }
            }
        }

        return (!empty($errors)) ? $errors : TRUE;
    }

    public static function CheckLoaded($model, $field, $validation, $id) {
        if (!empty($id)) {
            $R = ORM::factory($model, $id);
            if ($R->loaded()) {
                return TRUE;
            } else {
                $validation->error($field, 'Not_Loaded_In_Database');
            }
        }
    }

    public static function CheckStudent($model, $field, $validation, $id) {
        if (!empty($id)) {
            $R = ORM::factory($model, $id);
            if ($R->loaded() && ($R->user_groub == 3)) {
                return TRUE;
            } else {
                $validation->error($field, 'Not_Loaded_In_Database');
            }
        }
    }

    public static function CheckExists($field, $validation, $id) {
        $data = $validation->data();
        $Orm = ORM::factory('Financials_Sponsorships')
                ->where('student', '=', $data['student'])
                ->where('term', '=', $data['term'])
                ->find();
        if ($Orm->loaded() && ($data['id'] != $Orm->id)) {
            $validation->error($field, 'Has_Sponsorships_Current_Term');
        }
    }

}
