<?php

class Model_Financials_Manminpayment_Custom extends ORM {

    protected $_table_name = 'financials_mandatory_min_payment_custom';
    protected $_belongs_to = array(
        'Term' => array('model' => 'Study_Terms', 'foreign_key' => 'term'),
        'Student' => array('model' => 'User', 'foreign_key' => 'student'),
    );
    protected $_has_many = array(
    );

    public function rules() {
        return array(
            'student' => array(
                array('not_empty'),
                array('Model_Financials_Manminpayment_Custom::CheckStudent', array('User', ':field', ':validation', ':value')),
            ),
            'term' => array(
                array('not_empty'),
                array('Model_Financials_Manminpayment_Custom::CheckLoaded', array('Study_Terms', ':field', ':validation', ':value')),
            ),
            'mandatory_percent' => array(
                array('not_empty'),
                array('numeric'),
            ),
            'due_period_days' => array(
                array('not_empty'),
                array('numeric'),
            ),
        );
    }

    /*
     * return array of errors
     * or return true if no errors
     */

    public function CheckDeleteRules() {
        $This_ORM = $this->_object; //array_of_this_orm
        $errors = array();

        if ((!$this->_loaded) || !empty($This_ORM['is_deleted'])) {
            array_push($errors, Lang::__('Not_found_the_desired_item'));
        } else {
            foreach ($this->_has_many as $key => $value) {
                if ($this->$key->count_all() > 0) {
                    array_push($errors, Lang::__('Unable_to_deletion_because_it_linked_with') . ' ' . Lang::__($key));
                }
            }
        }

        return (!empty($errors)) ? $errors : TRUE;
    }

    public static function CheckLoaded($model, $field, $validation, $id) {
        if (!empty($id)) {
            $R = ORM::factory($model, $id);
            if ($R->loaded()) {
                return TRUE;
            } else {
                $validation->error($field, 'Not_Loaded_In_Database');
            }
        }
    }

    public static function CheckStudent($model, $field, $validation, $id) {
        if (!empty($id)) {
            $R = ORM::factory($model, $id);
            if ($R->loaded() && ($R->user_groub == 3)) {
                return TRUE;
            } else {
                $validation->error($field, 'Not_Loaded_In_Database');
            }
        }
    }

}
