<?php

class Model_Financials_Manminpayment extends ORM {

    protected $_table_name = 'financials_mandatory_min_payment';
    protected $_belongs_to = array(
        'Major' => array('model' => 'Study_Majors', 'foreign_key' => 'major'),
        'Term' => array('model' => 'Study_Terms', 'foreign_key' => 'term'),
        'Degree' => array('model' => 'Study_Degrees', 'foreign_key' => 'degree'),
    );
    protected $_has_many = array(
    );

    public function rules() {
        return array(
            'degree' => array(
                //array('not_empty'),
                array('Model_Financials_Discounts::CheckLoaded', array('Study_Degrees', ':field', ':validation', ':value')),
            ),
            'major' => array(
                //array('not_empty'),
                array('Model_Financials_Discounts::CheckLoaded', array('Study_Majors', ':field', ':validation', ':value')),
            ),
            'term' => array(
                array('not_empty'),
                array('Model_Financials_Discounts::CheckLoaded', array('Study_Terms', ':field', ':validation', ':value')),
            ),
            'mandatory_percent' => array(
                array('not_empty'),
                array('numeric'),
            ),
            'due_period_days' => array(
                array('not_empty'),
                array('numeric'),
            ),
        );
    }

    /*
     * return array of errors
     * or return true if no errors
     */

    public function CheckDeleteRules() {
        $This_ORM = $this->_object; //array_of_this_orm
        $errors = array();

        if ((!$this->_loaded) || !empty($This_ORM['is_deleted'])) {
            array_push($errors, Lang::__('Not_found_the_desired_item'));
        } else {
            foreach ($this->_has_many as $key => $value) {
                if ($this->$key->count_all() > 0) {
                    array_push($errors, Lang::__('Unable_to_deletion_because_it_linked_with') . ' ' . Lang::__($key));
                }
            }
        }

        return (!empty($errors)) ? $errors : TRUE;
    }

    public static function CheckLoaded($model, $field, $validation, $id) {
        if (!empty($id)) {
            $R = ORM::factory($model, $id);
            if ($R->loaded()) {
                return TRUE;
            } else {
                $validation->error($field, 'Not_Loaded_In_Database');
            }
        }
    }

}
