<?php

class Model_Financials_Discount_Students extends ORM {

    protected $_table_name = 'financials_discount_students';
    protected $_belongs_to = array(
        'Term' => array('model' => 'Study_Terms', 'foreign_key' => 'term'),
        'Student' => array('model' => 'User', 'foreign_key' => 'student'),
    );
    protected $_has_many = array(
    );

    public function rules() {
        return array(
            'student' => array(
                array('not_empty'),
                array('Model_Financials_Discount_Students::CheckStudent', array('User', ':field', ':validation', ':value')),
                array('Model_Financials_Discount_Students::CheckRelExists', array(':field', ':validation', ':value')),
                array('Model_Financials_Discount_Students::OneOfTow', array(':field', ':validation', ':value')),
            ),
            'term' => array(
                array('not_empty'),
                array('Model_Financials_Discount_Students::CheckLoaded', array('Study_Terms', ':field', ':validation', ':value')),
            ),
            'percent' => array(
                array('numeric'),
            ),
            'amount' => array(
                array('numeric'),
            ),
        );
    }

    /*
     * return array of errors
     * or return true if no errors
     */

    public function CheckDeleteRules() {
        $This_ORM = $this->_object; //array_of_this_orm
        $errors = array();

        if ((!$this->_loaded) || !empty($This_ORM['is_deleted'])) {
            array_push($errors, Lang::__('Not_found_the_desired_item'));
        } else {
            foreach ($this->_has_many as $key => $value) {
                if ($this->$key->count_all() > 0) {
                    array_push($errors, Lang::__('Unable_to_deletion_because_it_linked_with') . ' ' . Lang::__($key));
                }
            }
        }

        return (!empty($errors)) ? $errors : TRUE;
    }

    public static function CheckLoaded($model, $field, $validation, $id) {
        if (!empty($id)) {
            $R = ORM::factory($model, $id);
            if ($R->loaded()) {
                return TRUE;
            } else {
                $validation->error($field, 'Not_Loaded_In_Database');
            }
        }
    }

    public static function OneOfTow($field, $validation, $id) {
        $data = $validation->data();
        if (empty($data['percent']) && empty($data['amount'])) {
            $validation->error($field, 'You_must_specify_either_percentage_or_amount');
        }
        if (!empty($data['percent']) && !empty($data['amount'])) {
            $validation->error($field, 'You_must_specify_either_percentage_or_amount');
        }
    }

    public static function CheckRelExists($field, $validation, $id) {
        $data = $validation->data();
        $R = ORM::factory('Financials_Discount_Students')
                ->where('student', '=', $data['student'])
                ->where('term', '=', $data['term'])
                ->find()
        ;
        if ($R->loaded() && ($R->id != $data['id'])) {
            $validation->error($field, 'Student_Term_Discount_Exists');
        }
    }

    /*
     * لفحص اذا كان طالب ام لأ
     */

    public static function CheckStudent($model, $field, $validation, $id) {
        if (!empty($id)) {
            $R = ORM::factory($model, $id);
            if ($R->loaded() && ($R->user_groub == 3)) {
                return TRUE;
            } else {
                $validation->error($field, 'Not_Loaded_In_Database');
            }
        }
    }

}
