<?php

class Model_Community_Request_db extends ORM {

    protected $_table_name = 'community_service';

   
    public function rules() {
        return array(
            'first_name_ar' => array(
                array('not_empty'),
                array('Model_Rules::arabiconly', array(':field', ':validation', ':value')),
            ),
            'first_name_en' => array(
                array('not_empty'),
                array('Model_Rules::englishonly', array(':field', ':validation', ':value')),
            ),
            'father_name_ar' => array(
                array('not_empty'),
                array('Model_Rules::arabiconly', array(':field', ':validation', ':value')),
            ),
            'father_name_en' => array(
                array('not_empty'),
                array('Model_Rules::englishonly', array(':field', ':validation', ':value')),
            ),
            'grand_father_name_ar' => array(
                array('not_empty'),
                array('Model_Rules::arabiconly', array(':field', ':validation', ':value')),
            ),
           'grand_father_name_en' => array(
                array('not_empty'),
               array('Model_Rules::englishonly', array(':field', ':validation', ':value')),
            ),
            'last_name_ar' => array(
                array('not_empty'),
                array('Model_Rules::arabiconly', array(':field', ':validation', ':value')),
            ),
            'last_name_en' => array(
                array('not_empty'),
                array('Model_Rules::englishonly', array(':field', ':validation', ':value')),
            ),
            'email' => array(
                array('not_empty'),
            ),
            'jobtitle' => array(
                array('not_empty'),
            ),
            
        );
    }
public function CheckDeleteRules() {
        $This_ORM = $this->_object; //array_of_this_orm
        $errors = array();


        if ( (!$this->_loaded) || !empty($This_ORM['is_deleted'])){
            array_push($errors, Lang::__('Not_found_the_desired_item'));
        } else {
            foreach ($this->_has_many as $key => $value) {
                if ($this->$key->count_all() > 0) {
                    array_push($errors, Lang::__('Unable_to_deletion_because_it_linked_with') . ' ' . Lang::__($key));
                }
            }
            
        }

        return (!empty($errors)) ? $errors : TRUE;
    }
    public static function AdminRules($ORM) {

        $RulesJquery = array(
            'first_name_en' => array(
                'required' => TRUE,
                'englishonly' => TRUE,
                'maxlength' => 255,
            ),
            'father_name_en' => array(
                'required' => TRUE,
                'englishonly' => TRUE,
                'maxlength' => 255,
            ),
            'grand_father_name_en' => array(
                'required' => TRUE,
                'englishonly' => TRUE,
                'maxlength' => 255,
            ),
            'last_name_en' => array(
                'required' => TRUE,
                'englishonly' => TRUE,
                'maxlength' => 255,
            ),
            'first_name_ar' => array(
                'required' => TRUE,
                'arabiconly' => TRUE,
                'maxlength' => 255,
            ),
            'father_name_ar' => array(
                'required' => TRUE,
                'arabiconly' => TRUE,
                'maxlength' => 255,
            ),
            'grand_father_name_ar' => array(
                'required' => TRUE,
                'arabiconly' => TRUE,
                'maxlength' => 255,
            ),
            'last_name_ar' => array(
                'required' => TRUE,
                'arabiconly' => TRUE,
                'maxlength' => 255,
            ),
            'mobile' => array(
                'required' => TRUE,
                'number' => TRUE,
                'minlength' => 12,
                'maxlength' => 12,
            ),
            'email' => array(
                'required' => TRUE,
                'email' => TRUE,
            ),
            'gender' => array(
                'required' => TRUE,
                'number' => TRUE,
            ),
                       
            'jobtitle' => array(
                'required' => TRUE,
                'maxlength' => 200,
            ),
            'course' => array(
                'required' => TRUE,
                
            ),
        );

        return $RulesJquery;
    }
}
