<?php

defined('SYSPATH') OR die('No direct access allowed.');

/**
 * Default auth user
 *
 * @package    Kohana/Auth
 * @author     Kohana Team
 * @copyright  (c) 2007-2012 Kohana Team
 * @license    http://kohanaframework.org/license
 */
class Model_Auth_User extends ORM {

    /**
     * A user has many tokens and roles
     *
     * @var array Relationhips
     */
    protected $_has_many = array(
        'user_tokens' => array('model' => 'User_Token'),
        'roles' => array('model' => 'Role', 'through' => 'roles_users'),
        'Permissions_Usersrelations' => array('model' => 'Permissions_Usersrelations', 'foreign_key' => 'user'),
        'Permissions_Relations' => array(
            'model' => 'Permissions_Relations',
            'through' => 'permissions_groups_users_relations',
            'far_key' => 'groub',
            'foreign_key' => 'user',
        ),
        'Student_Terms' => array('model' => 'Students_Terms', 'foreign_key' => 'student'),
    );
    protected $_belongs_to = array(
        'User_Groub' => array('model' => 'Usersgroub', 'foreign_key' => 'user_groub'),
        'Creater' => array('model' => 'User', 'foreign_key' => 'Created_by')
    );
    protected $_has_one = array(
        'Student_Information' => array('model' => 'Students_Applications', 'foreign_key' => 'student_id',),
        'Employee_Information' => array('model' => 'Hr_Employment_Applications', 'foreign_key' => 'user_id',)
    );

    public function GetName($lang = 'ar') {
        if(!empty($this->Employee_Information)){
            return $this->Employee_Information->GetFullName($lang);
        }elseif (!empty($this->Student_Information)){
            return $this->Student_Information->FullName($lang);
        }else{
            return $this->{"name_".$lang};
        }
    }

    /**
     * Rules for the user model. Because the password is _always_ a hash
     * when it's set,you need to run an additional not_empty rule in your controller
     * to make sure you didn't hash an empty string. The password rules
     * should be enforced outside the model or with a model helper method.
     *
     * @return array Rules
     */
    public function rules() {
        return array(
            'username' => array(
                array('not_empty'),
                array('max_length', array(':value', 255)),
                array(array($this, 'unique'), array('username', ':value')),
            ),
            'password' => array(
                array('not_empty'),
            ),
            'user_groub' => array(
                array('not_empty'),
            ),
            'email' => array(
            //array('not_empty'),
            //array('email'),
            //array('email_domain'),
            //array(array($this, 'unique'), array('email', ':value')),
            ),
        );
    }

    /**
     * Filters to run when data is set in this model. The password filter
     * automatically hashes the password when it's set in the model.
     *
     * @return array Filters
     */
    public function filters() {
        return array(
            'password' => array(
                array(array(Auth::instance(), 'hash'))
            )
        );
    }

    /**
     * Labels for fields in this model
     *
     * @return array Labels
     */
    public function labels() {
        return array(
            'username' => 'username',
            'email' => 'email address',
            'password' => 'password',
        );
    }

    /**
     * Complete the login for a user by incrementing the logins and saving login timestamp
     *
     * @return void
     */
    public function complete_login() {
        if ($this->_loaded) {
            // Update the number of logins
            $this->logins = new Database_Expression('logins + 1');

            // Set the last login date
            $this->last_login = date("Y-m-d H:i:s");

            // Save the user
            $this->update();
        }
    }

    /**
     * Tests if a unique key value exists in the database.
     *
     * @param   mixed    the value to test
     * @param   string   field name
     * @return  boolean
     */
    public function unique_key_exists($value, $field = NULL) {
        if ($field === NULL) {
            // Automatically determine field by looking at the value
            $field = $this->unique_key($value);
        }

        return (bool) DB::select(array(DB::expr('COUNT(*)'), 'total_count'))
                        ->from($this->_table_name)
                        ->where($field, '=', $value)
                        ->where($this->_primary_key, '!=', $this->pk())
                        ->execute($this->_db)
                        ->get('total_count');
    }

    /**
     * Allows a model use both email and username as unique identifiers for login
     *
     * @param   string  unique value
     * @return  string  field name
     */
    public function unique_key($value) {
        return Valid::email($value) ? 'email' : 'username';
    }

    /**
     * Password validation for plain passwords.
     *
     * @param array $values
     * @return Validation
     */
    public static function get_password_validation($values) {
        return Validation::factory($values)
        //->rule('password', 'min_length', array(':value', 8))
        //->rule('password_confirm', 'matches', array(':validation', ':field', 'password'))
        ;
    }

    /**
     * Create a new user
     *
     * Example usage:
     * ~~~
     * $user = ORM::factory('User')->create_user($_POST, array(
     * 	'username',
     * 	'password',
     * 	'email',
     * );
     * ~~~
     *
     * @param array $values
     * @param array $expected
     * @throws ORM_Validation_Exception
     */
    public function create_user($values, $expected) {
        // Validation for passwords
        $extra_validation = Model_User::get_password_validation($values)
                ->rule('password', 'not_empty');

        return $this->values($values, $expected)->create($extra_validation);
    }

    /**
     * Update an existing user
     *
     * [!!] We make the assumption that if a user does not supply a password, that they do not wish to update their password.
     *
     * Example usage:
     * ~~~
     * $user = ORM::factory('User')
     * 	->where('username', '=', 'kiall')
     * 	->find()
     * 	->update_user($_POST, array(
     * 		'username',
     * 		'password',
     * 		'email',
     * 	);
     * ~~~
     *
     * @param array $values
     * @param array $expected
     * @throws ORM_Validation_Exception
     */
    public function update_user($values, $expected = NULL) {
        if (empty($values['password'])) {
            unset($values['password'], $values['password_confirm']);
        }

        // Validation for passwords
        $extra_validation = Model_User::get_password_validation($values);

        return $this->values($values, $expected)->update($extra_validation);
    }

    public function hasRole($alias, $far_keys = NULL) {
        //If user is admin reture true
        if ($this->user_groub == 1) {
            return TRUE;
        } else {
            //check direct role
            if ($this->has($alias, $far_keys)) {
                return TRUE;
            } else {
                //check groub roles
                $User_Groubs = $this->Permissions_Usersrelations->find_all();
                foreach ($User_Groubs as $User_Groub_Relation) {
                    if ($User_Groub_Relation->Groub->has('Roles', ORM::factory('Role', $far_keys))) {
                        return TRUE;
                    }
                }
            }
        }
    }

    /*
     * return true if user is teacher
     */

    public function IsTeacher() {
        //If user is admin reture true
        if ($this->user_groub == 4) {
            return TRUE;
        } else {
            if (!empty($this->Employee_Information->Employee_Type->is_teacher)) {
                return TRUE;
            }
        }

        return FALSE;
    }
    
    /*
     * return true if user is Girl
     */

    public function IsGirl() {
        //If user is admin reture true
        $is_girl = false;
        if ($this->Student_Information->Gender == 2) {
            $is_girl = TRUE;
        } elseif ($this->Employee_Information->gender == 2) {
           $is_girl = TRUE;
        }

        return $is_girl;
    }
    
      public static function GetAllTeachers() {
        $R = ORM::factory('User')->where('user_groub', 'IN', array(2,4,5))->where('is_deleted', '=', NULL)->find_all();
        $Teachers = array();
        foreach ($R as $user) {
            if($user->IsTeacher()){
                array_push($Teachers, $user);
            }
        }
        return $Teachers;
    }

}

// End Auth User Model
