<?php

defined('SYSPATH') or die('No direct script access.');

class Controller_Users extends Controller_Template_Base {

    public $Browse_System_Users = FALSE;
    public $Add_System_Users = FALSE;
    public $Edit_System_Users = FALSE;
    public $Delete_System_Users = FALSE;

    public function __construct(Request $request, Response $response) {
        // You must call parent::__construct at some point in your function
        parent::__construct($request, $response);
        // Do whatever else you want
        $this->Browse_System_Users = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'Browse_System_Users')));
        $this->Add_System_Users = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'Add_System_Users')));
        $this->Edit_System_Users = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'Edit_System_Users')));
        $this->Delete_System_Users = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'Delete_System_Users')));
    }

    public function action_index() {
        if ($this->Browse_System_Users || $this->Add_System_Users || $this->Edit_System_Users || $this->Delete_System_Users) {
            $this->template->title = Lang::__('Users');
            $this->template->layout = new View('system/users/view_all');
            $this->template->layout->lang = $this->lang;
            $this->template->layout->Add_System_Users = $this->Add_System_Users;
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }

    public function action_AE() {
        $par1 = $this->request->param('par1');
        $process_type = 'add_new';
        $Obj = ORM::factory('User', $par1);
        if ($Obj->loaded()) {
            $process_type = 'modify';
        }
        if (($this->Add_System_Users && ($process_type == 'add_new')) || ($this->Edit_System_Users && ($process_type == 'modify'))) {
            $view = View::factory('system/users/AE');

            if ($Obj->loaded()) {
                $view->set('Obj', $Obj);
            }

            $view->set('Arabic', $this->Arabic);
            $view->set('English', $this->English);

            $view->set('title', Lang::__($process_type));
            $view->set('lang', $this->lang);
            $view->set('Users', Search::action_FindAll_To_Array(ORM::factory('User')->find_all()));
            $this->response->body($view);
        } else {
            $view = View::factory('system/error_modal');
            $view->set('MSG', Lang::__('You_dont_have_permission_to_access_this_page'));
            $this->response->body($view);
        }
    }

//    public function action_Delete($id) {
//        $objj = ORM::factory('User', $id);
//        if ($objj->loaded() && $objj->id != 1) {
//            $objj->is_deleted = 1;
//            if ($objj->save()) {
//                
//            } else {
//                return FALSE;
//            }
//        }
//    }

    public function action_ToDB() {
        $results = array();
        $obj_id = $this->request->param('par1');

        $objj = ORM::factory('User', $obj_id);

        if (($this->Add_System_Users && (!$objj->loaded())) || ($this->Edit_System_Users && ($objj->loaded()))) {


            if (!$objj->loaded()) {
                $objj->Created_by = $this->user_online->id;
                $objj->Created_date = date("Y-m-d H:i:s");
            } else {
                $objj->last_update_by = $this->user_online->id;
                $objj->last_update_date = date("Y-m-d H:i:s");
            }

            if ($this->request->method() == Request::POST) {
                if (isset($_FILES['img'])) {
                    $directory = 'files/users/' . date('Y') . '/' . date("m") . '/';
                    $directory_thumbs = $directory . 'thumbs/';
                    $img = $this->_save_image($_FILES['img'], 600, 600, $directory, $directory_thumbs);
                    if ($img) {
                        if ($objj->img != NULL) {
                            if (strlen(DOCROOT . $objj->img) > 2) {
                                unlink(DOCROOT . $objj->img);
                            }
                            if (strlen(DOCROOT . $objj->img_thumb) > 2) {
                                unlink(DOCROOT . $objj->img_thumb);
                            }
                        }
                        $objj->img = $directory . $img;
                        $objj->img_thumb = $directory_thumbs . $img;
                    }
                }
            }

            $req = Request::current(); //fillter requset
            $Filtered_array = Search::action_Filtered_array($req->post());
            if (empty($Filtered_array['password'])) {
                unset($Filtered_array['password']);
            }
            $objj->values($Filtered_array);

            try {
                if (!$objj->loaded()) {
                    $new_objj = true;
                }
                if ($objj->save()) {
                    if (isset($new_objj)) {
                        $objj->add('roles', ORM::factory('Role', array('name' => 'login')));
                        $objj->save();
                    }

                    //Link Relations
                    if (empty($Filtered_array['Permissions_Groups'])) {
                        DB::delete(ORM::factory('Permissions_Usersrelations')->table_name())->where('user', '=', $objj->id)->execute();
                    } else {
                        $Rel_To_deleted = array();
                        $Relations = ORM::factory('Permissions_Usersrelations')
                                ->where('user', '=', $objj->id)
                                ->find_all();
                        foreach ($Relations as $value) {
                            $Rel_To_deleted[$value->id] = '';
                        }
                        foreach ($Filtered_array['Permissions_Groups'] as $value) {
                            $Relation = ORM::factory('Permissions_Usersrelations')
                                    ->where('user', '=', $objj->id)
                                    ->where('groub', '=', $value)
                                    ->find();
                            if ($Relation->loaded()) {
                                unset($Rel_To_deleted[$Relation->id]);
                            } else {
                                $Relation = ORM::factory('Permissions_Usersrelations');
                                $Relation->user = $objj->id;
                                $Relation->groub = $value;
                                $Relation->Created_by = $this->user_online->id;
                                $Relation->Created_date = date("Y-m-d H:i:s");
                                $Relation->save();
                            }
                        }
                        foreach ($Rel_To_deleted as $key => $value) {
                            ORM::factory('Permissions_Usersrelations', $key)->delete();
                        }
                    }
                    //End Link Relations

                    $results['Success'] = array(
                        'theme' => 'lime', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
                        'horizontalEdge' => 'top', //top,bottom
                        'verticalEdge' => 'right', //right,left
                        'heading' => '',
                        'life' => '2000', //1000 is 1 second
                        'text' => Lang::__('Saved_successfully'),
                    );
                }
            } catch (ORM_Validation_Exception $e) {
                $errors = $e->errors('');
                $results['Errors'] = General::ArrayToString(General::CatchErrorMSGSAjax($errors));
            }
        } else {
            $results['Errors'] = Lang::__('You_dont_have_permission_to_do_this_action');
        }

        echo json_encode($results);
    }

    protected function _save_image($image, $width = NULL, $height = NULL, $directory = NULL, $directory_thumbs = NULL) {
        if (!Upload::valid($image) OR ! Upload::not_empty($image) OR ! Upload::type($image, array('jpg', 'jpeg', 'png', 'gif'))) {
            return FALSE;
        }

        if (!empty($directory)) {
            $directory_D = DOCROOT . str_replace("\\", "/", $directory);
            if (!file_exists($directory_D)) {
                mkdir($directory_D, 0777, true);
            }
        }

        if (!empty($directory_thumbs)) {
            $directory_thumbs_D = DOCROOT . str_replace("\\", "/", $directory_thumbs);
            if (!file_exists($directory_thumbs_D)) {
                mkdir($directory_thumbs_D, 0777, true);
            }
        }

        if ($file = Upload::save($image, NULL, $directory)) {
            $ext = pathinfo($file, PATHINFO_EXTENSION);
            $filename = mb_strtolower(Text::random('alnum', rand(10, 30))) . '.' . $ext;

            $img = Image::factory($file);
            if (!empty($directory)) {
                $img->resize($width, $height, Image::INVERSE);
                $img->save($directory . $filename, 100);
            }

            if (!empty($directory_thumbs)) {
                $img->resize($width / 5, $height / 5, Image::INVERSE);
                $img->save($directory_thumbs . $filename, 100);
            }

            // Delete the temporary file
            unlink($file);

            return $filename;
        }

        return FALSE;
    }

    public function action_GetData() {

        if ($this->Add_System_Users || $this->Browse_System_Users || $this->Delete_System_Users || $this->Edit_System_Users) {

            $post = $this->request->post();
            $order = $post['order']; //Get how table order from datatable

            /*
             * All coulums will shown in table
             */
            $ALL_coulums = array(
                1 => "username",
                2 => "name_" . $this->lang,
                3 => "user_groub",
                4 => "email",
                5 => "Created_by",
                6 => "last_active",
            );

            $All_ORM = ORM::factory('User')
                    ->where('user_groub', '!=', 3)
                    ->where('is_deleted', '=', NULL)
                    ->order_by($ALL_coulums[$order[0]['column']], $order[0]['dir']);



            $Succesful_msg = Lang::__('Action_successfully_has_been_completed_Well_done');
            $C_Acti_status = "OK";

            /*
             * If Action exists
             */
            if (isset($post['customActionName'])) {
                switch ($post['customActionName']) {
                    case 'Delete':


                        break;


                    default:
                        break;
                }
            }


            /*
             * if search exists
             */
            if (isset($post['action']) && (!is_array($post['action'])) && mb_strtolower($post['action']) == 'filter') {
                if (!empty($post['name'])) {
                    $Name = $post['name'];
                    $All_ORM->and_where_open();
                    $All_ORM->or_where(DB::expr('lower(name_ar)'), 'LIKE', mb_strtolower("%$Name%"));
                    $All_ORM->or_where(DB::expr('lower(name_en)'), 'LIKE', mb_strtolower("%$Name%"));
                    $All_ORM->and_where_close();
                }
                if (!empty($post['username'])) {
                    $username = $post['username'];
                    $All_ORM->where(DB::expr('lower(username)'), 'LIKE', mb_strtolower("%$username%"));
                }
                if (!empty($post['email'])) {
                    $email = $post['email'];
                    $All_ORM->where(DB::expr('lower(email)'), 'LIKE', mb_strtolower("%$email%"));
                }
                if (!empty($post['user_groub'])) {
                    $user_groub = $post['user_groub'];
                    $All_ORM->where('user_groub', '=', $user_groub);
                }
            }

            /*
             * Paging
             */
            $All_ORM->reset(FALSE);
            $iTotalRecords = $All_ORM->count_all();

            $iDisplayLength = intval($post['length']);
            $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
            $iDisplayStart = intval($post['start']);
            $sEcho = intval($post['draw']);

            $records = array();
            $records["data"] = array();

            $end = $iDisplayStart + $iDisplayLength;
            $end = $end > $iTotalRecords ? $iTotalRecords : $end;

            $All_ORM->offset($iDisplayStart);
            $All_ORM->limit($iDisplayLength);


            /*
             * Prepare JSON Array
             */
            foreach ($All_ORM->find_all() as $value) {

                $Buttons = '';
                if ($this->Edit_System_Users) {
                    $Buttons .= '<a data-url="' . URL::base() . 'Users/AE/' . $value->id . '" class="btn btn-xs default EDIT" data-toggle="modal"><i class="fa fa-edit"></i> ' . Lang::__('Edit') . '</a>';
                }

                $records["data"][] = array(
                    '<input type="checkbox" name="id[]" value="' . $value->id . '">',
                    $value->username,
                    $value->{'name_' . $this->lang},
                    $value->User_Groub->{'name_' . $this->lang},
                    $value->email,
                    $value->Creater->{'name_' . $this->lang},
                    empty($value->last_active) ? Lang::__('Not_Active_Yet') : General::humanTiming(strtotime($value->last_active)),
                    $Buttons,
                );
            }
            if (isset($post["customActionType"]) && $post["customActionType"] == "group_action") {
                $records["customActionStatus"] = $C_Acti_status; // pass custom message(useful for getting status of group actions)
                $records["customActionMessage"] = $Succesful_msg; // pass custom message(useful for getting status of group actions)
            }

            $records["draw"] = $sEcho;
            $records["recordsTotal"] = $iTotalRecords;
            $records["recordsFiltered"] = $iTotalRecords;

            echo json_encode($records);
        }
    }

}

// End Users
