<?php

defined('SYSPATH') or die('No direct script access.');

class Controller_UserProfile extends Controller_Template_Base {

    public $Browse_ContactPersons = true;

    public function __construct(Request $request, Response $response) {
        // You must call parent::__construct at some point in your function
        parent::__construct($request, $response);
        // Do whatever else you want

        if (empty($this->user_online)) {
            $this->redirect('/', 302);
        }
    }

    public function action_index() {
        $Noti = ORM::factory("Notifications")->where('affected_user', '=', $this->user_online->id)->find_all();
        foreach ($Noti as $val) {
            $val->seen_in_system = 1;
            $val->seen_in_system = date("Y-m-d H:i:s");
            $val->save();
        }


        $video = new View('system/UserProfile/View');

        $this->template->Browse_ContactPersons = $this->Browse_ContactPersons;
        $this->template->title = Lang::__('userprofile');
        $this->template->layout = $video;
        $this->template->layout->user_online = $this->user_online;
    }

    public function action_ChangePassword() {
        $results = array();
        $req = Request::current(); 
        $Filtered_array = Search::action_Filtered_array($req->post());
        $objj = ORM::factory('User', $this->user_online->id);
        if($objj->loaded()){
            if($objj->password == Auth::instance()->hash($Filtered_array['old_password'])){
                $objj->password = $Filtered_array['new_password'];
                $objj->save();
                $results['Success'] = array('theme' => 'lime', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
                        'horizontalEdge' => 'top', //top,bottom
                        'verticalEdge' => 'right', //right,left
                        'heading' => '',
                        'life' => '2000', //1000 is 1 second
                        'text' => Lang::__('Password changed'));
            }else{
                $results['Errors'] = Lang::__("Error_Password");
            }
            
        }else{
            $results['Errors'] = "Something wrong";
        }
        echo json_encode($results);
    }

    public function action_ToDB() {


        $results = array();

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());
        // print_r($req);
        $directory = 'files/speeches/' . date('Y') . '/' . date("m") . '/';
        //echo Upload::save($Filtered_array['files[]'][0], NULL, $directory);
        $obj_id = $Filtered_array['par1'];
        $objj = ORM::factory('Speeches', $obj_id);

        if ($objj->loaded()) {
            $objj->last_update_by = $this->user_online->id;
            $objj->last_update_date = date("Y-m-d H:i:s");
        } else {
            $objj->Created_by = $this->user_online->id;
            $objj->Created_date = date("Y-m-d H:i:s");
        }
        if (array_key_exists("email", $Filtered_array)) {
            $data1 = implode(",", $Filtered_array['email']);

            $objj->email = $data1;
        } else {
            $results['Errors'] = array("الرجاء تحديد لمن الخطاب");
        }
        $objj->name = $Filtered_array['name'];
        $objj->message = $Filtered_array['message'];
        try {
            if ($objj->save()) {
                if ($objj->admin_reply_status != 1) {
                    //Send MSG here
                    $Sent_results = TRUE;
                    if ($Sent_results == TRUE) {
                        foreach ($Filtered_array['email'] as $val) {
                            $objj->admin_reply_status = 1;
                            $objj->save();
                            if (substr($val, 0, 1) != 'c') {
                                $Noti1 = ORM::factory("Notifications");
                                $Noti1->notification_cat = 1;
                                $Noti1->first_ref = $objj->id;
                                $Noti1->affected_user = $val;
                                $Noti1->effected_by = $this->user_online->id;
                                $Noti1->Created_date = date("Y-m-d H:i:s");
                                $Noti1->save();
                                $viewMessageBody = View::factory('system/email_message');
                                $viewMessageBody->username = $this->user_online->name_ar;
                                $viewMessageBody->type = 1;
                                $users = ORM::factory('Hr_Employment_Applications')->where('id', '=', $val)->find_all();
                                foreach ($users as $vals) {
                                    Mailer::SendEmail(null, null, $vals->email, "jaleat email", $viewMessageBody);
                                }
                            } else {
                                $objj->type = 1;
                                $objj->save();
                                $viewMessageBody = View::factory('system/email_message');
                                $viewMessageBody->username = $this->user_online->name_ar;
                                $viewMessageBody->type = 1;
                                $viewMessageBody->title = $Filtered_array['name'];
                                $viewMessageBody->messageID = $objj->id + 1000;
                                $viewMessageBody->message = $Filtered_array['message'];
                                $users = ORM::factory('Contactperson_Getinfo')->where('id', '=', ltrim($val, 'c'))->find_all();
                                foreach ($users as $vals) {
                                    Mailer::SendEmail(null, null, $vals->email, "jaleat email", $viewMessageBody);
                                }
                            }
                        }
                    }
                    //End Send MSG
                }
                $results['Success'] = '';
            }
        } catch (ORM_Validation_Exception $e) {
            $errors = $e->errors('');
            $Lang_Error = array();
            foreach ($errors as $key => $value) {
                $srting = '';
                $errr = explode('*', $value);
                if (count($errr) > 0) {
                    foreach ($errr as $aaa) {
                        $srting .= Lang::__($aaa) . ' ';
                    }
                    array_push($Lang_Error, $srting);
                }
            }
            $results['Errors'] = $Lang_Error;
        }
        echo json_encode($results);
    }

}

// End Speechescp
