<?php

defined('SYSPATH') or die('No direct script access.');

class Controller_Study_Equation extends Controller_Template_Base {

    public $Add = FALSE;
    public $Browse = FALSE;
    public $Edit = FALSE;
    public $Delete = FALSE;

    public function __construct(Request $request, Response $response) {
        // You must call parent::__construct at some point in your function
        parent::__construct($request, $response);
        // Do whatever else you want

        $this->Add = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'A_Sections')));
        $this->Browse = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'B_Sections')));
        $this->Edit = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'E_Sections')));
        $this->Delete = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'D_Sections')));
    }

    public function action_index() {
        if ($this->Add || $this->Browse || $this->Edit || $this->Delete) {
            $title = Lang::__('Courses equation');
            $this->template->title = $title;
            $this->template->layout = new View('system/study/equation/view_all');
            $this->template->layout->title = $title;
            $this->template->layout->Add = $this->Add;
            $this->template->layout->lang = $this->lang;
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }

    public function action_AE() {

        $par1 = $this->request->param('par1');
        $par2 = $this->request->param('par2');

        $process_type = 'add_new_Equation';
        $Obj = ORM::factory('Study_Equation', $par1);

        if ($Obj->loaded()) {
            $process_type = 'modify';
        }

        if ((($this->Add && $process_type == 'add_new_Equation') || ($this->Edit && $process_type == 'modify')) && ($Obj->is_deleted == NULL)) {
            $this->template->layout = new View('system/study/equation/AE');

            if ($Obj->loaded()) {
                $this->template->layout->Obj = $Obj;
            }
            
            $this->template->layout->Students = ORM::factory('User')->where('user_groub', '=', 3)->where('is_deleted', '=', NULL)->find_all();
            $this->template->layout->Courses = ORM::factory('Study_Courses')->where('is_deleted', '=', NULL)->find_all();
            
            $this->template->layout->Items_Of_Order = $Obj->Items->where('is_deleted', '=', NULL)->find_all();

            $this->template->layout->title = Lang::__($process_type);
            $this->template->title = Lang::__($process_type);
            $this->template->layout->lang = $this->lang;
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }

    public function action_Delete() {
        $results = array();

        if ($this->Delete) {
            $req = Request::current(); //fillter requset
            $Filtered_array = Search::action_Filtered_array($req->post());

            $Obj = ORM::factory('Study_Sections', $Filtered_array['id']);

            $CheckDeleteRules = $Obj->CheckDeleteRules();
            if ($CheckDeleteRules === TRUE) {
                try {
                    $Obj->is_deleted = 1;
                    $Obj->deleted_by = $this->user_online->id;
                    $Obj->deleted_date = date("Y-m-d H:i:s");
                    if ($Obj->save()) {
                        $results['Success'] = array(
                            'title' => Lang::__('Done'),
                            'content' => Lang::__('Deletion has been successfully'),
                        );
                    }
                } catch (ORM_Validation_Exception $e) {

                    $errors = $e->errors('');
                    $results['Errors'] = array(
                        'title' => Lang::__('Error'),
                        'content' => General::CatchErrorMSGSAjax($errors),
                    );
                }
            } else {
                if (is_array($CheckDeleteRules)) {

                    $results['Errors'] = array(
                        'title' => Lang::__('Error'),
                        'content' => General::ArrayToString($CheckDeleteRules),
                    );
                }
            }
        } else {
            $results['Errors'] = array(
                'title' => Lang::__('Error'),
                'content' => Lang::__('You_dont_have_permission_to_do_this_action'),
            );
        }

        echo json_encode($results);
    }

    public function action_ToDB() {
        $results = array();

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());
        $par1 = empty($Filtered_array['par1']) ? NULL : $Filtered_array['par1'];
        $par2 = empty($Filtered_array['par2']) ? NULL : $Filtered_array['par2'];

        $objj = ORM::factory('Study_Sections', $par1);
        if (!$objj->loaded()) {
            $objj->Created_by = $this->user_online->id;
            $objj->Created_date = date("Y-m-d H:i:s");
        } else {
            $objj->last_update_by = $this->user_online->id;
            $objj->last_update_date = date("Y-m-d H:i:s");
        }


        $objj->values($Filtered_array);

        try {
            if ($objj->save()) {

                //بداية ربط الشعبة بالاوقات
                if (empty($Filtered_array['Days'])) {
                    DB::delete(ORM::factory('Study_Sections_Dates')->table_name())->where('section', '=', $objj->id)->execute();
                } else {
                    $Rel_To_deleted = array();
                    $Relations = ORM::factory('Study_Sections_Dates')
                            ->where('section', '=', $objj->id)
                            ->find_all();
                    foreach ($Relations as $value) {
                        $Rel_To_deleted[$value->id] = '';
                    }
                    foreach ($Filtered_array['Days'] as $value) {
                        $Relation = ORM::factory('Study_Sections_Dates')
                                ->where('section', '=', $objj->id)
                                ->where('day', '=', $value)
                                ->find();
                        if ($Relation->loaded()) {
                            $Relation->start = $Filtered_array[$value . '_start'];
                            $Relation->end = $Filtered_array[$value . '_end'];
                            $Relation->save();
                            unset($Rel_To_deleted[$Relation->id]);
                        } else {
                            $Relation = ORM::factory('Study_Sections_Dates');
                            $Relation->section = $objj->id;
                            $Relation->day = $value;
                            $Relation->start = $Filtered_array[$value . '_start'];
                            $Relation->end = $Filtered_array[$value . '_end'];
                            $Relation->Created_by = $this->user_online->id;
                            $Relation->Created_date = date("Y-m-d H:i:s");
                            $Relation->save();
                        }
                    }
                    foreach ($Rel_To_deleted as $key => $value) {
                        ORM::factory('Study_Sections_Dates', $key)->delete();
                    }
                }
                //نهاية ربط الشعبة بالاوقات


                $results['Success'] = array(
                    'theme' => 'lime', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
                    'horizontalEdge' => 'top', //top,bottom
                    'verticalEdge' => 'right', //right,left
                    'heading' => '',
                    'life' => '2000', //1000 is 1 second
                    'text' => Lang::__('Saved_successfully'),
                );
            }
        } catch (ORM_Validation_Exception $e) {

            $errors = $e->errors('');
            $results['Errors'] = General::CatchErrorMSGSAjax($errors);
        }
        echo json_encode($results);
    }

    public function action_GetPrograms() {
        $results = array();

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());

        $id = empty($Filtered_array['id']) ? NULL : $Filtered_array['id'];
        $Department = ORM::factory('Study_Departments', $id);
        if ($Department->loaded() && $Department->is_deleted == NULL) {

            $Programs = $Department->Programs->where('is_deleted', '=', NULL)->find_all();
            $arr = array();
            foreach ($Programs as $value) {
                $arr[$value->id] = $value->{'name_' . $this->lang};
            }
            $results['models'] = $arr;
        }
        echo json_encode($results);
    }

    public function action_GetData() {
        $post = $this->request->post();
        $order = $post['order']; //Get how table order from datatable
        /*
         * All coulums will shown in table
         */
        $ALL_coulums = array(
            1 => "id",
        );

        $All_ORM = ORM::factory('Study_Sections')
                ->where('is_deleted', '=', NULL)
                ->order_by($ALL_coulums[$order[0]['column']], $order[0]['dir']);


        $Succesful_msg = Lang::__('Action_successfully_has_been_completed_Well_done');
        $C_Acti_status = "OK";

        /*
         * If Action exists
         */
        if (isset($post['customActionName'])) {
            switch ($post['customActionName']) {
                case 'Delete':

                    break;


                default:
                    break;
            }
        }


        /*
         * if search exists
         */
        if (isset($post['action']) && (!is_array($post['action'])) && mb_strtolower($post['action']) == 'filter') {
            if (!empty($post['term'])) {
                $All_ORM->where('term', '=', $post['term']);
            }
            if (!empty($post['course'])) {
                $All_ORM->where('course', '=', $post['course']);
            }
            if (!empty($post['room'])) {
                $All_ORM->where('room', '=', $post['room']);
            }
            if (!empty($post['teacher'])) {
                $All_ORM->where('teacher', '=', $post['teacher']);
            }
        }

        /*
         * Paging
         */
        $All_ORM->reset(FALSE);
        $iTotalRecords = $All_ORM->count_all();

        $iDisplayLength = intval($post['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($post['start']);
        $sEcho = intval($post['draw']);

        $records = array();
        $records["data"] = array();

        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;

        $All_ORM->offset($iDisplayStart);
        $All_ORM->limit($iDisplayLength);


        /*
         * Prepare JSON Array
         */
        foreach ($All_ORM->find_all() as $value) {
            $buttons = '';

            ($this->Edit) ? $buttons .= '<a href="' . URL::base() . 'Study_Sections/AE/' . $value->id . '" class="btn btn-xs default"><i class="fa fa-edit"></i> ' . Lang::__('Edit') . '</a>' : NULL;
            $buttons .= '<a href="' . URL::base() . 'Teacher_Educational/Chapters/' . $value->id . '" class="btn btn-xs green">' . Lang::__('Educational material') . '</a>';
            ($this->Delete && ($value->CheckDeleteRules() === TRUE)) ? $buttons .= '<a par1="' . $value->id . '" Dtitle="' . Lang::__('Alert') . '" Dcontent="' . Lang::__('Are_you_sure_you_want_to_delete_it') . '" confirmButton="' . Lang::__('Yes') . '" cancelButton="' . Lang::__('Cancel') . '" class="btn btn-xs red Delete"> ' . Lang::__('Delete') . '</a>' : NULL;

            $records["data"][] = array(
                '<input type="checkbox" name="id[]" value="' . $value->id . '">',
                $value->Term->{'name_' . $this->lang},
                $value->Course->{'name_' . $this->lang},
                $value->Room->{'name'},
                $value->Teacher->{'name_' . $this->lang},
                $buttons,
            );
        }
        if (isset($post["customActionType"]) && $post["customActionType"] == "group_action") {
            $records["customActionStatus"] = $C_Acti_status; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = $Succesful_msg; // pass custom message(useful for getting status of group actions)
        }

        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;

        echo json_encode($records);
    }

}
