<?php

defined('SYSPATH') or die('No direct script access.');

class Controller_Student_Registration extends Controller_Template_Site
{

    public function action_index()
    {
        $Registration_Status = ORM::factory('Variables', 77)->value;
        $Current_Term = ORM::factory('Study_Terms', ORM::factory('Variables', 78)->value);
        if ($Registration_Status == 'Open' && $Current_Term->loaded()) {
            //فحص اذا كان طالب
            if (isset($this->user_online) && $this->user_online->user_groub == 3) {
                $StateOfTerm = $Current_Term->StateOfTerm();

                $ROpen = FALSE;

                if(($StateOfTerm == "Regular registration period") || ($StateOfTerm == "Registration period fine")){
                    $ROpen = TRUE;
                }

                if($StateOfTerm == "Drag and added period"){
                    $Student_Term = ORM::factory("Students_Terms")
                                        ->where("term","=",$Current_Term->id)
                                        ->where("student","=",$this->user_online->id)
                                        ->where("is_deleted","=",NULL)
                                        ->find();

                    if($Student_Term->loaded()){
                        $ROpen = TRUE;
                    }

                }


                if ($ROpen) {
                    $this->template->layout = new View('site/student/registration');

                    $title = Lang::__("Onlinereg");
                    $sub_title = $Current_Term->{'name_' . $this->lang};

                    $StudentRegFin = Model_Financials_Payments::CalculateStudentRegFin($this->user_online, $Current_Term);

                    $this->template->layout->balance = isset($StudentRegFin['balance']) ? $StudentRegFin['balance'] : 0;
                    $this->template->layout->Current_Term_Cost = isset($StudentRegFin['Current_Term_Cost']) ? $StudentRegFin['Current_Term_Cost'] : 0;
                    $this->template->layout->AmountReqToReg = isset($StudentRegFin['AmountReqToReg']) ? $StudentRegFin['AmountReqToReg'] : 0;

                    $this->template->layout->Student_Info = ORM::factory('Students_Applications')->where('student_id', '=', $this->user_online->id)->find();
                    $this->template->layout->Current_Term = $Current_Term;
                    $this->template->layout->title = $title;
                    $this->template->layout->StateOfTerm = $StateOfTerm;
                    $this->template->layout->sub_title = $sub_title;
                    $Current_Term = ORM::factory('Study_Terms', ORM::factory('Variables', 78)->value);
                    $this->template->title = $title;

                    $this->template->layout->lang = $this->lang;
                } else {
                    $this->template->layout = new View('site/error');
                    $this->template->layout->MSG = Lang::__('The registration period for the current term is over');
                }
            } else {
                $this->template->layout = new View('site/error');
                $this->template->layout->MSG = Lang::__('Registration is available for students only');
            }
        } else {
            $this->template->layout = new View('site/error');
            $this->template->layout->MSG = Lang::__('You tracked wrong or expired link');
        }
    }

    public function action_GetSections()
    {
        if (!empty($this->user_online->id)) {
            $Current_Term = ORM::factory('Study_Terms', ORM::factory('Variables', 78)->value);

            $Student_Info = $this->user_online->Student_Information;

            //جميع الشعب المحجوزة مسبقا
            $AllStudSections = ORM::factory('Students_Sections')
                ->where('student', '=', $this->user_online->id)
                ->where('term', '=', $Current_Term->id)
                ->where('state', '!=', 4)
                ->where('is_deleted', '=', NULL)
                ->find_all();
            $AllRegSecIds = array(0);
            foreach ($AllStudSections as $value) {
                array_push($AllRegSecIds, $value->section);
            }
            //نهاية تحديد جميع الشعب المحجوزة مسبقاً

            $req = Request::current(); //fillter requset
            $post = Search::action_Filtered_array($req->post());

            $order = $post['order']; //Get how table order from datatable
            /*
             * All coulums will shown in table
             */
            $ALL_coulums = array(
                1 => "id",
            );
            $All_ORM = ORM::factory('Study_Sections');
            $All_ORM->with("Course");


            $All_ORM->and_where_open();
            $All_ORM->or_where('study_sections.gender', '=', $Student_Info->Gender); //اما جنس الشعبة مشابه لجنس الطالب
            $All_ORM->or_where('study_sections.gender', '=', NULL); //او الشعبة مختلطة
            $All_ORM->and_where_close();
            $All_ORM->where('Course.degree', '=', $Student_Info->degree); //الدرجة العلمية تكون نفسها
            $All_ORM->where('study_sections.term', '=', $Current_Term->id); //الشعب اللي نازلة هذا الفصل فقط
            $All_ORM->where('study_sections.id', 'NOT IN', $AllRegSecIds); //انه تكون الشعبة مش محجوزة مسبقا
            $All_ORM->where('study_sections.is_deleted', '=', NULL); //الشعب اللي مش محذوفة
            $All_ORM->order_by('study_sections.' . $ALL_coulums[$order[0]['column']], $order[0]['dir']);

//        foreach ($All_ORM->find_all() as $value) {
//            print_r($value->as_array());
//        }
            if ($Student_Info->study_type == 1) { //اذا كانت نوع دراسة الطالب مراحل
                $Levels_Courses_Relations = ORM::factory('Study_Levels_Courses')
                    ->where('level', '=', $Student_Info->level)
                    ->find_all();
                $AllCourseIds = array(0); //جميع مساقات مرحلة الطالب هذه
                foreach ($Levels_Courses_Relations as $value) {
                    array_push($AllCourseIds, $value->course);
                }
                //print_r($AllCourseIds);
                $All_ORM->where('study_sections.course', 'IN', $AllCourseIds);
            }

            $Succesful_msg = Lang::__('Action_successfully_has_been_completed_Well_done');
            $C_Acti_status = "OK";

            /*
             * if search exists
             */
            if (isset($post['action']) && (!is_array($post['action'])) && mb_strtolower($post['action']) == 'filter') {

            }

            /*
             * Paging
             */
            $All_ORM->reset(FALSE);
            $iTotalRecords = $All_ORM->count_all();

            $iDisplayLength = intval($post['length']);
            $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
            $iDisplayStart = intval($post['start']);
            $sEcho = intval($post['draw']);

            $records = array();
            $records["data"] = array();

            $end = $iDisplayStart + $iDisplayLength;
            $end = $end > $iTotalRecords ? $iTotalRecords : $end;


            $All_ORM->offset($iDisplayStart);
            $All_ORM->limit($iDisplayLength);


            /*
             * Prepare JSON Array
             */
            foreach ($All_ORM->find_all() as $value) {


                $Appointments = '';
                $AllCurrentDateOfSection = ORM::factory('Study_Sections_Dates')->where('section', '=', $value->id)->find_all();
                $NoConflect = TRUE;
                foreach ($AllCurrentDateOfSection as $CurrentSTime) {
                    $Start = explode(':', $CurrentSTime->start);
                    $Stime = '';
                    if (isset($Start[0]) && isset($Start[1])) {
                        $Stime = $Start[0] . ':' . $Start[1];
                    }
                    $EndT = explode(':', $CurrentSTime->end);
                    $Etime = '';
                    if (isset($EndT[0]) && isset($EndT[1])) {
                        $Etime = $EndT[0] . ':' . $EndT[1];
                    }
                    $Appointments .= $CurrentSTime->day . ' ' . $Stime . ' - ' . $Etime . '</br>';
                }
                foreach ($AllStudSections as $SSec) {
                    $Sect = ORM::factory('Study_Sections_Dates')->where('section', '=', $SSec->section)->find_all();
                    foreach ($Sect as $SecDate) {
                        foreach ($AllCurrentDateOfSection as $CurrentSTime) {
                            //اذا كانت الايام مثل بعض ابحث في الوقت نفسه
                            if (mb_strtolower($SecDate->day) == mb_strtolower($CurrentSTime->day)) {
                                $Res = Model_Students_Sections::intersectCheck($SecDate->start, $CurrentSTime->start, $SecDate->end, $CurrentSTime->end);
                                if ($Res == FALSE) {
                                    $NoConflect = FALSE;
                                    break;
                                }
                            }
                        }
                    }
                }


                //نفخص هل الشعبة مرفوضة مسبقا من قبل المرشد
                $StudSections = ORM::factory('Students_Sections')
                    ->where('section', '=', $value->id)
                    ->where('student', '=', $this->user_online->id)
                    ->where('term', '=', $Current_Term->id)
                    ->where('state', '=', 4)
                    ->find();
                $buttons = '';
                if ($NoConflect && !$StudSections->loaded()) {
                    $buttons = '<button par1="' . $value->id . '" type="button" class="btn btn-success mr-xs mb-sm add_section">' . Lang::__('add') . '</button>';
                } elseif (!$NoConflect) {
                    $buttons = Lang::__('Conflict With other registered section');
                } elseif ($StudSections->loaded()) {
                    $buttons = '<span class="font-red-thunderbird">' . Lang::__('This section rejected by advs') . ' - ' . Lang::__('Note') . ': ' . $StudSections->rejected_note . '</span>';
                }
                $Course = ORM::factory('Study_Courses', $value->course);

                $SecGender = Lang::__("Mixed_Section");

                if (!empty($value->gender)) {
                    if ($value->gender == 1) {
                        $SecGender = Lang::__("Only_males");
                    } elseif ($value->gender == 2) {
                        $SecGender = Lang::__("Only_females");
                    }
                }

                $records["data"][] = array(
                    ORM::factory('Study_Majors', $value->major)->{'name_' . $this->lang},
                    $Course->{'name_' . $this->lang},
                    ORM::factory('Study_Rooms', $value->room)->{'name'} . " (" . $SecGender . ")",
                    $value->Teacher->GetName($this->lang),
                    $Course->credit_hours,
                    $Appointments,
                    $buttons,
                );
            }
            if (isset($post["customActionType"]) && $post["customActionType"] == "group_action") {
                $records["customActionStatus"] = $C_Acti_status; // pass custom message(useful for getting status of group actions)
                $records["customActionMessage"] = $Succesful_msg; // pass custom message(useful for getting status of group actions)
            }

            $records["draw"] = $sEcho;
            $records["recordsTotal"] = $iTotalRecords;
            $records["recordsFiltered"] = $iTotalRecords;

            echo json_encode($records);
        }
    }

    public function action_GetRegSections()
    {
        if (!empty($this->user_online->id)) {
            $Current_Term = ORM::factory('Study_Terms', ORM::factory('Variables', 78)->value);
            $StateOfTerm = $Current_Term->StateOfTerm();
            $AllStudSections = ORM::factory('Students_Sections')
                ->where('student', '=', $this->user_online->id)
                ->where('term', '=', $Current_Term->id)
                ->and_where_open()
                    ->or_where('state', '=', NULL)
                    ->or_where('state', '=', 1)
                    ->or_where('state', '=', 2)
                    ->or_where('state', '=', 3)
                ->and_where_close()

                ->where('is_deleted', '=', NULL)
                ->find_all();
            $AllRegSecIds = array(0);
            $Need_To_Review_ = FALSE; //لتحديد زر بحاجة للمراجعة من المرشد
            $Stick_table_ = FALSE; //لتحديد زر اعتماد التسجيل
            $Approved_Sections = 0;
            foreach ($AllStudSections as $value) {
                array_push($AllRegSecIds, $value->section);
                if ($value->state == null) {
                    $Need_To_Review_ = TRUE;
                }
                if ($value->state == 2) {
                    $Approved_Sections++;
                }
            }
            if (!empty($Approved_Sections) && $Approved_Sections == count($AllStudSections)) {
                $Stick_table_ = TRUE;
            }

            $post = $this->request->post();
            $order = isset($post['order']) ? $post['order'] : NULL; //Get how table order from datatable
            /*
             * All coulums will shown in table
             */
            $ALL_coulums = array(
                1 => "id",
            );

            $All_ORM = ORM::factory('Study_Sections')
                ->where('id', 'IN', $AllRegSecIds)
                ->where('is_deleted', '=', NULL);


            $Succesful_msg = Lang::__('Action_successfully_has_been_completed_Well_done');
            $C_Acti_status = "OK";

            /*
             * If Action exists
             */
            if (isset($post['customActionName'])) {
                switch ($post['customActionName']) {
                    case 'Delete':
                        $ids = array();
                        foreach ($post['id'] as $value) {
                            if ($this->action_Delete($value) === FALSE) {
                                array_push($ids, $value);
                            }
                        }

                        break;


                    default:
                        break;
                }
            }


            /*
             * if search exists
             */
            if (isset($post['action']) && (!is_array($post['action'])) && mb_strtolower($post['action']) == 'filter') {
                if (!empty($post['term'])) {
                    $All_ORM->where('term', '=', $post['term']);
                }
                if (!empty($post['course'])) {
                    $All_ORM->where('course', '=', $post['course']);
                }
                if (!empty($post['room'])) {
                    $All_ORM->where('room', '=', $post['room']);
                }
                if (!empty($post['teacher'])) {
                    $All_ORM->where('teacher', '=', $post['teacher']);
                }
            }

            /*
             * Paging
             */
            $All_ORM->reset(FALSE);
            $iTotalRecords = $All_ORM->count_all();

            $iDisplayLength = intval($post['length']);
            $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
            $iDisplayStart = intval($post['start']);
            $sEcho = intval($post['draw']);

            $records = array();
            $records["data"] = array();

            $end = $iDisplayStart + $iDisplayLength;
            $end = $end > $iTotalRecords ? $iTotalRecords : $end;

            $All_ORM->offset($iDisplayStart);
            $All_ORM->limit($iDisplayLength);


            /*
             * Prepare JSON Array
             */
            foreach ($All_ORM->find_all() as $value) {
                $Appointments = '';
                $AllCurrentDateOfSection = ORM::factory('Study_Sections_Dates')->where('section', '=', $value->id)->find_all();
                foreach ($AllCurrentDateOfSection as $CurrentSTime) {
                    $Start = explode(':', $CurrentSTime->start);
                    $Stime = '';
                    if (isset($Start[0]) && isset($Start[1])) {
                        $Stime = $Start[0] . ':' . $Start[1];
                    }
                    $EndT = explode(':', $CurrentSTime->end);
                    $Etime = '';
                    if (isset($EndT[0]) && isset($EndT[1])) {
                        $Etime = $EndT[0] . ':' . $EndT[1];
                    }
                    $Appointments .= $CurrentSTime->day . ' ' . $Stime . ' - ' . $Etime . '</br>';
                }
                $buttons = '';

                $StudSections = ORM::factory('Students_Sections')
                    ->where('student', '=', $this->user_online->id)
                    ->where('term', '=', $Current_Term->id)
                    ->where('section', '=', $value->id)
                    ->where('is_deleted', '=', NULL)
                    ->find();

                if ($StudSections->state == NULL) {
                    $buttons .= '<a par1="' . $value->id . '" Dtitle="' . Lang::__('Alert') . '" Dcontent="' . Lang::__('Are_you_sure_you_want_to_delete_it') . '" confirmButton="' . Lang::__('Yes') . '" cancelButton="' . Lang::__('Cancel') . '" class="btn btn-xs red Delete"> ' . Lang::__('Delete') . '</a>';
                } elseif ($StudSections->state == 1) {
                    $buttons .= '<span class="font-red-haze">' . Lang::__('Awaiting approval') . ' </span>';
                    $buttons .= '<a par1="' . $value->id . '" Dtitle="' . Lang::__('Alert') . '" Dcontent="' . Lang::__('Are_you_sure_you_want_to_delete_it') . '" confirmButton="' . Lang::__('Yes') . '" cancelButton="' . Lang::__('Cancel') . '" class="btn btn-xs red Delete"> ' . Lang::__('Delete') . '</a>';
                } elseif ($StudSections->state == 2) {
                    $buttons .= '<span class="font-green-jungle">' . Lang::__('Approved') . ' </span>';

                    if (in_array($StateOfTerm, array('Regular registration period', 'Registration period fine', 'Drag and added period'))) {
                        $buttons .= '<a par1="' . $value->id . '" Dtitle="' . Lang::__('Alert') . '" Dcontent="' . Lang::__('Are_you_sure_you_want_to_delete_it') . '" confirmButton="' . Lang::__('Yes') . '" cancelButton="' . Lang::__('Cancel') . '" class="btn btn-xs red Delete"> ' . Lang::__('Delete') . '</a>';
                    }
                } elseif ($StudSections->state == 3) {
                    $buttons .= '<span class="font-green-jungle">' . Lang::__('Registered') . ' </span>';
                    if (in_array($StateOfTerm, array('Regular registration period', 'Registration period fine', 'Drag and added period'))) {
                        $buttons .= '<a par1="' . $value->id . '" Dtitle="' . Lang::__('Alert') . '" Dcontent="' . Lang::__('Are_you_sure_you_want_to_delete_it') . '" confirmButton="' . Lang::__('Yes') . '" cancelButton="' . Lang::__('Cancel') . '" class="btn btn-xs red Delete"> ' . Lang::__('Delete') . '</a>';
                    }
                } elseif ($StudSections->state == 4) {
                    $buttons .= '<span class="font-red-thunderbird">' . Lang::__('rejected_by') . ' ' . $StudSections->Rejecter->{'name_' . $this->lang} . '</span>';
                }

                $SecGender = Lang::__("Mixed_Section");

                if (!empty($value->gender)) {
                    if ($value->gender == 1) {
                        $SecGender = Lang::__("Only_males");
                    } elseif ($value->gender == 2) {
                        $SecGender = Lang::__("Only_females");
                    }
                }

                $Course = ORM::factory('Study_Courses', $value->course);
                if ($StudSections->state != 4) { //اذا كانت الشعبة مرفوضة مسبقا
                    $records["data"][] = array(
                        ORM::factory('Study_Majors', $value->major)->{'name_' . $this->lang},
                        $Course->{'name_' . $this->lang} ,
                        ORM::factory('Study_Rooms', $value->room)->{'name'} . ' (' . $SecGender . ')',
                        $value->Teacher->GetName($this->lang),
                        $Course->credit_hours,
                        $Appointments,
                        $buttons,
                    );
                }
            }
            if (isset($post["customActionType"]) && $post["customActionType"] == "group_action") {
                $records["customActionStatus"] = $C_Acti_status; // pass custom message(useful for getting status of group actions)
                $records["customActionMessage"] = $Succesful_msg; // pass custom message(useful for getting status of group actions)
            }

            $records["draw"] = $sEcho;
            $records["recordsTotal"] = $iTotalRecords;
            $records["recordsFiltered"] = $iTotalRecords;

            $StudentRegFin = Model_Financials_Payments::CalculateStudentRegFin($this->user_online, $Current_Term);

            $records += $StudentRegFin;


            //Fotter of table
            $Tfoot = '';
            if ($Need_To_Review_) {
                $Tfoot .= '<button type="button" class="btn btn-3d btn-success mr-xs mb-sm ReqAdvisor">' . Lang::__('Request_for_approval_of_the_academic_advisor') . '</button>';
            }
            if ($Stick_table_) {
                $Tfoot .= '<button type="button" class="btn btn-3d btn-success mr-xs mb-sm AdoptionSections">' . Lang::__('Adoption of sections') . '</button>';
            }
            $records["Tfoot"] = $Tfoot;

            echo json_encode($records);
        }
    }

    public function action_AddSection()
    {
        $results = array();

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());

        if (!empty($this->user_online->id)) {


            $Current_Term = ORM::factory('Study_Terms', ORM::factory('Variables', 78)->value);
            $StateOfTerm = $Current_Term->StateOfTerm();
            //فحص اذا الطالب مسجل للفصل
            $STerms = ORM::factory('Students_Terms')
                ->where('student', '=', $this->user_online->id)
                ->where('term', '=', $Current_Term->id)
                ->where('is_deleted', '=', NULL)
                ->find();

            if ($STerms->loaded() && (!in_array($StateOfTerm, array('Drag and added period', 'Registration period fine', 'Regular registration period')))) {
                $results['Errors'] = array(
                    'title' => Lang::__('Error'),
                    'content' => Lang::__('You can not add a new section to the schedule after the completion of the registration process'),
                );
            } else {
                $Obj = ORM::factory('Study_Sections', $Filtered_array['id']);
                if ($Obj->loaded()) {
                    $ExRel = ORM::factory('Students_Sections')
                        ->where('student', '=', $this->user_online->id)
                        ->where('section', '=', $Obj->id)
                        ->where('is_deleted', '=', NULL)
                        ->find();
                    if (!$ExRel->loaded()) {

                        try {
                            $New_Rel = ORM::factory('Students_Sections');
                            $New_Rel->student = $this->user_online->id;
                            $New_Rel->section = $Obj->id;
                            $New_Rel->term = $Current_Term->id;
                            $New_Rel->Created_by = $this->user_online->id;
                            $New_Rel->Created_date = date("Y-m-d H:i:s");
                            if ($New_Rel->save()) {
                                $results['Resp'] = array(
                                    'theme' => 'lime', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
                                    'horizontalEdge' => 'top', //top,bottom
                                    'verticalEdge' => 'right', //right,left
                                    'heading' => Lang::__('successfully'),
                                    'life' => '2000', //1000 is 1 second
                                    'text' => Lang::__('Section successfully been added to the table'),
                                );
                            }
                        } catch (ORM_Validation_Exception $e) {
                            $errors = $e->errors('');

                            $results['Errors'] = array(
                                'title' => Lang::__('Error'),
                                'content' => General::CatchErrorMSGSAjax($errors),
                            );
                        }
                    } else {

                        $results['Errors'] = array(
                            'title' => Lang::__('Error'),
                            'content' => Lang::__('Section already added to your schedule'),
                        );
                    }
                } else {
                    $results['Errors'] = array(
                        'title' => Lang::__('Error'),
                        'content' => Lang::__('Not_found_the_desired_item'),
                    );
                }
            }
        } else {
            $results['Errors'] = array(
                'title' => Lang::__('Error'),
                'content' => Lang::__('Please sign in to continue'),
            );
        }

        echo json_encode($results);
    }

    public function action_ReqAdvisor()
    {
        $results = array();

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());

        if (!empty($this->user_online->id)) {


            $Current_Term = ORM::factory('Study_Terms', ORM::factory('Variables', 78)->value);

            $ExRel = ORM::factory('Students_Sections')
                ->where('student', '=', $this->user_online->id)
                ->where('term', '=', $Current_Term->id)
                ->where('state', '=', NULL)
                ->where('is_deleted', '=', NULL)
                ->find_all();
            if (count($ExRel) > 0) {
                $All_credit_hours = 0;
                foreach ($ExRel as $value) {
                    $All_credit_hours += $value->Section->Course->credit_hours;
                }

                $Study_Terms_Hours = ORM::factory('Study_Terms_Hours')->where('term', '=', $Current_Term->id)->where('degree', '=', $this->user_online->Student_Information->degree)->where('is_deleted', '=', NULL)->find();
                $min_hours = $Study_Terms_Hours->min_hours;

                if ($All_credit_hours >= $min_hours) {
                    try {
                        foreach ($ExRel as $value) {
                            $value->set('state', 1)->update(); //بحاجة لمراجعة المرشد
                        }
                        $results['Resp'] = array(
                            'theme' => 'lime', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
                            'horizontalEdge' => 'top', //top,bottom
                            'verticalEdge' => 'right', //right,left
                            'heading' => '',
                            'life' => '10000', //1000 is 1 second
                            'text' => Lang::__('Sections now waiting for the approval'),
                        );
                    } catch (ORM_Validation_Exception $e) {

                        $errors = $e->errors('');
                        $results['Resp'] = array(
                            'theme' => 'ruby', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
                            'horizontalEdge' => 'top', //top,bottom
                            'verticalEdge' => 'right', //right,left
                            'heading' => Lang::__('Error'),
                            'life' => '5000', //1000 is 1 second
                            'text' => General::CatchErrorMSGSAjax($errors),
                        );
                    }
                } else {
                    $results['Resp'] = array(
                        'theme' => 'tangerine', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
                        'horizontalEdge' => 'top', //top,bottom
                        'verticalEdge' => 'right', //right,left
                        'heading' => '',
                        'life' => '5000', //1000 is 1 second
                        'text' => Lang::__('credit_hours_less_than_min_term'),
                    );
                }
            } else {
                $results['Resp'] = array(
                    'theme' => 'tangerine', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
                    'horizontalEdge' => 'top', //top,bottom
                    'verticalEdge' => 'right', //right,left
                    'heading' => Lang::__('Alert'),
                    'life' => '5000', //1000 is 1 second
                    'text' => Lang::__('There are no sections waiting for the approval'),
                );
            }
        } else {
            $results['Resp'] = array(
                'theme' => 'ruby', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
                'horizontalEdge' => 'top', //top,bottom
                'verticalEdge' => 'right', //right,left
                'heading' => Lang::__('Error'),
                'life' => '5000', //1000 is 1 second
                'text' => Lang::__('Please sign in to continue'),
            );
        }
        echo json_encode($results);
    }

    public function action_AdoptionSections()
    {
        $results = array();

        $Current_Term = ORM::factory('Study_Terms', ORM::factory('Variables', 78)->value);

        if (!empty($this->user_online)) {

            $ExRel = ORM::factory('Students_Sections')
                ->where('student', '=', $this->user_online->id)
                ->where('term', '=', $Current_Term->id)
                ->where('state', '!=', 4)//الشعبة غير مرفوضة
                ->where('is_deleted', '=', NULL)
                ->find_all();

            //حساب التكاليف
            $Balance_Test = FALSE;
            $balance = Model_Financials_Payments::CalculateStudentBalance($this->user_online->id);
            $Current_Term_Cost = Model_Financials_Payments::CalculateTermCost($this->user_online->id, $Current_Term);

            if (($balance - $Current_Term_Cost) >= 0) {

            } else {

                $Financials_Manminpayment_Custom = ORM::factory('Financials_Manminpayment_Custom')
                    ->where('student', '=', $this->user_online->id)
                    ->where('term', '=', $Current_Term->id)
                    ->find();

                $Financials_Manminpayment = ORM::factory('Financials_Manminpayment')
                    ->or_where_open()
                    ->where('major', '=', $this->user_online->Student_Information->major)
                    ->where('term', '=', $Current_Term->id)
                    ->or_where_close()
                    ->or_where_open()
                    ->where('degree', '=', $this->user_online->Student_Information->degree)
                    ->where('term', '=', $Current_Term->id)
                    ->or_where_close()
                    ->find();


                if ($Financials_Manminpayment_Custom->loaded()) {
                    $Amount = $Financials_Manminpayment_Custom->mandatory_percent * $Current_Term_Cost / 100;
                    if (($balance - $Amount) >= 0) {

                    } else {
                        $Balance_Test = TRUE;  //في مشكلة
                    }
                } elseif ($Financials_Manminpayment->loaded()) {
                    $Amount = $Financials_Manminpayment->mandatory_percent * $Current_Term_Cost / 100;
                    if (($balance - $Amount) >= 0) {

                    } else {
                        $Balance_Test = TRUE;  //في مشكلة
                    }
                } else {

                    $Balance_Test = TRUE;
                }
            }


            //نهاية حساب التكاليف

            $Need_To_Review_ = FALSE; //هل يوجد شعب لم يتم طلب اعتماد المرشد لها
            $Wait_To_Review_ = FALSE; //هل يوجد شعب لم يتم موافقة المرشد عليها
            $Stick_table_ = FALSE; //لتحديد زر اعتماد التسجيل
            $Approved_Sections = 0;
            $All_Credit_Hours = 0; // اجمالي الساعات المسجلة لهذا الفصل
            $Credit_Hours_Min_Test = FALSE; //الحد الادنى من الساعات التي يجب تسجيلها
            $Credit_Hours_Max_Test = FALSE; //الحد الاعلى من الساعات التي يجب تسجيلها
            foreach ($ExRel as $value) {
                if ($value->state == null) {
                    $Need_To_Review_ = TRUE;
                }
                if ($value->state == 1) {
                    $Wait_To_Review_ = TRUE;
                }
                if ($value->state == 2) {
                    $Approved_Sections++;
                }
                $All_Credit_Hours += $value->Section->Course->credit_hours;
            }
            $Study_Terms_Hours = ORM::factory('Study_Terms_Hours')->where('term', '=', $Current_Term->id)->where('degree', '=', $this->user_online->Student_Information->degree)->where('is_deleted', '=', NULL)->find();
            $min_hours = $Study_Terms_Hours->min_hours;
            $max_hours = $Study_Terms_Hours->max_hours;

            if ($All_Credit_Hours < $min_hours) {
                $Credit_Hours_Min_Test = TRUE;
            }
            if ($All_Credit_Hours > $max_hours) {
                $Credit_Hours_Max_Test = TRUE;
            }
            if (!empty($Approved_Sections) && $Approved_Sections == count($ExRel)) {
                $Stick_table_ = TRUE;
            }


            if (!$Need_To_Review_ && !$Wait_To_Review_ && !$Credit_Hours_Min_Test && !$Credit_Hours_Max_Test && !$Balance_Test) {

                try {
                    $Student_Term = ORM::factory('Students_Terms')
                        ->where('term', '=', $Current_Term->id)
                        ->where('student', '=', $this->user_online->id)
                        ->where('is_deleted', '=', NULL)
                        ->find();

                    $Student_Term->set('period', $Current_Term->StateOfTerm());
                    $Student_Term->set('term', $Current_Term->id);
                    $Student_Term->set('student', $this->user_online->id);
                    $Student_Term->set('cost', Model_Financials_Payments::CalculateTermCost($this->user_online->id, $Current_Term));
                    $Student_Term->save();

                    foreach ($ExRel as $value) {
                        $value->set('state', 3)->update(); //تم تسجيل المساق
                    }


                    //انشاء قيد مالي
                    $aqsat = ORM::factory('Accounting_Links', 2);
                    $themam = ORM::factory('Accounting_Links', 4); //ذمم الطلاب
                    if ((!empty($aqsat->account_id)) && !empty($aqsat->account_id)) {
                        $Trans_Array1 = array(
                            'branchno' => NULL,
                            'transno' => NULL,
                            'transYear' => Date('Y'),
                            'BranchSubno' => NULL,
                            'Gregorian_date' => date("Y-m-d"),
                            'Hijri_date' => General::ConvertDateToHegri(date("Y-m-d")),
                            'amount' => $Current_Term_Cost,
                            'Description' => $Current_Term->{'name_' . $this->lang} . ' - ' . ' (' . $this->user_online->Student_Information->ID_No . ') ' . $this->user_online->Student_Information->Full_Name_Arabic,
                            'Posted' => 1,
                            'Post_By' => $this->user_online->id,
                            'PostDate' => date("Y-m-d H:i:s"),
                            'Reversedno' => NULL,
                            'ReversedYear' => NULL,
                            'ReversedBranch' => NULL,
                            'CostCenterno' => NULL,
                            'Details' => array(
                                array(
                                    'transYear' => Date('Y'),
                                    'AccYear' => NULL,
                                    'posted' => 1,
                                    'TransNo' => NULL,
                                    'AccNo' => $themam->account_id,
                                    'debit' => $Current_Term_Cost,
                                    'credit' => NULL,
                                    'Description' => NULL,
                                    'PreDebitBal' => NULL,
                                    'PreCreditBal' => NULL,
                                    'CostCenterno' => NULL,
                                ),
                                array(
                                    'transYear' => Date('Y'),
                                    'AccYear' => NULL,
                                    'posted' => 1,
                                    'TransNo' => NULL,
                                    'AccNo' => $aqsat->account_id,
                                    'debit' => NULL,
                                    'credit' => $Current_Term_Cost,
                                    'Description' => NULL,
                                    'PreDebitBal' => NULL,
                                    'PreCreditBal' => NULL,
                                    'CostCenterno' => NULL,
                                ),
                            ),
                        );
                        $ToDB = Model_Accounting_Accounts_Trans::TransToDB($Trans_Array1, NULL, $this->user_online);
                    }

                    //انهاء انشاء قيد مالي

                    $results['Resp'] = array(
                        'theme' => 'lime', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
                        'horizontalEdge' => 'top', //top,bottom
                        'verticalEdge' => 'right', //right,left
                        'heading' => '',
                        'life' => '10000', //1000 is 1 second
                        'text' => Lang::__('Sections has been registered successfully') . ' ' . Lang::__('Reg_Not_will_modi'),
                    );
                } catch (ORM_Validation_Exception $e) {
                    $errors = $e->errors('');
                    $results['Errors'] = array(
                        'title' => Lang::__('Error'),
                        'content' => General::CatchErrorMSGSAjax($errors),
                    );
                }
            } else {
                $Errors = '';
                if ($Need_To_Review_ || $Wait_To_Review_) {
                    $Errors .= Lang::__('Sections now waiting for the approval');
                }
                if ($Credit_Hours_Min_Test) {
                    $Errors .= Lang::__('credit_hours_less_than_min_term');
                }
                if ($Credit_Hours_Max_Test) {
                    $Errors .= Lang::__('credit_hours_more_than_max_term');
                }
                if ($Balance_Test) {
                    $Errors .= Lang::__('You pay all required to complete the registration of financial fees');
                }
                $results['Errors'] = array(
                    'title' => Lang::__('Error'),
                    'content' => $Errors,
                );
            }
        }
        echo json_encode($results);
    }

    public function action_DeleteSectionRel()
    {
        $results = array();
        if (!empty($this->user_online->id)) {
            $req = Request::current(); //fillter requset
            $Filtered_array = Search::action_Filtered_array($req->post());
            $Current_Term = ORM::factory('Study_Terms', ORM::factory('Variables', 78)->value);
            $StateOfTerm = $Current_Term->StateOfTerm();

            //فحص اذا الطالب مسجل للفصل
            $STerms = ORM::factory('Students_Terms')
                ->where('student', '=', $this->user_online->id)
                ->where('term', '=', $Current_Term->id)
                ->where('is_deleted', '=', NULL)
                ->find();

            if ($STerms->loaded() && (!in_array($StateOfTerm, array('Drag and added period', 'Registration period fine', 'Regular registration period')))) {
                $results['Resp'] = array(
                    'theme' => 'ruby', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
                    'horizontalEdge' => 'top', //top,bottom
                    'verticalEdge' => 'right', //right,left
                    'heading' => '',
                    'life' => '2000', //1000 is 1 second
                    'text' => Lang::__('You can not delete section from schedule after the completion of the registration process'),
                );
            } else {
                $Obj = ORM::factory('Study_Sections', $Filtered_array['id']);
                if ($Obj->loaded()) {
                    $StudSections = ORM::factory('Students_Sections')
                        ->where('student', '=', $this->user_online->id)
                        ->where('term', '=', $Current_Term->id)
                        ->where('section', '=', $Obj->id)
                        ->where('is_deleted', '=', NULL)
                        ->find();
                    if ($StudSections->loaded()) {
                        try {
                            $StudSections->is_deleted = 1;
                            $StudSections->deleted_date = date("Y-m-d H:i:s");
                            $StudSections->deleted_by = $this->user_online->id;
                            if ($StudSections->update()) {
                                $results['Resp'] = array(
                                    'theme' => 'lime', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
                                    'horizontalEdge' => 'top', //top,bottom
                                    'verticalEdge' => 'right', //right,left
                                    'heading' => Lang::__('Deletion has been successfully'),
                                    'life' => '2000', //1000 is 1 second
                                    'text' => '',
                                );
                            }
                        } catch (ORM_Validation_Exception $e) {

                            $errors = $e->errors('');
                            $results['Resp'] = array(
                                'theme' => 'ruby', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
                                'horizontalEdge' => 'top', //top,bottom
                                'verticalEdge' => 'right', //right,left
                                'heading' => Lang::__('Error'),
                                'life' => '5000', //1000 is 1 second
                                'text' => General::CatchErrorMSGSAjax($errors),
                            );
                        }


//                        if ($StudSections->state == NULL) {
//                            if ($StudSections->delete()) {
//                                $results['Resp'] = array(
//                                    'theme' => 'lime', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
//                                    'horizontalEdge' => 'top', //top,bottom
//                                    'verticalEdge' => 'right', //right,left
//                                    'heading' => Lang::__('Deletion has been successfully'),
//                                    'life' => '2000', //1000 is 1 second
//                                    'text' => '',
//                                );
//                            }
//                        } elseif ($StudSections->state == 1) {
//                            $results['Resp'] = array(
//                                'theme' => 'ruby', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
//                                'horizontalEdge' => 'top', //top,bottom
//                                'verticalEdge' => 'right', //right,left
//                                'heading' => Lang::__('Error'),
//                                'life' => '2000', //1000 is 1 second
//                                'text' => Lang::__('You can not delete section is awaiting the approval'),
//                            );
//                        } elseif ($StudSections->state == 2) {
//                            $results['Resp'] = array(
//                                'theme' => 'ruby', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
//                                'horizontalEdge' => 'top', //top,bottom
//                                'verticalEdge' => 'right', //right,left
//                                'heading' => Lang::__('Error'),
//                                'life' => '2000', //1000 is 1 second
//                                'text' => Lang::__('You can not delete section'),
//                            );
//                        } elseif ($StudSections->state == 3) {
//                            $results['Resp'] = array(
//                                'theme' => 'ruby', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
//                                'horizontalEdge' => 'top', //top,bottom
//                                'verticalEdge' => 'right', //right,left
//                                'heading' => Lang::__('Error'),
//                                'life' => '2000', //1000 is 1 second
//                                'text' => Lang::__('You can not delete section'),
//                            );
//                        }
                    } else {
                        $results['Resp'] = array(
                            'theme' => 'ruby', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
                            'horizontalEdge' => 'top', //top,bottom
                            'verticalEdge' => 'right', //right,left
                            'heading' => Lang::__('Error'),
                            'life' => '2000', //1000 is 1 second
                            'text' => Lang::__('Not_found_the_desired_item'),
                        );
                    }
                } else {
                    $results['Resp'] = array(
                        'theme' => 'ruby', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
                        'horizontalEdge' => 'top', //top,bottom
                        'verticalEdge' => 'right', //right,left
                        'heading' => Lang::__('Error'),
                        'life' => '2000', //1000 is 1 second
                        'text' => Lang::__('Not_found_the_desired_item'),
                    );
                }
            }
        } else {
            $results['Resp'] = array(
                'theme' => 'ruby', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
                'horizontalEdge' => 'top', //top,bottom
                'verticalEdge' => 'right', //right,left
                'heading' => Lang::__('Error'),
                'life' => '2000', //1000 is 1 second
                'text' => Lang::__('Please sign in to continue'),
            );
        }
        echo json_encode($results);
    }

}

// End Onlinereg

    