<?php

defined('SYSPATH') or die('No direct script access.');

class Controller_Stores_Detection extends Controller_Template_Base {

    public $Browse_Employees_Detection = FALSE;
    public $Browse_Suppliers_Detection = FALSE;

    public function __construct(Request $request, Response $response) {
        // You must call parent::__construct at some point in your function
        parent::__construct($request, $response);
        // Do whatever else you want

        $this->Browse_Employees_Detection = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'Browse_Employees_Detection')));
        $this->Browse_Suppliers_Detection = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'Browse_Suppliers_Detection')));
    }

    public function action_Show() {
        $par1 = mb_strtolower($this->request->param('par1'));
        if (($this->Browse_Employees_Detection && $par1 == 'employees') || ($this->Browse_Suppliers_Detection && $par1 == 'suppliers')) {
            $title = Lang::__('Browse_' . $par1 . '_Detection');
            $this->template->title = $title;
            $this->template->layout = new View('system/stores/detection/view_all');
            $this->template->layout->title = $title;
            if ($par1 == 'employees') {
                $this->template->layout->Employees = ORM::factory('Hr_Employment_Applications')->where('app_status', '=', 1)->where('is_deleted', '=', NULL)->find_all();
            }
            if ($par1 == 'suppliers') {
                $this->template->layout->Suppliers = ORM::factory('Accounting_Accounts')->where('type_of_account', '=', 2)->where('is_deleted', '=', NULL)->find_all();
            }
            $this->template->layout->type = $par1;
            $this->template->layout->lang = $this->lang;
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }

    public function action_GetData() {
        $post = $this->request->post();
        $type = !empty($post['par1']) ? $post['par1'] : NULL;
        if (isset($post['action']) && (!is_array($post['action'])) && mb_strtolower($post['action']) == 'filter') {

            if (in_array($type, array('employees', 'suppliers'))) {

                if (($this->Browse_Employees_Detection && ($type == 'employees')) || ($this->Browse_Suppliers_Detection && ($type == 'suppliers'))) {


                    $from_date = !empty($post['from_date']) ? $post['from_date'] : NULL;
                    $to_date = !empty($post['to_date']) ? $post['to_date'] : NULL;



                    if ($type == 'employees') {
                        $Employee_id = !empty($post['employee']) ? $post['employee'] : NULL;
                        $Employee = ORM::factory('Hr_Employment_Applications', $Employee_id);
                    } elseif ($type == 'suppliers') {
                        $supplier_id = !empty($post['supplier']) ? $post['supplier'] : NULL;
                        $Supplier = ORM::factory('Accounting_Accounts', $supplier_id);
                    }
                    if (((isset($Employee) && $Employee->loaded()) || (isset($Supplier) && $Supplier->loaded() && ($Supplier->type_of_account == 2))) && ($to_date >= $from_date)) {

                        if (isset($Employee) && $Employee->loaded()) {

                            $Stores_Goods_Receipts_Vouchers = $Employee->Stores_Goods_Receipts_Vouchers->where('is_deleted', '=', NULL);
                            if (!empty($from_date)) {
                                $Stores_Goods_Receipts_Vouchers = $Stores_Goods_Receipts_Vouchers->where("Created_date", ">=", $from_date);
                            }
                            if (!empty($to_date)) {
                                $Stores_Goods_Receipts_Vouchers = $Stores_Goods_Receipts_Vouchers->where("Created_date", "<=", $to_date);
                            }
                            $Stores_Goods_Receipts_Vouchers = $Stores_Goods_Receipts_Vouchers->find_all();



                            $Stores_Goods_Delivery_Vouchers = $Employee->Stores_Goods_Delivery_Vouchers->where('is_deleted', '=', NULL);
                            if (!empty($from_date)) {
                                $Stores_Goods_Delivery_Vouchers = $Stores_Goods_Delivery_Vouchers->where("Created_date", ">=", $from_date);
                            }
                            if (!empty($to_date)) {
                                $Stores_Goods_Delivery_Vouchers = $Stores_Goods_Delivery_Vouchers->where("Created_date", "<=", $to_date);
                            }

                            $Stores_Goods_Delivery_Vouchers = $Stores_Goods_Delivery_Vouchers->find_all();
                        } elseif (isset($Supplier) && $Supplier->loaded()) {
                            
                            $Stores_Goods_Receipts_Vouchers = $Supplier->Stores_Goods_Receipts_Vouchers->where('is_deleted', '=', NULL);
                            if (!empty($from_date)) {
                                $Stores_Goods_Receipts_Vouchers = $Stores_Goods_Receipts_Vouchers->where("Created_date", ">=", $from_date);
                            }
                            if (!empty($to_date)) {
                                $Stores_Goods_Receipts_Vouchers = $Stores_Goods_Receipts_Vouchers->where("Created_date", "<=", $to_date);
                            }
                            $Stores_Goods_Receipts_Vouchers = $Stores_Goods_Receipts_Vouchers->find_all();



                            $Stores_Goods_Delivery_Vouchers = $Supplier->Stores_Goods_Delivery_Vouchers->where('is_deleted', '=', NULL);
                            if (!empty($from_date)) {
                                $Stores_Goods_Delivery_Vouchers = $Stores_Goods_Delivery_Vouchers->where("Created_date", ">=", $from_date);
                            }
                            if (!empty($to_date)) {
                                $Stores_Goods_Delivery_Vouchers = $Stores_Goods_Delivery_Vouchers->where("Created_date", "<=", $to_date);
                            }

                            $Stores_Goods_Delivery_Vouchers = $Stores_Goods_Delivery_Vouchers->find_all();
                            
                        }

                        $ResARr = array();
                        foreach ($Stores_Goods_Receipts_Vouchers as $value) {
                            array_push($ResARr, array(
                                'type' => 'Receipts',
                                'p_id' => $value->id,
                                'details_url' => URL::base().'Stores_Goods_Receipts/AE/'.$value->id,
                                'store' => $value->Store->{'name_' . $this->lang},
                                'Created_by' => $value->Created_by_User->{'name_' . $this->lang},
                                'Created_date' => $value->Created_date,
                            ));
                        }
                        foreach ($Stores_Goods_Delivery_Vouchers as $value) {
                            array_push($ResARr, array(
                                'type' => 'Delivery',
                                'p_id' => $value->id,
                                'details_url' => URL::base().'Stores_Goods_Delivery/AE/'.$value->id,
                                'store' => $value->Store->{'name_' . $this->lang},
                                'Created_by' => $value->Created_by_User->{'name_' . $this->lang},
                                'Created_date' => $value->Created_date,
                            ));
                        }


                        $Succesful_msg = Lang::__('Action_successfully_has_been_completed_Well_done');
                        $C_Acti_status = "OK";

                        /*
                         * Paging
                         */
                        $iTotalRecords = count($ResARr);

                        $iDisplayLength = intval($post['length']);
                        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
                        $iDisplayStart = intval($post['start']);
                        $sEcho = intval($post['draw']);

                        $records = array();
                        $records["data"] = array();

                        $end = $iDisplayStart + $iDisplayLength;
                        $end = $end > $iTotalRecords ? $iTotalRecords : $end;


                        /*
                         * Prepare JSON Array
                         */
                        foreach ($ResARr as $value) {
                            $buttons = '';
                            $buttons .= '<a class="btn btn-block green" href="'.$value['details_url'].'">'.Lang::__('Details').'</a>';

                            $records["data"][] = array(
                            Lang::__($value['type']),
                                $value['p_id'],
                                $value['store'],
                                $value['Created_by'],
                                $value['Created_date'],
                                $buttons,
                            );
                        }
                    } else {
                        
                    }
                }
            }
        }
        if (isset($post["customActionType"]) && $post["customActionType"] == "group_action") {
            $records["customActionStatus"] = $C_Acti_status; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = $Succesful_msg; // pass custom message(useful for getting status of group actions)
        }

        $records["draw"] = isset($sEcho) ? $sEcho : intval($post['draw']);
        $records["recordsTotal"] = isset($iTotalRecords) ? $iTotalRecords : 0;
        $records["recordsFiltered"] = isset($iTotalRecords) ? $iTotalRecords : 0;
        if (!isset($records["data"])) {
            $records["data"] = array();
        }
        echo json_encode($records);
    }

}
