<?php

defined('SYSPATH') or die('No direct script access.');

class Controller_Speeches extends Controller_Template_Base {

    public $Browse_ContactPersons = FALSE;

    public function __construct(Request $request, Response $response) {
        // You must call parent::__construct at some point in your function
        parent::__construct($request, $response);
        // Do whatever else you want

        if (empty($this->user_online)) {
            $this->redirect('/', 302);
        }
        $this->Browse_ContactPersons = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'B_Contactperson')));
    }

    public function action_test() {
        // echo Mailer::SendEmail(null, null, "dev.ahmad.b@gmail.com", "jaleat email", "test");
    }
    public function action_GetLastRowNumber(){
        $data = ORM::factory('Speeches')->limit(1)->order_by("id","DESC")->find_all();
        $cout = 0;
        foreach($data as $row){
            $cout = $row->id;
        }
        if($cout != 0){
            echo $cout;
        }else{
            echo '0';
        }
    }
    public function action_index() {
        $Noti = ORM::factory("Notifications")->where('affected_user', '=', $this->user_online->id)->find_all();
        foreach ($Noti as $val) {
            $val->seen_in_system = 1;
            $val->seen_in_system = date("Y-m-d H:i:s");
            $val->save();
        }

        $data = ORM::factory('Speeches')->where('readed', '=', '0')->find_all();
        $count = 0;
        foreach ($data as $row) {
            if (in_array($this->user_online->id, explode(",", $row->email))) {
                $count++;
            }
        }
        $video = new View('system/speeches/view_all');
        $video->set('inbox_count', $count);
        $this->template->Browse_ContactPersons = $this->Browse_ContactPersons;
        $this->template->title = Lang::__('speeches');
        $this->template->layout = $video;
        $this->template->layout->user_online = $this->user_online;
    }

    public function action_UploadAttachments() {

        $directory = 'files/speeches/' . date('Y') . '/' . date("m") . '/';
        $directory_thumbs = $directory . 'thumbs/';

        $directory_D = DOCROOT . str_replace("\\", "/", $directory);
        if (!file_exists($directory_D)) {
            mkdir($directory_D, 0777, true);
        }

        $directory_thumbs_D = DOCROOT . str_replace("\\", "/", $directory_thumbs);
        if (!file_exists($directory_thumbs_D)) {
            mkdir($directory_thumbs_D, 0777, true);
        }
        if (isset($_FILES['files']['name']) && Upload::size($_FILES['files'], '2M')) {
            if (($_FILES['files']['name'][0] != '')) {
                $ext = pathinfo($_FILES['files']['name'][0], PATHINFO_EXTENSION);
                $filename = 'upload_' . date('Y_m_d') . '_' . $_FILES['files']['name'][0];
                $file_ary = $this->reArrayFiles($_FILES['files']);

                foreach ($file_ary as $file) {
                    $file = Upload::save($file, $filename, $directory);
                }

                $uploadArray[] = array('name' => $filename,
                    "size" => 10);
            }
            $results['files'] = $uploadArray;
        } else {
            $results['Errors'] = array(
                'title' => Lang::__('Error') . '#1',
                'content' => Lang::__('error_file_size')
            );
        }
        echo json_encode($results);


        //error_reporting(E_ALL | E_STRICT);
        //$ext = pathinfo($_FILES['files']['name'], PATHINFO_EXTENSION);
        // $filename = 'upload_' . date('Y_m_d') . '_' . rand(0, 10) . rand(0, 10) . rand(0, 10) . rand(0, 10) . rand(0, 10);
        // $file = Upload::save($_FILES['img'], $filename . '.' . $ext, $directory);
    }

    function reArrayFiles(&$file_post) {

        $file_ary = array();
        $file_count = count($file_post['name']);
        $file_keys = array_keys($file_post);

        for ($i = 0; $i < $file_count; $i++) {
            foreach ($file_keys as $key) {
                $file_ary[$i][$key] = $file_post[$key][$i];
            }
        }

        return $file_ary;
    }

    public function action_composeForm() {
        $view = View::factory('system/speeches/composeForm');
        $view->set('lang', $this->lang);
        $view->set('Browse_ContactPersons', $this->Browse_ContactPersons);
        return $this->response->body($view);
    }

    public function action_replaForm() {
        $Obj = ORM::factory('Speeches', $_GET['messageid']);
        $view = View::factory('system/speeches/composeForm');
        if ($Obj->loaded()) {
            $view->set('messageReply', $Obj);
        }
        $view->set('lang', $this->lang);

        return $this->response->body($view);
    }

    public function action_View() {
        //$req = Request::current(); //fillter requset
        //$Filtered_array = Search::action_Filtered_array($req->GET());
        //print_r($Filtered_array);
        $Message_id = $_GET['message_id']; //$Filtered_array['message_id'];
        $view = View::factory('system/speeches/view_message');
        $process_type = 'add_new';
        $Obj = ORM::factory('Speeches', $Message_id);
        $canReplay = true;
        if ($Obj->loaded()) {
            $data1 = explode(",", $Obj->email);
            foreach ($data1 as $row) {
                if (substr($row, 0, 1) == 'c') {
                    $canReplay = false;
                }
            }
            $Obj->readed = 1;
            $Obj->save();
            $view->set('Obj', $Obj);
            $view->set('canReplay', $canReplay);
            $process_type = 'view';
        } else {
            
        }
        $view->set('title', Lang::__($process_type));
        $view->set('lang', $this->lang);
        $this->response->body($view);
    }

    public function action_ViewList() {
        $view = View::factory('system/speeches/viewList');
        $par1 = $_GET['type'];
        if ($par1 == "inbox") {
            $Obj = ORM::factory('Speeches')->find_all();
        } else if ($par1 == "sent") {
            $view->set('type_view', 'sent');
            $Obj = ORM::factory('Speeches')->where('Created_by', '=', $this->user_online->id)->find_all();
        } else {
            $Obj = ORM::factory('Speeches')->find_all();
        }
        $view->set('data', $Obj);
        $view->set('myid', $this->user_online);
        $this->response->body($view);
    }

    public function action_Delete() {
        $array = explode(',', $_GET['ids']);
        foreach ($array as $row) {
            $objj = ORM::factory('Speeches', $row);
            if ($objj->loaded()) {

                if ($objj->delete()) {
                    
                } else {
                    return FALSE;
                }
            }
        }
    }

    public function action_ToDB() {


        $results = array();

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());
        // print_r($req);
        $directory = 'files/speeches/' . date('Y') . '/' . date("m") . '/';
        //echo Upload::save($Filtered_array['files[]'][0], NULL, $directory);
        $obj_id = $Filtered_array['par1'];
        $objj = ORM::factory('Speeches', $obj_id);

        if ($objj->loaded()) {
            $objj->last_update_by = $this->user_online->id;
            $objj->last_update_date = date("Y-m-d H:i:s");
        } else {
            $objj->Created_by = $this->user_online->id;
            $objj->Created_date = date("Y-m-d H:i:s");
        }
        if (array_key_exists("email", $Filtered_array)) {
            $data1 = implode(",", $Filtered_array['email']);

            $objj->email = $data1;
        } else {
            $results['Errors'] = array("الرجاء تحديد لمن الخطاب");
        }
        $objj->name = $Filtered_array['name'];
        $objj->message = $Filtered_array['message'];
        if (isset($Filtered_array['archive_folder'])) {
            $objj->archive_url = $Filtered_array['archive_folder'];
            $objj->important = $Filtered_array['how_important'];
        }
        $uploadArray = array();
        $count = 1;
        while (isset($Filtered_array['f_' . $count])) {
            $uploadArray[] = $directory . $Filtered_array['f_' . $count];
            $count++;
        }
        if (sizeof($uploadArray) != 0) {
            $objj->upload_files = implode(",", $uploadArray);
        }
        try {
            if ($objj->save()) {
                if ($objj->admin_reply_status != 1) {
                    //Send MSG here
                    $Sent_results = TRUE;
                    if ($Sent_results == TRUE) {
                        foreach ($Filtered_array['email'] as $val) {
                            $objj->admin_reply_status = 1;
                            $objj->save();
                            if (substr($val, 0, 1) != 'c') {
                                $Noti1 = ORM::factory("Notifications");
                                $Noti1->notification_cat = 1;
                                $Noti1->first_ref = $objj->id;
                                $Noti1->affected_user = $val;
                                $Noti1->effected_by = $this->user_online->id;
                                $Noti1->Created_date = date("Y-m-d H:i:s");
                                $Noti1->save();
                                $viewMessageBody = View::factory('system/email_message');
                                $viewMessageBody->username = $this->user_online->name_ar;
                                $viewMessageBody->type = 1;
                                $users = ORM::factory('Hr_Employment_Applications')->where('id', '=', $val)->find_all();
                                foreach ($users as $vals) {
                                     Mailer::SendEmail(null, null, $vals->email, "jaleat email", $viewMessageBody);
                                }
                            } else {
                                $objj->type = 1;
                                $objj->save();
                                $viewMessageBody = View::factory('system/email_message');
                                $viewMessageBody->username = $this->user_online->name_ar;
                                $viewMessageBody->type = 1;
                                $viewMessageBody->title = $Filtered_array['name'];
                                $viewMessageBody->messageID = $objj->id + 1000;
                                $viewMessageBody->message = $Filtered_array['message'];
                                $viewMessageBody->archive_url = $objj->archive_url;
                                $im = "هام جدا";
                                if ($objj->important == 0) {
                                    $im = "هام جدا";
                                } else if ($objj->important == 1) {
                                    $im = "هام ";
                                } else {
                                    $im = "متوسط";
                                }
                                $viewMessageBody->important = $im;
                                $viewMessageBody->attachments = $objj->upload_files;
                                $users = ORM::factory('Contactperson_Getinfo')->where('id', '=', ltrim($val, 'c'))->find_all();
                                foreach ($users as $vals) {
                                    Mailer::SendEmail(null, null, $vals->email, "jaleat email", $viewMessageBody);
                                }
                            }
                        }
                    }
                    //End Send MSG
                }
                $results['Success'] = '';
            }
        } catch (ORM_Validation_Exception $e) {
            $errors = $e->errors('');
            $Lang_Error = array();
            foreach ($errors as $key => $value) {
                $srting = '';
                $errr = explode('*', $value);
                if (count($errr) > 0) {
                    foreach ($errr as $aaa) {
                        $srting .= Lang::__($aaa) . ' ';
                    }
                    array_push($Lang_Error, $srting);
                }
            }
            $results['Errors'] = $Lang_Error;
        }
        echo json_encode($results);
    }

    public function action_simulate() {
        $viewMessageBody = View::factory('system/email_message');
        $viewMessageBody->username = "أحمد نوباني";
        $viewMessageBody->type = 1;
        $viewMessageBody->title = "اختبار عنوان";
        $viewMessageBody->messageID = 1000;
        $viewMessageBody->message = "الرسالة تحتوي على معلومات كثيرة";
        $viewMessageBody->archive_url = "ملفات الارشيفية";
        $objj = 0;
        $im = "هام جدا";
        if ($objj == 0) {
            $im = "هام جدا";
        } else if ($objj == 1) {
            $im = "هام ";
        } else {
            $im = "متوسط";
        }
        $viewMessageBody->important = $im;
        $viewMessageBody->attachments = "files/speeches/2019/07/upload_2019_07_31_logo.png,files/speeches/2019/07/upload_2019_07_31_logo.png";
        //$users = ORM::factory('Contactperson_Getinfo')->where('id', '=', ltrim($val, 'c'))->find_all();
        echo $viewMessageBody;
    }

    public function action_markAsRead() {
        $array = explode(',', $_GET['ids']);
        foreach ($array as $row) {
            $objj = ORM::factory('Speeches', $row);
            if ($objj->loaded()) {
                $objj->readed = 1;
                $objj->save();
            }
        }
    }

    public function action_GetData() {
        $post = $this->request->post();
        //$order = $post['order']; //Get how table order from datatable

        /*
         * All coulums will shown in table
         */
        $ALL_coulums = array(
            1 => "id",
        );

        $All_ORM = ORM::factory('Speeches');
        // ->order_by($ALL_coulums[$order[0]['column']], $order[0]['dir']);


        $Succesful_msg = Lang::__('Action_successfully_has_been_completed_Well_done');
        $C_Acti_status = "OK";

        /*
         * If Action exists
         */
        if (isset($post['customActionName'])) {
            switch ($post['customActionName']) {
                case 'Delete':
                    $ids = array();
                    foreach ($post['id'] as $value) {
                        if ($this->action_Delete($value) === FALSE) {
                            array_push($ids, $value);
                        }
                    }

                    break;


                default:
                    break;
            }
        }


        /*
         * if search exists
         */
        if (isset($post['action']) && (!is_array($post['action'])) && mb_strtolower($post['action']) == 'filter') {
            
        }

        /*
         * Paging
         */
        $All_ORM->reset(FALSE);
        $iTotalRecords = $All_ORM->count_all();

        $iDisplayLength = intval($post['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($post['start']);
        $sEcho = intval($post['draw']);

        $records = array();
        $records["data"] = array();

        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;

        $All_ORM->offset($iDisplayStart);
        $All_ORM->limit($iDisplayLength);


        /*
         * Prepare JSON Array
         */
        foreach ($All_ORM->find_all() as $value) {
            $records["data"][] = array(
                '<input type="checkbox" name="id[]" value="' . $value->id . '">',
                $value->name,
                $value->email,
                $value->mobile,
                $value->Created_date,
                '<a data-url="' . URL::base() . 'Speechescp/View/' . $value->id . '" class="btn btn-xs default EDIT" data-toggle="modal"><i class="fa fa-view"></i> ' . Lang::__('view') . '</a>',
            );
        }
        if (isset($post["customActionType"]) && $post["customActionType"] == "group_action") {
            $records["customActionStatus"] = $C_Acti_status; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = $Succesful_msg; // pass custom message(useful for getting status of group actions)
        }

        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;

        echo json_encode($records);
    }

}

// End Speechescp
