<?php

defined('SYSPATH') or die('No direct script access.');

class Controller_Settings extends Controller_Template_Base {

    public $General_Settings_Control = FALSE;
    public $E_Registration_Settings = FALSE;
    public $E_WebSite_Settings = FALSE;
    public $E_hr_Settings = FALSE;
    public $Journal_Control = FALSE;

    public function __construct(Request $request, Response $response) {
        // You must call parent::__construct at some point in your function
        parent::__construct($request, $response);
        // Do whatever else you want

        $this->General_Settings_Control = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'General_Settings_Control')));
        $this->E_Registration_Settings = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'E_Registration_Settings')));
        $this->E_WebSite_Settings = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'E_WebSite_Settings')));
        $this->E_hr_Settings = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'E_hr_Settings')));
        $this->Journal_Control = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'Journal_Control')));
    }

    public function action_Custom() {

        $par1 = mb_strtolower($this->request->param('par1'));
        $permission = TRUE;
        switch ($par1) {
            case "registration":
                if ($this->E_Registration_Settings && $permission) {
                    $this->template->layout = new View('system/settings/registration');
                    $this->template->title = Lang::__('Registration Settings');
                } else {
                    $permission = FALSE;
                }
                break;
            case "website":
                if ($this->E_WebSite_Settings && $permission) {
                    $this->template->layout = new View('system/settings/website');
                    $this->template->title = Lang::__('website Settings');
                } else {
                    $permission = FALSE;
                }
                break;
            case "journal":
                if ($this->Journal_Control && $permission) {
                    $this->template->layout = new View('system/settings/journal');
                    $this->template->title = Lang::__('Journal_Control');
                } else {
                    $permission = FALSE;
                }
                break;
            case "hr":
                if ($this->E_hr_Settings && $permission) {
                    $this->template->layout = new View('system/settings/hr');
                    $this->template->title = Lang::__('website Settings');
                } else {
                    $permission = FALSE;
                }
                break;

            default:
                break;
        }

        if (!$permission) {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }


        $this->template->layout->Arabic = $this->Arabic;
        $this->template->layout->English = $this->English;
        $this->template->layout->lang = $this->lang;

        $this->template->layout->Variables_Array = Search::action_FindAll_To_Array(ORM::factory('Variables')->find_all());
    }

    public function action_index() {


        if ($this->General_Settings_Control) {

            $this->template->title = Lang::__('Settings');
            $this->template->layout = new View('system/settings');

            $this->template->layout->Arabic = $this->Arabic;
            $this->template->layout->English = $this->English;
            $this->template->layout->Hebrew = $this->Hebrew;

            $this->template->layout->Variables_Array = Search::action_FindAll_To_Array(ORM::factory('Variables')->find_all());
        } else {
            $this->redirect('/', 302);
        }
    }

    public function action_ToDB() {
        if ($this->General_Settings_Control || $this->E_Registration_Settings || $this->E_WebSite_Settings || $this->E_hr_Settings || $this->Journal_Control) {

            $post = $this->request->post();
            $vars = ORM::factory('Variables')
                    ->find_all();
            foreach ($vars as $value) {
                $varname = 'value' . $value->id;
                $value_ar = 'value_ar' . $value->id;
                $value_en = 'value_en' . $value->id;
                $value_he = 'value_he' . $value->id;
                $texname = 'text_ar' . $value->id;
                $texname_en = 'text_en' . $value->id;
                $texname_he = 'text_he' . $value->id;
                $img = 'img' . $value->id;

                if (isset($post[$varname])) {
                    $ch = ORM::factory('Variables', $value->id);
                    $ch->value = Lang::safehtml($post[$varname]);
                    $ch->save();
                }
                if (isset($post[$value_ar])) {
                    $ch = ORM::factory('Variables', $value->id);
                    $ch->value_ar = Lang::safehtml($post[$value_ar]);
                    $ch->save();
                }
                if (isset($post[$value_he])) {
                    $ch = ORM::factory('Variables', $value->id);
                    $ch->value_he = Lang::safehtml($post[$value_he]);
                    $ch->save();
                }
                if (isset($post[$value_en])) {
                    $ch = ORM::factory('Variables', $value->id);
                    $ch->value_en = Lang::safehtml($post[$value_en]);
                    $ch->save();
                }
                if (isset($post[$texname])) {
                    $ch = ORM::factory('Variables', $value->id);
                    $ch->text_ar = Lang::safehtml($post[$texname]);
                    $ch->save();
                }
                if (isset($post[$texname_en])) {
                    $ch = ORM::factory('Variables', $value->id);
                    $ch->text_en = Lang::safehtml($post[$texname_en]);
                    $ch->save();
                }
                if (isset($post[$texname_he])) {
                    $ch = ORM::factory('Variables', $value->id);
                    $ch->text_he = Lang::safehtml($post[$texname_he]);
                    $ch->save();
                }
                if (isset($_FILES[$img])) {
                    $img = $this->_save_image($_FILES[$img], 400, 400);
                    if ($img) {

                        $ch = ORM::factory('Variables', $value->id);
                        if (file_exists(DOCROOT . $ch->img) && (strlen($ch->img) > 10)) {
                            unlink(DOCROOT . $ch->img);
                        }
                        $ch->img = $img;
                        $ch->save();
                    }
                }
            }

            if ($this->request->method() == Request::POST) {
                if (isset($_FILES['Logo'])) {
                    $img = $this->_save_image($_FILES['Logo'], 520, 130);
                    if ($img) {

                        $ch = ORM::factory('Variables', 1);
                        if (file_exists(DOCROOT . $ch->value) && (strlen($ch->value) > 10)) {
                            unlink(DOCROOT . $ch->value);
                        }
                        $ch->value = $img;
                        $ch->save();
                    }
                }
                if (isset($_FILES['Dean_photo_ar'])) {
                    $img = $this->_save_image($_FILES['Dean_photo_ar'], 500, 500);
                    if ($img) {

                        $ch = ORM::factory('Variables', 89);
                        if (file_exists(DOCROOT . $ch->value) && (strlen($ch->value) > 10)) {
                            unlink(DOCROOT . $ch->value);
                        }
                        $ch->value_ar = $img;
                        $ch->save();
                    }
                }
                if (isset($_FILES['Dean_photo_en'])) {
                    $img = $this->_save_image($_FILES['Dean_photo_en'], 500, 500);
                    if ($img) {

                        $ch = ORM::factory('Variables', 89);
                        if (file_exists(DOCROOT . $ch->value) && (strlen($ch->value) > 10)) {
                            unlink(DOCROOT . $ch->value);
                        }
                        $ch->value_en = $img;
                        $ch->save();
                    }
                }
                if (isset($_FILES['main_footer_image'])) {
                    $img = $this->_save_image($_FILES['main_footer_image'], 1519, 629);
                    if ($img) {

                        $ch = ORM::factory('Variables', 93);
                        if (file_exists(DOCROOT . $ch->value) && (strlen($ch->value) > 10)) {
                            unlink(DOCROOT . $ch->value);
                        }
                        $ch->img = $img;
                        $ch->save();
                    }
                }
                if (isset($_FILES['Logo1'])) {
                    $img = $this->_save_image($_FILES['Logo1'], 160, 130);
                    if ($img) {

                        $ch = ORM::factory('Variables', 81);
                        if (file_exists(DOCROOT . $ch->value) && (strlen($ch->value) > 10)) {
                            unlink(DOCROOT . $ch->value);
                        }
                        $ch->value = $img;
                        $ch->save();
                    }
                }
                if (isset($_FILES['Logo2'])) {
                    $img = $this->_save_image($_FILES['Logo2'], 160, 130);
                    if ($img) {

                        $ch = ORM::factory('Variables', 82);
                        if (file_exists(DOCROOT . $ch->value) && (strlen($ch->value) > 10)) {
                            unlink(DOCROOT . $ch->value);
                        }
                        $ch->value = $img;
                        $ch->save();
                    }
                }
                if (isset($_FILES['journal'])) {
                    $directory = 'files/journal/' . date('Y') . '/' . date("m") . '/';
                    $allowed_ext = array('pdf');
                    $max_size = 5000000;
                    $file = $this->_save_journal($_FILES['journal']);

                    if ($file) {
                        $ch = ORM::factory('Variables', 88);
                        if (file_exists(DOCROOT . $ch->value) && (strlen($ch->value) > 10)) {
                            unlink(DOCROOT . $ch->value);
                        }
                        $ch->value = $file;
                        $ch->save();
                    }
                }
            }

             HTTP::redirect($this->request->referrer(), 302);
        }
    }

    public function action_AJaxToDB() {
        $results = array();

        $post = $this->request->post();
        $vars = ORM::factory('Variables')
                ->find_all();
        foreach ($vars as $value) {
            $varname = 'value' . $value->id;
            $value_ar = 'value_ar' . $value->id;
            $value_en = 'value_en' . $value->id;
            $value_he = 'value_he' . $value->id;
            $texname = 'text_ar' . $value->id;
            $texname_en = 'text_en' . $value->id;
            $texname_he = 'text_he' . $value->id;

            if (isset($post[$varname])) {
                $ch = ORM::factory('Variables', $value->id);
                $ch->value = Lang::safehtml($post[$varname]);
                $ch->save();
            }
            if (isset($post[$value_ar])) {
                $ch = ORM::factory('Variables', $value->id);
                $ch->value_ar = Lang::safehtml($post[$value_ar]);
                $ch->save();
            }
            if (isset($post[$value_he])) {
                $ch = ORM::factory('Variables', $value->id);
                $ch->value_he = Lang::safehtml($post[$value_he]);
                $ch->save();
            }
            if (isset($post[$value_en])) {
                $ch = ORM::factory('Variables', $value->id);
                $ch->value_en = Lang::safehtml($post[$value_en]);
                $ch->save();
            }
            if (isset($post[$texname])) {
                $ch = ORM::factory('Variables', $value->id);
                $ch->text_ar = Lang::safehtml($post[$texname]);
                $ch->save();
            }
            if (isset($post[$texname_en])) {
                $ch = ORM::factory('Variables', $value->id);
                $ch->text_en = Lang::safehtml($post[$texname_en]);
                $ch->save();
            }
            if (isset($post[$texname_he])) {
                $ch = ORM::factory('Variables', $value->id);
                $ch->text_he = Lang::safehtml($post[$texname_he]);
                $ch->save();
            }
        }

        if ($this->request->method() == Request::POST) {
            if (isset($_FILES['Logo'])) {
                $img = $this->_save_image($_FILES['Logo'], 222, 108);
                if ($img) {

                    $ch = ORM::factory('Variables', 1);
                    if (file_exists(DOCROOT . $ch->value) && (strlen($ch->value) > 10)) {
                        unlink(DOCROOT . $ch->value);
                    }
                    $ch->value = $img;
                    $ch->save();
                }
            }
        }
        $results['Success'] = '';
        echo json_encode($results);
    }

    protected function _save_image($image, $width = NULL, $height = NULL) {
        if (!Upload::valid($image) OR ! Upload::not_empty($image) OR ! Upload::type($image, array('jpg', 'jpeg', 'png', 'gif'))) {
            return FALSE;
        }

        $directory = 'files/';

        if ($file = Upload::save($image, NULL, $directory)) {
            $ext = pathinfo($file, PATHINFO_EXTENSION);
            $filename = mb_strtolower(Text::random('alnum', 20)) . '.' . $ext;


            $img = Image::factory($file);
            $img->resize($width, $height, Image::INVERSE);
            $img->save($directory . $filename, 100);

            // Delete the temporary file
            unlink($file);

            return $directory . $filename;
        }

        return FALSE;
    }

    protected function _save_journal($file) {
        if (!Upload::valid($file) OR ! Upload::not_empty($file) OR ! Upload::type($file, array('pdf'))) {
            var_dump($file);
            return FALSE;
        }
        $directory = 'files/journal/' . date('Y') . '/' . date("m") . '/';
        if (!empty($directory)) {
            $directory_D = DOCROOT . str_replace("\\", "/", $directory);
            if (!file_exists($directory_D)) {
                mkdir($directory_D, 0777, true);
            }
        }
        $ext = pathinfo($file['name'], PATHINFO_EXTENSION);
        $filename = strtolower(Text::random('alnum', 22)) . '.' . $ext;
        if ($file = Upload::save($file, $filename, $directory)) {
            
            return $directory . $filename;
        }else{
           
        }

        // return FALSE;
    }

}

// End Settings
