<?php

defined('SYSPATH') or die('No direct script access.');

class Controller_Permissions_Groups extends Controller_Template_Base {

    public $Add = TRUE;
    public $Browse = TRUE;
    public $Edit = TRUE;
    public $Delete = TRUE;

    public function __construct(Request $request, Response $response) {
        // You must call parent::__construct at some point in your function
        parent::__construct($request, $response);
        // Do whatever else you want
        $this->Add = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'Add_permissions_groups')));
        $this->Browse = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'Browse_permissions_groups')));
        $this->Edit = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'Edit_permissions_groups')));
        $this->Delete = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'Delete_permissions_groups')));
    }

    public function action_index() {
        if ($this->Add || $this->Browse || $this->Edit || $this->Delete) {
            $title = Lang::__('Permissions_Groups');
            $this->template->title = $title;
            $this->template->layout = new View('system/permissions/groups/view_all');
            $this->template->layout->title = $title;
            $this->template->layout->Add = $this->Add;
            $this->template->layout->lang = $this->lang;
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }

    public function action_AE() {

        $par1 = $this->request->param('par1');
        $par2 = $this->request->param('par2');

        $process_type = 'add_new';
        $Obj = ORM::factory('Permissions_Groups', $par1);

        if ($Obj->loaded()) {
            $process_type = 'modify';
        }

        if ((($this->Add && $process_type == 'add_new') || ($this->Edit && $process_type == 'modify')) && ($Obj->is_deleted == NULL)) {
            $this->template->layout = new View('system/permissions/groups/AE');

            if ($Obj->loaded()) {
                $this->template->layout->Obj = $Obj;

                $ExRelations = ORM::factory('Permissions_Relations')
                        ->where('groub', '=', $Obj->id)
                        ->find_all();
                $ExRoles = array(0);
                foreach ($ExRelations as $value) {
                    array_push($ExRoles, $value->role);
                }
                $this->template->layout->ExRoles = $ExRoles;
            }
            $this->template->layout->title = Lang::__($process_type);
            $this->template->title = Lang::__($process_type);
            $this->template->layout->lang = $this->lang;
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }

    public function action_Delete() {
        $results = array();

        if ($this->Delete) {
            $req = Request::current(); //fillter requset
            $Filtered_array = Search::action_Filtered_array($req->post());

            $Obj = ORM::factory('Permissions_Groups', $Filtered_array['id']);

            $CheckDeleteRules = $Obj->CheckDeleteRules();
            if ($CheckDeleteRules === TRUE) {
                try {
                    $Obj->is_deleted = 1;
                    $Obj->deleted_by = $this->user_online->id;
                    $Obj->deleted_date = date("Y-m-d H:i:s");
                    if ($Obj->save()) {
                        $results['Success'] = array(
                            'title' => Lang::__('Done'),
                            'content' => Lang::__('Deletion has been successfully'),
                        );
                    }
                } catch (ORM_Validation_Exception $e) {

                    $errors = $e->errors('');
                    $results['Errors'] = array(
                        'title' => Lang::__('Error'),
                        'content' => General::CatchErrorMSGSAjax($errors),
                    );
                }
            } else {
                if (is_array($CheckDeleteRules)) {

                    $results['Errors'] = array(
                        'title' => Lang::__('Error'),
                        'content' => General::ArrayToString($CheckDeleteRules),
                    );
                }
            }
        } else {
            $results['Errors'] = array(
                'title' => Lang::__('Error'),
                'content' => Lang::__('You_dont_have_permission_to_do_this_action'),
            );
        }

        echo json_encode($results);
    }

    public function action_ToDB() {
        $results = array();

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());
        $par1 = empty($Filtered_array['par1']) ? NULL : $Filtered_array['par1'];
        $par2 = empty($Filtered_array['par2']) ? NULL : $Filtered_array['par2'];

        $objj = ORM::factory('Permissions_Groups', $par1);
        if (($this->Add && (!$objj->loaded())) || ($this->Edit && ($objj->loaded()))) {
            if (!$objj->loaded()) {
                $objj->Created_by = $this->user_online->id;
                $objj->Created_date = date("Y-m-d H:i:s");
            } else {
                $objj->last_update_by = $this->user_online->id;
                $objj->last_update_date = date("Y-m-d H:i:s");
            }


            $objj->values($Filtered_array);

            try {
                if ($objj->save()) {

                    //Link Relations
                    if (empty($Filtered_array['Roles'])) {
                        DB::delete(ORM::factory('Permissions_Relations')->table_name())->where('groub', '=', $objj->id)->execute();
                    } else {
                        $Rel_To_deleted = array();
                        $Relations = ORM::factory('Permissions_Relations')
                                ->where('groub', '=', $objj->id)
                                ->find_all();
                        foreach ($Relations as $value) {
                            $Rel_To_deleted[$value->id] = '';
                        }
                        foreach ($Filtered_array['Roles'] as $value) {
                            $Relation = ORM::factory('Permissions_Relations')
                                    ->where('groub', '=', $objj->id)
                                    ->where('role', '=', $value)
                                    ->find();
                            if ($Relation->loaded()) {
                                unset($Rel_To_deleted[$Relation->id]);
                            } else {
                                $Relation = ORM::factory('Permissions_Relations');
                                $Relation->groub = $objj->id;
                                $Relation->role = $value;
                                $Relation->Created_by = $this->user_online->id;
                                $Relation->Created_date = date("Y-m-d H:i:s");
                                $Relation->save();
                            }
                        }
                        foreach ($Rel_To_deleted as $key => $value) {
                            ORM::factory('Permissions_Relations', $key)->delete();
                        }
                    }
                    //End Link Relations

                    $results['Success'] = array(
                        'theme' => 'lime', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
                        'horizontalEdge' => 'top', //top,bottom
                        'verticalEdge' => 'right', //right,left
                        'heading' => '',
                        'life' => '2000', //1000 is 1 second
                        'text' => Lang::__('Saved_successfully'),
                    );
                }
            } catch (ORM_Validation_Exception $e) {

                $errors = $e->errors('');
                $results['Errors'] = General::ArrayToString(General::CatchErrorMSGSAjax($errors));
            }
        } else {
            $results['Errors'] = Lang::__('You_dont_have_permission_to_do_this_action');
        }


        echo json_encode($results);
    }

    public function action_GetData() {

        if ($this->Add || $this->Browse || $this->Edit || $this->Delete) {


            $post = $this->request->post();
            $order = $post['order']; //Get how table order from datatable
            /*
             * All coulums will shown in table
             */
            $ALL_coulums = array(
                1 => "id",
            );

            $All_ORM = ORM::factory('Permissions_Groups')
                    ->where('is_deleted', '=', NULL)
                    ->order_by($ALL_coulums[$order[0]['column']], $order[0]['dir']);


            $Succesful_msg = Lang::__('Action_successfully_has_been_completed_Well_done');
            $C_Acti_status = "OK";

            /*
             * If Action exists
             */
            if (isset($post['customActionName'])) {
                switch ($post['customActionName']) {
                    case 'Delete':


                        break;


                    default:
                        break;
                }
            }


            /*
             * if search exists
             */
            if (isset($post['action']) && (!is_array($post['action'])) && mb_strtolower($post['action']) == 'filter') {
                if (!empty($post['name'])) {

                    $Name = $post['name'];
                    $All_ORM->and_where_open();
                    $All_ORM->or_where(DB::expr('lower(name_ar)'), 'LIKE', mb_strtolower("%$Name%"));
                    $All_ORM->or_where(DB::expr('lower(name_en)'), 'LIKE', mb_strtolower("%$Name%"));
                    $All_ORM->and_where_close();
                }
            }

            /*
             * Paging
             */
            $All_ORM->reset(FALSE);
            $iTotalRecords = $All_ORM->count_all();

            $iDisplayLength = intval($post['length']);
            $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
            $iDisplayStart = intval($post['start']);
            $sEcho = intval($post['draw']);

            $records = array();
            $records["data"] = array();

            $end = $iDisplayStart + $iDisplayLength;
            $end = $end > $iTotalRecords ? $iTotalRecords : $end;


            $All_ORM->offset($iDisplayStart);
            $All_ORM->limit($iDisplayLength);



            /*
             * Prepare JSON Array
             */
            foreach ($All_ORM->find_all() as $value) {
                $buttons = '';

                ($this->Edit) ? $buttons .= '<a href="' . URL::base() . 'Permissions_Groups/AE/' . $value->id . '" class="btn btn-xs default"><i class="fa fa-edit"></i> ' . Lang::__('Edit') . '</a>' : NULL;
                ($this->Delete && ($value->CheckDeleteRules() === TRUE)) ? $buttons .= '<a par1="' . $value->id . '" Dtitle="' . Lang::__('Alert') . '" Dcontent="' . Lang::__('Are_you_sure_you_want_to_delete_it') . '" confirmButton="' . Lang::__('Yes') . '" cancelButton="' . Lang::__('Cancel') . '" class="btn btn-xs red Delete"> ' . Lang::__('Delete') . '</a>' : NULL;


                $records["data"][] = array(
                    '<input type="checkbox" name="id[]" value="' . $value->id . '">',
                    $value->name_ar,
                    $value->name_en,
                    $buttons,
                );
            }
            if (isset($post["customActionType"]) && $post["customActionType"] == "group_action") {
                $records["customActionStatus"] = $C_Acti_status; // pass custom message(useful for getting status of group actions)
                $records["customActionMessage"] = $Succesful_msg; // pass custom message(useful for getting status of group actions)
            }

            $records["draw"] = $sEcho;
            $records["recordsTotal"] = $iTotalRecords;
            $records["recordsFiltered"] = $iTotalRecords;

            echo json_encode($records);
        }
    }

    /*
     * Send Json of rules to jquery validation
     */

    public function action_GetRules() {
        $results = array();

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());

        $par1 = empty($Filtered_array['par1']) ? NULL : $Filtered_array['par1'];

        $ORM = ORM::factory('Permissions_Groups', $par1);

        $results['Rules'] = $ORM->AdminRules($ORM);

        echo json_encode($results);
    }

}
