<?php

defined('SYSPATH') or die('No direct script access.');

class Controller_Permissions extends Controller_Template_Base {

    public $give_delete_permissions = FALSE;

    public function __construct(Request $request, Response $response) {
        // You must call parent::__construct at some point in your function
        parent::__construct($request, $response);
        // Do whatever else you want

        $this->give_delete_permissions = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'give_delete_permissions')));
    }

    public function action_index() {
        if ($this->give_delete_permissions) {
            $id = $this->request->param("par1");

            $Permissions_Sections = ORM::factory('Permissions_Sections', $id);

            if ($Permissions_Sections->loaded()) {
                $title = Lang::__('Permissions') . ' - ' . $Permissions_Sections->{"name_" . $this->lang};
                $this->template->title = $title;
                $this->template->layout = new View('system/permissions/view_all');
                $this->template->layout->title = $title;
                $this->template->layout->Permissions_Sections = $Permissions_Sections;
//
//            foreach ($Permissions_Sections->Roles->find_all() as $value) {
//                $Dictionary = ORM::factory('Dictionary')->where('token', '=', $value->name)->find();
//                if (!$Dictionary->loaded()) {
//                   $ar = explode('_', $value->name);
//                   switch ($ar[0]) {
//                       case 'A':
//                           $fir_ar = Lang::__('Add','ar');
//                           $fir_en = Lang::__('Add','en');
//                           break;
//                       case 'E':
//                           $fir_ar = Lang::__('Edit','ar');
//                           $fir_en = Lang::__('Edit','en');
//                           break;
//                       case 'B':
//                           $fir_ar = Lang::__('Browse','ar');
//                           $fir_en = Lang::__('Browse','en');
//                           break;
//                       case 'D':
//                           $fir_ar = Lang::__('Delete','ar');
//                           $fir_en = Lang::__('Delete','en');
//                           break;
//                       case 'Accept':
//                           $fir_ar = Lang::__('Accept','ar');
//                           $fir_en = Lang::__('Accept','en');
//                           break;
//                       case 'Reject':
//                           $fir_ar = Lang::__('Reject','ar');
//                           $fir_en = Lang::__('Reject','en');
//                           break;
//
//                       default:
//                           break;
//                   }
//                   if(!empty($fir_ar) && !empty($fir_en)){
//                       unset($ar[0]);
//                       $new_t = implode('_', $ar);
//                       
//                       $Dictionary1 = ORM::factory('Dictionary')->where('token', '=', $new_t)->find();
//                       
//                       if($Dictionary1->loaded()){
//                           $Dictionary->token = $value->name;
//                           $Dictionary->txt_ar = $fir_ar.' '.$Dictionary1->txt_ar;
//                           $Dictionary->txt_en = $fir_en.' '.$Dictionary1->txt_en;
//                           $Dictionary->save();
//                          
//                       }
//                       
//                      
//                   }
//                   
//                }
//            }

                $this->template->layout->Role = $Permissions_Sections->Roles->find_all();
                $this->template->layout->UsersNotAdmin = ORM::factory('User')->where('user_groub', 'NOT IN', array(1, 3))->find_all();
                $this->template->layout->lang = $this->lang;
            }
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }

    public function action_PermissionsToDB() {
        if ($this->give_delete_permissions) {
            $results = array();

            $req = Request::current(); //fillter requset
            $Filtered_array = Search::action_Filtered_array($req->post());


            $Permissions_Section = !empty($Filtered_array['par1']) ? $Filtered_array['par1'] : NULL;

            try {
                // اعداد مصفوفة الرول التي تريد تفريغ المستخدمين منها اي التي لم ترسل في البوست
                $RolesToDeleteUsers = array();
                foreach (ORM::factory('Role')->where('section', '=', $Permissions_Section)->find_all() as $value) {
                    $RolesToDeleteUsers[$value->name] = 'R';
                }

                //عمليات الاضافة
                foreach ($Filtered_array as $roleName => $users) {
                    unset($RolesToDeleteUsers[$roleName]);
                    //مستخدمين ليتم حذف الرول تاعتهم
                    $ToDeleteArray = array();
                    $allCurrent = ORM::factory('Role', array('name' => $roleName))->users->where('user_groub', '!=', 1)->find_all();
                    foreach ($allCurrent as $Cuser) {
                        $ToDeleteArray[$Cuser->id] = '';
                    }
                    if (is_array($users)) {
                        foreach ($users as $user) {
                            $ORMUser = ORM::factory('User', $user);
                            unset($ToDeleteArray[$ORMUser->id]);
                            if ($ORMUser->user_groub != 1) {
                                if ($ORMUser->has('roles', ORM::factory('Role', array('name' => $roleName)))) {
                                    
                                } else {
                                    $ORMUser->add('roles', ORM::factory('Role', array('name' => $roleName)));
                                }
                            }
                        }
                    }

                    foreach ($ToDeleteArray as $key => $value) {
                        $ORMUserToDeleteRole = ORM::factory('User', $key);

                        $ORMUserToDeleteRole->remove('roles', ORM::factory('Role', array('name' => $roleName)));
                    }
                }

                foreach ($RolesToDeleteUsers as $key => $value) { //لحذف جميع المستخدمين من الرول التي لم يتم اختيار اي مستخدم لها
                    foreach (ORM::factory('Role', array('name' => $key))->users->where('user_groub', '!=', 1)->find_all() as $UserToDel) {
                        $UserToDel->remove('roles', ORM::factory('Role', array('name' => $key)));
                    }
                }
                $results['Success'] = array(
                    'theme' => 'lime', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
                    'horizontalEdge' => 'top', //top,bottom
                    'verticalEdge' => 'right', //right,left
                    'heading' => '',
                    'life' => '2000', //1000 is 1 second
                    'text' => Lang::__('Saved_successfully'),
                );
            } catch (ORM_Validation_Exception $e) {
                $errors = $e->errors('');
                $Lang_Error = array();
                foreach ($errors as $key => $value) {
                    $srting = '';
                    $errr = explode('*', $value);
                    if (count($errr) > 0) {
                        foreach ($errr as $aaa) {
                            $srting .= Lang::__($aaa) . ' ';
                        }
                        array_push($Lang_Error, $srting);
                    }
                }
                $results['Errors'] = $Lang_Error;
            }
            echo json_encode($results);
        }
    }

}

// End Permissions
