<?php

defined('SYSPATH') or die('No direct script access.');

class Controller_Page extends Controller_Template_Site {

    public function action_view() {

        $par1 = $this->request->param('par1');

        $Page = ORM::factory('Pages', $par1);

        if ($Page->loaded() && empty($Page->is_deleted)) {
            $this->template->layout = new View('site/page/view_page');
            $title = $Page->{'title_' . $this->lang};

            $text = General::Img_Replaces(($Page->{'content_' . $this->lang}));

            $text = preg_replace('/font-family:(.*?);/s', ' ', $text);
            $text = preg_replace('/font-size:(.*?);/s', ' ', $text);


            $this->template->layout->Text = $text;



            $this->template->layout->title = $title;
            $this->template->title = $title;
            $this->template->layout->lang = $this->lang;
        }
    }

    public function action_About() {
        $this->template->layout = new View('site/page/about_us');
        $title = ORM::factory('Variables', 18)->{'value_' . $this->lang};
        $this->template->layout->title = $title;
        $this->template->title = $title;
        $this->template->keywords = ORM::factory('Variables', 19)->{'value_' . $this->lang};
        $this->template->description = ORM::factory('Variables', 20)->{'value_' . $this->lang};
        $this->template->layout->lang = $this->lang;
    }

    public function action_Journal() {
        $this->template->layout = new View('site/page/journal');
        $title = Lang::__("College Newspaper");
        $Journals = ORM::factory('Journal')
            ->where('is_deleted', '=', NULL)
            ->order_by('issue_number', 'desc')
            ->find_all();
        $this->template->layout->Journals = $Journals;
        $this->template->layout->title = $title;
        $this->template->title = $title;
    }

    public function action_Login() {
        if (empty($this->user_online)) {
            $this->template->layout = new View('site/page/login');
            $title = Lang::__('Login');
            $this->template->layout->title = $title;
            $this->template->title = $title;
            $this->template->layout->lang = $this->lang;
        } else {
            $this->redirect('/', 302);
        }
    }

}

// End Page
