<?php

defined('SYSPATH') or die('No direct script access.');

class Controller_Menus extends Controller_Template_Base {

    public $Add = TRUE;
    public $Edit = TRUE;
    public $Browse = TRUE;
    public $Delete = TRUE;

    public function __construct(Request $request, Response $response) {
        // You must call parent::__construct at some point in your function
        parent::__construct($request, $response);
        // Do whatever else you want

        $this->Add = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'A_Site_Menus')));
        $this->Browse = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'B_Site_Menus')));
        $this->Edit = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'E_Site_Menus')));
        $this->Delete = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'D_Site_Menus')));
    }

    public function action_index() {
        $parent = !empty($this->par1) ? $this->par1 : NULL;
        $Section = ORM::factory('Menus', $parent);
        if ($this->Add || $this->Edit || $this->Delete || $this->Browse) {
            if ($Section->loaded()) {
                $title = $Section->{'name_' . $this->lang} . ' - ' . Lang::__('SubMenus');
            } else {
                $title = Lang::__('MainMenus');
            }
            $this->template->title = $title;
            $this->template->layout = new View('system/menus/view_all');
            $this->template->layout->title = $title;
            $this->template->layout->Add = $this->Add;
            $this->template->layout->Edit = $this->Edit;
            $this->template->layout->Delete = $this->Delete;
            $this->template->layout->Section = $Section;
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }

    public function action_AE() {
        $view = View::factory('system/menus/AE');

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());
        $par1 = empty($Filtered_array['par1']) ? NULL : $Filtered_array['par1'];
        $par2 = empty($Filtered_array['par2']) ? NULL : $Filtered_array['par2'];

        $process_type = 'add_new';
        $Obj = ORM::factory('Menus', $par1);

        if ($Obj->loaded()) {
            $Section = ORM::factory('Menus', $Obj->parent);
            $view->set('Obj', $Obj);
            $process_type = 'modify';
        } else {
            $Section = ORM::factory('Menus', $par2);
        }
        if ($Section->loaded()) {
            $view->set('Section', $par2);
        }
        $view->set('Add', $this->Add);

        $view->set('title', Lang::__($process_type));
        $view->set('lang', $this->lang);
        $view->set('Users', Search::action_FindAll_To_Array(ORM::factory('User')->find_all()));

        if ($this->Add || $this->Edit) {
            $this->response->body($view);
        } else {
            $view = View::factory('system/error_modal');
            $view->set('MSG', Lang::__('You_dont_have_permission_to_access_this_page'));
            $this->response->body($view);
        }
    }

    public function action_Delete() {
        $results = array();

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());

        $Categorie = ORM::factory('Menus', $Filtered_array['id']);
        if ($Categorie->loaded()) {
            if ($this->Delete) {
                $Categorie->is_deleted = 1;
                $Categorie->deleted_by = $this->user_online->id;
                if ($Categorie->save()) {
                    $results['Resp'] = array(
                        'theme' => 'lime', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
                        'horizontalEdge' => 'top', //top,bottom
                        'verticalEdge' => 'right', //right,left
                        'heading' => Lang::__('Deletion has been successfully'),
                        'life' => '2000', //1000 is 1 second
                        'text' => $Categorie->{'name_' . $this->lang} . ' ' . Lang::__('has been deleted successfully'),
                    );
                }
            } else {
                $results['Resp'] = array(
                    'theme' => 'ruby', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
                    'horizontalEdge' => 'top', //top,bottom
                    'verticalEdge' => 'right', //right,left
                    'heading' => Lang::__('Error'),
                    'life' => '2000', //1000 is 1 second
                    'text' => Lang::__('You_dont_have_permission_to_do_this_action'),
                );
            }
        } else {
            $results['Resp'] = array(
                'theme' => 'ruby', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
                'horizontalEdge' => 'top', //top,bottom
                'verticalEdge' => 'right', //right,left
                'heading' => Lang::__('Error'),
                'life' => '2000', //1000 is 1 second
                'text' => Lang::__('Not_found_the_desired_item'),
            );
        }



        echo json_encode($results);
    }

    public function action_ToDB() {
        $results = array();

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());
        $par1 = empty($Filtered_array['par1']) ? NULL : $Filtered_array['par1'];
        $par2 = empty($Filtered_array['par2']) ? NULL : $Filtered_array['par2'];
        $parent = ORM::factory('Menus', $par2);
        $objj = ORM::factory('Menus', $par1);

        if (!$objj->loaded()) {
            $objj->Created_by = $this->user_online->id;
            $objj->Created_date = date("Y-m-d H:i:s");
            if ($parent->loaded()) {
                $objj->parent = $parent->id;
            }
        } else {
            $objj->last_update_by = $this->user_online->id;
            $objj->last_update_date = date("Y-m-d H:i:s");
        }

        $objj->values($Filtered_array);

        try {
            if ($objj->save()) {
                $results['Success'] = array(
                    'theme' => 'lime', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
                    'horizontalEdge' => 'top', //top,bottom
                    'verticalEdge' => 'right', //right,left
                    'heading' => '',
                    'life' => '2000', //1000 is 1 second
                    'text' => Lang::__('Saved_successfully'),
                );
            }
        } catch (ORM_Validation_Exception $e) {
            $errors = $e->errors('');
            $Lang_Error = array();
            foreach ($errors as $key => $value) {
                $srting = '';
                $errr = explode('*', $value);
                if (count($errr) > 0) {
                    foreach ($errr as $aaa) {
                        $srting .= Lang::__($aaa) . ' ';
                    }
                    array_push($Lang_Error, $srting);
                }
            }
            $results['Errors'] = $Lang_Error;
        }
        echo json_encode($results);
    }

    public function action_GetData() {

        $post = $this->request->post();
        $order = $post['order']; //Get how table order from datatable

        $par1 = !empty($post['par1']) ? $post['par1'] : NULL;

        /*
         * All coulums will shown in table
         */
        $ALL_coulums = array(
            1 => "id",
        );



        $All_ORM = ORM::factory('Menus')->where('parent', '=', $par1)->where('is_deleted', '=', NULL)->order_by($ALL_coulums[$order[0]['column']], $order[0]['dir'])->find_all();

        // Convert Object to array
        $array_ = Search::action_FindAll_To_Array($All_ORM);
        // End Convert Object to array 

        $Succesful_msg = Lang::__('Action_successfully_has_been_completed_Well_done');
        $C_Acti_status = "OK";

        /*
         * If Action exists
         */
        if (isset($post['customActionName'])) {
            switch ($post['customActionName']) {
                case 'Delete':
                    $ids = array();
                    foreach ($post['id'] as $value) {
                        if ($this->action_Delete($value) === FALSE) {
                            array_push($ids, $value);
                        }
                    }

                    break;


                default:
                    break;
            }
        }


        /*
         * if search exists
         */
        if (isset($post['action']) && (!is_array($post['action'])) && mb_strtolower($post['action']) == 'filter') {

            $array_1 = array();
            foreach ($All_ORM as $value) {
                if (
                        ((!empty($post['name'])) && ((strpos(mb_strtolower($value->name_ar), mb_strtolower($post['name'])) !== false) || strpos(mb_strtolower($value->name_en), mb_strtolower($post['name'])) !== false)) || (((!empty($post['max_students_no_from']) && !empty($post['max_students_no_to']))) && ($value->max_students_no >= $post['max_students_no_from'] && $value->max_students_no <= $post['max_students_no_to'])) || (((!empty($post['max_students_no_from']) && empty($post['max_students_no_to']))) && ($value->max_students_no >= $post['max_students_no_from'])) || (((empty($post['max_students_no_from']) && !empty($post['max_students_no_to']))) && ($value->max_students_no <= $post['max_students_no_to']))
                ) {
                    array_push($array_1, $value->id);
                }
            }
        }

        /*
         * Paging
         */
        if (isset($post['action']) && (!is_array($post['action'])) && mb_strtolower($post['action']) == 'filter') {
            $iTotalRecords = count($array_1);
        } else {
            $iTotalRecords = count($array_);
        }

        $iDisplayLength = intval($post['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($post['start']);
        $sEcho = intval($post['draw']);

        $records = array();
        $records["data"] = array();

        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;



        if (isset($post['action']) && (!is_array($post['action'])) && mb_strtolower($post['action']) == 'filter') {
            $output = array_slice($array_1, $iDisplayStart, $iDisplayLength);
            $Search_objs = array();
            foreach ($output as $value) {
                array_push($Search_objs, Search::action_GetOne($array_, 'id', $value));
            }
        } else {
            $Search_objs = array_slice($array_, $iDisplayStart, $iDisplayLength);
        }



        /*
         * Prepare JSON Array
         */
        foreach ($Search_objs as $key => $value) {
            $buttons = '';
            ($this->Edit) ? $buttons .= '<a par1="' . $value['id'] . '" par2="" class="btn btn-xs default ModModal" data-toggle="modal"><i class="fa fa-edit"></i> ' . Lang::__('Edit') . '</a>' : NULL;
            ($this->Edit || $this->Browse || $this->Delete || $this->Add) ? $buttons .= '<a href="' . URL::base() . 'Menus/index/' . $value['id'] . '" class="btn btn-xs purple-studio"><i class="fa fa-list"></i> ' . Lang::__('SubMenus') . '</a>' : NULL;
            ($this->Delete) ? $buttons .= '<a par1="' . $value['id'] . '" par2="" class="btn btn-xs red Delete" data-toggle="modal"><i class="fa fa-times"></i> ' . Lang::__('Delete') . '</a>' : NULL;
            $records["data"][] = array(
                '<input type="checkbox" name="id[]" value="' . $value['id'] . '">',
                $value['name_ar'],
                $value['name_en'],
                $buttons,
            );
        }
        if (isset($post["customActionType"]) && $post["customActionType"] == "group_action") {
            $records["customActionStatus"] = $C_Acti_status; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = $Succesful_msg; // pass custom message(useful for getting status of group actions)
        }

        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;

        echo json_encode($records);
    }

    protected function _save_image($image, $width = NULL, $height = NULL, $directory, $directory_thumbs) {

        $directory_D = DOCROOT . str_replace("\\", "/", $directory);
        if (!file_exists($directory_D)) {
            mkdir($directory_D, 0777, true);
        }

        $directory_thumbs_D = DOCROOT . str_replace("\\", "/", $directory_thumbs);
        if (!file_exists($directory_thumbs_D)) {
            mkdir($directory_thumbs_D, 0777, true);
        }

        if (!Upload::valid($image) OR ! Upload::not_empty($image) OR ! Upload::type($image, array('jpg', 'jpeg', 'png', 'gif'))) {
            return FALSE;
        }

        if ($file = Upload::save($image, NULL, $directory)) {
            $ext = pathinfo($file, PATHINFO_EXTENSION);
            $filename = mb_strtolower(Text::random('alnum', rand(10, 30))) . '.' . $ext;

            $img = Image::factory($file);
            $img->resize($width + 200, $height + 200, Image::INVERSE);
            $img->save($directory . $filename, 100);
            $img->resize($width, $height, Image::INVERSE);
            $img->crop($width, $height);
            $img->save($directory_thumbs . $filename, 100);

            // Delete the temporary file
            unlink($file);

            return $filename;
        }

        return FALSE;
    }

}

// End Teamnewscp
