<?php

defined('SYSPATH') or die('No direct script access.');

class Controller_Marketing_Rejected extends Controller_Template_Base {

    public $Add = FALSE;
    public $Browse = FALSE;
    public $Edit = FALSE;
    public $Delete = FALSE;
    public $Reject_Student_Applications = FALSE;

    public function __construct(Request $request, Response $response) {
        // You must call parent::__construct at some point in your function
        parent::__construct($request, $response);
        // Do whatever else you want

        $this->Add = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'A_Courses')));
        $this->Browse = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'B_Courses')));
        $this->Edit = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'E_Courses')));
        $this->Delete = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'D_Courses')));
        $this->Reject_Student_Applications = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'Reject_Student_Applications')));
    }

    public function action_index() {
        if ($this->Add || $this->Browse || $this->Edit || $this->Delete) {
            $title = Lang::__('Reject_Student_Applications');
            $this->template->title = $title;
            $this->template->layout = new View('system/Marketing/view_all');
            $this->template->layout->title = $title;
            $this->template->layout->Add = $this->Add;
            $this->template->layout->lang = $this->lang;
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }

    public function action_GetData() {
        $post = $this->request->post();
        $order = $post['order']; //Get how table order from datatable
        /*
         * All coulums will shown in table
         */
        $ALL_coulums = array(
            1 => "id",
        );

        $All_ORM = ORM::factory('Students_Applications')
                ->where('is_deleted', '=', NULL)
                ->where('rejected', '!=', NULL)
                ->where('student_id', '=', NULL)
                ->where('finished', '=', 1)
                ->order_by($ALL_coulums[$order[0]['column']], $order[0]['dir']);


        $Succesful_msg = Lang::__('Action_successfully_has_been_completed_Well_done');
        $C_Acti_status = "OK";

        /*
         * If Action exists
         */
        if (isset($post['customActionName'])) {
            switch ($post['customActionName']) {
                case 'Delete':


                    break;


                default:
                    break;
            }
        }


        /*
         * if search exists
         */

        if (isset($post['action']) && (!is_array($post['action'])) && mb_strtolower($post['action']) == 'filter') {

            if (!empty($post['Created_date_From'])) {
                $All_ORM->where('Created_date', '>=', $post['Created_date_From']);
            }
            if (!empty($post['Created_date_to'])) {
                $new_Created_date_to = new DateTime($post['Created_date_to']);
                $new_Created_date_to->modify('+1 day'); //تم اضافة يوم لحل مشكلة عدم تحقق شرط التساوي
                $All_ORM->where('Created_date', '<=', $new_Created_date_to->format('Y-m-d H:i:s'));
            }
            if (!empty($post['name'])) {
                $Name = $post['name'];
                $All_ORM->and_where_open();
                $All_ORM->or_where(DB::expr('lower(Full_Name_Arabic)'), 'LIKE', mb_strtolower("%$Name%"));
                $All_ORM->or_where(DB::expr('lower(Full_Name_English)'), 'LIKE', mb_strtolower("%$Name%"));
                $All_ORM->and_where_close();
            }
            if (!empty($post['ID_No'])) {
                $ID_No = $post['ID_No'];
                $All_ORM->where(DB::expr('lower(ID_No)'), 'LIKE', mb_strtolower("%$ID_No%"));
            }
            if (!empty($post['ba_Major'])) {
                $ba_Major = $post['ba_Major'];
                $All_ORM->where(DB::expr('lower(ba_Major)'), 'LIKE', mb_strtolower("%$ba_Major%"));
            }
            if (!empty($post['app_type'])) {
                $All_ORM->where('app_type', '=', $post['app_type']);
            }
        }

        /*
         * Paging
         */

        $All_ORM->reset(FALSE);
        $iTotalRecords = $All_ORM->count_all();

        $iDisplayLength = intval($post['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($post['start']);
        $sEcho = intval($post['draw']);

        $records = array();
        $records["data"] = array();

        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;

        $All_ORM->offset($iDisplayStart);
        $All_ORM->limit($iDisplayLength);

        /*
         * Prepare JSON Array
         */
        foreach ($All_ORM->find_all() as $value) {
            $buttons = '';
            ($this->Edit || $this->Browse || $this->Add || $this->Delete) ? $buttons .= '<a href="' . URL::base() . 'Students_Admissionapps/Browse/' . $value->id . '" class="btn btn-xs blue-soft"><i class="fa fa-binoculars"></i> ' . Lang::__('Browse') . '</a>' : NULL;
            //($this->Edit && ($value->amount_paid == 1)) ? $buttons .= '<a href="' . URL::base() . 'Students_Admissionapps/Payment/' . $value->id . '" class="btn btn-xs green-sharp"><i class="fa fa-credit-card"></i> ' . Lang::__('Restrict Payment') . '</a>' : NULL;
            //($this->Edit && ($value->amount_paid == 2) && $value->Initial_Approval == 1 && empty($value->rejected) && empty($value->interview_date)) ? $buttons .= '<a href="' . URL::base() . 'Students_Admissionapps/Initial_Approval/' . $value->id . '" class="btn btn-xs green-dark"><i class="fa fa-check"></i> ' . Lang::__('initial approval') . '</a>' : NULL;
            //($this->Delete && ($value->CheckDeleteRules() === TRUE)) ? $buttons .= '<a par1="' . $value->id . '" Dtitle="' . Lang::__('Alert') . '" Dcontent="' . Lang::__('Are_you_sure_you_want_to_delete_it') . '" confirmButton="' . Lang::__('Yes') . '" cancelButton="' . Lang::__('Cancel') . '" class="btn btn-xs red Delete"> ' . Lang::__('Delete') . '</a>' : NULL;
            ($this->Reject_Student_Applications && $value->CanRejected()) ? $buttons .= '<button type="button" class="btn btn-xs red-mint app_affect" par1="' . $value->id . '" par2="reject" Dtitle="' . Lang::__('confirmation') . '" Dcontent="' . Lang::__('If you wish to continue with the reject application process') . ' ' . $value->FullName($this->lang) . ' ' . Lang::__('Click submit you can also leave a note in the field below') . '" PHold="' . Lang::__('Notes') . '" Submit_Btn="' . Lang::__('Submit') . '" Cancel_Btn="' . Lang::__('Cancel') . '"> ' . Lang::__('Reject_application') . '</button>' : NULL;

            $App_Status = Lang::__('undefined');
            if ($value->amount_paid == 1) {
                $App_Status = Lang::__('Waiting to pay finance charges');
            } elseif ($value->amount_paid == 2) {

                if (empty($value->interview_date)) {
                    if ($value->rejected == 1) {
                        $App_Status = Lang::__('The request was reject by') . ' ' . $value->Rejected_By->{'name_' . $this->lang};
                        $App_Status .= ' ' . Lang::__('in_date') . ' ' . $value->rejected_date;
                        if (!empty($value->rejected_notes)) {
                            $App_Status .= ' </br>' . Lang::__('notes') . ': ' . nl2br($value->rejected_notes);
                        }
                    } elseif ($value->Initial_Approval == 2) {
                        $App_Status = Lang::__('The request was accepted without interview');
                    } else {
                        $App_Status = Lang::__('The request wait Initial Approval');
                    }
                } else {
                    if (empty($value->interview_state)) {
                        $App_Status = Lang::__('interview need to review');
                    } elseif ($value->interview_state == 'reject') {
                        $App_Status = Lang::__('The request was rejected after the interview');
                    } elseif ($value->interview_state == 'accept' && !empty($value->student_id)) {
                        $App_Status = Lang::__('The request was accepted after the interview and student now have membership');
                    }
                }
            }
            $RejectStatus = ORM::factory('Marketing_Rejectedstatus', $value->id);
            if ($RejectStatus->loaded()) {
                $RejectStatusString = Lang::__('Marketing_rejected_status_yes');
            } else {
                $RejectStatusString = Lang::__('Marketing_rejected_status_not_started');
            }
            $records["data"][] = array(
                '<input type="checkbox" name="id[]" value="' . $value->id . '">',
                Lang::__($value->app_type),
                $value->Created_date,
                $value->ID_No,
                $value->Full_Name_Arabic,
                date_diff(date_create($value->Date_of_Birth), date_create('today'))->y,
                //$App_Status . $value->interview_state,
                '<a class="ButtonStatus" href="#" val-v = "' . $value->id . '" data-toggle="modal" data-target="#statusM" class="btn btn-xs green-sharp"><i class="fa fa-check"></i> ' . $RejectStatusString . '</a>',
                $buttons,
            );
        }
        if (isset($post["customActionType"]) && $post["customActionType"] == "group_action") {
            $records["customActionStatus"] = $C_Acti_status; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = $Succesful_msg; // pass custom message(useful for getting status of group actions)
        }

        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;

        echo json_encode($records);
    }

    public function action_ToDB() {
        $post = $this->request->post();
        print_r($post);
    }
    public function action_SMS() {
        $title = Lang::__('Reject_Student_Applications_SMS');
            $this->template->title = $title;
            $this->template->layout = new View('system/Marketing/sms');
            $this->template->layout->title = $title;
            $this->template->layout->Add = $this->Add;
            $this->template->layout->lang = $this->lang;
    }
    
    public function action_email() {
        $title = Lang::__('Reject_Student_Applications_email');
            $this->template->title = $title;
            $this->template->layout = new View('system/Marketing/email');
            $this->template->layout->title = $title;
            $this->template->layout->Add = $this->Add;
            $this->template->layout->lang = $this->lang;
    }
}
