<?php

defined('SYSPATH') or die('No direct script access.');

class Controller_Login extends Controller {

    public function __construct(Request $request, Response $response) {
        // You must call parent::__construct at some point in your function
        parent::__construct($request, $response);

        // Do whatever else you want
        //Set Default Langauge
        $lang = Cookie::get('lang');
        if (empty($lang)) {
            Cookie::set('lang', 'ar');
        }
    }

    public function before() {
        
    }

    public function action_index() {
        // Load the user information
        $user = Auth::instance()->get_user();

        // if a user is not logged in, redirect to login page
        if ($user) {
            $this->redirect('Adminpanel', 302);
        } else {
            $view = View::factory('system/login');
            $this->response->body($view);
        }
    }

    public function action_JsonLang() {
        $lang = $this->request->param('par1');

        if (!in_array($lang, array('ar', 'en'))) {
            $lang = 'ar';
        }
        Cookie::set('lang', $lang);
        I18n::lang($lang);

        HTTP::redirect($this->request->referrer(), 302);
    }

    public function action_ProcessLogin() {
        $result = array(); //مصفوفة نتائج الجسون
        try {
            if (HTTP_Request::POST == $this->request->method()) {
                // Attempt to login user
                $remember = array_key_exists('remember', $this->request->post()) ? (bool) $this->request->post('remember') : FALSE;
                $user = Auth::instance()->login($this->request->post('username'), $this->request->post('password'), $remember);
                
                // If successful, redirect user
                if ($user) {
                    $result['Success'] = 'redirect';
                    $user = Auth::instance()->get_user();
                    if(ORM::factory('User',$user)->user_groub == 3){
                     $result['redirect_url'] = URL::base().'Student_Portal';   
                    }
                    
                    $result['Success_msg'] = Lang::__('Logged in successfully');
                } else {
                    $Us = ORM::factory('User')->where('username', '=', $this->request->post('username'))->find();
                    if ($Us->loaded()) {
                        $logrole = $Us->hasRole('roles', ORM::factory('Role', array('name' => 'login')));
                        if ($logrole) {
                            $result['Errors'] = Lang::__('Wrong_password');
                        } else {
                            $result['Errors'] = Lang::__('user_dont_have_login_permesion');
                        }
                    } else {
                        $result['Errors'] = Lang::__('Wrong_username');
                    }
                }
            }
        } catch (ORM_Validation_Exception $e) {
            $errors = $e->errors('');
            $Lang_Error = array();
            foreach ($errors as $key => $value) {
                $srting = '';
                $errr = explode('*', $value);
                if (count($errr) > 0) {
                    foreach ($errr as $aaa) {
                        $srting .= Lang::__($aaa) . ' ';
                    }
                    array_push($Lang_Error, $srting);
                }
            }
            $result['Errors'] = $Lang_Error;
        }
        echo json_encode($result);
    }

    public function action_create() {

        if (HTTP_Request::POST == $this->request->method()) {
            try {

                // Create the user using form values
                $user = ORM::factory('User')->create_user($this->request->post(), array(
                    'username',
                    'password',
                    'email'
                ));

                // Grant user login role
                $user->add('roles', ORM::factory('Role', array('name' => 'login')));

                // Reset values so form is not sticky
                $_POST = array();

                // Set success message
                $message = "You have added user '{$user->username}' to the database";
            } catch (ORM_Validation_Exception $e) {

                // Set failure message
                $message = 'There were errors, please see form below.';

                // Set errors using custom messages
                $errors = $e->errors('models');
                print_r($errors);
            }
        }
    }

    public function action_logout() {
        // Log user out
        Auth::instance()->logout();

        // Redirect to login page
        $this->redirect('/', 302);
    }

}

// End Login
