<?php

defined('SYSPATH') or die('No direct script access.');

class Controller_Library_Manager extends Controller_Template_Base
{

    public $Add = FALSE;
    public $Browse = FALSE;
    public $Edit = FALSE;
    public $Delete = FALSE;

    public function __construct(Request $request, Response $response)
    {
        // You must call parent::__construct at some point in your function
        parent::__construct($request, $response);
        // Do whatever else you want

        $this->Add = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'A_Library_Items')));
        $this->Browse = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'B_Library_Items')));
        $this->Edit = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'E_Library_Items')));
        $this->Delete = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'D_Library_Items')));
    }

    /*
     * Send Json of rules to jquery validation
     */

    public function action_GetRules()
    {
        $results = array();

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());

        $par1 = empty($Filtered_array['par1']) ? NULL : $Filtered_array['par1'];

        $ORM = ORM::factory('Library_Manager', $par1);

        $results['Rules'] = $ORM->AdminRules($ORM, $Filtered_array);


        echo json_encode($results);
    }

    public function action_index()
    {
        if ($this->Add || $this->Browse || $this->Edit || $this->Delete) {
            $title = Lang::__('Library');
            $this->template->title = $title;
            $this->template->layout = new View('system/library/manager/view_all');
            $this->template->layout->title = $title;
            $this->template->layout->Add = $this->Add;
            $this->template->layout->lang = $this->lang;
            $this->template->layout->Library_Types = ORM::factory('Library_Types')->where('is_deleted', '=', NULL)->find_all();
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }

    public function action_AE()
    {

        $par1 = $this->request->param('par1');
        $par2 = $this->request->param('par2');


        $Obj = ORM::factory('Library_Manager', $par1);
        $type = NULL;
        if ($Obj->loaded()) {
            $process_type = 'modify';
            $type = $Obj->type;
        } else {
            if (mb_strtolower($par1) == mb_strtolower('book')) {
                $type = 1;
            }
            if (mb_strtolower($par1) == mb_strtolower('thesis')) {
                $type = 2;
            }
        }

        if ($type == 1) {
            $process_type = 'add_new_book';
        }
        if ($type == 2) {
            $process_type = 'add_new_thesis';
        }

        if ((($this->Add && !$Obj->loaded()) || ($this->Edit && $Obj->loaded())) && ($Obj->is_deleted == NULL)) {
            $this->template->layout = new View('system/library/manager/AE');

            if ($Obj->loaded()) {
                $this->template->layout->Obj = $Obj;
            }

            $this->template->layout->Stores_Categories = ORM::factory('General_Stores_Categories')->where('is_active', '=', 1)->where('is_deleted', '=', NULL)->find_all();
            $this->template->layout->Stores_Stores = ORM::factory('General_Stores_Stores')->where('is_active', '=', 1)->where('is_deleted', '=', NULL)->find_all();
            $this->template->layout->Stores_Units = ORM::factory('General_Stores_Units')->where('is_active', '=', 1)->where('is_deleted', '=', NULL)->find_all();


            $this->template->layout->type = $type;

            $this->template->layout->title = Lang::__($process_type);
            $this->template->title = Lang::__($process_type);
            $this->template->layout->lang = $this->lang;
            $this->template->layout->Users = Search::action_FindAll_To_Array(ORM::factory('User')->find_all());
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }

    public function action_Delete()
    {
        $results = array();

        if ($this->Delete) {
            $req = Request::current(); //fillter requset

            $Filtered_array = Search::action_Filtered_array($req->post());

            $Obj = ORM::factory('Library_Manager', $Filtered_array['id']);

            $CheckDeleteRules = $Obj->CheckDeleteRules();
            if ($CheckDeleteRules === TRUE) {
                try {
                    $Obj->is_deleted = 1;
                    $Obj->deleted_by = $this->user_online->id;
                    $Obj->deleted_date = date("Y-m-d H:i:s");
                    if ($Obj->save()) {
                        $results['Success'] = array(
                            'title' => Lang::__('Done'),
                            'content' => Lang::__('Deletion has been successfully'),
                        );
                    }
                } catch (ORM_Validation_Exception $e) {

                    $errors = $e->errors('');
                    $results['Errors'] = array(
                        'title' => Lang::__('Error'),
                        'content' => General::CatchErrorMSGSAjax($errors),
                    );
                }
            } else {
                if (is_array($CheckDeleteRules)) {

                    $results['Errors'] = array(
                        'title' => Lang::__('Error'),
                        'content' => General::ArrayToString($CheckDeleteRules),
                    );
                }
            }
        } else {
            $results['Errors'] = array(
                'title' => Lang::__('Error'),
                'content' => Lang::__('You_dont_have_permission_to_do_this_action'),
            );
        }

        echo json_encode($results);
    }

    public function action_ToDB()
    {
        $results = array();

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());
        $par1 = empty($Filtered_array['par1']) ? NULL : $Filtered_array['par1'];
        $par2 = empty($Filtered_array['par2']) ? NULL : $Filtered_array['par2'];

        $objj = ORM::factory('Library_Manager', $par1);
        if (!$objj->loaded()) {
            $objj->Created_by = $this->user_online->id;
            $objj->Created_date = date("Y-m-d H:i:s");
            $objj->type = $par2;
        } else {
            $objj->last_update_by = $this->user_online->id;
            $objj->last_update_date = date("Y-m-d H:i:s");
        }


        $Jquery_Rules = $objj->AdminRules($objj, $Filtered_array);
        $extra_rules = General::Jquery_To_ORM_Rules($Filtered_array, $Jquery_Rules);

        //Path of upload images
        $directory = 'files/library/' . date('Y') . '/' . date("m") . '/';
        $directory_thumbs = $directory . 'thumbs/';

        $upload_images_error = array();
        if ($this->request->method() == Request::POST) {
            $FileS = isset($_FILES['pdf_file']) ? $_FILES['pdf_file'] : NULL;
            if (!empty($FileS) && Upload::valid($FileS) && Upload::not_empty($FileS)) {
                $allowed_ext = isset($Jquery_Rules['pdf_file']['accept']) ? explode('|', $Jquery_Rules['pdf_file']['accept']) : array();
                $max_size = isset($Jquery_Rules['pdf_file']['filesize']) ? $Jquery_Rules['pdf_file']['filesize'] : 5000000;
                $pdf_file = $this->_save_image($_FILES['pdf_file'], NULL, NULL, $directory, NULL, $allowed_ext, $max_size . 'B');
                if ($pdf_file) {
                    foreach (array('pdf_file') as $value) {
                        if (!empty($objj->$value)) {
                            $DelFilePath = DOCROOT . $objj->$value;
                            if (is_file($DelFilePath)) {
                                unlink($DelFilePath);
                            }
                        }
                    }
                    $Filtered_array['pdf_file'] = $directory . $pdf_file;
                } else {
                    array_push($upload_images_error, Lang::__('pdf_file'));
                }
            }
            
            $FileS = isset($_FILES['cover_image']) ? $_FILES['cover_image'] : NULL;
            if (!empty($FileS) && Upload::valid($FileS) && Upload::not_empty($FileS)) {
                $allowed_ext = isset($Jquery_Rules['cover_image']['accept']) ? explode('|', $Jquery_Rules['cover_image']['accept']) : array();
                $max_size = isset($Jquery_Rules['cover_image']['filesize']) ? $Jquery_Rules['cover_image']['filesize'] : 5000000;
                $cover_image = $this->_save_image($_FILES['cover_image'], 150, 200, $directory, $directory_thumbs, $allowed_ext, $max_size . 'B');
                if ($cover_image) {
                    foreach (array('cover_image') as $value) {
                        if (!empty($objj->$value)) {
                            $DelFilePath = DOCROOT . $objj->$value;
                            if (is_file($DelFilePath)) {
                                unlink($DelFilePath);
                            }
                        }
                    }
                    $Filtered_array['cover_image'] = $directory . $cover_image;
                } else {
                    array_push($upload_images_error, Lang::__('cover_image'));
                }
            }
        }

        $objj->values($Filtered_array);

        try {
            if ($objj->save($extra_rules)) {
                $results['Success'] = array(
                    'type' => 'green',
                    'title' => Lang::__('Done'),
                    'content' => Lang::__('Saved_successfully'),
                    'redirect' => URL::base() . 'Library_Manager',
                );
            }
        } catch (ORM_Validation_Exception $e) {

            $errors = $e->errors('');
            $results['Errors'] = array(
                'type' => 'red',
                'title' => Lang::__('Error'),
                'content' => General::ArrayToString(General::CatchErrorMSGSAjax($errors)),
            );
        }
        echo json_encode($results);
    }

    public function action_GetData()
    {
        $post = $this->request->post();
        $order = $post['order']; //Get how table order from datatable
        /*
         * All coulums will shown in table
         */
        $ALL_coulums = array(
            1 => "id",
        );

        $All_ORM = ORM::factory('Library_Manager')
            ->where('is_deleted', '=', NULL)
            ->order_by($ALL_coulums[$order[0]['column']], $order[0]['dir']);

        $Succesful_msg = Lang::__('Action_successfully_has_been_completed_Well_done');
        $C_Acti_status = "OK";

        /*
         * If Action exists
         */
        if (isset($post['customActionName'])) {
            switch ($post['customActionName']) {
                case 'Delete':


                    break;


                default:
                    break;
            }
        }


        /*
         * if search exists
         */
        if (isset($post['action']) && (!is_array($post['action'])) && mb_strtolower($post['action']) == 'filter') {

            if (!empty($post['type'])) {
                $All_ORM->where('type', '=', $post['type']);
            }

            if (!empty($post['title'])) {
                $title = $post['title'];
                $All_ORM->where(DB::expr('lower(title)'), 'LIKE', mb_strtolower("%$title%"));
            }
            if (!empty($post['auther'])) {
                $auther = $post['auther'];
                $All_ORM->where(DB::expr('lower(auther)'), 'LIKE', mb_strtolower("%$auther%"));
            }
            if (!empty($post['public_number'])) {
                $public_number = $post['public_number'];
                $All_ORM->where(DB::expr('lower(public_number)'), 'LIKE', mb_strtolower("%$public_number%"));
            }
            if (!empty($post['category_no'])) {
                $category_no = $post['category_no'];
                $All_ORM->where(DB::expr('lower(category_no)'), 'LIKE', mb_strtolower("%$category_no%"));
            }
        }

        /*
         * Paging
         */
        $All_ORM->reset(FALSE);
        $iTotalRecords = $All_ORM->count_all();

        $iDisplayLength = intval($post['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($post['start']);
        $sEcho = intval($post['draw']);

        $records = array();
        $records["data"] = array();

        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;

        $All_ORM->offset($iDisplayStart);
        $All_ORM->limit($iDisplayLength);


        /*
         * Prepare JSON Array
         */
        foreach ($All_ORM->find_all() as $value) {
            $buttons = '';
            ($this->Edit) ? $buttons .= '<a href="' . URL::base() . 'Library_Manager/AE/' . $value->id . '" class="btn btn-xs default"><i class="fa fa-edit"></i> ' . Lang::__('Edit') . '</a>' : NULL;
            ($this->Delete && ($value->CheckDeleteRules() === TRUE)) ? $buttons .= '<a par1="' . $value->id . '" Dtitle="' . Lang::__('Alert') . '" Dcontent="' . Lang::__('Are_you_sure_you_want_to_delete_it') . '" confirmButton="' . Lang::__('Yes') . '" cancelButton="' . Lang::__('Cancel') . '" class="btn btn-xs red Delete"> ' . Lang::__('Delete') . '</a>' : NULL;

            $records["data"][] = array(
                $value->Type->{'name_'.$this->lang},
                $value->title,
                $value->auther,
                $value->public_number,
                $value->category_no,
                $buttons,
            );
        }
        if (isset($post["customActionType"]) && $post["customActionType"] == "group_action") {
            $records["customActionStatus"] = $C_Acti_status; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = $Succesful_msg; // pass custom message(useful for getting status of group actions)
        }

        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;

        echo json_encode($records);
    }

    protected function _save_image($image, $width = NULL, $height = NULL, $directory, $directory_thumbs, $extensions, $max_file_size)
    {
        if (!Upload::valid($image) OR !Upload::not_empty($image) OR !Upload::type($image, $extensions) OR !Upload::size($image, $max_file_size)) {
            return FALSE;
        }

        if (!empty($directory)) {
            $directory_D = DOCROOT . str_replace("\\", "/", $directory);
            if (!file_exists($directory_D)) {
                mkdir($directory_D, 0777, true);
            }
        }

        if (!empty($directory_thumbs)) {
            $directory_thumbs_D = DOCROOT . str_replace("\\", "/", $directory_thumbs);
            if (!file_exists($directory_thumbs_D)) {
                mkdir($directory_thumbs_D, 0777, true);
            }
        }

        $ext = pathinfo($image['name'], PATHINFO_EXTENSION);
        $filename = mb_strtolower(Text::random('alnum', rand(10, 30))) . '.' . $ext;

        if (in_array(mb_strtolower($ext), array("gif", "jpeg", "jpg", "png", "bmp"))) {
            if ($file = Upload::save($image, NULL, $directory)) {
                $img = Image::factory($file);
                $img->save($directory . $filename, 100);
                if (!empty($directory_thumbs)) {
                    $img->resize($width, $height, Image::INVERSE);
                    $img->save($directory_thumbs . $filename, 100);
                }
                // Delete the temporary file
                unlink($file);

                return $filename;
            }
        } else {
            if ($file = Upload::save($image, $filename, $directory)) {

                return $filename;
            }
        }
    }
}
