<?php

defined('SYSPATH') or die('No direct script access.');

class Controller_Letters_Approvals extends Controller_Template_Base {

    public $Add = TRUE;
    public $Browse = TRUE;
    public $Edit = TRUE;
    public $Delete = TRUE;

    public function __construct(Request $request, Response $response) {
        // You must call parent::__construct at some point in your function
        parent::__construct($request, $response);
        // Do whatever else you want
//        $this->Add =  $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'A_Leave_Request')));
//        $this->Browse =  $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'B_Leave_Request')));
//        $this->Edit =  $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'E_Leave_Request')));
//        $this->Delete =  $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'D_Leave_Request')));
    }

    public function action_index() {
        if ($this->Add || $this->Browse || $this->Edit || $this->Delete) {
            $Noti = ORM::factory("Notifications")->where('affected_user', '=', $this->user_online->id)->find_all();
            foreach ($Noti as $val) {
                $val->seen_in_system = 1;
                $val->seen_in_system = date("Y-m-d H:i:s");
                $val->save();
            }

            $u_hr_position = $this->user_online->Employee_Information->hr_position;
            if (!empty($u_hr_position)) {
                $d = ORM::factory('General_Hr_Departments')
                        ->and_where_open()
                        ->or_where('director', '=', $u_hr_position)
                        ->or_where('deputy_director', '=', $u_hr_position)
                        ->and_where_close()
                        ->where('is_deleted', '=', NULL)
                        ->find();
                if ($d->loaded()) {
                    $title = Lang::__('Manage_Approvals_stuck');
                    $this->template->title = $title;
                    $this->template->layout = new View('system/letters/approvals/view_all');
                    $this->template->layout->title = $title;
                    $this->template->layout->Employee_Information = $this->user_online->Employee_Information;
                }
            }
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }

    public function action_Archive() {
        if ($this->Add || $this->Browse || $this->Edit || $this->Delete) {
            $Noti = ORM::factory("Notifications")->where('affected_user', '=', $this->user_online->id)->find_all();
            foreach ($Noti as $val) {
                $val->seen_in_system = 1;
                $val->seen_in_system = date("Y-m-d H:i:s");
                $val->save();
            }

            $u_hr_position = $this->user_online->Employee_Information->hr_position;
            if (!empty($u_hr_position)) {
                $d = ORM::factory('General_Hr_Departments')
                        ->and_where_open()
                        ->or_where('director', '=', $u_hr_position)
                        ->or_where('deputy_director', '=', $u_hr_position)
                        ->and_where_close()
                        ->where('is_deleted', '=', NULL)
                        ->find();
                if ($d->loaded()) {
                    $title = Lang::__('Manage_Approvals_archive');
                    $this->template->title = $title;
                    $this->template->layout = new View('system/letters/approvals/view_all');
                    $this->template->layout->title = $title;
                    $this->template->layout->Employee_Information = $this->user_online->Employee_Information;
                }
            }
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }

    public function action_Deputy() {
        if ($this->Add || $this->Browse || $this->Edit || $this->Delete) {
            $u_hr_position = $this->user_online->Employee_Information->hr_position;
            if (!empty($u_hr_position)) {
                $d = ORM::factory('General_Hr_Departments')
                        ->and_where_open()
                        ->or_where('director', '=', $u_hr_position)
                        ->or_where('deputy_director', '=', $u_hr_position)
                        ->and_where_close()
                        ->where('is_deleted', '=', NULL)
                        ->find();
                if ($d->loaded()) {

                    $view = View::factory('system/letters/approvals/deputy');
                    $title = Lang::__('Appoint a deputy for me');
                    $view->set('title', $title);
                    $view->set('lang', $this->lang);
                    $view->set('Employee_Information', $this->user_online->Employee_Information);
                    $view->set('Employees', ORM::factory('Hr_Employment_Applications')->where('app_status', '=', 1)->where('is_deleted', '=', NULL)->find_all());
                    $this->response->body($view);
                }
            }
        }
    }

    public function action_DeputyToDB() {
        $results = array();
        if ($this->Add || $this->Browse || $this->Edit || $this->Delete) {
            $u_hr_position = $this->user_online->Employee_Information->hr_position;
            if (!empty($u_hr_position)) {

                $req = Request::current(); //fillter requset
                $Filtered_array = Search::action_Filtered_array($req->post());
                $objj = $this->user_online->Employee_Information;
                $objj->deputy = $Filtered_array['deputy'];
                if ($objj->update()) {
                    $results['Success'] = array(
                        'title' => Lang::__('Done'),
                        'content' => Lang::__('Saved_successfully')
                    );
                }
            }
        }
        echo json_encode($results);
    }

    public function action_GetData() {

        $u_hr_position = $this->user_online->Employee_Information->hr_position;
        if (!empty($u_hr_position)) {
            //في حال كان مدير او نائب مدير سيظهر له الطلب
            $d = ORM::factory('General_Hr_Departments')
                    ->and_where_open()
                    ->or_where('director', '=', $u_hr_position)
                    ->or_where('deputy_director', '=', $u_hr_position)
                    ->and_where_close()
                    ->where('is_deleted', '=', NULL)
                    ->find_all();
            $dep_ids = array(0);
            foreach ($d as $value) {
                array_push($dep_ids, $value->id);
            }
        }


        $post = $this->request->post();
        $order = $post['order']; //Get how table order from datatable
        /*
         * All coulums will shown in table
         */
        $ALL_coulums = array(
            1 => "id",
        );

        $All_ORM = ORM::factory('Letters_Applications_Approvals')
                ->where('department', 'IN', $dep_ids)
                ->where('app_status', '=', NULL)
                ->where('is_deleted', '=', NULL)
                //->where('app_status', '=', NULL)
                ->group_by('application_id', 'app_status')
                ->order_by('Created_date', 'DESC');


        $Succesful_msg = Lang::__('Action_successfully_has_been_completed_Well_done');
        $C_Acti_status = "OK";

        /*
         * If Action exists
         */
        if (isset($post['customActionName'])) {
            switch ($post['customActionName']) {
                case 'Delete':


                    break;


                default:
                    break;
            }
        }


        /*
         * if search exists
         */
        if (isset($post['action']) && (!is_array($post['action'])) && mb_strtolower($post['action']) == 'filter') {
            if (!empty($post['name'])) {
                $name = $post['name'];
                $All_ORM->where(DB::expr('lower(name)'), 'LIKE', mb_strtolower("%$name%"));
            }
        }

        /*
         * Paging
         */
        $All_ORM->reset(FALSE);
        $iTotalRecords = $All_ORM->count_all();

        $iDisplayLength = intval($post['length']);
        if ($iDisplayLength == -1) {
            $iDisplayLength = 1000;
            ;
        }
        //$iDisplayLength = $iDisplayLength < 1 ? $iTotalRecords : $iDisplayLength;

        $iDisplayStart = intval($post['start']);
        $sEcho = intval($post['draw']);

        $records = array();
        $records["data"] = array();

        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;


        $All_ORM->offset($iDisplayStart);
        $All_ORM->limit($iDisplayLength);

        /* echo "iDisplayStart:".$iDisplayStart."<br>"
          . "iDisplayLength".$iDisplayLength."<br>"
          . "end".$end."<br>"
          . "sEcho".$sEcho."<br>"
          . "iTotalRecords".$iTotalRecords."<br>"; */


        /*
         * Prepare JSON Array
         */
        foreach ($All_ORM->find_all() as $value) {
            $buttons = '';
            ($this->Browse) ? $buttons .= '<a data-url="' . URL::base() . 'Letters_Approvals/ViewDetails/' . $value->id . '" class="btn btn-xs default ViewD" data-toggle="modal"><i class="fa fa-eye"></i> ' . Lang::__('Browse') . '</a>' : NULL;

            //$buttons.='<a par1="' . $value->id . '" Dtitle="' . Lang::__('Alert') . '" Dcontent="' . Lang::__('Are_you_sure_you_want_to_delete_it') . '" confirmButton="' . Lang::__('Yes') . '" cancelButton="' . Lang::__('Cancel') . '" class="btn btn-xs red Delete"> ' . Lang::__('Delete') . '</a>';
            //($this->Delete && ($value->CheckDeleteRules() === TRUE)) ? $buttons.='<a par1="' . $value->id . '" Dtitle="' . Lang::__('Alert') . '" Dcontent="' . Lang::__('Are_you_sure_you_want_to_delete_it') . '" confirmButton="' . Lang::__('Yes') . '" cancelButton="' . Lang::__('Cancel') . '" class="btn btn-xs red Delete"> ' . Lang::__('Delete') . '</a>' : NULL;

            $All_Approval_for_this_app = ORM::factory('Letters_Applications_Approvals')
                    ->where('application_id', '=', $value->application_id)
                    ->where('is_deleted', '=', NULL)
                    ->order_by('order')
                    ->find_all();
            $Text_Approvals = '';
            $approvals_notes = '';
            $count = 1;
            foreach ($All_Approval_for_this_app as $Approval) {
                
                        
                $department = $Approval->department;
                if (empty($department)) {
                    $department = $Approval->Application->Created_User->Employee_Information->department;
                }
                if ($Approval->app_status == 1) {
                   $user = ORM::factory("User" , $Approval->approved_by);
                        $user->loaded();
                    $class = ' font-green-jungle ';
                    $S_State = Lang::__('App_Approved') . '<br>'.Lang::__('By') . ': '.$user->{'name_'.$this->lang} .' <br> ' . $Approval->approved_date;
                } elseif ($Approval->app_status == 2) {
                    $user = ORM::factory("User" , $Approval->rejected_by);
                        $user->loaded();
                    $class = ' font-red-thunderbird ';
                    $S_State = Lang::__('rejected') . '<br>'.Lang::__('By') . ': '.$user->{'name_'.$this->lang}. ' <br> ' . $Approval->rejected_date;
                } else {
                    $class = ' font-grey-cascade  ';
                    $S_State = Lang::__('Waiting for approval');
                }

                $Text_Approvals .= '<span class="' . $class . '">' . $Approval->order . ' - ' . ORM::factory('General_Hr_Departments', $department)->{'name_' . $this->lang} . ' ( ' . $S_State . ' )' . '';
                if ($Approval->notes != null && $Approval->notes != '') {
                    //$Text_Approvals .= ' - '.$Approval->notes . '</br>';
                    $approvals_notes .= $count . ') ' . $Approval->notes . '</br>';
                    $count++;
                }
                $Text_Approvals .= '</span></br>';
            }

            $records["data"][] = array(
                '<input type="checkbox" name="id[]" value="' . $value->id . '">',
                $value->Application->Created_User->{'name_' . $this->lang},
                $value->Application->Letter->{'name_' . $this->lang},
                $value->Created_date,
                $Text_Approvals,
                $approvals_notes,
                $buttons,
            );
        }
        if (isset($post["customActionType"]) && $post["customActionType"] == "group_action") {
            $records["customActionStatus"] = $C_Acti_status; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = $Succesful_msg; // pass custom message(useful for getting status of group actions)
        }

        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;

        echo json_encode($records);
    }
public function action_GetDataArchive() {

        $u_hr_position = $this->user_online->Employee_Information->hr_position;
        if (!empty($u_hr_position)) {
            //في حال كان مدير او نائب مدير سيظهر له الطلب
            $d = ORM::factory('General_Hr_Departments')
                    ->and_where_open()
                    ->or_where('director', '=', $u_hr_position)
                    ->or_where('deputy_director', '=', $u_hr_position)
                    ->and_where_close()
                    ->where('is_deleted', '=', NULL)
                    ->find_all();
            $dep_ids = array(0);
            foreach ($d as $value) {
                array_push($dep_ids, $value->id);
            }
        }


        $post = $this->request->post();
        $order = $post['order']; //Get how table order from datatable
        /*
         * All coulums will shown in table
         */
        $ALL_coulums = array(
            1 => "id",
        );

        $All_ORM = ORM::factory('Letters_Applications_Approvals')
                ->where('department', 'IN', $dep_ids)
                ->where('app_status', '!=', NULL)
                ->where('is_deleted', '=', NULL)
                //->where('app_status', '=', NULL)
                ->group_by('application_id', 'app_status')
                ->order_by('Created_date', 'DESC');


        $Succesful_msg = Lang::__('Action_successfully_has_been_completed_Well_done');
        $C_Acti_status = "OK";

        /*
         * If Action exists
         */
        if (isset($post['customActionName'])) {
            switch ($post['customActionName']) {
                case 'Delete':


                    break;


                default:
                    break;
            }
        }


        /*
         * if search exists
         */
        if (isset($post['action']) && (!is_array($post['action'])) && mb_strtolower($post['action']) == 'filter') {
            if (!empty($post['name'])) {
                $name = $post['name'];
                $All_ORM->where(DB::expr('lower(name)'), 'LIKE', mb_strtolower("%$name%"));
            }
        }

        /*
         * Paging
         */
        $All_ORM->reset(FALSE);
        $iTotalRecords = $All_ORM->count_all();

        $iDisplayLength = intval($post['length']);
        if ($iDisplayLength == -1) {
            $iDisplayLength = 1000;
            ;
        }
        //$iDisplayLength = $iDisplayLength < 1 ? $iTotalRecords : $iDisplayLength;

        $iDisplayStart = intval($post['start']);
        $sEcho = intval($post['draw']);

        $records = array();
        $records["data"] = array();

        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;


        $All_ORM->offset($iDisplayStart);
        $All_ORM->limit($iDisplayLength);

        /* echo "iDisplayStart:".$iDisplayStart."<br>"
          . "iDisplayLength".$iDisplayLength."<br>"
          . "end".$end."<br>"
          . "sEcho".$sEcho."<br>"
          . "iTotalRecords".$iTotalRecords."<br>"; */


        /*
         * Prepare JSON Array
         */
        foreach ($All_ORM->find_all() as $value) {
            $buttons = '';
            ($this->Browse) ? $buttons .= '<a data-url="' . URL::base() . 'Letters_Approvals/ViewDetails/' . $value->id . '" class="btn btn-xs default ViewD" data-toggle="modal"><i class="fa fa-eye"></i> ' . Lang::__('Browse') . '</a>' : NULL;

            //$buttons.='<a par1="' . $value->id . '" Dtitle="' . Lang::__('Alert') . '" Dcontent="' . Lang::__('Are_you_sure_you_want_to_delete_it') . '" confirmButton="' . Lang::__('Yes') . '" cancelButton="' . Lang::__('Cancel') . '" class="btn btn-xs red Delete"> ' . Lang::__('Delete') . '</a>';
            //($this->Delete && ($value->CheckDeleteRules() === TRUE)) ? $buttons.='<a par1="' . $value->id . '" Dtitle="' . Lang::__('Alert') . '" Dcontent="' . Lang::__('Are_you_sure_you_want_to_delete_it') . '" confirmButton="' . Lang::__('Yes') . '" cancelButton="' . Lang::__('Cancel') . '" class="btn btn-xs red Delete"> ' . Lang::__('Delete') . '</a>' : NULL;

            $All_Approval_for_this_app = ORM::factory('Letters_Applications_Approvals')
                    ->where('application_id', '=', $value->application_id)
                    ->where('is_deleted', '=', NULL)
                    ->order_by('order')
                    ->find_all();
            $Text_Approvals = '';
            $approvals_notes = '';
            $count = 1;
            foreach ($All_Approval_for_this_app as $Approval) {
                
                $department = $Approval->department;
                if (empty($department)) {
                    $department = $Approval->Application->Created_User->Employee_Information->department;
                }
                if ($Approval->app_status == 1) {
                    $user = ORM::factory("User" , $Approval->approved_by);
                        $user->loaded();
                    $class = ' font-green-jungle ';
                    $S_State = Lang::__('App_Approved') . '<br>'.Lang::__('By') . ': '.$user->{'name_'.$this->lang}. ' <br> ' . $Approval->approved_date;
                } elseif ($Approval->app_status == 2) {
                    $user = ORM::factory("User" , $Approval->rejected_by);
                        $user->loaded();
                    $class = ' font-red-thunderbird ';
                    $S_State = Lang::__('rejected') . '<br>'.Lang::__('By') . ': '.$user->{'name_'.$this->lang}. ' <br> ' . $Approval->rejected_date;
                } else {
                    $class = ' font-grey-cascade  ';
                    $S_State = Lang::__('Waiting for approval');
                }

                $Text_Approvals .= '<span class="' . $class . '">' . $Approval->order . ' - ' . ORM::factory('General_Hr_Departments', $department)->{'name_' . $this->lang} . ' ( ' . $S_State . ' )' . '';
                if ($Approval->notes != null && $Approval->notes != '') {
                    //$Text_Approvals .= ' - '.$Approval->notes . '</br>';
                    $approvals_notes .= $count . ') ' . $Approval->notes . '</br>';
                    $count++;
                }
                $Text_Approvals .= '</span></br>';
            }

            $records["data"][] = array(
                '<input type="checkbox" name="id[]" value="' . $value->id . '">',
                $value->Application->Created_User->{'name_' . $this->lang},
                $value->Application->Letter->{'name_' . $this->lang},
                $value->Created_date,
                $Text_Approvals,
                $approvals_notes,
                $buttons,
            );
        }
        if (isset($post["customActionType"]) && $post["customActionType"] == "group_action") {
            $records["customActionStatus"] = $C_Acti_status; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = $Succesful_msg; // pass custom message(useful for getting status of group actions)
        }

        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;

        echo json_encode($records);
    }
    public function action_ViewDetails() {
        if (($this->Browse)) {
            $par1 = $this->request->param('par1');

            $Obj = ORM::factory('Letters_Applications_Approvals', $par1);

            if ($Obj->loaded()) {
                $view = View::factory('system/letters/approvals/view_details');
                // $Debugging_Approvals = $Obj->Application->Letter->CheckApprovalsStaff($Obj->Application->Letter, $this->user_online, TRUE, $this->lang);
                // $view->set('Debugging_Approvals',$Debugging_Approvals);
                $view->set('Obj', $Obj);
                $view->set('Fields', $Obj->Application->Letter->Fields->find_all());
                $view->set('Application', $Obj->Application);
                $view->set('Letter', $Obj->Application->Letter);
                $view->set('title', Lang::__('Manage_Approvals'));
                $view->set('lang', $this->lang);
                $this->response->body($view);
            }
        }
    }

    public function action_AppApproval() {
        $results = array();

        $req = Request::current();
        $Filtered_array = Search::action_Filtered_array($req->post());
        $par1 = !empty($Filtered_array['par1']) ? $Filtered_array['par1'] : NULL;
        $par2 = !empty($Filtered_array['par2']) ? $Filtered_array['par2'] : NULL;
        $notes = !empty($Filtered_array['notes']) ? $Filtered_array['notes'] : NULL;
        echo json_encode($this->approvalFUn($par1, $par2, $notes));
    }

    public function approvalFUn($par1, $par2, $notes) {
        $objj = ORM::factory('Letters_Applications_Approvals', $par1);
        //فحص صلاحية الموافقة
        $u_hr_position = $this->user_online->Employee_Information->hr_position;
        if (!empty($u_hr_position)) {
            //في حال كان مدير او نائب مدير سيظهر له الطلب
            $d = ORM::factory('General_Hr_Departments')
                    ->and_where_open()
                    ->or_where('director', '=', $u_hr_position)
                    ->or_where('deputy_director', '=', $u_hr_position)
                    ->and_where_close()
                    ->where('id', '=', $objj->department)
                    ->where('is_deleted', '=', NULL)
                    ->find();
            if ($d->loaded()) {

                //فحص ترتيب الموافقة اذا كان صحيح وما صار تعدي
                $CurrectApproval = ORM::factory('Letters_Applications_Approvals')
                        ->where('application_id', '=', $objj->application_id)
                        ->where('is_deleted', '=', NULL)
                        ->where('app_status', '=', NULL)
                        ->group_by('application_id', 'app_status')
                        ->order_by('order')
                        ->find();

                if ($objj->loaded() && ($objj->id == $CurrectApproval->id)) {
                    try {
                        if ($par2 == 1 && empty($objj->app_status)) {
                            $objj->app_status = 1;
                            $objj->approved_date = date("Y-m-d H:i:s");
                            $objj->approved_by = $this->user_online->id;
                            $objj->notes = $notes;
                            if ($objj->update()) {
                                $results['Success'] = array(
                                    'title' => Lang::__('Done'),
                                    'content' => Lang::__('Application approved successfully')
                                );
                            }
                        } elseif ($par2 == 2 && empty($objj->app_status)) {
                            $objj->app_status = 2;
                            $objj->rejected_date = date("Y-m-d H:i:s");
                            $objj->rejected_by = $this->user_online->id;
                            $objj->notes = $notes;
                            if ($objj->update()) {

                                $RejectOther = ORM::factory('Letters_Applications_Approvals')
                                        ->where('application_id', '=', $objj->application_id)
                                        ->where('app_status', '=', NULL)
                                        ->where('is_deleted', '=', NULL)
                                        ->find_all();
                                foreach ($RejectOther as $value) {
                                    $value->app_status = 2;
                                    $value->update();
                                }


                                $results['Success'] = array(
                                    'title' => Lang::__('Done'),
                                    'content' => Lang::__('Application rejected successfully')
                                );
                            }
                        } else {
                            $results['Errors'] = array(
                                 'Error_number' => 1,
                                'title' => Lang::__('Error'),
                                'content' => Lang::__('You_dont_have_permission_to_do_this_action')
                            );
                        }
                    } catch (ORM_Validation_Exception $e) {
                        $errors = $e->errors('');
                        $results['Errors'] = array(
                            'Error_number' => 2,
                            'title' => Lang::__('Error'),
                            'content' => General::ArrayToString(General::CatchErrorMSGSAjax($errors))
                        );
                    }
                } else {
                    $results['Errors'] = array(
                        'Error_number' => 3,
                        'title' => Lang::__('Error'),
                        'content' => Lang::__('You_dont_have_permission_to_do_this_action')
                    );
                }
            } else {
                $results['Errors'] = array(
                    'Error_number' => 4,
                    'title' => Lang::__('Error'),
                    'content' => Lang::__('You_dont_have_permission_to_do_this_action')
                );
            }
        }



        return $results;
    }

    public function action_RedirectAppApproval() {
        $results = array();

        $req = Request::current();
        $Filtered_array = Search::action_Filtered_array($req->post());
        $par1 = !empty($Filtered_array['par1']) ? $Filtered_array['par1'] : NULL;
        $par2 = !empty($Filtered_array['par2']) ? $Filtered_array['par2'] : NULL;
        $notes = !empty($Filtered_array['notes']) ? $Filtered_array['notes'] : NULL;
        $todepartment = !empty($Filtered_array['todepartment']) ? $Filtered_array['todepartment'] : NULL;

        $objj = ORM::factory('Letters_Applications_Approvals', $par1);

        if ($objj->loaded()) {
            $order = $objj->order + 1;
            foreach ($todepartment as $selectedOption) {
                $objj2 = ORM::factory('Letters_Applications_Approvals');
                $objj2->order = $order;
                $objj2->department = $selectedOption;
                $objj2->application_id = $objj->application_id;
                $objj2->Created_by = $this->user_online->id;
                $objj2->Created_date = date("Y-m-d H:i:s");
                $objj2->save();
                $order++;
            }
            $this->approvalFUn($par1, $par2, $notes);
            $results['Success'] = array(
                'title' => Lang::__('Done'),
                'content' => Lang::__('Application redirected successfully	')
            );
        } else {
            $results['Errors'] = array(
                'title' => Lang::__('Error'),
                'content' => Lang::__('You_dont_have_permission_to_do_this_action')
            );
        }


        echo json_encode($results);
    }

}
