<?php

defined('SYSPATH') or die('No direct script access.');

class Controller_Letters_Applications extends Controller_Template_Base {

    public $Add = TRUE;
    public $Browse = TRUE;
    public $Edit = TRUE;
    public $Delete = TRUE;

    public function __construct(Request $request, Response $response) {
// You must call parent::__construct at some point in your function
        parent::__construct($request, $response);
// Do whatever else you want
    }

    public function action_index() {
        if ($this->Add || $this->Browse || $this->Edit || $this->Delete) {
            $par1 = $this->request->param('par1');
            $Letters = ORM::factory('Letters_Letters', $par1);
            if ($Letters->loaded()) {


                $ChAccess = ORM::factory('Letters_Applications')->CheckUserApplicationAccess(ORM::factory('Letters_Applications'), $Letters, $this->user_online); //لفحص هل الطلب لرؤساء الاقسام فقط ام للجميع
                $Letters_Applications = ORM::factory('Letters_Applications')->where('letter', '=', $Letters->id)->where('is_deleted', '=', NULL)->count_all();


                if ($ChAccess || $Letters_Applications > 0) {
                    $title = $Letters->{'name_' . $this->lang};
                    $this->template->title = $title;
                    $this->template->layout = new View('system/letters/applications/view_all');
                    $this->template->layout->title = $title;
                    $this->template->layout->Letters = $Letters;
                    $Fields = $Letters->Fields->where('is_deleted', '=', NULL)->order_by('order')->limit(4)->find_all();
                    $this->template->layout->Fields = $Fields;
                    $this->template->layout->user_online = $this->user_online;

                    $this->template->layout->lang = $this->lang;
                    $this->template->layout->ChAccess = $ChAccess;

                    $this->template->layout->Add = $this->Add;
                } else {
                    $this->template->layout = new View('system/show_msg');
                    $this->template->layout->class_color = 'danger';
                    $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
                }
            }
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }

    public function action_All() {
        if ($this->Add || $this->Browse || $this->Edit || $this->Delete) {
            $Access = FALSE;
            $Letters = ORM::factory('Letters_Letters')->where('is_active', '=', 1)->where('is_deleted', '=', NULL)->find_all();
            foreach ($Letters as $value) {
                $ChAccess = ORM::factory('Letters_Applications')->CheckUserApplicationAccess(ORM::factory('Letters_Applications'), $value, $this->user_online); //لفحص هل الطلب لرؤساء الاقسام فقط ام للجميع
                $Letters_Applications = ORM::factory('Letters_Applications')->where('Created_by', '=', $this->user_online->id)->where('letter', '=', $value->id)->where('is_deleted', '=', NULL)->count_all();

                if ($ChAccess || $Letters_Applications > 0) {
                    $Access = TRUE;
                    break;
                }
            }
            if ($Access === TRUE && !empty($this->user_online->Employee_Information->department)) {
                $title = Lang::__('Request_letters');
                $this->template->title = $title;
                $this->template->layout = new View('system/letters/applications/all');
                $this->template->layout->title = $title;
                $this->template->layout->Letters = $Letters;

                $this->template->layout->lang = $this->lang;
                $this->template->layout->user_online = $this->user_online;
            } else {
                $this->template->layout = new View('system/show_msg');
                $this->template->layout->class_color = 'danger';
                $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
            }
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }

    public function action_Type() {

        $par1 = $this->request->param('par1'); //Add or id
        $par2 = $this->request->param('par2'); //letter id or null

        $process_type = 'add_new';
        $Obj = ORM::factory('Letters_Applications', $par1);

        if ((!$Obj->loaded()) || ($Obj->loaded() && ($Obj->Created_by == $this->user_online->id))) {
            if ($Obj->loaded()) {
                $process_type = 'modify';
                $Letter = $Obj->Letter;
            } else {
                $Letter = ORM::factory('Letters_Letters', $par2);
            }

            $ChAccess = $Obj->CheckUserApplicationAccess($Obj, $Letter, $this->user_online); //لفحص هل الطلب لرؤساء الاقسام فقط ام للجميع

            if ($ChAccess) {
                $CheckApprovalsStaff = $Letter->CheckApprovalsStaff($Letter, $this->user_online); //نفحص في حال كان هنالك مدير ونائب مدير غير معين لقسم مطلوب
                if (empty($CheckApprovalsStaff)) {
                    if ((($this->Add && $process_type == 'add_new' && isset($Letter) && $Letter->loaded()) || ($this->Edit && $process_type == 'modify')) && ($Obj->is_deleted == NULL)) {

                        $Fields = $Letter->Fields->where('is_deleted', '=', NULL)->order_by('order')->find_all();

                        if (count($Fields) > 0) {

                            $Approvals = $Obj->Letter_Application_Approvals
                                    ->where('is_deleted', '=', NULL)
                                    ->and_where_open()
                                    ->or_where('app_status', '=', 1)
                                    ->or_where('app_status', '=', 2)
                                    ->and_where_close()
                                    ->count_all();
//للتأكد من عدم وجود موافقات او رفض قبل امكانية التعديل
                            if ($Approvals > 0) {
                                $this->template->layout = new View('system/show_msg');
                                $this->template->layout->class_color = 'danger';
                                $this->template->layout->msg = Lang::__('The application can not be modified after approvals have been made or rejected');
                            } else {
                                $this->template->layout = new View('system/letters/applications/AE');

                                if ($Obj->loaded()) {
                                    $this->template->layout->Obj = $Obj;
                                }

                                $Debugging_Approvals = $Letter->CheckApprovalsStaff($Letter, $this->user_online, TRUE, $this->lang);
                                $this->template->layout->Debugging_Approvals = $Debugging_Approvals;

                                $this->template->layout->Letter = $Letter;
                                $this->template->layout->Fields = $Fields;
                                $this->template->layout->title = Lang::__($process_type) . ' - ' . $Letter->{'name_' . $this->lang};
                                $this->template->title = Lang::__($process_type) . ' - ' . $Letter->{'name_' . $this->lang};
                                $this->template->layout->lang = $this->lang;
                            }
                        } else {
                            $this->template->layout = new View('system/show_msg');
                            $this->template->layout->class_color = 'danger';
                            $this->template->layout->msg = Lang::__('This letter does not contain any fields');
                        }
                    } else {
                        $this->template->layout = new View('system/show_msg');
                        $this->template->layout->class_color = 'danger';
                        $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
                    }
                } else {
                    $this->template->layout = new View('system/show_msg');
                    $this->template->layout->class_color = 'danger';
                    $msg = Lang::__('Sorry the application can not be submitted') . '</br>';
                    foreach ($CheckApprovalsStaff as $Approval) {
                        $DName = !empty($Approval->Department->{'name_' . $this->lang}) ? $Approval->Department->{'name_' . $this->lang} : Lang::__('The department which the employee belongs');
                        $msg .= '* ' . $DName . '</br>';
                    }
                    $this->template->layout->msg = $msg;
                }
            } else {
                $this->template->layout = new View('system/show_msg');
                $this->template->layout->class_color = 'danger';
                $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
            }
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }

    public function action_Delete() {
        $results = array();

        if ($this->Delete) {
            $req = Request::current(); //fillter requset
            $Filtered_array = Search::action_Filtered_array($req->post());

            $Obj = ORM::factory('Letters_Applications', $Filtered_array['id']);

            $CheckDeleteRules = $Obj->CheckDeleteRules();
            if ($CheckDeleteRules === TRUE) {
                try {
                    $Obj->is_deleted = 1;
                    $Obj->deleted_by = $this->user_online->id;
                    $Obj->deleted_date = date("Y-m-d H:i:s");
                    if ($Obj->update()) {
                        $Approval = $Obj->Letter_Application_Approvals->find_all();
                        foreach ($Approval as $value) {
                            $value->is_deleted = 1;
                            $value->deleted_by = $this->user_online->id;
                            $value->deleted_date = date("Y-m-d H:i:s");
                            $value->update();
                        }
                        $results['Success'] = array(
                            'title' => Lang::__('Done'),
                            'content' => Lang::__('Deletion has been successfully'),
                        );
                    }
                } catch (ORM_Validation_Exception $e) {

                    $errors = $e->errors('');
                    $results['Errors'] = array(
                        'title' => Lang::__('Error'),
                        'content' => General::CatchErrorMSGSAjax($errors),
                    );
                }
            } else {
                if (is_array($CheckDeleteRules)) {

                    $results['Errors'] = array(
                        'title' => Lang::__('Error'),
                        'content' => General::ArrayToString($CheckDeleteRules),
                    );
                }
            }
        } else {
            $results['Errors'] = array(
                'title' => Lang::__('Error'),
                'content' => Lang::__('You_dont_have_permission_to_do_this_action'),
            );
        }

        echo json_encode($results);
    }

    public function action_Tarek() {
        $arr = array();
        $arr[] = 'asd';
        $arr[] = '23123';
        echo implode(" ", $arr);
    }

    function callAPI($method, $url) {
        $curl = curl_init();


        // OPTIONS:
        curl_setopt($curl, CURLOPT_URL, $url);



        // EXECUTE:
        $result = curl_exec($curl);
        if (!$result) {
            die("Connection Failure");
        }
        curl_close($curl);
        return $result;
    }

     public function action_ToDB() {
        $results = array();
        $uploadArray = array();
        $directory = 'files/stores/letters_applications/' . date('Y') . '/' . date("m") . '/';
        $directory_thumbs = $directory . 'thumbs/';
        if (!empty($directory)) {
            $directory_D = DOCROOT . str_replace("\\", "/", $directory);
            if (!file_exists($directory_D)) {
                mkdir($directory_D, 0777, true);
            }
        }

        if (!empty($directory_thumbs)) {
            $directory_thumbs_D = DOCROOT . str_replace("\\", "/", $directory_thumbs);
            if (!file_exists($directory_thumbs_D)) {
                mkdir($directory_thumbs_D, 0777, true);
            }
        }
        $upload_images_error = array();
        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());
        $par1 = empty($Filtered_array['par1']) ? NULL : $Filtered_array['par1'];
        $par2 = empty($Filtered_array['par2']) ? NULL : $Filtered_array['par2'];

        $objj = ORM::factory('Letters_Applications', $par1);
        if (!$objj->loaded() || ($objj->loaded() && ($objj->Created_by == $this->user_online->id))) {

            if (!$objj->loaded()) {
                $objj->Created_by = $this->user_online->id;
                $objj->Created_date = date("Y-m-d H:i:s");
                $Letter = ORM::factory('Letters_Letters', $par2);
                $objj->letter = $par2;
            } else {
                $objj->last_update_by = $this->user_online->id;
                $objj->last_update_date = date("Y-m-d H:i:s");
                $Letter = $objj->Letter;
            }
            if (!isset($_FILES['img'])) {
                $results['Errors'] = array(
                    'title' => Lang::__('Error'),
                    'content' => Lang::__('error_file_size')
                );
                echo json_encode($results);
                exit();
            }

            try {

                if (isset($_FILES['img']['name']) && Upload::size($_FILES['img'], '2M')) {
                    if (($_FILES['img']['name'] != '')) {
                        $ext = pathinfo($_FILES['img']['name'], PATHINFO_EXTENSION);
                        $filename = 'upload_' . date('Y_m_d') . '_' . rand(0, 10) . rand(0, 10) . rand(0, 10) . rand(0, 10) . rand(0, 10);
                        $file = Upload::save($_FILES['img'], $filename . '.' . $ext, $directory);
                        $uploadArray[] = $filename . '.' . $ext;
                    }
                } else {
                    $results['Errors'] = array(
                        'title' => Lang::__('Error') . '#1',
                        'content' => Lang::__('error_file_size')
                    );
                    echo json_encode($results);
                    exit();
                }
                if (isset($_FILES['file2']) && isset($_FILES['file2']['name']) && Upload::size($_FILES['file2'], '2M')) {
                    if (($_FILES['file2']['name'] != '')) {
                        $ext = pathinfo($_FILES['file2']['name'], PATHINFO_EXTENSION);
                        $filename = 'upload_' . date('Y_m_d') . '_' . rand(0, 10) . rand(0, 10) . rand(0, 10) . rand(0, 10) . rand(0, 10);
                        $file = Upload::save($_FILES['file2'], $filename . '.' . $ext, $directory);
                        $uploadArray[] = $filename . '.' . $ext;
                    }
                } else {
                    if ($par2 == 13) {
                        $results['Errors'] = array(
                            'title' => Lang::__('Error') . '#2',
                            'content' => Lang::__('error_file_size')
                        );
                        echo json_encode($results);
                        exit();
                    }
                }
                if (isset($_FILES['file3']['name']) && Upload::size($_FILES['file3'], '2M')) {
                    if (($_FILES['file3']['name'] != '')) {
                        $ext = pathinfo($_FILES['file3']['name'], PATHINFO_EXTENSION);
                        $filename = 'upload_' . date('Y_m_d') . '_' . rand(0, 10) . rand(0, 10) . rand(0, 10) . rand(0, 10) . rand(0, 10);
                        $file = Upload::save($_FILES['file3'], $filename . '.' . $ext, $directory);
                        $uploadArray[] = $filename . '.' . $ext;
                    }
                } else {
                    if ($par2 == 13) {
                        $results['Errors'] = array(
                            'title' => Lang::__('Error') . '#3',
                            'content' => Lang::__('error_file_size')
                        );
                        echo json_encode($results);
                        exit();
                    }
                }
            } catch (ORM_Validation_Exception $e) {
                $errors = $e->errors('forms');
                $results['Errors'] = array(
                    'title' => Lang::__('Error'),
                    'content' => $errors
                );
                echo json_encode($results);
                exit();

                //echo Debug::vars($errors);
            } catch (Exception $e) {
                $upload_errors = $e->getMessage();
                $results['Errors'] = array(
                    'title' => Lang::__('Error'),
                    'content' => $upload_errors
                );
                echo json_encode($results);
                exit();
            }


            $ChAccess = $objj->CheckUserApplicationAccess($objj, $Letter, $this->user_online); //لفحص هل الطلب لرؤساء الاقسام فقط ام للجميع

            $numbers = '';
            if ($ChAccess) {
                $CheckApprovalsStaff = $Letter->CheckApprovalsStaff($Letter, $this->user_online);

                if (empty($CheckApprovalsStaff) && $Letter->loaded() && empty($Letter->is_deleted)) {


                    $objj->values($Filtered_array);
                    $objj->attachment = implode(",", $uploadArray) . "";
                    $objj->directory = $directory;
                    try {
                        $extra_rules = General::Jquery_To_ORM_Rules($Filtered_array, $objj->AdminRules($objj, $Letter, FALSE));
                        if ($objj->save($extra_rules)) {

//في حالة اضافة جديد فقط
                            if (empty($objj->last_update_date)) {
//بداية انشاء علاقات الموافقات المطلوبة...
                                $ApprovalStep = $Letter->ApprovalStep->where('is_deleted', '=', NULL)->order_by('order')->find_all();
                                $department_array = array();
                                $department_array_SMS = array();
                                foreach ($ApprovalStep as $value) {
                                    $department = $value->department;
                                    if (empty($department)) {
//يعني ان الموافقة تتعلق بقسم الموظف
                                        $department = $this->user_online->Employee_Information->Department->id;
                                    }
                                    // if (!in_array($department, $department_array)) {
                                    array_push($department_array, array('order' => $value->order, 'department' => $department));
                                    // }
                                    if (!in_array($department, $department_array_SMS)) {
                                        array_push($department_array_SMS, $department);
                                    }
                                }
                                //print_r($department_array);
                                foreach ($department_array as $value) {
//لعدم تكرار نفس القسم للموافقة
                                    $Prev = ORM::factory('Letters_Applications_Approvals')
                                            ->where('department', '=', $value['department'])
                                            ->where('application_id', '=', $objj->id)
                                            ->find();
                                    if (!$Prev->loaded() || true) {
                                        $O = ORM::factory('Letters_Applications_Approvals');
                                        $O->order = $value['order'];
                                        $O->department = $value['department'];
                                        $O->application_id = $objj->id;
                                        $O->Created_by = $this->user_online->id;
                                        $O->Created_date = date("Y-m-d H:i:s");
                                        $O->save();
                                        if (in_array($value['department'], $department_array_SMS)) {
                                            $dep_ids = array(0);

                                            $users = ORM::factory('Hr_Employment_Applications')
                                                    ->where('department', '=', $value['department'])
                                                    ->where('is_manager','=', 1)
                                                    ->find_all();

                                            foreach ($users as $vals) {
                                                if (!empty($vals->hr_position)) {
                                                    //في حال كان مدير او نائب مدير سيظهر له الطلب
                                                    $d = ORM::factory('General_Hr_Departments')
                                                            ->and_where_open()
                                                            ->or_where('director', '=', $vals->hr_position)
                                                            ->or_where('deputy_director', '=', $vals->hr_position)
                                                            ->and_where_close()
                                                            ->where('is_deleted', '=', NULL)
                                                            ->find_all();
                                                    
                                                    foreach ($d as $value11) {
                                                        array_push($dep_ids, $value11->id);
                                                    }
                                                }
                                                if (in_array($value['department'], $dep_ids)) {
                                                    if (strlen($numbers) > 1) {
                                                        $numbers = $numbers . ',' . $vals->mobile;
                                                    } else {
                                                        $numbers = $vals->mobile;
                                                    }
                                                    try {
                                                        $Noti1 = ORM::factory("Notifications");
                                                        $Noti1->notification_cat = 2;
                                                        $Noti1->first_ref = $O->id;
                                                        $Noti1->affected_user = $vals->id;
                                                        $Noti1->effected_by = $this->user_online->id;
                                                        $Noti1->Created_date = date("Y-m-d H:i:s");
                                                        $Noti1->save();
                                                        $viewMessageBody = View::factory('system/email_message');
                                                        $viewMessageBody->username = $this->user_online->name_ar;
                                                        $viewMessageBody->type = 1;
                                                    //    Mailer::SendEmail(null, null, $vals->email, "jaleat email", $viewMessageBody);
                                                    } catch (Exception $ex) {
                                                        echo $ex;
                                                    }
                                                }
                                            }
                                            unset($department_array_SMS[array_search($vals, $department_array_SMS)]);
                                        }
                                    }
                                }
//نهاية انشاء علاقات الموافقات المطلوبة...    
                            }


                            $results['Success'] = array(
                                'title' => Lang::__('Done'),
                                'phones' => $numbers,
                                'content' => Lang::__('Saved_successfully'),
                                'redirect' => URL::base() . 'Letters_Applications/index/' . $Letter->id,
                            );
                        }
                    } catch (ORM_Validation_Exception $e) {

                        $errors = $e->errors('');

                        $Lang_Error = array();
                        foreach ($errors as $key => $value) {
                            $srting = '';
                            if (is_array($value)) {
                                foreach ($value as $subval) {
                                    $srting_sub = '';
                                    $errr = explode('*', $subval);
                                    if (count($errr) > 0) {
                                        $i = 0;
                                        foreach ($errr as $aaa) {
                                            $ss = NULL;
                                            if ($i == 0) {
                                                $F = ORM::factory('Letters_Fields')->where('col_name', '=', $aaa)->where('letter', '=', $Letter->id)->find();
                                                if ($F->loaded()) {
                                                    $ss = $F->{'name_' . $this->lang};
                                                }
                                            }
                                            if (empty($ss)) {
                                                $srting_sub .= Lang::__($aaa) . ' ';
                                            } else {
                                                $srting_sub .= $ss . ' ';
                                            }

                                            $i++;
                                        }
                                        array_push($Lang_Error, $srting_sub);
                                    }
                                }
                            } else {
                                $errr = explode('*', $value);
                                if (count($errr) > 0) {

                                    foreach ($errr as $aaa) {
                                        $ss = NULL;
                                        if ($i == 0) {
                                            $F = ORM::factory('Letters_Fields')->where('col_name', '=', $aaa)->where('letter', '=', $Letter->id)->find();
                                            if ($F->loaded()) {
                                                $ss = $F->{'name_' . $this->lang};
                                            }
                                        }
                                        if (empty($ss)) {
                                            $srting .= Lang::__($aaa) . ' ';
                                        } else {
                                            $srting .= $ss . ' ';
                                        }

                                        $i++;
                                    }
                                    array_push($Lang_Error, $srting);
                                }
                            }
                        }
                        $results['Errors'] = array(
                            'title' => Lang::__('Error'),
                            'content' => General::ArrayToString($Lang_Error)
                        );
                    }
                }
            } else {
                $results['Errors'] = array(
                    'title' => Lang::__('Error'),
                    'content' => Lang::__('You_dont_have_permission_to_do_this_action')
                );
            }
        } else {
            $results['Errors'] = array(
                'title' => Lang::__('Error'),
                'content' => Lang::__('You_dont_have_permission_to_do_this_action')
            );
        }



        echo json_encode($results);
    }

    public function action_GetData() {
        $post = $this->request->post();
        $order = $post['order']; //Get how table order from datatable
        $par1 = !empty($post['par1']) ? $post['par1'] : NULL;
        $Letter = ORM::factory('Letters_Letters', $par1);
        $Fields = $Letter->Fields->where('is_deleted', '=', NULL)->order_by('order')->limit(4)->find_all();
        /*
         * All coulums will shown in table
         */
        $ALL_coulums = array(
            1 => "id",
        );

        $All_ORM = ORM::factory('Letters_Applications')
                ->where('Created_by', '=', $this->user_online->id)
                ->where('is_deleted', '=', NULL)
                ->where('letter', '=', $par1)
                ->order_by($ALL_coulums[$order[0]['column']], $order[0]['dir']);


        $Succesful_msg = Lang::__('Action_successfully_has_been_completed_Well_done');
        $C_Acti_status = "OK";

        /*
         * If Action exists
         */
        if (isset($post['customActionName'])) {
            switch ($post['customActionName']) {
                case 'Delete':


                    break;


                default:
                    break;
            }
        }


        /*
         * if search exists
         */
        if (isset($post['action']) && (!is_array($post['action'])) && mb_strtolower($post['action']) == 'filter') {
            
        }

        /*
         * Paging
         */
        $All_ORM->reset(FALSE);
        $iTotalRecords = $All_ORM->count_all();

        $iDisplayLength = intval($post['length']);
        if($iDisplayLength == -1){
            $iDisplayLength = 1000;
        }
        //$iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($post['start']);
        $sEcho = intval($post['draw']);

        $records = array();
        $records["data"] = array();

        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;


        $All_ORM->offset($iDisplayStart);
        $All_ORM->limit($iDisplayLength);



        /*
         * Prepare JSON Array
         */
        foreach ($All_ORM->find_all() as $value) {
            $buttons = '';

            $Approvals = $value->Letter_Application_Approvals->where('is_deleted', '=', NULL)->find_all();
            $Approvals_All = count($Approvals);
            $Wait = 0;
            $accept = 0;
            $reject = 0;
            $rejected_by = NULL;
            $Text_Approvals = '';
            $notes = '';
            $count = 1;
            foreach ($Approvals as $Approval) {
                if (empty($Approval->app_status)) {
                    $Wait++;
                }
                if ($Approval->app_status == 1) {
                    $accept++;
                }
                if ($Approval->app_status == 2) {
                    $reject++;
                    if (!empty($Approval->rejected_by)) {
                        $rejected_by = $Approval->Rejected_By->{'name_' . $this->lang};
                    }
                }


                $department = $Approval->department;
                if (empty($department)) {
                    $department = $Approval->Application->Created_User->Employee_Information->department;
                }
                if ($Approval->app_status == 1) {
                    $user = ORM::factory("User" , $Approval->approved_by);
                        $user->loaded();
                    $class = ' font-green-jungle ';
                    $S_State = Lang::__('App_Approved') . '<br>'.Lang::__('By') . ': '.$user->{'name_'.$this->lang}. ' <br> ' . $Approval->approved_date;
                } elseif ($Approval->app_status == 2) {
                    $user = ORM::factory("User" , $Approval->rejected_by);
                        $user->loaded();
                    $class = ' font-red-thunderbird ';
                    $S_State = Lang::__('rejected') . '<br>'.Lang::__('By') . ': '.$user->{'name_'.$this->lang}. ' <br> ' . $Approval->rejected_date;
                } else {
                    $class = ' font-grey-cascade  ';
                    $S_State = Lang::__('Waiting for approval');
                }

                $Text_Approvals .= '<span class="' . $class . '">' . $Approval->order . ' - ' . ORM::factory('General_Hr_Departments', $department)->{'name_' . $this->lang} . ' ( ' . $S_State . ' )' . '</span></br>';
                if ($Approval->notes != null && $Approval->notes != '') {
                    $notes .= $count . ') ' . $Approval->notes . '<br>';
                    $count++;
                }
            }






            $buttons .= '<a data-url="' . URL::base() . 'Letters_Applications/ViewDetails/' . $value->id . '" class="btn btn-xs default ViewD" data-toggle="modal"><i class="fa fa-eye"></i> ' . Lang::__('Browse') . '</a>';
            ($this->Edit && empty($accept) && empty($reject)) ? $buttons .= '<a href="' . URL::base() . 'Letters_Applications/Type/' . $value->id . '" class="btn btn-xs default"><i class="fa fa-edit"></i> ' . Lang::__('Edit') . '</a>' : NULL;
            ($this->Delete && ($value->CheckDeleteRules() === TRUE)) ? $buttons .= '<a par1="' . $value->id . '" Dtitle="' . Lang::__('Alert') . '" Dcontent="' . Lang::__('Are_you_sure_you_want_to_delete_it') . '" confirmButton="' . Lang::__('Yes') . '" cancelButton="' . Lang::__('Cancel') . '" class="btn btn-xs red Delete"> ' . Lang::__('Delete') . '</a>' : NULL;

            $data_array = array();
            array_push($data_array, '<input type="checkbox" name="id[]" value="');
            foreach ($Fields as $Field) {
                if ($Field->type == 6) {
                    if ($Field->Dropdown->source == 1) {

                        switch ($Field->Dropdown->source_data) {
                            case 'All_Employees':

                                array_push($data_array, ORM::factory('Hr_Employment_Applications', $value->{$Field->col_name})->GetFullName($this->lang));
                                break;

                            default:
                                break;
                        }
                    } elseif ($Field->Dropdown->source == 2) {
                        array_push($data_array, ORM::factory('Letters_Dropdowns_Options', $value->{$Field->col_name})->{'name_' . $this->lang});
                    }
                } elseif ($Field->type == 7) {

                    array_push($data_array, ORM::factory('Letters_Dropdowns_Options', $value->{$Field->col_name})->{'name_' . $this->lang});
                } else {
                    array_push($data_array, $value->{$Field->col_name});
                }
            }

            array_push($data_array, $Text_Approvals);
            array_push($data_array, $notes);
            array_push($data_array, $buttons);


            $records["data"][] = $data_array;
        }
        if (isset($post["customActionType"]) && $post["customActionType"] == "group_action") {
            $records["customActionStatus"] = $C_Acti_status; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = $Succesful_msg; // pass custom message(useful for getting status of group actions)
        }

        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;

        echo json_encode($records);
    }

    /*
     * Send Json of rules to jquery validation
     */

    public function action_GetRules() {
        $results = array();

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());

        $par1 = empty($Filtered_array['par1']) ? NULL : $Filtered_array['par1'];
        $par2 = empty($Filtered_array['par2']) ? NULL : $Filtered_array['par2'];

        $Letter = ORM::factory('Letters_Letters', $par2);
        $ORM = ORM::factory('Letters_Applications', $par1);

        $results['Rules'] = $ORM->AdminRules($ORM, $Letter);



        echo json_encode($results);
    }

    public function action_ViewDetails() {
        if (($this->Browse)) {
            $par1 = $this->request->param('par1');
            /*             * **************** */
            $view = new View('system/letters/applications/view_details');
            ;


            $par1 = $this->request->param('par1'); //Add or id
            $par2 = $this->request->param('par2'); //letter id or null

            $process_type = 'add_new';
            $Obj = ORM::factory('Letters_Applications', $par1);
            $Letter = $Obj->Letter;
            $Fields = $Letter->Fields->where('is_deleted', '=', NULL)->order_by('order')->find_all();

            $Approvals = $Obj->Letter_Application_Approvals
                    ->where('is_deleted', '=', NULL)
                    ->and_where_open()
                    ->or_where('app_status', '=', 1)
                    ->or_where('app_status', '=', 2)
                    ->and_where_close()
                    ->count_all();




            if ($Obj->loaded()) {
                $view->set('Obj', $Obj);
            }

            $Debugging_Approvals = $Letter->CheckApprovalsStaff($Letter, $this->user_online, TRUE, $this->lang);
            $view->set('Debugging_Approvals', $Debugging_Approvals);

            $view->set('par1', $par1);
            $view->set('Letter', $Letter);
            $view->set('Fields', $Fields);
            $view->set('title', Lang::__($process_type) . ' - ' . $Letter->{'name_' . $this->lang});
            $view->set('title', Lang::__($process_type) . ' - ' . $Letter->{'name_' . $this->lang});
            $view->set('lang', $this->lang);
            $this->response->body($view);



            /*             * **************** */
        }
    }

}
