<?php

defined('SYSPATH') or die('No direct script access.');

class Controller_Journal extends Controller_Template_Base {

    public $Add = FALSE;
    public $Edit = FALSE;
    public $Delete = FALSE;

    public function __construct(Request $request, Response $response) {
        // You must call parent::__construct at some point in your function
        parent::__construct($request, $response);
        // Do whatever else you want

        $this->Add = ($this->user_online->user_groub == 1) ? TRUE : $this->user_online->has('roles', ORM::factory('Role', array('name' => 'A_Journal')));
        $this->Edit = ($this->user_online->user_groub == 1) ? TRUE : $this->user_online->has('roles', ORM::factory('Role', array('name' => 'E_Journal')));
        $this->Delete = ($this->user_online->user_groub == 1) ? TRUE : $this->user_online->has('roles', ORM::factory('Role', array('name' => 'D_Journal')));
    }


    public function action_index() {
        if ($this->Add || $this->Edit || $this->Delete) {
            $title = Lang::__('Journal');
            $this->template->title = $title;
            $this->template->layout = new View('system/journal/view_all');
            $this->template->layout->title = $title;
            $this->template->layout->Add = $this->Add;
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }

    public function action_AE() {

        $par1 = $this->request->param('par1');

        $process_type = 'Add new version';
        $Obj = ORM::factory('Journal', $par1);

        if ($Obj->loaded()) {
            $process_type = 'modify_file';
        }

        if ((($this->Add && !$Obj->loaded()) || ($this->Edit && $Obj->loaded())) && ($Obj->is_deleted == NULL)) {
            $this->template->layout = new View('system/journal/AE');

            if ($Obj->loaded()) {
                $this->template->layout->Obj = $Obj;
            }
            $title = Lang::__($process_type);
            $this->template->layout->title = $title;
            $this->template->title = $title;

            $this->template->layout->lang = $this->lang;
            $this->template->layout->images = ORM::factory('Imagescenter')->where('section', '=', 'journal')->where('ref_id', '=', $Obj->id)->find_all();
            $this->template->layout->Users = Search::action_FindAll_To_Array(ORM::factory('User')->find_all());
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }

    public function action_Delete() {
        $results = array();

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());

        $Obj = ORM::factory('Journal', $Filtered_array['id']);
        if ($Obj->loaded()) {
            if ($this->Delete) {
                try {
                    $Obj->is_deleted = 1;
                    $Obj->deleted_by = $this->user_online->id;
                    $Obj->deleted_date = date("Y-m-d H:i:s");
                    if ($Obj->save()) {
                        $results['Success'] = array(
                            'title' => Lang::__('Deletion has been successfully'),
                            'content' => $Obj->{'title'} . ' ' . Lang::__('has been deleted successfully'),
                        );
                    }
                } catch (ORM_Validation_Exception $e) {

                    $errors = $e->errors('');
                    $results['Errors'] = array(
                        'title' => Lang::__('Error'),
                        'content' => General::ArrayToString(General::CatchErrorMSGSAjax($errors)),
                    );
                }
            } else {
                $results['Errors'] = array(
                    'title' => Lang::__('Error'),
                    'content' => Lang::__('You_dont_have_permission_to_do_this_action'),
                );
            }
        } else {
            $results['Errors'] = array(
                'title' => Lang::__('Error'),
                'content' => Lang::__('Not_found_the_desired_item'),
            );
        }
        echo json_encode($results);
    }

    public function action_ToDB() {
        $results = array();

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());
        $par1 = empty($Filtered_array['par1']) ? NULL : $Filtered_array['par1'];
        $par2 = empty($Filtered_array['par2']) ? NULL : $Filtered_array['par2'];

        $objj = ORM::factory('Journal', $par1);
        if (!$objj->loaded()) {
            $objj->Created_by = $this->user_online->id;
            $objj->Created_date = date("Y-m-d H:i:s");
        } else {
            $objj->last_update_by = $this->user_online->id;
            $objj->last_update_date = date("Y-m-d H:i:s");
        }



        $Files_to_upload = array('file_path');
        $Uploaded = array();
        foreach ($Files_to_upload as $File_Name) {
            if (isset($_FILES[$File_Name])) {
                $File = $this->_save_file($_FILES[$File_Name]);
                if ($File) {
                    $Uploaded[$File_Name] = $File;
                }
            }
        }
        foreach ($Uploaded as $key => $value) {
            $objj->$key = $value;
        }

        $objj->values($Filtered_array);

        try {
            if ($objj->save()) {



                $results['Success'] = array(
                    'title' => Lang::__('Done'),
                    'content' => Lang::__('Saved_successfully'),
                    'redirect_url' => URL::base() . 'Journal',
                );
            }
        } catch (ORM_Validation_Exception $e) {
            //To Delete Image From Server If OBJ Not Saved
            foreach ($Uploaded as $value) {
                $DelFilePath = DOCROOT . $value;
                if (is_file($DelFilePath)) {
                    unlink($DelFilePath);
                }
            }

            //End To Delete Image From Server If OBJ Not Saved

            $errors = $e->errors('');
            $results['Errors'] = array(
                'title' => Lang::__('Error'),
                'content' => General::ArrayToString(General::CatchErrorMSGSAjax($errors)),
            );
        }
        echo json_encode($results);
    }

    protected function _save_image($image, $width = NULL, $height = NULL, $directory, $directory_thumbs) {
        if (!Upload::valid($image) OR ! Upload::not_empty($image) OR ! Upload::type($image, array('jpg', 'jpeg', 'png', 'gif'))) {
            return FALSE;
        }

        if ($file = Upload::save($image, NULL, $directory)) {
            $ext = pathinfo($file, PATHINFO_EXTENSION);
            $filename = strtolower(Text::random('alnum', rand(10, 30))) . '.' . $ext;

            $img = Image::factory($file);
            $img->save($directory . $filename, 100);
            $img->resize($width, $height, Image::INVERSE);
            $img->crop($width, $height);
            $img->save($directory_thumbs . $filename, 100);

            // Delete the temporary file
            unlink($file);

            return $filename;
        }

        return FALSE;
    }

    public function action_GetData() {
        $post = $this->request->post();
        $order = $post['order']; //Get how table order from datatable
        /*
         * All coulums will shown in table
         */
        $ALL_coulums = array(
            1 => "Created_date",
        );

        $All_ORM = ORM::factory('Journal')
                ->where('is_deleted', '=', NULL)
                ->order_by($ALL_coulums[$order[0]['column']], $order[0]['dir']);


        $Succesful_msg = Lang::__('Action_successfully_has_been_completed_Well_done');
        $C_Acti_status = "OK";



        /*
         * if search exists
         */
        if (isset($post['action']) && (!is_array($post['action'])) && mb_strtolower($post['action']) == 'filter') {
            if (!empty($post['from_date'])) {
                $All_ORM->where('Created_date', '>=', $post['from_date']);
            }
            if (!empty($post['to_date'])) {
                $new_to_date = new DateTime($post['to_date']);
                $new_to_date->modify('+1 day'); //تم اضافة يوم لحل مشكلة عدم تحقق شرط التساوي
                $All_ORM->where('Created_date', '<=', $new_to_date->format('Y-m-d H:i:s'));
            }
            if (!empty($post['title'])) {
                $title = $post['title'];
                $All_ORM->and_where_open();
                $All_ORM->or_where(DB::expr('lower(title)'), 'LIKE', mb_strtolower("%$title%"));
                $All_ORM->and_where_close();
            }

        }

        /*
         * Paging
         */
        $All_ORM->reset(FALSE);
        $iTotalRecords = $All_ORM->count_all();

        $iDisplayLength = intval($post['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($post['start']);
        $sEcho = intval($post['draw']);

        $records = array();
        $records["data"] = array();

        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;

        $All_ORM->offset($iDisplayStart);
        $All_ORM->limit($iDisplayLength);




        /*
         * Prepare JSON Array
         */
        foreach ($All_ORM->find_all() as $value) {
            $buttons = '';
            //$buttons .= '<a href="' . URL::base() . 'Journal/' . $value->id . '" target="_blank" class="btn btn-xs green-sharp"><i class="fa fa-television"></i> ' . Lang::__('Show_in_website') . '</a>';
            ($this->Edit) ? $buttons .= '<a href="' . URL::base() . 'Journal/AE/' . $value->id . '" class="btn btn-xs default"><i class="fa fa-edit"></i> ' . Lang::__('Edit') . '</a>' : NULL;
            ($this->Delete) ? $buttons .= '<a par1="' . $value->id . '" confirmButton="' . Lang::__('Yes') . '" cancelButton="' . Lang::__('No') . '" Dtitle="' . Lang::__('confirmation') . '" Dcontent="' . Lang::__('Are_you_sure_you_want_to_delete_it') . '" class="btn btn-xs red Delete" data-toggle="modal"><i class="fa fa-times"></i> ' . Lang::__('Delete') . '</a>' : NULL;



            $records["data"][] = array(
                $value->title,
                date('Y-m-d', strtotime($value->Created_date)),
                $buttons,
            );
        }
        if (isset($post["customActionType"]) && $post["customActionType"] == "group_action") {
            $records["customActionStatus"] = $C_Acti_status; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = $Succesful_msg; // pass custom message(useful for getting status of group actions)
        }

        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;

        echo json_encode($records);
    }

    protected function _save_file($file)
    {
        if (!Upload::valid($file) OR !Upload::not_empty($file) OR !Upload::type($file, array('pdf','doc','docx','xls','xlsx','ppt','pptx'))) {
            return FALSE;
        }
        $directory = 'files/journal/' . date("y") . '/'.date('m').'/';
        if (!empty($directory)) {
            $directory_D = DOCROOT . str_replace("\\", "/", $directory);
            if (!file_exists($directory_D)) {
                mkdir($directory_D, 0777, true);
            }
        }
        $ext = pathinfo($file['name'], PATHINFO_EXTENSION);
        $filename = strtolower(Text::random('alnum', 22)) . '.' . $ext;
        if ($file = Upload::save($file, $filename, $directory)) {
            return $directory . $filename;
        }

        // return FALSE;
    }

}
