<?php

defined('SYSPATH') or die('No direct script access.');

class Controller_Hr_Employment_Applications extends Controller_Template_Base {

    public $Add = FALSE;
    public $Browse = FALSE;
    public $Edit = FALSE;
    public $Delete = FALSE;
    public $Accept_Employment_Applications = FALSE;
    public $Reject_Employment_Applications = FALSE;

    public function __construct(Request $request, Response $response) {
        // You must call parent::__construct at some point in your function
        parent::__construct($request, $response);
        // Do whatever else you want
        //$this->Add =  $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'A_Employment_Applications')));
        $this->Browse =  $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'B_Employment_Applications')));
        $this->Edit =  $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'E_Employment_Applications')));
        $this->Delete =  $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'D_Employment_Applications')));
        $this->Accept_Employment_Applications =  $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'Accept_Employment_Applications')));
        $this->Reject_Employment_Applications =  $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'Reject_Employment_Applications')));
    }

    public function action_index() {
        if ($this->Add || $this->Browse || $this->Edit || $this->Delete) {
            $title = Lang::__('Employment_Applications');
            $this->template->title = $title;
            $this->template->layout = new View('system/hr/employment/applications/view_all');
            $this->template->layout->title = $title;
            $this->template->layout->Add = $this->Add;
            $this->template->layout->lang = $this->lang;
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }

    public function action_Browse() {

        $par1 = $this->request->param('par1');

        $Obj = ORM::factory('Hr_Employment_Applications', $par1);
        if ($this->Browse || $this->Delete || $this->Edit) {
            if (($Obj->loaded()) && ($Obj->is_deleted == NULL)) {
                $this->template->layout = new View('system/hr/employment/applications/Browse');

                $this->template->layout->Obj = $Obj;
                $this->template->layout->App_Status = $Obj->App_Status($Obj);

                $this->template->layout->Qualifications = $Obj->Qualifications->where('is_deleted', '=', NULL)->find_all();
                $this->template->layout->Certificates = $Obj->Certificates->where('is_deleted', '=', NULL)->find_all();
                $this->template->layout->Experiances = $Obj->Experiances->where('is_deleted', '=', NULL)->find_all();
                $title = Lang::__('Review of employment application');
                $this->template->layout->title = $title;
                $this->template->title = $title;
                $this->template->layout->lang = $this->lang;
            } else {
                $this->template->layout = new View('system/show_msg');
                $this->template->layout->class_color = 'danger';
                $this->template->layout->msg = Lang::__('You tracked wrong or expired link');
            }
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }

    public function action_AppApproval() {
        $results = array();

        $req = Request::current();
        $Filtered_array = Search::action_Filtered_array($req->post());
        $par1 = !empty($Filtered_array['par1']) ? $Filtered_array['par1'] : NULL;
        $par2 = !empty($Filtered_array['par2']) ? $Filtered_array['par2'] : NULL;
        $notes = !empty($Filtered_array['notes']) ? $Filtered_array['notes'] : NULL;

        $objj = ORM::factory('Hr_Employment_Applications', $par1);

        if ($objj->loaded()) {
            try {
                if ($par2 == 1 && empty($objj->app_status) && $this->Accept_Employment_Applications) {
                    $objj->app_status = 1;
                    $objj->approved_date = date("Y-m-d H:i:s");
                    $objj->approved_by = $this->user_online->id;
                    $objj->notes = $notes;
                    if ($objj->update()) {
                        $results['Success'] = array(
                            'title' => Lang::__('Done'),
                            'content' => Lang::__('Application approved successfully')
                        );
                    }
                } elseif ($par2 == 2 && empty($objj->app_status) && $this->Reject_Employment_Applications) {
                    $objj->app_status = 2;
                    $objj->rejected_date = date("Y-m-d H:i:s");
                    $objj->rejected_by = $this->user_online->id;
                    $objj->notes = $notes;
                    if ($objj->update()) {
                        $results['Success'] = array(
                            'title' => Lang::__('Done'),
                            'content' => Lang::__('Application rejected successfully')
                        );
                    }
                } else {
                    $results['Errors'] = array(
                        'title' => Lang::__('Error'),
                        'content' => Lang::__('You_dont_have_permission_to_do_this_action')
                    );
                }
            } catch (ORM_Validation_Exception $e) {
                $errors = $e->errors('');
                $results['Errors'] = array(
                    'title' => Lang::__('Error'),
                    'content' => General::ArrayToString(General::CatchErrorMSGSAjax($errors))
                );
            }
        }

        echo json_encode($results);
    }


    public function action_Delete() {
        $results = array();

        if ($this->Delete) {
            $req = Request::current(); //fillter requset
            $Filtered_array = Search::action_Filtered_array($req->post());

            $Obj = ORM::factory('Hr_Employment_Applications', $Filtered_array['id']);

            $CheckDeleteRules = $Obj->CheckDeleteRules();
            if ($CheckDeleteRules === TRUE) {
                try {
                    $Obj->is_deleted = 1;
                    $Obj->deleted_by = $this->user_online->id;
                    $Obj->deleted_date = date("Y-m-d H:i:s");
                    if ($Obj->save()) {
                        $results['Success'] = array(
                            'title' => Lang::__('Done'),
                            'content' => Lang::__('Deletion has been successfully'),
                        );
                    }
                } catch (ORM_Validation_Exception $e) {

                    $errors = $e->errors('');
                    $results['Errors'] = array(
                        'title' => Lang::__('Error'),
                        'content' => General::CatchErrorMSGSAjax($errors),
                    );
                }
            } else {
                if (is_array($CheckDeleteRules)) {

                    $results['Errors'] = array(
                        'title' => Lang::__('Error'),
                        'content' => General::ArrayToString($CheckDeleteRules),
                    );
                }
            }
        } else {
            $results['Errors'] = array(
                'title' => Lang::__('Error'),
                'content' => Lang::__('You_dont_have_permission_to_do_this_action'),
            );
        }

        echo json_encode($results);
    }


    public function action_GetData() {
        $post = $this->request->post();
        $order = $post['order']; //Get how table order from datatable
        /*
         * All coulums will shown in table
         */
        $ALL_coulums = array(
            1 => "id",
        );

        $All_ORM = ORM::factory('Hr_Employment_Applications')
                ->where_open()
                ->or_where('app_status', '=', 2)
                ->or_where('app_status', '=', NULL)
                ->where_close()
                ->where('is_deleted', '=', NULL)
                ->order_by($ALL_coulums[$order[0]['column']], $order[0]['dir']);


        $Succesful_msg = Lang::__('Action_successfully_has_been_completed_Well_done');
        $C_Acti_status = "OK";

        /*
         * If Action exists
         */
        if (isset($post['customActionName'])) {
            switch ($post['customActionName']) {
                case 'Delete':


                    break;


                default:
                    break;
            }
        }


        /*
         * if search exists
         */
        if (isset($post['action']) && (!is_array($post['action'])) && mb_strtolower($post['action']) == 'filter') {
            if (!empty($post['name'])) {
                $Name = mb_strtolower($post['name']);
                $All_ORM->and_where_open();
                $All_ORM->or_where(DB::expr("concat(`name_first_ar`, ' ', `name_father_ar`,' ',`name_grandfather_ar`, ' ',`name_last_ar`)"), "LIKE", DB::expr("concat('%', replace('$Name', ' ', '%'), '%')"));
                $All_ORM->or_where(DB::expr("concat(`name_first_en`, ' ', `name_father_en`,' ',`name_grandfather_en`, ' ',`name_last_en`)"), "LIKE", DB::expr("concat('%', replace('$Name', ' ', '%'), '%')"));
                $All_ORM->and_where_close();
            }


            if (!empty($post['id_no'])) {
                $id_no = $post['id_no'];
                $All_ORM->where('id_no', 'like', mb_strtolower("%$id_no%"));
            }
            if (!empty($post['date_from'])) {
                $All_ORM->where('Created_date', '>=', $post['date_from']);
            }
            if (!empty($post['date_to'])) {
                $new_Created_date_to = new DateTime($post['date_to']);
                $new_Created_date_to->modify('+1 day'); //تم اضافة يوم لحل مشكلة عدم تحقق شرط التساوي
                $All_ORM->where('Created_date', '<=', $new_Created_date_to->format('Y-m-d H:i:s'));
            }
            if (!empty($post['gender'])) {
                    $All_ORM->where('gender', '=', $post['gender']);
            }
        }

        /*
         * Paging
         */

        $All_ORM->reset(FALSE);
        $iTotalRecords = $All_ORM->count_all();

        $iDisplayLength = intval($post['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($post['start']);
        $sEcho = intval($post['draw']);

        $records = array();
        $records["data"] = array();

        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;

        $All_ORM->offset($iDisplayStart);
        $All_ORM->limit($iDisplayLength);



        /*
         * Prepare JSON Array
         */
 foreach ($All_ORM->find_all() as $value) {
            $View = TRUE;


            $majors = '';

            foreach ($value->Qualifications->find_all() as $Q) {

                if (!empty($post['major'])) {
                    $View = FALSE;
                    $major = $post['major'];

                    if (!empty($Q->major) && strpos($Q->major, $major) !== false) {
                        $View = TRUE;
                    }

                }


                $majors .= '<span class="bg-blue-hoki bg-font-blue-hoki" style="padding: 5px;margin:3px;display:inline-block;">' . $Q->major . '</span>';
            }
            if ($View) {
                $buttons = '';
                ($this->Edit || $this->Browse || $this->Delete) ? $buttons .= '<a href="' . URL::base() . 'Hr_Employment_Applications/Browse/' . $value->id . '" class="btn btn-xs blue"><i class="fa fa-search"></i> ' . Lang::__('Browse') . '</a>' : NULL;
                ($this->Delete && ($value->CheckDeleteRules() === TRUE)) ? $buttons .= '<a par1="' . $value->id . '" Dtitle="' . Lang::__('Alert') . '" Dcontent="' . Lang::__('Are_you_sure_you_want_to_delete_it') . '" confirmButton="' . Lang::__('Yes') . '" cancelButton="' . Lang::__('Cancel') . '" class="btn btn-xs red Delete"> ' . Lang::__('Delete') . '</a>' : NULL;

                $records["data"][] = array(
                    '<input type="checkbox" name="id[]" value="' . $value->id . '">',
                    $value->name_first_ar . ' ' . $value->name_father_ar . ' ' . $value->name_grandfather_ar . ' ' . $value->name_last_ar,
                    $value->name_first_en . ' ' . $value->name_father_en . ' ' . $value->name_grandfather_en . ' ' . $value->name_last_en,
                    $value->id_no,
                    $majors,
		    $value->Gender->{'name_'.$this->lang},
                    $value->Created_date,
                    $buttons,
                );
            }
        }        

if (isset($post["customActionType"]) && $post["customActionType"] == "group_action") {
            $records["customActionStatus"] = $C_Acti_status; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = $Succesful_msg; // pass custom message(useful for getting status of group actions)
        }

        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;

        echo json_encode($records);
    }

    protected function _save_image($image, $width = NULL, $height = NULL, $directory, $directory_thumbs, $extensions, $max_file_size) {
        if (!Upload::valid($image) OR ! Upload::not_empty($image) OR ! Upload::type($image, $extensions) OR ! Upload::size($image, $max_file_size)) {
            return FALSE;
        }

        if (!empty($directory)) {
            $directory_D = DOCROOT . str_replace("\\", "/", $directory);
            if (!file_exists($directory_D)) {
                mkdir($directory_D, 0777, true);
            }
        }

        if (!empty($directory_thumbs)) {
            $directory_thumbs_D = DOCROOT . str_replace("\\", "/", $directory_thumbs);
            if (!file_exists($directory_thumbs_D)) {
                mkdir($directory_thumbs_D, 0777, true);
            }
        }

        $ext = pathinfo($image['name'], PATHINFO_EXTENSION);
        $filename = mb_strtolower(Text::random('alnum', rand(10, 30))) . '.' . $ext;

        if (in_array(mb_strtolower($ext), array("gif", "jpeg", "jpg", "png", "bmp"))) {
            if ($file = Upload::save($image, NULL, $directory)) {
                $img = Image::factory($file);
                $img->save($directory . $filename, 100);
                if (!empty($directory_thumbs)) {
                    $img->resize($width, $height, Image::INVERSE);
                    $img->save($directory_thumbs . $filename, 100);
                }
                // Delete the temporary file
                unlink($file);

                return $filename;
            }
        } else {
            if ($file = Upload::save($image, $filename, $directory)) {

                return $filename;
            }
        }
    }

    public function action_DeleteDetails() {
        $results = array();

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());

        $id = isset($Filtered_array['id']) ? $Filtered_array['id'] : NULL;
        $par2 = isset($Filtered_array['par2']) ? $Filtered_array['par2'] : NULL;

        if (in_array($par2, array('Qualifications', 'Certificates', 'Experiances'))) {
            $Obj = ORM::factory('Hr_Employment_Applications_' . $par2, $id);
            if ($Obj->loaded()) {
                if ($this->Delete) {
                    $Obj->is_deleted = 1;
                    $Obj->deleted_by = $this->user_online->id;
                    $Obj->deleted_date = date("Y-m-d H:i:s");
                    if ($Obj->save()) {
                        $results['Success'] = array(
                            'title' => Lang::__('Done'),
                            'content' => Lang::__('Deletion has been successfully'),
                        );
                    }
                } else {
                    $results['Errors'] = array(
                        'title' => Lang::__('Error'),
                        'content' => Lang::__('You_dont_have_permission_to_do_this_action'),
                    );
                }
            } else {

                $results['Errors'] = array(
                    'title' => Lang::__('Error'),
                    'content' => Lang::__('Not_found_the_desired_item'),
                );
            }
        } else {

            $results['Errors'] = array(
                'title' => Lang::__('Error'),
                'content' => Lang::__('Not_found_the_desired_item'),
            );
        }

        $Obj = ORM::factory('Hr_Employment_Applications_' . $par2, $id);


        echo json_encode($results);
    }

    /*
     * Send Json of rules to jquery validation
     */

    public function action_GetRules() {
        $results = array();

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());

        $par1 = empty($Filtered_array['par1']) ? NULL : $Filtered_array['par1'];
        $par2 = empty($Filtered_array['par2']) ? NULL : $Filtered_array['par2'];

        $ORM = ORM::factory('Hr_Employment_Applications', $par1);

        $results['Rules'] = $ORM->AdminRules($ORM);



        echo json_encode($results);
    }

}
