<?php

defined('SYSPATH') or die('No direct script access.');

class Controller_Hr_Employment_Administration extends Controller_Template_Base {

    public $Add = FALSE;
    public $Browse = FALSE;
    public $Edit = FALSE;
    public $Delete = FALSE;
    public $Add_Allowances_To_Employee = FALSE;
    public $Delete_Allowances_From_Employee = FALSE;
    public $Add_Deductions_To_Employee = FALSE;
    public $Delete_Deductions_From_Employee = FALSE;

    public function __construct(Request $request, Response $response) {
        // You must call parent::__construct at some point in your function
        parent::__construct($request, $response);
        // Do whatever else you want
        //$this->Add =  $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'A_Employment_Applications')));
        $this->Browse = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'B_Hr_Employment_Administration')));
        $this->Edit = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'E_Hr_Employment_Administration')));
        $this->Delete = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'D_Hr_Employment_Administration')));
        $this->Add_Allowances_To_Employee = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'Add_Allowances_To_Employee')));
        $this->Add_Deductions_To_Employee = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'Add_Deductions_To_Employee')));
        $this->Delete_Allowances_From_Employee = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'Delete_Allowances_From_Employee')));
        $this->Delete_Deductions_From_Employee = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'Delete_Deductions_From_Employee')));
    }

    public function action_excel() {

        $headerstyleArray = array(
            'font' => array(
                'bold' => true,
            ),
            'alignment' => array(
                'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
            ),
            'borders' => array(
                'top' => array(
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                ),
            ),
        );

        $NormalstyleArray = array(
            'alignment' => array(
                'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
            ),
            'borders' => array(
                'top' => array(
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                ),
            ),
        );

        $spreadsheet = new \PhpOffice\PhpSpreadsheet\Spreadsheet();
        $worksheet = $spreadsheet->getActiveSheet();

        $Feilds = array(
            1 => 'code',
            2 => 'id_no',
            3 => 'name_ar',
            4 => 'name_en',
            5 => 'mobile',
            6 => 'email',
        ); //To Start Keys From 1 not 0

        foreach ($Feilds as $key => $value) {
            $alphapet = General::getNameFromNumber($key);

            $worksheet->getCell($alphapet . '1')->setValue(Lang::__($value))->getStyle($alphapet . '1')->applyFromArray($headerstyleArray);
            $Feilds[$alphapet] = $value; //To change key to alphapet
            unset($Feilds[$key]);
        }

        $Students_Applications = ORM::factory('Hr_Employment_Applications')->where('app_status', '=', 1)->find_all();
        $k = 2;
        foreach ($Students_Applications as $Attendance) {
            foreach ($Feilds as $alpha => $col_name) {
                if ($col_name == 'name_ar') {
                    $val = $Attendance->name_first_ar . ' ' . $Attendance->name_father_ar . ' ' . $Attendance->name_grandfather_ar . ' ' . $Attendance->name_last_ar;
                } else if ($col_name == 'name_en') {
                    $val = $Attendance->name_first_en . ' ' . $Attendance->name_father_en . ' ' . $Attendance->name_grandfather_en . ' ' . $Attendance->name_last_en;
                } else {
                    $val = $Attendance->$col_name;
                }

                $worksheet->getCell($alpha . $k)->setValue($val)->getStyle($alpha . $k)->applyFromArray($NormalstyleArray);
            }

            $k++;
        }
        foreach ($Feilds as $alpha => $col_name) {
            $worksheet->getColumnDimension($alpha)->setAutoSize(true);
        }

        $Success_Files = array();
        $directory = 'files/hr/' . date('Y') . '/' . date("m") . '/';
        $directory_D = DOCROOT . str_replace("\\", "/", $directory);
        if (!file_exists($directory_D)) {
            mkdir($directory_D, 0777, true);
        }
        $ext = 'xlsx';
        $filename = mb_strtolower(Text::random('alnum', rand(10, 30))) . '.' . $ext;
        $writer = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($spreadsheet, ucfirst($ext));

        if ($writer->save($directory . $filename) === NULL) {
            
        }



        $spreadsheet->disconnectWorksheets(); //Clearing a Workbook from memory
        unset($spreadsheet); //Clearing a Workbook from memory
    }

    public function action_CreateAccount() {

        $results = array();

        $req = Request::current();
        $Filtered_array = Search::action_Filtered_array($req->post());
        $id = !empty($Filtered_array['id']) ? $Filtered_array['id'] : NULL;

        $Accounting_Links = ORM::factory('Accounting_Links', 1);
        if (!empty($Accounting_Links->account_id)) {

            $objj = ORM::factory('Hr_Employment_Applications', $id);

            if ($objj->loaded() && empty($objj->is_deleted) && empty($objj->account_id)) {
                try {

                    $Financials_Accounts = ORM::factory('Financials_Accounts');
                    $Financials_Accounts->ParentNo = $Accounting_Links->account_id;
                    $Financials_Accounts->AccName_ar = $objj->{'name_first_ar'} . ' ' . $objj->{'name_father_ar'} . ' ' . $objj->{'name_grandfather_ar'} . ' ' . $objj->{'name_last_ar'};
                    $Financials_Accounts->AccName_en = $objj->{'name_first_en'} . ' ' . $objj->{'name_father_en'} . ' ' . $objj->{'name_grandfather_en'} . ' ' . $objj->{'name_last_en'};
                    $Financials_Accounts->Created_by = $this->user_online->id;
                    $Financials_Accounts->Created_date = date("Y-m-d H:i:s");
                    //Create auto account number
                    $New_Acc_id = '';
                    if (isset($Accounting_Links->account_id) && !empty($Accounting_Links->account_id)) {
                        $Parent_Obj = ORM::factory('Financials_Accounts', $Accounting_Links->account_id);
                        if ($Parent_Obj->loaded()) {
                            $New_Acc_id = $Parent_Obj->AccNo;
                            $CountPrev = ORM::factory('Financials_Accounts')->where('is_deleted', '=', NULL)->where('ParentNo', '=', $Parent_Obj->id)->count_all();
                            $CountPrev++;
                            $New_Acc_id .= '.' . $CountPrev;
                        }
                    }
                    $Financials_Accounts->AccNo = $New_Acc_id;
                    //End Create auto account number
                    if ($Financials_Accounts->save()) {
                        $objj->account_id = $Financials_Accounts->id;
                        $objj->update();

                        $results['Success'] = array(
                            'title' => Lang::__('Done'),
                            'content' => Lang::__('A new account has been created under the account') . ' ' . $Accounting_Links->{'name_' . $this->lang}
                        );
                    }
                } catch (ORM_Validation_Exception $e) {
                    $errors = $e->errors('');
                    $results['Errors'] = array(
                        'title' => Lang::__('Error'),
                        'content' => General::ArrayToString(General::CatchErrorMSGSAjax($errors))
                    );
                }
            } else {
                $results['Errors'] = array(
                    'title' => Lang::__('Error'),
                    'content' => Lang::__('An error occurred while trying to process the request')
                );
            }
        } else {
            $results['Errors'] = array(
                'title' => Lang::__('Error'),
                'content' => Lang::__('No employee screen account linked')
            );
        }



        echo json_encode($results);
    }

    public function action_CreateUser() {

        $results = array();

        $req = Request::current();
        $Filtered_array = Search::action_Filtered_array($req->post());
        $par1 = !empty($Filtered_array['par1']) ? $Filtered_array['par1'] : NULL;

        $objj = ORM::factory('Hr_Employment_Applications', $par1);

        if ($objj->loaded() && empty($objj->is_deleted) && empty($objj->user_id) && ($objj->app_status == 1)) {
            try {
                $Groub = ORM::factory('Usersgroub', 5); // موظف
                $password = Text::random('nozero', rand(8, 8));

                $username = $objj->GenerateAcadimicNo();

                $User = ORM::factory('User');
                $User->username = $username;
                $User->password = $password;
                $User->email = $objj->email;
                $User->user_groub = $Groub->id;
                $User->name_ar = $objj->name_first_ar . ' ' . $objj->name_father_ar . ' ' . $objj->name_grandfather_ar . ' ' . $objj->name_last_ar;
                $User->name_en = $objj->name_first_en . ' ' . $objj->name_father_en . ' ' . $objj->name_grandfather_en . ' ' . $objj->name_last_en;
                $User->Created_by = $this->user_online->id;
                $User->Created_date = date("Y-m-d H:i:s");
                if ($User->save()) {
                    // Grant user login role
                    $User->add('roles', ORM::factory('Role', array('name' => 'login')));
                    $objj->user_id = $User->id;
                    $objj->user_password = $password;
                    $objj->update();

                    $results['Success'] = array(
                        'title' => Lang::__('Done'),
                        'content' => Lang::__('A new membership has been created for the employee') . '</br>' . '* ' . Lang::__('The user name is') . ': ' . $username . '</br> * ' . Lang::__('The password is') . ': ' . $password
                    );
                }
            } catch (ORM_Validation_Exception $e) {
                $errors = $e->errors('');
                $results['Errors'] = array(
                    'title' => Lang::__('Error'),
                    'content' => General::ArrayToString(General::CatchErrorMSGSAjax($errors))
                );
            }
        }

        echo json_encode($results);
    }

    public function action_index() {
        if ($this->Add || $this->Browse || $this->Edit || $this->Delete) {
            $title = Lang::__('Hr_Employment_Administration');
            $this->template->title = $title;
            $this->template->layout = new View('system/hr/employment/administration/view_all');
            $this->template->layout->title = $title;
            $this->template->layout->Add = $this->Add;
            $this->template->layout->lang = $this->lang;
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }

    public function action_GetData() {
        $post = $this->request->post();
        $order = $post['order']; //Get how table order from datatable
        /*
         * All coulums will shown in table
         */
        $ALL_coulums = array(
            1 => "id",
        );

        $All_ORM = ORM::factory('Hr_Employment_Applications')
                ->where('is_deleted', '=', NULL)
                ->where('app_status', '=', 1)
                ->order_by($ALL_coulums[$order[0]['column']], $order[0]['dir']);


        $Succesful_msg = Lang::__('Action_successfully_has_been_completed_Well_done');
        $C_Acti_status = "OK";

        /*
         * If Action exists
         */
        if (isset($post['customActionName'])) {
            switch ($post['customActionName']) {
                case 'Delete':


                    break;


                default:
                    break;
            }
        }


        /*
         * if search exists
         */
        if (isset($post['action']) && (!is_array($post['action'])) && mb_strtolower($post['action']) == 'filter') {
            if (!empty($post['name'])) {
                $Name = $post['name'];
                $All_ORM->and_where_open();
                $All_ORM->or_where(DB::expr("concat(`name_first_ar`, ' ', `name_father_ar`,' ',`name_grandfather_ar`, ' ',`name_last_ar`)"), "LIKE", DB::expr("concat('%', replace('$Name', ' ', '%'), '%')"));
                $All_ORM->or_where(DB::expr("concat(`name_first_en`, ' ', `name_father_en`,' ',`name_grandfather_en`, ' ',`name_last_en`)"), "LIKE", DB::expr("concat('%', replace('$Name', ' ', '%'), '%')"));
                $All_ORM->and_where_close();
            }
            if (!empty($post['id_no'])) {
                $All_ORM->where('id_no', '=', $post['id_no']);
            }
        }

        /*
         * Paging
         */

        $All_ORM->reset(FALSE);
        $iTotalRecords = $All_ORM->count_all();

        $iDisplayLength = intval($post['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($post['start']);
        $sEcho = intval($post['draw']);

        $records = array();
        $records["data"] = array();

        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;

        $All_ORM->offset($iDisplayStart);
        $All_ORM->limit($iDisplayLength);



        /*
         * Prepare JSON Array
         */
        foreach ($All_ORM->find_all() as $value) {
            $buttons = '';
            ($this->Edit || $this->Browse || $this->Delete) ? $buttons .= '<a href="' . URL::base() . 'Hr_Employment_Administration/Browse/' . $value->id . '" class="btn btn-xs blue"><i class="fa fa-search"></i> ' . Lang::__('Browse') . '</a>' : NULL;
            ($this->Edit && ($value->app_status == 1)) ? $buttons .= '<a href="' . URL::base() . 'Hr_Employment_Administration/AE/' . $value->id . '" class="btn btn-xs default"><i class="fa fa-edit"></i> ' . Lang::__('Edit') . '</a>' : NULL;
            ($this->Delete && ($value->CheckDeleteRules() === TRUE)) ? $buttons .= '<a par1="' . $value->id . '" Dtitle="' . Lang::__('Alert') . '" Dcontent="' . Lang::__('Are_you_sure_you_want_to_delete_it') . '" confirmButton="' . Lang::__('Yes') . '" cancelButton="' . Lang::__('Cancel') . '" class="btn btn-xs red Delete"> ' . Lang::__('Delete') . '</a>' : NULL;

            $records["data"][] = array(
                '<input type="checkbox" name="id[]" value="' . $value->id . '">',
                $value->name_first_ar . ' ' . $value->name_father_ar . ' ' . $value->name_grandfather_ar . ' ' . $value->name_last_ar,
                $value->name_first_en . ' ' . $value->name_father_en . ' ' . $value->name_grandfather_en . ' ' . $value->name_last_en,
                $value->id_no,
                $buttons,
            );
        }
        if (isset($post["customActionType"]) && $post["customActionType"] == "group_action") {
            $records["customActionStatus"] = $C_Acti_status; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = $Succesful_msg; // pass custom message(useful for getting status of group actions)
        }

        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;

        echo json_encode($records);
    }

    public function action_Browse() {

        $par1 = $this->request->param('par1');

        $Obj = ORM::factory('Hr_Employment_Applications', $par1);
        if ($this->Browse || $this->Delete || $this->Edit) {
            if (($Obj->loaded()) && ($Obj->is_deleted == NULL)) {
                $this->template->layout = new View('system/hr/employment/administration/Browse');

                $this->template->layout->Obj = $Obj;
                $this->template->layout->App_Status = $Obj->App_Status($Obj);

                $this->template->layout->Qualifications = $Obj->Qualifications->where('is_deleted', '=', NULL)->find_all();
                $this->template->layout->Certificates = $Obj->Certificates->where('is_deleted', '=', NULL)->find_all();
                $this->template->layout->Experiances = $Obj->Experiances->where('is_deleted', '=', NULL)->find_all();

                $this->template->layout->Allowances_Types = $Obj->Allowances_Types->where('hr_allowances_relations.is_deleted', '=', NULL)->find_all();
                $this->template->layout->Deductions_Types = $Obj->Deductions_Types->where('hr_deductions_relations.is_deleted', '=', NULL)->find_all();

                $title = Lang::__('Review of employment application');
                $this->template->layout->title = $title;
                $this->template->title = $title;
                $this->template->layout->lang = $this->lang;
            } else {
                $this->template->layout = new View('system/show_msg');
                $this->template->layout->class_color = 'danger';
                $this->template->layout->msg = Lang::__('You tracked wrong or expired link');
            }
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }

    public function action_AE() {

        $par1 = $this->request->param('par1');
        $par2 = $this->request->param('par2');

        $process_type = 'add_new';
        $Obj = ORM::factory('Hr_Employment_Applications', $par1);

        if ($Obj->loaded()) {
            $process_type = 'modify';
        }

        if ((($this->Add && $process_type == 'add_new') || ($this->Edit && $process_type == 'modify' && ($Obj->app_status == 1))) && ($Obj->is_deleted == NULL)) {
            $this->template->layout = new View('system/hr/employment/administration/AE');

            if ($Obj->loaded()) {
                $this->template->layout->Obj = $Obj;
                $this->template->layout->date_of_birth = explode('-', $Obj->date_of_birth);
                $this->template->layout->date_of_birth_higri = explode('-', $Obj->date_of_birth_higri);
                $this->template->layout->passport_expiration_date = explode('-', $Obj->passport_expiration_date);
                $this->template->layout->passport_expiration_date_higri = explode('-', $Obj->passport_expiration_date_higri);
                $this->template->layout->id_expiry_date = explode('-', $Obj->id_expiry_date);
                $this->template->layout->id_expiry_date_higri = explode('-', $Obj->id_expiry_date_higri);
                $this->template->layout->starting_date = explode('-', $Obj->starting_date);
            }
            $this->template->layout->Maritalstatus = ORM::factory('General_Maritalstatus')->where('is_active', '=', 1)->where('is_deleted', '=', NULL)->find_all();
            $this->template->layout->Nationalities = ORM::factory('General_Countries')->where('is_active', '=', 1)->where('is_deleted', '=', NULL)->find_all();
            $this->template->layout->Religions = ORM::factory('General_Religions')->where('is_active', '=', 1)->where('is_deleted', '=', NULL)->find_all();
            $this->template->layout->Genders = ORM::factory('General_Genders')->where('is_active', '=', 1)->where('is_deleted', '=', NULL)->find_all();
            $this->template->layout->Banks = ORM::factory('General_Banks')->where('is_active', '=', 1)->where('is_deleted', '=', NULL)->find_all();
            $this->template->layout->Sections = ORM::factory('General_Hr_Sections')->where('is_active', '=', 1)->where('is_deleted', '=', NULL)->find_all();
            $this->template->layout->Employee_Types = ORM::factory('General_Hr_Employee_Types')->where('is_active', '=', 1)->where('is_deleted', '=', NULL)->find_all();
            $this->template->layout->Departments = ORM::factory('General_Hr_Departments')->where('is_active', '=', 1)->where('is_deleted', '=', NULL)->find_all();
            $this->template->layout->Positions = ORM::factory('General_Hr_Positions')->where('is_active', '=', 1)->where('is_deleted', '=', NULL)->find_all();

            $this->template->layout->Qualifications = $Obj->Qualifications->where('is_deleted', '=', NULL)->find_all();
            $this->template->layout->Certificates = $Obj->Certificates->where('is_deleted', '=', NULL)->find_all();
            $this->template->layout->Experiances = $Obj->Experiances->where('is_deleted', '=', NULL)->find_all();

            $this->template->layout->title = Lang::__($process_type);
            $this->template->title = Lang::__($process_type);
            $this->template->layout->lang = $this->lang;
            $this->template->layout->Add_Allowances_To_Employee = $this->Add_Allowances_To_Employee;
            $this->template->layout->Add_Deductions_To_Employee = $this->Add_Deductions_To_Employee;
            $this->template->layout->Users = Search::action_FindAll_To_Array(ORM::factory('User')->find_all());
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }

    public function action_Delete() {
        $results = array();

        if ($this->Delete) {
            $req = Request::current(); //fillter requset
            $Filtered_array = Search::action_Filtered_array($req->post());

            $Obj = ORM::factory('Hr_Employment_Applications', $Filtered_array['id']);

            $CheckDeleteRules = $Obj->CheckDeleteRules();
            if ($CheckDeleteRules === TRUE) {
                try {
                    $Obj->is_deleted = 1;
                    $Obj->deleted_by = $this->user_online->id;
                    $Obj->deleted_date = date("Y-m-d H:i:s");
                    if ($Obj->save()) {
                        $results['Success'] = array(
                            'title' => Lang::__('Done'),
                            'content' => Lang::__('Deletion has been successfully'),
                        );
                    }
                } catch (ORM_Validation_Exception $e) {

                    $errors = $e->errors('');
                    $results['Errors'] = array(
                        'title' => Lang::__('Error'),
                        'content' => General::CatchErrorMSGSAjax($errors),
                    );
                }
            } else {
                if (is_array($CheckDeleteRules)) {

                    $results['Errors'] = array(
                        'title' => Lang::__('Error'),
                        'content' => General::ArrayToString($CheckDeleteRules),
                    );
                }
            }
        } else {
            $results['Errors'] = array(
                'title' => Lang::__('Error'),
                'content' => Lang::__('You_dont_have_permission_to_do_this_action'),
            );
        }

        echo json_encode($results);
    }

    public function action_ToDB() {
        $results = array();

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());

        $par1 = empty($Filtered_array['par1']) ? NULL : $Filtered_array['par1'];
        $par2 = empty($Filtered_array['par2']) ? NULL : $Filtered_array['par2'];

        //Path of upload images
        $directory = 'files/hr/' . date('Y') . '/' . date("m") . '/';
        $directory_thumbs = $directory . 'thumbs/';

        $objj = ORM::factory('Hr_Employment_Applications', $par1);

        if (!$objj->loaded() || ($objj->loaded() && ($objj->app_status == 1))) {

            if (!$objj->loaded()) {
                $objj->Created_by = $this->user_online->id;
                $objj->Created_date = date("Y-m-d H:i:s");
            } else {
                $objj->last_update_by = $this->user_online->id;
                $objj->last_update_date = date("Y-m-d H:i:s");

                if (!empty($objj->employee_not_in_payroll) && empty($Filtered_array['employee_not_in_payroll'])) {
                    $objj->employee_not_in_payroll = NULL;
                }
            }

            if (isset($Filtered_array['bd_year_gregorian']) && isset($Filtered_array['bd_month_gregorian']) && isset($Filtered_array['bd_day_gregorian'])) {
                $Filtered_array['date_of_birth'] = $Filtered_array['bd_year_gregorian'] . '-' . $Filtered_array['bd_month_gregorian'] . '-' . $Filtered_array['bd_day_gregorian'];
            }
            if (isset($Filtered_array['bd_year']) && isset($Filtered_array['bd_month']) && isset($Filtered_array['bd_day'])) {
                $Filtered_array['date_of_birth_higri'] = $Filtered_array['bd_year'] . '-' . $Filtered_array['bd_month'] . '-' . $Filtered_array['bd_day'];
            }
            if (isset($Filtered_array['passport_expiration_date_year']) && isset($Filtered_array['passport_expiration_date_month']) && isset($Filtered_array['passport_expiration_date_day'])) {
                $Filtered_array['passport_expiration_date'] = $Filtered_array['passport_expiration_date_year'] . '-' . $Filtered_array['passport_expiration_date_month'] . '-' . $Filtered_array['passport_expiration_date_day'];
            }
            if (isset($Filtered_array['passport_expiration_date_year_higri']) && isset($Filtered_array['passport_expiration_date_month_higri']) && isset($Filtered_array['passport_expiration_date_day_higri'])) {
                $Filtered_array['passport_expiration_date_higri'] = $Filtered_array['passport_expiration_date_year_higri'] . '-' . $Filtered_array['passport_expiration_date_month_higri'] . '-' . $Filtered_array['passport_expiration_date_day_higri'];
            }

            if (isset($Filtered_array['id_expiry_year_gregorian']) && isset($Filtered_array['id_expiry_month_gregorian']) && isset($Filtered_array['id_expiry_day_gregorian'])) {
                $Filtered_array['id_expiry_date'] = $Filtered_array['id_expiry_year_gregorian'] . '-' . $Filtered_array['id_expiry_month_gregorian'] . '-' . $Filtered_array['id_expiry_day_gregorian'];
            }
            if (isset($Filtered_array['id_expiry_year']) && isset($Filtered_array['id_expiry_month']) && isset($Filtered_array['id_expiry_day'])) {
                $Filtered_array['id_expiry_date_higri'] = $Filtered_array['id_expiry_year'] . '-' . $Filtered_array['id_expiry_month'] . '-' . $Filtered_array['id_expiry_day'];
            }
            if (isset($Filtered_array['starting_date_year']) && isset($Filtered_array['starting_date_month']) && isset($Filtered_array['starting_date_day'])) {
                $Filtered_array['starting_date'] = $Filtered_array['starting_date_year'] . '-' . $Filtered_array['starting_date_month'] . '-' . $Filtered_array['starting_date_day'];
            }

            $Jquery_Rules = $objj->AdminRules($objj, FALSE);

            $upload_images_error = array();
            if ($this->request->method() == Request::POST) {
                $FileS = isset($_FILES['id_copy']) ? $_FILES['id_copy'] : NULL;
                if (!empty($FileS) && Upload::valid($FileS) && Upload::not_empty($FileS)) {
                    $allowed_ext = isset($Jquery_Rules['id_copy']['accept']) ? explode('|', $Jquery_Rules['id_copy']['accept']) : array();
                    $max_size = isset($Jquery_Rules['id_copy']['filesize']) ? $Jquery_Rules['id_copy']['filesize'] : 5000000;
                    $id_copy = $this->_save_image($_FILES['id_copy'], NULL, NULL, $directory, NULL, $allowed_ext, $max_size . 'B');
                    if ($id_copy) {

                        foreach (array('id_copy') as $value) {
                            if (!empty($objj->$value)) {
                                $DelFilePath = DOCROOT . $objj->$value;
                                if (is_file($DelFilePath)) {
                                    unlink($DelFilePath);
                                }
                            }
                        }
                        $Filtered_array['id_copy'] = $directory . $id_copy;
                    } else {
                        array_push($upload_images_error, Lang::__('id_copy'));
                    }
                }
                $cv_file = isset($_FILES['cv_file']) ? $_FILES['cv_file'] : NULL;
                if (!empty($cv_file) && Upload::valid($cv_file) && Upload::not_empty($cv_file)) {
                    $allowed_ext = isset($Jquery_Rules['cv_file']['accept']) ? explode('|', $Jquery_Rules['cv_file']['accept']) : array();
                    $max_size = isset($Jquery_Rules['cv_file']['filesize']) ? $Jquery_Rules['cv_file']['filesize'] : 5000000;
                    $cv_file = $this->_save_image($_FILES['cv_file'], NULL, NULL, $directory, NULL, $allowed_ext, $max_size . 'B');
                    if ($cv_file) {

                        foreach (array('cv_file') as $value) {
                            if (!empty($objj->$value)) {
                                $DelFilePath = DOCROOT . $objj->$value;
                                if (is_file($DelFilePath)) {
                                    unlink($DelFilePath);
                                }
                            }
                        }
                        $Filtered_array['cv_file'] = $directory . $cv_file;
                    } else {
                        array_push($upload_images_error, Lang::__('cv_file'));
                    }
                }
            }
            //Start allowed fields check
            $ArrayOfPrevents = array("app_status", "notes", "app_id", "is_deleted", "deleted_by", "deleted_date", "Created_by", "Created_date", "last_update_by", "last_update_date", "approved_date", "approved_by", "rejected_date", "rejected_by");
            foreach ($Filtered_array as $key => $value) {
                if (in_array($key, $ArrayOfPrevents)) {
                    unset($Filtered_array[$key]);
                }
            }
            //End allowed fields check
            $objj->values($Filtered_array);
            $extra_rules = General::Jquery_To_ORM_Rules($Filtered_array, $Jquery_Rules);

            if (empty($upload_images_error)) {
                try {

                    if ($objj->save($extra_rules)) {
                        //Start dealing with with Qualifications
                        $Qualifications = isset($Filtered_array['Qualifications']) ? $Filtered_array['Qualifications'] : NULL;
                        if (!empty($Qualifications)) {
                            foreach ($Qualifications as $keyQ => $Qualification) {

                                $This_File = array();
                                if (isset($_FILES['Qualifications']['name'][$keyQ]['attachment_file'])) {
                                    $This_File['name'] = $_FILES['Qualifications']['name'][$keyQ]['attachment_file'];
                                }
                                if (isset($_FILES['Qualifications']['type'][$keyQ]['attachment_file'])) {
                                    $This_File['type'] = $_FILES['Qualifications']['type'][$keyQ]['attachment_file'];
                                }
                                if (isset($_FILES['Qualifications']['tmp_name'][$keyQ]['attachment_file'])) {
                                    $This_File['tmp_name'] = $_FILES['Qualifications']['tmp_name'][$keyQ]['attachment_file'];
                                }
                                if (isset($_FILES['Qualifications']['error'][$keyQ]['attachment_file'])) {
                                    $This_File['error'] = $_FILES['Qualifications']['error'][$keyQ]['attachment_file'];
                                }
                                if (isset($_FILES['Qualifications']['size'][$keyQ]['attachment_file'])) {
                                    $This_File['size'] = $_FILES['Qualifications']['size'][$keyQ]['attachment_file'];
                                }

                                if (isset($This_File) && Upload::valid($This_File) && Upload::not_empty($This_File)) {
                                    $allowed_ext = array("jpg", "jpeg", "png", "gif");
                                    $max_size = 5000000;
                                    $File = $this->_save_image($This_File, NULL, NULL, $directory, NULL, $allowed_ext, $max_size . 'B');
                                    if ($File) {
                                        foreach (array('attachment_file') as $value) {
                                            if (!empty($objj->$value)) {
                                                $DelFilePath = DOCROOT . $objj->$value;
                                                if (is_file($DelFilePath)) {
                                                    unlink($DelFilePath);
                                                }
                                            }
                                        }
                                        $Qualification['attachment_file'] = $directory . $File;
                                    } else {
                                        //array_push($upload_images_error, Lang::__('attachment_file'));
                                    }
                                }
                                //To check if any of field exist
                                $all_empty = TRUE;
                                foreach ($Qualification as $key => $value) {
                                    if (!empty($value)) {
                                        $all_empty = FALSE;
                                        break;
                                    }
                                }
                                //End check if any of field exist
                                if ($all_empty == FALSE) {
                                    $id_this = isset($Qualification['id']) ? $Qualification['id'] : NULL;
                                    $Packagesadditional = ORM::factory('Hr_Employment_Applications_Qualifications', $id_this);
                                    $Packagesadditional->values($Qualification);
                                    if (!$Packagesadditional->loaded()) {
                                        $Packagesadditional->application_id = $objj->id;
                                    }
                                    $Packagesadditional->save();
                                }
                            }
                        }
                        //End dealing with with Qualifications
                        //Start dealing with with Certificates
                        $Certificates = isset($Filtered_array['Certificates']) ? $Filtered_array['Certificates'] : NULL;
                        if (!empty($Certificates)) {
                            foreach ($Certificates as $keyQ => $Certificate) {

                                $This_File = array();
                                if (isset($_FILES['Certificates']['name'][$keyQ]['attachment_file'])) {
                                    $This_File['name'] = $_FILES['Certificates']['name'][$keyQ]['attachment_file'];
                                }
                                if (isset($_FILES['Certificates']['type'][$keyQ]['attachment_file'])) {
                                    $This_File['type'] = $_FILES['Certificates']['type'][$keyQ]['attachment_file'];
                                }
                                if (isset($_FILES['Certificates']['tmp_name'][$keyQ]['attachment_file'])) {
                                    $This_File['tmp_name'] = $_FILES['Certificates']['tmp_name'][$keyQ]['attachment_file'];
                                }
                                if (isset($_FILES['Certificates']['error'][$keyQ]['attachment_file'])) {
                                    $This_File['error'] = $_FILES['Certificates']['error'][$keyQ]['attachment_file'];
                                }
                                if (isset($_FILES['Certificates']['size'][$keyQ]['attachment_file'])) {
                                    $This_File['size'] = $_FILES['Certificates']['size'][$keyQ]['attachment_file'];
                                }

                                if (isset($This_File) && Upload::valid($This_File) && Upload::not_empty($This_File)) {
                                    $allowed_ext = array("jpg", "jpeg", "png", "gif");
                                    $max_size = 5000000;
                                    $File = $this->_save_image($This_File, NULL, NULL, $directory, NULL, $allowed_ext, $max_size . 'B');
                                    if ($File) {
                                        foreach (array('attachment_file') as $value) {
                                            if (!empty($objj->$value)) {
                                                $DelFilePath = DOCROOT . $objj->$value;
                                                if (is_file($DelFilePath)) {
                                                    unlink($DelFilePath);
                                                }
                                            }
                                        }
                                        $Certificate['attachment_file'] = $directory . $File;
                                    } else {
                                        //array_push($upload_images_error, Lang::__('attachment_file'));
                                    }
                                }
                                //To check if any of field exist
                                $all_empty = TRUE;
                                foreach ($Certificate as $key => $value) {
                                    if (!empty($value)) {
                                        $all_empty = FALSE;
                                        break;
                                    }
                                }
                                //End check if any of field exist
                                if ($all_empty == FALSE) {
                                    $id_this = isset($Certificate['id']) ? $Certificate['id'] : NULL;
                                    $Certifica = ORM::factory('Hr_Employment_Applications_Certificates', $id_this);
                                    $Certifica->values($Certificate);
                                    if (!$Certifica->loaded()) {
                                        $Certifica->application_id = $objj->id;
                                    }
                                    $Certifica->save();
                                }
                            }
                        }
                        //End dealing with with Certificates
                        //Start dealing with with Experiances
                        $Experiances = isset($Filtered_array['Experiances']) ? $Filtered_array['Experiances'] : NULL;
                        if (!empty($Experiances)) {
                            foreach ($Experiances as $keyQ => $Experiance) {

                                $This_File = array();
                                if (isset($_FILES['Experiances']['name'][$keyQ]['attachment_file'])) {
                                    $This_File['name'] = $_FILES['Experiances']['name'][$keyQ]['attachment_file'];
                                }
                                if (isset($_FILES['Experiances']['type'][$keyQ]['attachment_file'])) {
                                    $This_File['type'] = $_FILES['Experiances']['type'][$keyQ]['attachment_file'];
                                }
                                if (isset($_FILES['Experiances']['tmp_name'][$keyQ]['attachment_file'])) {
                                    $This_File['tmp_name'] = $_FILES['Experiances']['tmp_name'][$keyQ]['attachment_file'];
                                }
                                if (isset($_FILES['Experiances']['error'][$keyQ]['attachment_file'])) {
                                    $This_File['error'] = $_FILES['Experiances']['error'][$keyQ]['attachment_file'];
                                }
                                if (isset($_FILES['Experiances']['size'][$keyQ]['attachment_file'])) {
                                    $This_File['size'] = $_FILES['Experiances']['size'][$keyQ]['attachment_file'];
                                }

                                if (isset($This_File) && Upload::valid($This_File) && Upload::not_empty($This_File)) {
                                    $allowed_ext = array("jpg", "jpeg", "png", "gif");
                                    $max_size = 5000000;
                                    $File = $this->_save_image($This_File, NULL, NULL, $directory, NULL, $allowed_ext, $max_size . 'B');
                                    if ($File) {
                                        foreach (array('attachment_file') as $value) {
                                            if (!empty($objj->$value)) {
                                                $DelFilePath = DOCROOT . $objj->$value;
                                                if (is_file($DelFilePath)) {
                                                    unlink($DelFilePath);
                                                }
                                            }
                                        }
                                        $Experiance['attachment_file'] = $directory . $File;
                                    } else {
                                        //array_push($upload_images_error, Lang::__('attachment_file'));
                                    }
                                }
                                //To check if any of field exist
                                $all_empty = TRUE;
                                foreach ($Experiance as $key => $value) {
                                    if (!empty($value)) {
                                        $all_empty = FALSE;
                                        break;
                                    }
                                }
                                //End check if any of field exist
                                if ($all_empty == FALSE) {
                                    $id_this = isset($Experiance['id']) ? $Experiance['id'] : NULL;
                                    $Ex = ORM::factory('Hr_Employment_Applications_Experiances', $id_this);
                                    $Ex->values($Experiance);
                                    if (!$Ex->loaded()) {
                                        $Ex->application_id = $objj->id;
                                    }
                                    $Ex->save();
                                }
                            }
                        }
                        //End dealing with with Experiances

                        $results['Success'] = array(
                            'theme' => 'lime', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
                            'horizontalEdge' => 'top', //top,bottom
                            'verticalEdge' => 'right', //right,left
                            'heading' => '',
                            'life' => '2000', //1000 is 1 second
                            'text' => Lang::__('Saved_successfully'),
                        );
                    }
                } catch (ORM_Validation_Exception $e) {
                    $errors = $e->errors('');
                    $results['Errors'] = array(
                        'title' => Lang::__('Error'),
                        'content' => General::ArrayToString(General::CatchErrorMSGSAjax($errors))
                    );
                }
            } else {
                $results['Errors'] = array(
                    'title' => Lang::__('Errors'),
                    'content' => Lang::__('The following images or files could not be uploaded') . '</br>' . General::ArrayToString($upload_images_error)
                );
            }
        }



        echo json_encode($results);
    }

    protected function _save_image($image, $width = NULL, $height = NULL, $directory, $directory_thumbs, $extensions, $max_file_size) {
        if (!Upload::valid($image) OR ! Upload::not_empty($image) OR ! Upload::type($image, $extensions) OR ! Upload::size($image, $max_file_size)) {
            return FALSE;
        }

        if (!empty($directory)) {
            $directory_D = DOCROOT . str_replace("\\", "/", $directory);
            if (!file_exists($directory_D)) {
                mkdir($directory_D, 0777, true);
            }
        }

        if (!empty($directory_thumbs)) {
            $directory_thumbs_D = DOCROOT . str_replace("\\", "/", $directory_thumbs);
            if (!file_exists($directory_thumbs_D)) {
                mkdir($directory_thumbs_D, 0777, true);
            }
        }

        $ext = pathinfo($image['name'], PATHINFO_EXTENSION);
        $filename = mb_strtolower(Text::random('alnum', rand(10, 30))) . '.' . $ext;

        if (in_array(mb_strtolower($ext), array("gif", "jpeg", "jpg", "png", "bmp"))) {
            if ($file = Upload::save($image, NULL, $directory)) {
                $img = Image::factory($file);
                $img->save($directory . $filename, 100);
                if (!empty($directory_thumbs)) {
                    $img->resize($width, $height, Image::INVERSE);
                    $img->save($directory_thumbs . $filename, 100);
                }
                // Delete the temporary file
                unlink($file);

                return $filename;
            }
        } else {
            if ($file = Upload::save($image, $filename, $directory)) {

                return $filename;
            }
        }
    }

    public function action_DeleteDetails() {
        $results = array();

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());

        $id = isset($Filtered_array['id']) ? $Filtered_array['id'] : NULL;
        $par2 = isset($Filtered_array['par2']) ? $Filtered_array['par2'] : NULL;

        if (in_array($par2, array('Qualifications', 'Certificates', 'Experiances'))) {
            $Obj = ORM::factory('Hr_Employment_Applications_' . $par2, $id);
            if ($Obj->loaded()) {
                if ($this->Delete) {
                    $Obj->is_deleted = 1;
                    $Obj->deleted_by = $this->user_online->id;
                    $Obj->deleted_date = date("Y-m-d H:i:s");
                    if ($Obj->save()) {
                        $results['Success'] = array(
                            'title' => Lang::__('Done'),
                            'content' => Lang::__('Deletion has been successfully'),
                        );
                    }
                } else {
                    $results['Errors'] = array(
                        'title' => Lang::__('Error'),
                        'content' => Lang::__('You_dont_have_permission_to_do_this_action'),
                    );
                }
            } else {

                $results['Errors'] = array(
                    'title' => Lang::__('Error'),
                    'content' => Lang::__('Not_found_the_desired_item'),
                );
            }
        } else {

            $results['Errors'] = array(
                'title' => Lang::__('Error'),
                'content' => Lang::__('Not_found_the_desired_item'),
            );
        }

        $Obj = ORM::factory('Hr_Employment_Applications_' . $par2, $id);


        echo json_encode($results);
    }

    /*
     * Send Json of rules to jquery validation
     */

    public function action_GetRules() {
        $results = array();

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());

        $par1 = empty($Filtered_array['par1']) ? NULL : $Filtered_array['par1'];
        $par2 = empty($Filtered_array['par2']) ? NULL : $Filtered_array['par2'];

        $ORM = ORM::factory('Hr_Employment_Applications', $par1);

        $results['Rules'] = $ORM->AdminRules($ORM);



        echo json_encode($results);
    }

    /*
     * Modal for add new relation between employee and allowance
     */

    public function action_Add_Allowance() {
        if ($this->Add_Allowances_To_Employee) {
            $req = Request::current(); //fillter requset
            $Filtered_array = Search::action_Filtered_array($req->post());

            $par1 = empty($Filtered_array['par1']) ? NULL : $Filtered_array['par1']; //Hr_Employment_Applications
            $Obj = ORM::factory('Hr_Employment_Applications', $par1);

            if ($Obj->loaded() && ($Obj->app_status == 1) && (empty($Obj->is_deleted))) {
                $view = View::factory('system/hr/employment/administration/allowances_add_modal');
                $view->set('Obj', $Obj);
                $PExists = array(0);
                $P = ORM::factory('Hr_Allowances_Relations')
                        ->where('employee', '=', $Obj->id)
                        ->where('is_deleted', '=', NULL)
                        ->find_all();
                foreach ($P as $value) {
                    array_push($PExists, $value->Allowances_Type->id);
                }
                $view->set('Hr_Allowances_Types', ORM::factory('Hr_Allowances_Types')->where('id', 'NOT IN', $PExists)->where('is_deleted', '=', NULL)->find_all());
                $view->set('title', Lang::__('add_new_Allowance') . ' ' . $Obj->{"name_first_" . $this->lang} . ' ' . $Obj->{"name_last_" . $this->lang});
                $view->set('lang', $this->lang);
                $this->response->body($view);
            } else {
                $view = View::factory('system/error_modal');
                $view->set('MSG', Lang::__('Not_found_the_desired_item'));
                $this->response->body($view);
            }
        } else {
            $view = View::factory('system/error_modal');
            $view->set('MSG', Lang::__('You_dont_have_permission_to_do_this_action'));
            $this->response->body($view);
        }
    }

    public function action_Allowance_EmployeeToDB() {
        if ($this->Add_Allowances_To_Employee) {
            $results = array();

            $req = Request::current(); //fillter requset
            $Filtered_array = Search::action_Filtered_array($req->post());

            $par1 = empty($Filtered_array['par1']) ? NULL : $Filtered_array['par1'];

            $Hr_Employment_Applications = ORM::factory('Hr_Employment_Applications', $par1);
            if ($Hr_Employment_Applications->loaded() && empty($Hr_Employment_Applications->is_deleted)) {

                $Obj = ORM::factory('Hr_Allowances_Relations');
                $Obj->type = !empty($Filtered_array['allowance_type']) ? $Filtered_array['allowance_type'] : NULL;
                $Obj->employee = $Hr_Employment_Applications->id;
                $Obj->Created_by = $this->user_online->id;
                $Obj->Created_date = date("Y-m-d H:i:s");

                try {
                    if ($Obj->save()) {
                        $results['Success'] = array(
                            'title' => Lang::__('Done'),
                            'content' => Lang::__('Successfully_added')
                        );
                    }
                } catch (ORM_Validation_Exception $e) {

                    $errors = $e->errors('');
                    $results['Errors'] = array(
                        'title' => Lang::__('Error'),
                        'content' => General::ArrayToString(General::CatchErrorMSGSAjax($errors))
                    );
                }
            }
        } else {
            $results['Errors'] = array(
                'title' => Lang::__('Error'),
                'content' => Lang::__('You_dont_have_permission_to_do_this_action')
            );
        }
        echo json_encode($results);
    }

    public function action_GetAllowancesData() {
        $post = $this->request->post();
        $order = $post['order']; //Get how table order from datatable
        $par1 = $post['par1'];
        $Hr_Employment_Applications = ORM::factory('Hr_Employment_Applications', $par1);
        if ($Hr_Employment_Applications->loaded() && empty($Hr_Employment_Applications->is_deleted) && ($Hr_Employment_Applications->app_status == 1)) {
            /*
             * All coulums will shown in table
             */
            $ALL_coulums = array(
                1 => "hr_allowances_relations.id",
            );

            $All_ORM = $Hr_Employment_Applications->Allowances_Types
                    ->where('hr_allowances_relations.is_deleted', '=', NULL)
                    ->order_by($ALL_coulums[$order[0]['column']], $order[0]['dir']);

            $records = array();
            $records["data"] = array();
            //Calculate total amount and percentage
            $All_ORM->reset(FALSE);
            $records["total_amount"] = 0;
            $records["total_percentage"] = 0;
            foreach ($All_ORM->find_all() as $value) {
                $records["total_amount"] += $value->amount;
                $records["total_percentage"] += $value->percentage;
            }
            $All_ORM->reset(FALSE);
            //End Calculate total amount and percentage


            $Succesful_msg = Lang::__('Action_successfully_has_been_completed_Well_done');
            $C_Acti_status = "OK";

            /*
             * If Action exists
             */
            if (isset($post['customActionName'])) {
                switch ($post['customActionName']) {
                    case 'Delete':


                        break;


                    default:
                        break;
                }
            }


            /*
             * if search exists
             */
            if (isset($post['action']) && (!is_array($post['action'])) && mb_strtolower($post['action']) == 'filter') {
                
            }

            /*
             * Paging
             */

            $All_ORM->reset(FALSE);
            $iTotalRecords = $All_ORM->count_all();

            $iDisplayLength = intval($post['length']);
            $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
            $iDisplayStart = intval($post['start']);
            $sEcho = intval($post['draw']);



            $end = $iDisplayStart + $iDisplayLength;
            $end = $end > $iTotalRecords ? $iTotalRecords : $end;

            $All_ORM->offset($iDisplayStart);
            $All_ORM->limit($iDisplayLength);



            /*
             * Prepare JSON Array
             */

            foreach ($All_ORM->find_all() as $value) {
                $buttons = '';
                ($this->Delete_Allowances_From_Employee) ? $buttons .= '<a par1="' . $value->id . '" par2="' . $Hr_Employment_Applications->id . '" Dtitle="' . Lang::__('Alert') . '" Dcontent="' . Lang::__('Are_you_sure_you_want_to_delete_it') . '" confirmButton="' . Lang::__('Yes') . '" cancelButton="' . Lang::__('Cancel') . '" class="btn btn-xs red DeleteAllowance"> ' . Lang::__('Delete') . '</a>' : NULL;

                $records["data"][] = array(
                    $value->{"name_" . $this->lang},
                    $value->amount,
                    !empty($value->percentage) ? $value->percentage . "%" : NULL,
                    $buttons,
                );
            }
            if (isset($post["customActionType"]) && $post["customActionType"] == "group_action") {
                $records["customActionStatus"] = $C_Acti_status; // pass custom message(useful for getting status of group actions)
                $records["customActionMessage"] = $Succesful_msg; // pass custom message(useful for getting status of group actions)
            }

            $records["draw"] = $sEcho;
            $records["recordsTotal"] = $iTotalRecords;
            $records["recordsFiltered"] = $iTotalRecords;



            echo json_encode($records);
        }
    }

    public function action_DeleteAllowance() {
        $results = array();

        if ($this->Delete_Allowances_From_Employee) {
            $req = Request::current(); //fillter requset
            $Filtered_array = Search::action_Filtered_array($req->post());

            $type = !empty($Filtered_array['id']) ? $Filtered_array['id'] : NULL;
            $employee = !empty($Filtered_array['par2']) ? $Filtered_array['par2'] : NULL;

            $Obj = ORM::factory('Hr_Allowances_Relations')
                    ->where('type', '=', $type)
                    ->where('employee', '=', $employee)
                    ->where('is_deleted', '=', NULL)
                    ->find();

            if (!empty($type) && !empty($employee)) {
                try {
                    $Obj->is_deleted = 1;
                    $Obj->deleted_by = $this->user_online->id;
                    $Obj->deleted_date = date("Y-m-d H:i:s");
                    if ($Obj->save()) {
                        $results['Success'] = array(
                            'title' => Lang::__('Done'),
                            'content' => Lang::__('Deletion has been successfully'),
                        );
                    }
                } catch (ORM_Validation_Exception $e) {

                    $errors = $e->errors('');
                    $results['Errors'] = array(
                        'title' => Lang::__('Error'),
                        'content' => General::CatchErrorMSGSAjax($errors),
                    );
                }
            } else {

                $results['Errors'] = array(
                    'title' => Lang::__('Error'),
                    'content' => Lang::__('Not_found_the_desired_item'),
                );
            }
        } else {
            $results['Errors'] = array(
                'title' => Lang::__('Error'),
                'content' => Lang::__('You_dont_have_permission_to_do_this_action'),
            );
        }

        echo json_encode($results);
    }

    public function action_Add_Deduction() {
        if ($this->Add_Deductions_To_Employee) {
            $req = Request::current(); //fillter requset
            $Filtered_array = Search::action_Filtered_array($req->post());

            $par1 = empty($Filtered_array['par1']) ? NULL : $Filtered_array['par1']; //Hr_Employment_Applications
            $Obj = ORM::factory('Hr_Employment_Applications', $par1);

            if ($Obj->loaded() && ($Obj->app_status == 1) && (empty($Obj->is_deleted))) {
                $view = View::factory('system/hr/employment/administration/deductions_add_modal');
                $view->set('Obj', $Obj);
                $PExists = array(0);
                $P = ORM::factory('Hr_Deductions_Relations')
                        ->where('employee', '=', $Obj->id)
                        ->where('is_deleted', '=', NULL)
                        ->find_all();
                foreach ($P as $value) {
                    array_push($PExists, $value->Deductions_Type->id);
                }
                $view->set('Hr_Deductions_Types', ORM::factory('Hr_Deductions_Types')->where('id', 'NOT IN', $PExists)->where('is_deleted', '=', NULL)->find_all());
                $view->set('title', Lang::__('add_new_Deduction') . ' ' . $Obj->{"name_first_" . $this->lang} . ' ' . $Obj->{"name_last_" . $this->lang});
                $view->set('lang', $this->lang);
                $this->response->body($view);
            } else {
                $view = View::factory('system/error_modal');
                $view->set('MSG', Lang::__('Not_found_the_desired_item'));
                $this->response->body($view);
            }
        } else {
            $view = View::factory('system/error_modal');
            $view->set('MSG', Lang::__('You_dont_have_permission_to_do_this_action'));
            $this->response->body($view);
        }
    }

    public function action_Deduction_EmployeeToDB() {
        if ($this->Add_Deductions_To_Employee) {
            $results = array();

            $req = Request::current(); //fillter requset
            $Filtered_array = Search::action_Filtered_array($req->post());

            $par1 = empty($Filtered_array['par1']) ? NULL : $Filtered_array['par1'];

            $Hr_Employment_Applications = ORM::factory('Hr_Employment_Applications', $par1);
            if ($Hr_Employment_Applications->loaded() && empty($Hr_Employment_Applications->is_deleted)) {

                $Obj = ORM::factory('Hr_Deductions_Relations');
                $Obj->type = !empty($Filtered_array['deduction_type']) ? $Filtered_array['deduction_type'] : NULL;
                $Obj->employee = $Hr_Employment_Applications->id;
                $Obj->Created_by = $this->user_online->id;
                $Obj->Created_date = date("Y-m-d H:i:s");

                try {
                    if ($Obj->save()) {
                        $results['Success'] = array(
                            'title' => Lang::__('Done'),
                            'content' => Lang::__('Successfully_added')
                        );
                    }
                } catch (ORM_Validation_Exception $e) {

                    $errors = $e->errors('');
                    $results['Errors'] = array(
                        'title' => Lang::__('Error'),
                        'content' => General::ArrayToString(General::CatchErrorMSGSAjax($errors))
                    );
                }
            }
        } else {
            $results['Errors'] = array(
                'title' => Lang::__('Error'),
                'content' => Lang::__('You_dont_have_permission_to_do_this_action')
            );
        }
        echo json_encode($results);
    }

    public function action_GetDeductionsData() {
        $post = $this->request->post();
        $order = $post['order']; //Get how table order from datatable
        $par1 = $post['par1'];
        $Hr_Employment_Applications = ORM::factory('Hr_Employment_Applications', $par1);
        if ($Hr_Employment_Applications->loaded() && empty($Hr_Employment_Applications->is_deleted) && ($Hr_Employment_Applications->app_status == 1)) {
            /*
             * All coulums will shown in table
             */
            $ALL_coulums = array(
                1 => "hr_deductions_relations.id",
            );

            $All_ORM = $Hr_Employment_Applications->Deductions_Types
                    ->where('hr_deductions_relations.is_deleted', '=', NULL)
                    ->order_by($ALL_coulums[$order[0]['column']], $order[0]['dir']);

            $records = array();
            $records["data"] = array();
            //Calculate total amount and percentage
            $All_ORM->reset(FALSE);
            $records["total_amount"] = 0;
            $records["total_percentage"] = 0;
            foreach ($All_ORM->find_all() as $value) {
                $records["total_amount"] += $value->amount;
                $records["total_percentage"] += $value->percentage;
            }
            $All_ORM->reset(FALSE);
            //End Calculate total amount and percentage


            $Succesful_msg = Lang::__('Action_successfully_has_been_completed_Well_done');
            $C_Acti_status = "OK";

            /*
             * If Action exists
             */
            if (isset($post['customActionName'])) {
                switch ($post['customActionName']) {
                    case 'Delete':


                        break;


                    default:
                        break;
                }
            }


            /*
             * if search exists
             */
            if (isset($post['action']) && (!is_array($post['action'])) && mb_strtolower($post['action']) == 'filter') {
                
            }

            /*
             * Paging
             */

            $All_ORM->reset(FALSE);
            $iTotalRecords = $All_ORM->count_all();

            $iDisplayLength = intval($post['length']);
            $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
            $iDisplayStart = intval($post['start']);
            $sEcho = intval($post['draw']);



            $end = $iDisplayStart + $iDisplayLength;
            $end = $end > $iTotalRecords ? $iTotalRecords : $end;

            $All_ORM->offset($iDisplayStart);
            $All_ORM->limit($iDisplayLength);



            /*
             * Prepare JSON Array
             */

            foreach ($All_ORM->find_all() as $value) {
                $buttons = '';
                ($this->Delete_Deductions_From_Employee) ? $buttons .= '<a par1="' . $value->id . '" par2="' . $Hr_Employment_Applications->id . '" Dtitle="' . Lang::__('Alert') . '" Dcontent="' . Lang::__('Are_you_sure_you_want_to_delete_it') . '" confirmButton="' . Lang::__('Yes') . '" cancelButton="' . Lang::__('Cancel') . '" class="btn btn-xs red DeleteDeduction"> ' . Lang::__('Delete') . '</a>' : NULL;

                $records["data"][] = array(
                    $value->{"name_" . $this->lang},
                    $value->amount,
                    !empty($value->percentage) ? $value->percentage . "%" : NULL,
                    $buttons,
                );
            }
            if (isset($post["customActionType"]) && $post["customActionType"] == "group_action") {
                $records["customActionStatus"] = $C_Acti_status; // pass custom message(useful for getting status of group actions)
                $records["customActionMessage"] = $Succesful_msg; // pass custom message(useful for getting status of group actions)
            }

            $records["draw"] = $sEcho;
            $records["recordsTotal"] = $iTotalRecords;
            $records["recordsFiltered"] = $iTotalRecords;



            echo json_encode($records);
        }
    }

    public function action_DeleteDeduction() {
        $results = array();

        if ($this->Delete_Deductions_From_Employee) {
            $req = Request::current(); //fillter requset
            $Filtered_array = Search::action_Filtered_array($req->post());

            $type = !empty($Filtered_array['id']) ? $Filtered_array['id'] : NULL;
            $employee = !empty($Filtered_array['par2']) ? $Filtered_array['par2'] : NULL;

            $Obj = ORM::factory('Hr_Deductions_Relations')
                    ->where('type', '=', $type)
                    ->where('employee', '=', $employee)
                    ->where('is_deleted', '=', NULL)
                    ->find();

            if (!empty($type) && !empty($employee)) {
                try {
                    $Obj->is_deleted = 1;
                    $Obj->deleted_by = $this->user_online->id;
                    $Obj->deleted_date = date("Y-m-d H:i:s");
                    if ($Obj->save()) {
                        $results['Success'] = array(
                            'title' => Lang::__('Done'),
                            'content' => Lang::__('Deletion has been successfully'),
                        );
                    }
                } catch (ORM_Validation_Exception $e) {

                    $errors = $e->errors('');
                    $results['Errors'] = array(
                        'title' => Lang::__('Error'),
                        'content' => General::CatchErrorMSGSAjax($errors),
                    );
                }
            } else {

                $results['Errors'] = array(
                    'title' => Lang::__('Error'),
                    'content' => Lang::__('Not_found_the_desired_item'),
                );
            }
        } else {
            $results['Errors'] = array(
                'title' => Lang::__('Error'),
                'content' => Lang::__('You_dont_have_permission_to_do_this_action'),
            );
        }

        echo json_encode($results);
    }

}
