<?php

defined('SYSPATH') or die('No direct script access.');

class Controller_Hr_Deductions_Advancepayment extends Controller_Template_Base {

    public $Add = FALSE;
    public $Browse = FALSE;
    public $Edit = FALSE;
    public $Delete = FALSE;

    public function __construct(Request $request, Response $response) {
        // You must call parent::__construct at some point in your function
        parent::__construct($request, $response);
        // Do whatever else you want

        $this->Add = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'A_Advancepayment')));
        $this->Browse = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'B_Advancepayment')));
        $this->Edit = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'E_Advancepayment')));
        $this->Delete = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'D_Advancepayment')));
    }

    public function action_index() {
        if ($this->Add || $this->Browse || $this->Edit || $this->Delete) {
            $title = Lang::__('Advance_payment');
            $this->template->title = $title;
            $this->template->layout = new View('system/hr/deductions/advancepayment/view_all');
            $this->template->layout->title = $title;
            $this->template->layout->Add = $this->Add;
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }

    public function action_AE() {

        $par1 = $this->request->param('par1');
        $par2 = $this->request->param('par2');

        $process_type = 'add_new';
        $Obj = ORM::factory('Hr_Deductions_Advancepayment', $par1);

        if ($Obj->loaded()) {
            $process_type = 'Browse';
        }

        if ((($this->Add && $process_type == 'add_new') || ($this->Edit && $process_type == 'Browse')) && ($Obj->is_deleted == 0)) {
            $this->template->layout = new View('system/hr/deductions/advancepayment/AE');
            //$this->template->layout->Hr_Leavetypes = ORM::factory('General_Hr_Leavetypes')->where('is_active', '=', 1)->where('is_deleted', '=', NULL)->find_all();

            if ($Obj->loaded()) {
                $this->template->layout->Obj = $Obj;
            }
            $this->template->layout->title = Lang::__($process_type);
            $this->template->title = Lang::__($process_type);
            $this->template->layout->lang = $this->lang;
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }

    public function action_Delete() {
        $results = array();

        if ($this->Delete) {
            $req = Request::current(); //fillter requset
            $Filtered_array = Search::action_Filtered_array($req->post());

            $Obj = ORM::factory('Hr_Deductions_Advancepayment', $Filtered_array['id']);
            $CheckDeleteRules = $Obj->CheckDeleteRules();
            if ($CheckDeleteRules === TRUE) {
                try {
                    if ($this->canDelete($Obj)) {
                        $Obj->is_deleted = 1;
                        $Obj->deleted_by = $this->user_online->id;
                        $Obj->deleted_date = date("Y-m-d H:i:s");
                        if ($Obj->save()) {
                            $Obj2 = ORM::factory('Hr_Deductions_Advancepaymentrecords')->where('advace_payment_id', '=', $Filtered_array['id'])->find_all();
                            foreach ($Obj2 as $f) {
                                $f->is_deleted = 1;
                                $f->deleted_by = $this->user_online->id;
                                $f->deleted_date = date("Y-m-d H:i:s");
                                $f->save();
                            }
                            $results['Success'] = array(
                                'title' => Lang::__('Done'),
                                'content' => Lang::__('Deletion has been successfully'),
                            );
                        }
                    } else {
                        $results['Errors'] = array(
                            'title' => Lang::__('Error'),
                            'content' => Lang::__('error_advance_payment_date'),
                        );
                    }
                } catch (ORM_Validation_Exception $e) {

                    $errors = $e->errors('');
                    $results['Errors'] = array(
                        'title' => Lang::__('Error'),
                        'content' => General::CatchErrorMSGSAjax($errors),
                    );
                }
            } else {
                if (is_array($CheckDeleteRules)) {

                    $results['Errors'] = array(
                        'title' => Lang::__('Error'),
                        'content' => General::ArrayToString($CheckDeleteRules),
                    );
                }
            }
        } else {
            $results['Errors'] = array(
                'title' => Lang::__('Error'),
                'content' => Lang::__('You_dont_have_permission_to_do_this_action'),
            );
        }

        echo json_encode($results);
    }

    public function canDelete($obj) {
        $month = date('m');
        $year = date('Y');

        if ($obj->month <= $month && $obj->year <= $year) {
            return false;
        } else {
            return true;
        }
    }

    public function action_ToDB() {
        $results = array();

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());
        $par1 = empty($Filtered_array['par1']) ? NULL : $Filtered_array['par1'];
        $par2 = empty($Filtered_array['par2']) ? NULL : $Filtered_array['par2'];

        $objj = ORM::factory('Hr_Deductions_Advancepayment', $par1);
        if (!$objj->loaded()) {
            $objj->Created_by = $this->user_online->id;
            $objj->Created_date = date("Y-m-d H:i:s");
        } else {
            $objj->last_update_by = $this->user_online->id;
            $objj->last_update_date = date("Y-m-d H:i:s");
        }

        $objj->employee_ID = $Filtered_array['employee_ID'];
        $objj->amount = $Filtered_array['amount'];
        $objj->month = $Filtered_array['month'];
        $objj->year = $Filtered_array['year'];
        $objj->number_month = $Filtered_array['number_month'];



        try {
            if ($objj->save()) {
                $M = $Filtered_array['month'];
                $Y = $Filtered_array['year'];
                for ($i = 1; $i <= $Filtered_array['number_month']; $i++) {
                    $objj2 = ORM::factory('Hr_Deductions_Advancepaymentrecords');
                    $objj2->advace_payment_id = $objj->id;
                    $objj2->employee_ID = $Filtered_array['employee_ID'];
                    $objj2->amount = $Filtered_array['amount'] / $Filtered_array['number_month'];
                    $objj2->month = $M;
                    $objj2->year = $Y;
                    $M++;
                    if ($M > 12) {
                        $M = 1;
                        $Y++;
                    }
                    $objj2->save();
                }


                $results['Success'] = array(
                    'theme' => 'lime', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
                    'horizontalEdge' => 'top', //top,bottom
                    'verticalEdge' => 'right', //right,left
                    'heading' => '',
                    'life' => '2000', //1000 is 1 second
                    'text' => Lang::__('Saved_successfully'),
                );
            }
        } catch (ORM_Validation_Exception $e) {

            $errors = $e->errors('');
            $results['Errors'] = General::CatchErrorMSGSAjax($errors);
        }
        echo json_encode($results);
    }

    public function action_GetData() {
        $post = $this->request->post();
        $order = $post['order']; //Get how table order from datatable
        /*
         * All coulums will shown in table
         */
        $ALL_coulums = array(
            1 => "id",
        );

        $All_ORM = ORM::factory('Hr_Deductions_Advancepayment')
                ->where('is_deleted', '=', 0)
                ->order_by($ALL_coulums[$order[0]['column']], $order[0]['dir']);


        $Succesful_msg = Lang::__('Action_successfully_has_been_completed_Well_done');
        $C_Acti_status = "OK";

        /*
         * If Action exists
         */
        if (isset($post['customActionName'])) {
            switch ($post['customActionName']) {
                case 'Delete':


                    break;


                default:
                    break;
            }
        }


        /*
         * if search exists
         */
        if (isset($post['action']) && (!is_array($post['action'])) && mb_strtolower($post['action']) == 'filter') {
            if (!empty($post['name'])) {

                $userID = ORM::factory('Hr_Employment_Applications');
                $Name = $post['name'];
                $userID->or_where_open();
                $userID->or_where(DB::expr('lower(name_first_ar)'), 'LIKE', mb_strtolower("%$Name%"));
                $userID->or_where(DB::expr('lower(name_father_ar)'), 'LIKE', mb_strtolower("%$Name%"));
                $userID->or_where(DB::expr('lower(name_grandfather_ar)'), 'LIKE', mb_strtolower("%$Name%"));
                $userID->or_where(DB::expr('lower(name_last_ar)'), 'LIKE', mb_strtolower("%$Name%"));
                $userID->or_where(DB::expr('lower(name_first_en)'), 'LIKE', mb_strtolower("%$Name%"));
                $userID->or_where(DB::expr('lower(name_father_en)'), 'LIKE', mb_strtolower("%$Name%"));
                $userID->or_where(DB::expr('lower(name_grandfather_en)'), 'LIKE', mb_strtolower("%$Name%"));
                $userID->or_where(DB::expr('lower(name_last_en)'), 'LIKE', mb_strtolower("%$Name%"));
                $userID->or_where_close();
                $userID->find_all();

                foreach ($userID as $vals) {
                    $All_ORM->or_where("employee_ID", '=', $vals->id);
                }
            }
            if (!empty($post['amount_from'])) {
                $All_ORM->where("amount", '>=', $post['amount_from']);
            }
            if (!empty($post['amount_to'])) {
                $All_ORM->where("amount", '<=', $post['amount_to']);
            }
        }

        /*
         * Paging
         */
        $All_ORM->reset(FALSE);
        $iTotalRecords = $All_ORM->count_all();

        $iDisplayLength = intval($post['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($post['start']);
        $sEcho = intval($post['draw']);

        $records = array();
        $records["data"] = array();

        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;


        $All_ORM->offset($iDisplayStart);
        $All_ORM->limit($iDisplayLength);



        /*
         * Prepare JSON Array
         */
        foreach ($All_ORM->find_all() as $value) {
            $buttons = '';
            ($this->Browse) ? $buttons .= '<a href="' . URL::base() . 'Hr_Deductions_Advancepayment/AE/' . $value->id . '" class="btn btn-xs default"><i class="fa fa-edit"></i> ' . Lang::__('Browse') . '</a>' : NULL;
            ($this->Delete && ($value->CheckDeleteRules() === TRUE)) ? $buttons .= '<a par1="' . $value->id . '" Dtitle="' . Lang::__('Alert') . '" Dcontent="' . Lang::__('Are_you_sure_you_want_to_delete_it') . '" confirmButton="' . Lang::__('Yes') . '" cancelButton="' . Lang::__('Cancel') . '" class="btn btn-xs red Delete"> ' . Lang::__('Delete') . '</a>' : NULL;
            $employees = ORM::factory('Hr_Employment_Applications', $value->employee_ID);
            $employees->loaded();
            $records["data"][] = array(
                '<input type="checkbox" name="id[]" value="' . $value->id . '">',
                $employees->{'name_first_' . $this->lang} . ' ' . $employees->{'name_father_' . $this->lang} . ' ' . $employees->{'name_grandfather_' . $this->lang} . ' ' . $employees->{'name_last_' . $this->lang},
                $value->amount,
                $value->year . '/' . $value->month,
                $buttons,
            );
        }
        if (isset($post["customActionType"]) && $post["customActionType"] == "group_action") {
            $records["customActionStatus"] = $C_Acti_status; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = $Succesful_msg; // pass custom message(useful for getting status of group actions)
        }

        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;

        echo json_encode($records);
    }

    /*
     * Send Json of rules to jquery validation
     */

    public function action_GetRules() {
        $results = array();

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());

        $par1 = empty($Filtered_array['par1']) ? NULL : $Filtered_array['par1'];

        $ORM = ORM::factory('Hr_Deductions_Advancepayment', $par1);

        $results['Rules'] = $ORM->AdminRules($ORM);



        echo json_encode($results);
    }

}
