<?php

defined('SYSPATH') or die('No direct script access.');

class Controller_General_Generally extends Controller_Template_Base {

    public $Add = FALSE;
    public $Browse = FALSE;
    public $Edit = FALSE;
    public $Delete = FALSE;

    public function action_index() {
        $par1 = $this->request->param('par1');
        $par2 = $this->request->param('par2'); //parent_id
        $General_Generally = ORM::factory('General_Generally')->where('model_name', '=', $par1)->find();
        if ($General_Generally->loaded()) {

            $this->Add = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => $General_Generally->add_rule)));
            $this->Browse = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => $General_Generally->browse_rule)));
            $this->Edit = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => $General_Generally->edit_rule)));
            $this->Delete = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => $General_Generally->delete_rule)));





            if ($this->Add || $this->Browse || $this->Edit || $this->Delete) {
                $title = Lang::__($General_Generally->model_name);
                $this->template->title = $title;
                $this->template->layout = new View('system/general/generally/view_all');
                if (!empty($General_Generally->parent) && !empty($par2)) {
                    $ParentGeneral_Generally = ORM::factory("General_Generally", $General_Generally->parent);
                    if ($ParentGeneral_Generally->loaded()) {
                        $ParentOrm = ORM::factory("General_" . $ParentGeneral_Generally->model_name, $par2);
                        $parents = array();
                        if ($ParentOrm->loaded()) {
                            $this->template->layout->ParentOrm = $ParentOrm;
                            while (TRUE) {
                                if ($ParentOrm->loaded()) {
                                    $A = array(
                                        'name' => $ParentOrm->{'name_' . $this->lang},
                                        'link' => "General_Generally/index/" . $ParentGeneral_Generally->model_name . "/" . $ParentOrm->id,
                                    );
                                    array_push($parents, $A);
                                    if(isset($ParentOrm->Parent)){
                                    $ParentOrm = $ParentOrm->Parent;
                                    }else{
                                    break;    
                                    }
                                } else {
                                    break;
                                }
                            }
                            $reversed = array_reverse($parents);
                            $this->template->layout->Parents_Array = $reversed;
                        }
                    }
                }
                $this->template->layout->title = $title;
                $this->template->layout->General_Generally = $General_Generally;
                $this->template->layout->Add = $this->Add;
                $this->template->layout->lang = $this->lang;
            } else {
                $this->template->layout = new View('system/show_msg');
                $this->template->layout->class_color = 'danger';
                $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
            }
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You tracked wrong or expired link');
        }
    }

    public function action_AE() {
        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());
        $par1 = empty($Filtered_array['par1']) ? NULL : $Filtered_array['par1'];
        $par2 = empty($Filtered_array['par2']) ? NULL : $Filtered_array['par2'];
        $par3 = empty($Filtered_array['par3']) ? NULL : $Filtered_array['par3'];
        $General_Generally = ORM::factory('General_Generally')->where('model_name', '=', $par2)->find();
        if ($General_Generally->loaded()) {
            $this->Add = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => $General_Generally->add_rule)));
            $this->Browse = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => $General_Generally->browse_rule)));
            $this->Edit = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => $General_Generally->edit_rule)));
            $this->Delete = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => $General_Generally->delete_rule)));

            $view = View::factory('system/general/generally/AE');


            if ($General_Generally->loaded()) {
                $process_type = 'add_new';
                $Obj = ORM::factory('General_' . $General_Generally->model_name, $par1);

                if ($Obj->loaded()) {
                    $view->set('Obj', $Obj);
                    $process_type = 'modify';
                } else {
                    
                }
                $view->set('General_Generally', $General_Generally);
                $view->set('Fields', $General_Generally->Fields->where('is_deleted', '=', NULL)->find_all());

                $view->set('Add', $this->Add);
                $view->set('par3', $par3);

                $view->set('title', Lang::__($process_type));
                $view->set('lang', $this->lang);
            }


            if ($this->Add || $this->Edit) {
                $this->response->body($view);
            } else {
                $view = View::factory('system/error_modal');
                $view->set('MSG', Lang::__('You_dont_have_permission_to_access_this_page'));
                $this->response->body($view);
            }
        } else {
            $view = View::factory('system/error_modal');
            $view->set('MSG', Lang::__('You tracked wrong or expired link'));
            $this->response->body($view);
        }
    }

    public function action_Delete() {
        $results = array();

        $General_Generally = ORM::factory('General_Generally')->where('model_name', '=', $this->request->param('par1'))->find();
        if ($General_Generally->loaded()) {
            $this->Delete = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => $General_Generally->delete_rule)));

            if ($this->Delete) {
                $req = Request::current(); //fillter requset
                $Filtered_array = Search::action_Filtered_array($req->post());

                $Obj = ORM::factory('General_' . $General_Generally->model_name, $Filtered_array['id']);

                $CheckDeleteRules = $Obj->CheckDeleteRules();
                if ($CheckDeleteRules === TRUE) {
                    try {
                        $Obj->is_deleted = 1;
                        $Obj->deleted_by = $this->user_online->id;
                        $Obj->deleted_date = date("Y-m-d H:i:s");
                        if ($Obj->save()) {
                            $results['Success'] = array(
                                'title' => Lang::__('Done'),
                                'content' => Lang::__('Deletion has been successfully'),
                            );
                        }
                    } catch (ORM_Validation_Exception $e) {

                        $errors = $e->errors('');
                        $results['Errors'] = array(
                            'title' => Lang::__('Error'),
                            'content' => General::CatchErrorMSGSAjax($errors),
                        );
                    }
                } else {
                    if (is_array($CheckDeleteRules)) {

                        $results['Errors'] = array(
                            'title' => Lang::__('Error'),
                            'content' => General::ArrayToString($CheckDeleteRules),
                        );
                    }
                }
            } else {
                $results['Errors'] = array(
                    'title' => Lang::__('Error'),
                    'content' => Lang::__('You_dont_have_permission_to_do_this_action'),
                );
            }
        } else {
            $results['Errors'] = array(
                'title' => Lang::__('Error'),
                'content' => Lang::__('You tracked wrong or expired link'),
            );
        }
        echo json_encode($results);
    }

    public function action_ToDB() {
        $results = array();

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());
        $par1 = empty($Filtered_array['par1']) ? NULL : $Filtered_array['par1'];
        $par2 = empty($Filtered_array['par2']) ? NULL : $Filtered_array['par2'];
        $par3 = empty($Filtered_array['par3']) ? NULL : $Filtered_array['par3'];

        $General_Generally = ORM::factory('General_Generally')->where('model_name', '=', $par2)->find();
        if ($General_Generally->loaded()) {
            $objj = ORM::factory('General_' . $par2, $par1);
            if (!$objj->loaded()) {
                $objj->Created_by = $this->user_online->id;
                $objj->Created_date = date("Y-m-d H:i:s");
                if (!empty($General_Generally->parent) && !empty($par3)) {
                    $parent_col_name = $General_Generally->parent_col_name;
                    $objj->$parent_col_name = $par3;
                }
            } else {
                $objj->last_update_by = $this->user_online->id;
                $objj->last_update_date = date("Y-m-d H:i:s");
            }

            $objj->values($Filtered_array);

            try {
                if ($objj->save()) {

                    $results['Success'] = array(
                        'theme' => 'lime', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
                        'horizontalEdge' => 'top', //top,bottom
                        'verticalEdge' => 'right', //right,left
                        'heading' => '',
                        'life' => '2000', //1000 is 1 second
                        'text' => Lang::__('Saved_successfully'),
                    );
                }
            } catch (ORM_Validation_Exception $e) {
                $errors = $e->errors('');
                $results['Errors'] = General::CatchErrorMSGSAjax($errors);
            }
        }


        echo json_encode($results);
    }

    public function action_GetData() {
        $post = $this->request->post();
        $par1 = isset($post['par1']) ? $post['par1'] : NULL;
        $par2 = isset($post['par2']) ? $post['par2'] : NULL;
        $General_Generally = ORM::factory('General_Generally')->where('model_name', '=', $par1)->find();
        $this->Add = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => $General_Generally->add_rule)));
        $this->Browse = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => $General_Generally->browse_rule)));
        $this->Edit = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => $General_Generally->edit_rule)));
        $this->Delete = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => $General_Generally->delete_rule)));

        $order = $post['order']; //Get how table order from datatable
        /*
         * All coulums will shown in table
         */
        $ALL_coulums = array(
            1 => "is_active",
        );
       // print_r($General_Generally->model_name);
        $All_ORM = ORM::factory('General_' . $General_Generally->model_name)
                ->where('is_deleted', '=', NULL)
                ->order_by($ALL_coulums[$order[0]['column']], $order[0]['dir']);


        if (!empty($par2) && !empty($General_Generally->parent)) {
            $All_ORM->where($General_Generally->parent_col_name, '=', $par2);
        } else {
            //حتى ما تظهر النتائج كلها في الصفحة الأم
            if (!empty($General_Generally->parent_col_name)) {
                $All_ORM->where($General_Generally->parent_col_name, '=', NULL);
            }
        }

        $Succesful_msg = Lang::__('Action_successfully_has_been_completed_Well_done');
        $C_Acti_status = "OK";

        /*
         * If Action exists
         */
        if (isset($post['customActionName'])) {
            switch ($post['customActionName']) {
                case 'Delete':


                    break;


                default:
                    break;
            }
        }


        /*
         * if search exists
         */
        if (isset($post['action']) && (!is_array($post['action'])) && mb_strtolower($post['action']) == 'filter') {
            if (!empty($post['name'])) {

                $Name = $post['name'];
                $All_ORM->and_where_open();
                $All_ORM->or_where(DB::expr('lower(name_ar)'), 'LIKE', mb_strtolower("%$Name%"));
                $All_ORM->or_where(DB::expr('lower(name_en)'), 'LIKE', mb_strtolower("%$Name%"));
                $All_ORM->and_where_close();
            }
            if (isset($post['is_active']) && ($post['is_active'] == 1 || $post['is_active'] == 0)) {
                $All_ORM->where('is_active', '=', $post['is_active']);
            }
        }

        /*
         * Paging
         */
        $All_ORM->reset(FALSE);
        $iTotalRecords = $All_ORM->count_all();

        $iDisplayLength = intval($post['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($post['start']);
        $sEcho = intval($post['draw']);

        $records = array();
        $records["data"] = array();

        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;

        $All_ORM->offset($iDisplayStart);
        $All_ORM->limit($iDisplayLength);


        /*
         * Prepare JSON Array
         */
        foreach ($All_ORM->find_all() as $value) {
            $buttons = '';

            foreach ($General_Generally->Childs->find_all() as $Child) {

                $Add = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => $Child->add_rule)));
                $Browse = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => $Child->browse_rule)));
                $Edit = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => $Child->edit_rule)));
                $Delete = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => $Child->delete_rule)));

                if ($Add || $Browse || $Edit || $Delete) {
                    $buttons .= '<a href="' . URL::base() . 'General_Generally/index/' . $Child->model_name . '/' . $value->id . '" par2="' . $General_Generally->model_name . '" class="btn btn-xs blue" ><i class="fa fa-list"></i> ' . Lang::__($Child->model_name) . '</a>';
                }
            }

            ($this->Edit) ? $buttons .= '<a par1="' . $value->id . '" par2="' . $General_Generally->model_name . '" class="btn btn-xs default AEModal" data-toggle="modal"><i class="fa fa-edit"></i> ' . Lang::__('Edit') . '</a>' : NULL;
            ($this->Delete && ($value->CheckDeleteRules() === TRUE)) ? $buttons .= '<a par1="' . $value->id . '" Dtitle="' . Lang::__('Alert') . '" Dcontent="' . Lang::__('Are_you_sure_you_want_to_delete_it') . '" confirmButton="' . Lang::__('Yes') . '" cancelButton="' . Lang::__('Cancel') . '" class="btn btn-xs red Delete"> ' . Lang::__('Delete') . '</a>' : NULL;

            $records["data"][] = array(
                '<input type="checkbox" name="id[]" value="' . $value->id . '">',
                ($value->is_active == 0) ? Lang::__('No') : Lang::__('Yes'),
                $value->name_en,
                $value->name_ar,
                $buttons,
            );
        }
        if (isset($post["customActionType"]) && $post["customActionType"] == "group_action") {
            $records["customActionStatus"] = $C_Acti_status; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = $Succesful_msg; // pass custom message(useful for getting status of group actions)
        }

        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;

        echo json_encode($records);
    }

}

// End General_Legalforms
