<?php

defined('SYSPATH') or die('No direct script access.');

class Controller_Financials_Trans extends Controller_Template_Base {

    public $Post_states;
    public $Add = FALSE;
    public $Browse = FALSE;
    public $Edit = FALSE;
    public $Delete = FALSE;

    public function __construct(Request $request, Response $response) {
        // You must call parent::__construct at some point in your function
        parent::__construct($request, $response);

        // Do whatever else you want
        //تحتوي هذه المصفوفة جميع حالات ترحيل القيد
        $this->Post_states = array(
            '0' => Lang::__('NotPosted'), //غير مرحل
            '1' => Lang::__('Posted'), //مرحل
            '2' => Lang::__('Reversed'), //معكوس
            '3' => Lang::__('Linked'), //مرتبط بقيد معكوس
            '4' => Lang::__('Post_error'), //حدث خطأ اثناء الترحيل بعدم تسجيل الدائن والمدين في الحسابات
        );

        $this->Add = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'A_Discount_Management')));
        $this->Browse = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'B_Discount_Management')));
        $this->Edit = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'E_Discount_Management')));
        $this->Delete = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'D_Discount_Management')));
    }

    public function action_index() {

        if ($this->Add || $this->Browse || $this->Edit || $this->Delete) {
            $msg = mb_strtolower($this->request->param('par1'));
            $title = Lang::__('Accounts_Table');
            $this->template->title = $title;
            $this->template->layout = new View('system/financials/trans/view_all');
            $this->template->layout->title = $title;
            $this->template->layout->Post_states = $this->Post_states;
            $this->template->layout->Add = $this->Add;
            $this->template->layout->lang = $this->lang;
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }

    /*
     * عرض القيد
     */

    public function action_view() {

        $post = $this->request->post();
        $Trans = ORM::factory('Financials_Accounts_Trans', $post['TransID']);
        $Details = ORM::factory('Financials_Accounts_Transdetail')->where('TransNo', '=', $Trans->id)->find_all();
        $view = View::factory('system/financials/trans/viewTrans')
                ->set('Trans', $Trans)
                ->set('Details', $Details)
                ->set('Post_states', $this->Post_states)
                ->set('lang', $this->lang);
        $this->response->body($view);
    }

    /*
     * This method search in any MD-array
     */

    public function action_search($array, $field, $value) {
        foreach ($array as $key => $v) {
            if ($v[$field] === $value) {
                return $v;
            }
        }
        return false;
    }

    /*
     * ترحيل القيد
     */

    public function action_PostTrans($Trans_id = NULL) {
        $result = array();
        $u_id = $this->user_online->id;
        $post = $this->request->post();
        $Tra_id = NULL;
        if ($Trans_id != NULL) {
            $Tra_id = $Trans_id;
        } elseif (isset($post['TransID'])) {
            $Tra_id = $post['TransID'];
        }

        $ORM = ORM::factory('Financials_Accounts_Trans', $Tra_id);
        if ($ORM->loaded() && $ORM->Posted == 0) {
            $ORM->Posted = 1; //تم الترحيل
            $ORM->Post_By = $u_id;
            $ORM->PostDate = date("Y-m-d H:i:s");
            if ($ORM->save()) {
            $result['Success'] = array(
                'title' => Lang::__('Done'),
                'content' => Lang::__('Trans_successfully_has_been_Posted'),
            );
                //Reports::AddReport('Trans', 'post_trans_done', $ORM->id); //تسجيل تقرير بالعملية
            }
            $Details = ORM::factory('Financials_Accounts_Transdetail')->where('TransNo', '=', $ORM->id)->find_all();
            foreach ($Details as $value) {
                if ($value->posted == NULL) { //للتأكد بشكل قطعي ان هذا الصف لم يؤثر في الحسابات مسبقا
                    $Account = ORM::factory('Financials_Accounts', $value->AccNo);
                    $SetPosted = ORM::factory('Financials_Accounts_Transdetail', $value->id);
                    if ($Account->loaded() && (Accounts::isParent($Account->id) == FALSE)) { //ايضا للتأكد من انه ليس حساب رئيسي
                        $SetPosted->PreDebitBal = $Account->Debit;
                        $SetPosted->PreCreditBal = $Account->Credit;
                        $SetPosted->save();

                        $Account->Debit += $value->debit;
                        $Account->Credit += $value->credit;
                        if ($Account->save()) { //تم التأثير على الدائن والمدين للحساب
                            $SetPosted->posted = 1;
                            $SetPosted->save();
                        } else {
                            $ORM->Posted = 4; //حدث خطأ في عملية الترحيل
                            $ORM->save();
                        }
                    }
                }
            }
        } else {
            if ($Trans_id == NULL) {
                $result['Errors'] = Lang::__('Not_found_the_desired_item');
                
            } else {
                return False;
            }
        }
        echo json_encode($result);
    }

    /*
     * عكس القيد
     */

    public function action_ReverseTrans() {
        $results = array();
        $u_id = $this->user_online->id;

        $post = $this->request->post();
        $ORM = ORM::factory('Financials_Accounts_Trans', $post['TransID']);
        if ($ORM->loaded() && $ORM->Posted == 1) {

            if ($ORM->save()) {
                //تجهيز البيانات الجديدة وحذف ما لا نريد نقله الى الصف الجديد
                $OrginalData = $ORM->as_array();
                unset($OrginalData['id']);
                unset($OrginalData['Posted']);
                unset($OrginalData['Reversedno']);
                unset($OrginalData['ReversedYear']);
                unset($OrginalData['ReversedBranch']);
                unset($OrginalData['transType']);
                unset($OrginalData['Reversed_By']);
                unset($OrginalData['Reversed_date']);
                unset($OrginalData['last_update_by']);
                unset($OrginalData['Last_Modify_date']);
                unset($OrginalData['Created_by']);
                unset($OrginalData['Created_date']);
                unset($OrginalData['Post_By']);
                unset($OrginalData['PostDate']);

                $NewTrans = ORM::factory('Financials_Accounts_Trans');
                $NewTrans->values($OrginalData);
                $NewTrans->Linked_with = $ORM->id;
                $NewTrans->Posted = 3; //مرتبط
                if ($NewTrans->save()) {
                    $ORM->Posted = 2; //تم عكسه
                    $ORM->Reversedno = $NewTrans->id;
                    $ORM->Reversed_By = $u_id;
                    $ORM->Reversed_date = date("Y-m-d H:i:s");
                    $ORM->save();
                }
                
                 $results['Success'] = array(
                'title' => Lang::__('Done'),
                'content' => Lang::__('Reverse_Trans_And_its_calculations_done'),
            );

                //Reports::AddReport('Trans', 'reversed_trans', $ORM->id); //تسجيل تقرير بالعملية
            }
            $Details = ORM::factory('Financials_Accounts_Transdetail')->where('TransNo', '=', $ORM->id)->find_all();
            foreach ($Details as $value) {
                if ($value->posted == 1) { //للتأكد أن هذا الصف فعلا تم ترحيله
                    $new_detail_data = $value->as_array();
                    unset($new_detail_data['id']);
                    unset($new_detail_data['posted']);
                    unset($new_detail_data['TransNo']);
                    unset($new_detail_data['PreDebitBal']);
                    unset($new_detail_data['PreCreditBal']);
                    //swap between debit and credit
                    $temp = $new_detail_data['debit'];
                    $new_detail_data['debit'] = $new_detail_data['credit'];
                    $new_detail_data['credit'] = $temp;

                    $New_det_obj = ORM::factory('Financials_Accounts_Transdetail');
                    $New_det_obj->values($new_detail_data);
                    $New_det_obj->TransNo = $NewTrans->id;
                    if ($New_det_obj->save()) {
                        $Account = ORM::factory('Financials_Accounts', $New_det_obj->AccNo);
                        if ($Account->loaded()) {
                            $New_det_obj->PreDebitBal = $Account->Debit;
                            $New_det_obj->PreCreditBal = $Account->Credit;
                            $New_det_obj->save();

                            $Account->Debit += $New_det_obj->debit;
                            $Account->Credit += $New_det_obj->credit;

                            if ($Account->save()) { //تم التأثير على الدائن والمدين للحساب
                                $New_det_obj->posted = 1;
                                $New_det_obj->save();
                            } else {
                                $NewTrans->Posted = 4; //حدث خطأ في عملية الترحيل
                                $NewTrans->save();
                            }
                        }
                    }
                }
            }
        } else {
             $results['Errors'] = array(
                'title' => Lang::__('Error'),
                'content' => Lang::__('Not_found_the_desired_item'),
            );
        }
        
        echo json_encode($results);
    }

    /*
     * عرض نموذج اضافة وتحرير القيد
     */

    public function action_AEobj() {


        /////////////////////
        if ($this->Add || $this->Browse || $this->Edit || $this->Delete) {
            $id = mb_strtolower($this->request->param('par1'));
            $obj = ORM::factory('Financials_Accounts_Trans', $id);
            $title = Lang::__('New_Entry') . ' - ' . Lang::__('Daily_Constraints');
            $this->template->layout = new View('system/financials/trans/AE');
            if ($obj->loaded() && $obj->Posted == 0) {
                $title = Lang::__('Modify_Entry') . ' - ' . Lang::__('Daily_Constraints');
                $Details = ORM::factory('Financials_Accounts_Transdetail')->where('TransNo', '=', $obj->id)->find_all();
                $this->template->layout->Details = $Details;
                $this->template->layout->Obj = $obj;
             
            }
             $this->template->title = $title;
                $this->template->layout->title = $title;
                $this->template->layout->Post_states = $this->Post_states;
                $this->template->layout->Add = $this->Add;
                $this->template->layout->lang = $this->lang;
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }

    /*
     * توثيق تعديلات القيد في قاعدة البيانات
     */

    public function action_ObjToDB() {
        $u_id = $this->user_online->id;

        $errors = array();
        $obj_id = mb_strtolower($this->request->param('par1'));
        $objj = ORM::factory('Financials_Accounts_Trans', $obj_id);

        $post = $this->request->post();

        $req = Request::current(); //fillter requset
        $Filtered_array = $req->post();
        foreach ($Filtered_array as $key => $value) {
            if (!is_array($value)) {
                $Filtered_array[$key] = $this->action_safehtml($value);
                if ($this->action_safehtml($value) == '') {
                    $Filtered_array[$key] = NULL;
                }
            }
        }
        //delete all variable which must not changed
        unset($Filtered_array['id']);
        unset($Filtered_array['array_of_table']);
        unset($Filtered_array['last_update_by']);
        unset($Filtered_array['Last_Modify_date']);
        unset($Filtered_array['Created_by']);
        unset($Filtered_array['Created_date']);
        //اجراء تعديلات على مصفوفة التفاصيل بما يتوافق مع شروط النظام والحماية
        $Details = $this->action_ModifyDetailsArray(json_decode(stripslashes($post['array_of_table'])));

        if (!is_array($Details)) {
            array_push($errors, $Details);
        }

        //هنا نكشف في حال محاولة تعديل قيد تم ترحيله مسبقا
        if ($objj->loaded() && $objj->Posted != 0) {
            array_push($errors, Lang::__('you_cant_modify_posted_trans'));
        }

        //في حال كانت العملية تعديل القيد
        if ($objj->loaded()) {
            $objj->last_update_by = $u_id;
            $objj->Last_Modify_date = date("Y-m-d H:i:s");
        } else {
            $objj->Created_by = $u_id;
            $objj->Created_date = date("Y-m-d H:i:s");
        }

        if (count($errors) == 0) {
            $objj->values($Filtered_array);
            try {
                if ($objj->save()) {
                    $this->action_SaveDetails($objj->id, $Details);
                    //توثيق العملية في سجل التقارير
                    if ($objj->last_update_by == NULL) {
                        //Reports::AddReport('Trans', 'add', $objj->id);
                    } else {
                        //Reports::AddReport('Trans', 'edit', $objj->id);
                    }
                   //set success msg
                    $session = Session::instance();
                    $session->set('ToastrTitle', Lang::__('The_process_successfully'));
                    $session->set('ToastrMSG', Lang::__('Trans_data_has_been_saved_successfully'));
                    $this->redirect('Financials_Trans/AEobj/' . $objj->id, 302);

                    //end set success msg
                }
            } catch (ORM_Validation_Exception $e) {
                $errors = $e->errors(''); //see the massage files (must be the same name of model)
                //print_r($errors);
                $this->action_error($errors);
            }
        } else {
            $this->action_error($errors);
        }
    }

    /*
     * اجراء تعديلات على مصفوفة التفاصيل بما يتوافق مع شروط النظام والحماية
     */

    public function action_ModifyDetailsArray($data) {
        /*
         * [0] id
         * [1] AccNo
         * [2] CostCenter
         * [3] description
         * [4] depit
         * [5] Credit
         */
        unset($data[0]); //delete first empty array
        $total_debit = 0;
        $total_Credit = 0;
        foreach ($data as $key => $value) {
            if (!is_numeric($value[0])) { //if id not loaded
                $data[$key][0] = NULL;
            }
            if (!is_numeric($value[1])) { //if AccNo not loaded
                unset($data[$key]);
                continue;
            }
            if (!is_numeric($value[2])) { //if CostCenter not correct
                $data[$key][2] = NULL;
            }
            if (!is_numeric($value[4])) { //if depit not num
                $data[$key][4] = 0;
            }
            if (!is_numeric($value[5])) { //if Credit not num
                $data[$key][5] = 0;
            }
            $total_debit += $value[4];
            $total_Credit += $value[5];
            if ($value[1] <= 0) {
                return Lang::__('You_must_enter_account');
            }
            if ($value[4] < 0 || $value[5] < 0) {
                return Lang::__('You_cant_enter_value_less_than_0');
            }
            if ($value[4] > 0 && $value[5] > 0) {
                return Lang::__('debit_of_credit_must_be_equal_0');
            }
            if ($value[4] == 0 && $value[5] == 0) {
                return Lang::__('debit_and_credit_should_not_be_same_0');
            }
        }

        $diff_deb_cre = $total_debit - $total_Credit;
        if ($total_debit <= 0 && $total_Credit <= 0) {
            return Lang::__('You_must_enter_details');
        } elseif ($diff_deb_cre != 0) {
            return Lang::__('the_difference_between_the_sum_of_the_creditor_and_the_debtor_is_not_equal_to_zero');
        } else {
            return $data;
        }
    }

    /*
     * ارسال تفاصيل القيد الى قاعدة البيانات
     */

    public function action_SaveDetails($TransNo, $data) {
        $TransDet = ORM::factory('Financials_Accounts_Transdetail')->where('TransNo', '=', $TransNo)->find_all();
        $All_prev_rows_id = array();
        foreach ($TransDet as $value) {
            array_push($All_prev_rows_id, $value->id);
        }
        $all_modifided_rows_id = array();
        $total_debit = 0;
        foreach ($data as $key => $value) {
            if ($key > 0 && (Accounts::isParent($value[1]) == FALSE)) { //لتجنب اضافة المصفوفة الاولى الفارغةأو للتاثير على حساب رئيسي
                $id = $value[0];
                $AccNo = $value[1];
                $CostCenterno = $value[2];
                $Description = $value[3];
                $debit = $value[4];
                $credit = $value[5];

                $objj = ORM::factory('Financials_Accounts_Transdetail', $id);
                $objj->TransNo = $TransNo;
                $objj->AccNo = $AccNo;
                $objj->CostCenterno = $CostCenterno;
                $objj->Description = $Description;
                $objj->debit = $debit;
                $objj->credit = $credit;
                if ($objj->save()) {
                    $total_debit += $objj->debit;
                    array_push($all_modifided_rows_id, $objj->id);
                }
            }
        }
        // save amount
        $amount = ORM::factory('Financials_Accounts_Trans', $TransNo);
        $amount->amount = $total_debit;
        $amount->save();
        // end save amount
        //delete rows
        $to_delete = array_diff($All_prev_rows_id, $all_modifided_rows_id);
        foreach ($to_delete as $value) {
            ORM::factory('Financials_Accounts_Transdetail', $value)->delete();
        }
        //end delete rows
    }

    public function action_GetDateToTable() {
        $post = $this->request->post();
        $order = $post['order']; //Get how table order from datatable
        //جميع الأعمدة بالترتيب
        $ALL_coulums = array(
            1 => "id",
            2 => "Gregorian_date",
            3 => "Document_Number",
            4 => "Description",
            5 => "amount",
            6 => "Posted",
        );

        $All_Objs = ORM::factory('Financials_Accounts_Trans')->order_by($ALL_coulums[$order[0]['column']], $order[0]['dir'])->find_all();

        // Convert Object to array
        $array_ = array(); //MD-array of All accounts
        foreach ($All_Objs as $k => $d) {
            $array_[$k] = $d->as_array();
        }
        // End Convert Object to array 

        $Succesful_msg = Lang::__('Action_successfully_has_been_completed_Well_done');
        $C_Acti_status = "OK";


        /*
         * If Action exists
         */
        if (isset($post['customActionName'])) {
            switch ($post['customActionName']) {

                case 'Post_Trans':
                    $succ = 0;
                    $fail = 0;
                    foreach ($post['id'] as $value) {
                        if ($this->action_PostTrans($value) === false) {
                            $fail++;
                        } else {
                            $succ++;
                        }
                    }

                    $Succesful_msg = $succ . " " . Lang::__('Trans_successfully_Posted') . " " . $fail . " " . Lang::__('Fail');
                    break;
                case 'ExportToExcel':
                    $array_to_excel = array();
                    foreach ($post['id'] as $value) {
                        array_push($array_to_excel, $this->action_search($array_, 'id', $value));
                    }
                    $path = $this->action_ExportToFile('Excel', $array_to_excel);
                    $Succesful_msg = Lang::__('Export_the_file_has_been_successfully');
                    $Succesful_msg .= " <a href='" . URL::base() . $path . "'>" . Lang::__('by_click_here') . "</a>";
                    $Succesful_msg .= '<div class="desc"><span class="label label-sm label-warning " style="margin:2px;"><span>' . Lang::__('Note') . '</span></span>' . Lang::__('File_been_added_to_your_portfolio_files') . ' </div>';
                    break;

                case 'ExportToPDF':
                    $array_to_pdf = array();
                    foreach ($post['id'] as $value) {
                        array_push($array_to_pdf, $this->action_search($array_, 'id', $value));
                    }
                    $path = $this->action_ExportToFile('PDF', $array_to_pdf);
                    $Succesful_msg = Lang::__('Export_the_file_has_been_successfully');
                    $Succesful_msg .= " <a href='" . URL::base() . $path . "'>" . Lang::__('by_click_here') . "</a>";
                    $Succesful_msg .= '<div class="desc"><span class="label label-sm label-warning " style="margin:2px;"><span>' . Lang::__('Note') . '</span></span>' . Lang::__('File_been_added_to_your_portfolio_files') . ' </div>';

                    break;
                case 'Print':
                    $array_to_pdf = array();
                    foreach ($post['id'] as $value) {
                        array_push($array_to_pdf, $this->action_search($array_, 'id', $value));
                    }
                    $path = $this->action_ExportToFile('Print', $array_to_pdf);
                    $Succesful_msg = Lang::__('Successfully_prepared_print_file');
                    $Succesful_msg .= " <a target='_blank' href='" . URL::base() . $path . "'>" . Lang::__('by_click_here') . "</a>";
                    $Succesful_msg .= '<div class="desc"><span class="label label-sm label-warning " style="margin:2px;"><span>' . Lang::__('Note') . '</span></span>' . Lang::__('File_been_added_to_your_portfolio_files') . ' </div>';

                    break;

                default:
                    break;
            }
        }


        /*
         * Paging
         */

        $iTotalRecords = count($All_Objs);

        $iDisplayLength = intval($post['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($post['start']);
        $sEcho = intval($post['draw']);

        $records = array();
        $records["data"] = array();

        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;

        /*
         * if search exists
         */
        if (isset($post['action']) && (!is_array($post['action'])) && mb_strtolower($post['action']) == 'filter') {

            $Search_objss = $All_Objs;
            $array_1 = array();
            foreach ($Search_objss as $value) {
                if (
                        ( (strlen($post['id_from']) > 0 && strlen($post['id_to']) > 0) && (($value->id >= $post['id_from'] && $value->id <= $post['id_to'])) ) || ( (strlen($post['id_from']) > 0 && strlen($post['id_to']) <= 0) && (($value->id == $post['id_from'])) ) || ( (strlen($post['Gregorian_date_from']) > 0 && strlen($post['Gregorian_date_to']) > 0) && ((strtotime($value->Gregorian_date) >= strtotime($post['Gregorian_date_from']) && strtotime($value->Gregorian_date) <= strtotime($post['Gregorian_date_to']))) ) || ( (strlen($post['Gregorian_date_from']) > 0 && strlen($post['Gregorian_date_to']) <= 0) && ((strtotime($value->Gregorian_date) == strtotime($post['Gregorian_date_from']))) ) || ( (strlen($post['Document_Number_from']) > 0 && strlen($post['Document_Number_to']) > 0) && (($value->Document_Number >= $post['Document_Number_from'] && $value->Document_Number <= $post['Document_Number_to'])) ) || ( (strlen($post['Document_Number_from']) > 0 && strlen($post['Document_Number_to']) <= 0) && (($value->Document_Number == $post['Document_Number_from'])) ) || ( (strlen($post['Description']) > 1) && (strpos(mb_strtolower($value->Description), mb_strtolower($post['Description'])) !== false)) || ( (strlen($post['amount_from']) > 0 && strlen($post['amount_to']) > 0) && (($value->amount >= $post['amount_from'] && $value->amount <= $post['amount_to'])) ) || ( (strlen($post['amount_from']) > 0 && strlen($post['amount_to']) <= 0) && (($value->amount == $post['amount_from'])) ) || ( $value->Posted == $post['Posted'] )
                ) {

                    array_push($array_1, $value->id);
                }
            }

            $output = array_slice($array_1, $iDisplayStart, $iDisplayLength);
            $Search_objs = array();
            foreach ($output as $value) {
                array_push($Search_objs, $this->action_search($array_, 'id', $value));
            }
        }
        /*
         * if is not search
         */ else {
            $Search_objs = array_slice($array_, $iDisplayStart, $iDisplayLength);
        }

        /*
         * Prepare JSON Array
         */
        foreach ($Search_objs as $key => $value) {


            $records["data"][] = array(
                '<input type="checkbox" name="id[]" value="' . $value['id'] . '">',
                $value['id'],
                $value['Gregorian_date'],
                $value['Document_Number'],
                $value['Description'],
                $value['amount'],
                $this->Post_states[$value['Posted']],
                $this->action_GetButton($value['id'], $value['Posted'], TRUE),
                $this->action_GetBackground($value['Posted']),
            );
        }
        if (isset($post["customActionType"]) && $post["customActionType"] == "group_action") {
            $records["customActionStatus"] = $C_Acti_status; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = $Succesful_msg; // pass custom message(useful for getting status of group actions)
        }

        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;

        echo json_encode($records);
    }

    /*
     * لجلب بيانات قيد واحد الى جدول القيود
     */

    public function action_UpdateOneRow() {
        $post = $this->request->post();
        $row = ORM::factory('Financials_Accounts_Trans', $post['TransID']);

        $result = array(
            '0' => '<input type="checkbox" name="id[]" value="' . $row->id . '">',
            '1' => $row->id,
            '2' => $row->Gregorian_date,
            '3' => $row->Document_Number,
            '4' => $row->Description,
            '5' => $row->amount,
            '6' => $this->Post_states[$row->Posted],
            '7' => $this->action_GetButton($row->id, $row->Posted, TRUE),
            '8' => $this->action_GetBackground($row->Posted),
        );
        print_r(json_encode($result));
    }

    public function action_GetBackground($POSTED) {
        switch ($POSTED) {
            case 0:
                $background = '#FFFFFF';
                break;
            case 1:
                $background = '#F0FFF5';
                break;
            case 2:
                $background = '#FFDAE4';
                break;
            case 3:
                $background = '#FFFFEC';
                break;
            case 4:
                $background = '#CACACA';
                break;
            default:
                $background = '#F3F7F7';
                break;
        }
        return $background;
    }

    public function action_GetButton($TransID = NULL, $Posted = NULL, $Return = TRUE) {

//        $post = $this->request->post();
//        if (isset($post['TransID']) && is_numeric($post['TransID'])) {
//            $TransID = $post['TransID'];
//            $Posted = ORM::factory('Financials_Accounts_Trans', $post['TransID'])->Posted;
//            $Return = FALSE;
//        }

        if ((!is_numeric($Posted)) && $TransID != NULL) {
            $Posted = ORM::factory('Financials_Accounts_Trans', $TransID)->Posted;
        }

        $Buttons = '<span id="ButtonGroub' . $TransID . '">';
        $Buttons .= '<a TransID="' . $TransID . '" class="btn btn-xs blue ShowTrans">' . Lang::__('View') . '</a>';
        if ($Posted == 0) { //NotPosted
            $Buttons .= '<a href="' . URL::base() . 'Financials_Trans/AEobj/' . $TransID . '" class="btn btn-xs default">' . Lang::__('Edit') . '</a>';
            $Buttons .= '<a TransID="' . $TransID . '" class="btn btn-xs green PostTrans">' . Lang::__('Post_Trans') . '</a>';
        }
        if ($Posted == 1) { //Posted
            $Buttons .= '<a TransID="' . $TransID . '" msg="'.Lang::__('Are_you_sure_you_want_to_reverse_this_Trans').'" class="btn btn-xs purple ReverseTrans">' . Lang::__('Reverse_Trans') . '</a>';
        }
        if ($Posted == 2) {
            $Objec = ORM::factory('Financials_Accounts_Trans', $TransID)->Reversedno;
            $Buttons .= '<a TransID="' . $Objec . '" class="btn btn-xs yellow ShowTrans">' . Lang::__('View_Linked_Trans') . '</a>';
        }
        if ($Posted == 3) {
            $Objec = ORM::factory('Financials_Accounts_Trans', $TransID)->Linked_with;
            $Buttons .= '<a TransID="' . $Objec . '" class="btn btn-xs red ShowTrans">' . Lang::__('View_Linked_Trans') . '</a>';
        }
        $Buttons .='</span>';

        if ($Return == TRUE) {
            return $Buttons;
        } else {
            echo $Buttons;
        }
    }

    public function action_ExportToFile($File_Type, $array_to_excel) {
        $lang = $this->lang;
        $dir = 'ltr';
        if ($lang == 'ar') {
            $dir = 'rtl';
        }
        $user_id = $this->user_online->id;

        $objPHPExcel = new PHPExcel();

        $objPHPExcel->getDefaultStyle()->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $objPHPExcel->getDefaultStyle()->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);

        $All_data = $objPHPExcel->setActiveSheetIndex(0);

        $row = 3;
        $total_amount = 0;
        $End_Date = null;
        $Start_Date = null;
        foreach ($array_to_excel as $value) {
            if ($row == 3) {
                $End_Date = $value['Gregorian_date'];
                $Start_Date = $value['Gregorian_date'];
            } else {
                if ($End_Date < $value['Gregorian_date']) {
                    $End_Date = $value['Gregorian_date'];
                }
                if ($Start_Date > $value['Gregorian_date']) {
                    $Start_Date = $value['Gregorian_date'];
                }
            }
            $All_data->setCellValue('A' . $row, $value['id']);
            $All_data->setCellValue('B' . $row, $value['Gregorian_date']);
            $All_data->setCellValue('C' . $row, $value['Hijri_date']);
            $All_data->setCellValue('D' . $row, $value['Document_Number']);
            $All_data->setCellValue('E' . $row, $value['Description']);
            $All_data->setCellValue('F' . $row, $value['amount']);
            $total_amount+= $value['amount'];
            $row++;
        }

        //اعداد السطر الاخير
        $All_data->setCellValue('A' . $row, '');
        $All_data->setCellValue('B' . $row, Lang::__('Number') . ": ");
        $All_data->setCellValue('C' . $row, count($array_to_excel));
        $All_data->setCellValue('D' . $row, '');
        $All_data->setCellValue('E' . $row, Lang::__('Total') . ": ");
        $All_data->setCellValue('F' . $row, "=SUM(F3:F" . ($row - 1) . ")");

        //بداية  اعداد معلومات التقرير
        $objPHPExcel->setActiveSheetIndex(0)->mergeCells('A1:F1');
        $Center_String = "";
        $Center_String.= ORM::factory('Variables', 2)->{'value_' . $lang} . "\n";
        $Center_String.= ORM::factory('Variables', 3)->{'value_' . $lang} . "\n";
        $Center_String.= Lang::__('Phone') . ": " . ORM::factory('Variables', 4)->value . "     " . Lang::__('Fax') . ": " . ORM::factory('Variables', 5)->value . "\n";
        $Center_String.= Lang::__('Print_date') . ": " . date("Y-m-d") . " ( " . Covertdate::GregorianToHijri(date("Y-m-d")) . "هـ ) " . "         " . Lang::__('Time') . ": " . date("h:i:s") . " " . Lang::__(date("a")) . "\n";
        $Center_String.= Lang::__('Report_daily_Trans') . "\n";
        $Center_String.= Lang::__('Date') . ": " . Lang::__('From') . " " . $Start_Date . "     " . Lang::__('To') . ": " . $End_Date;

        $All_data->setCellValue('A1', $Center_String);

        $All_data->setCellValue('A2', Lang::__('id'));
        $All_data->setCellValue('B2', Lang::__('Gregorian_date'));
        $All_data->setCellValue('C2', Lang::__('Hijri_date'));
        $All_data->setCellValue('D2', Lang::__('Document_Number'));
        $All_data->setCellValue('E2', Lang::__('Description'));
        $All_data->setCellValue('F2', Lang::__('amount'));
        //نهاية  اعداد معلومات التقرير
        //بداية الستايلات
        $objPHPExcel->setActiveSheetIndex(0)->getStyle('A1:F1')->applyFromArray(
                array(
                    'fill' => array(
                        'type' => PHPExcel_Style_Fill::FILL_SOLID,
                        'color' => array('rgb' => 'EAF7EE')
                    ),
                    'borders' => array(
                        'allborders' => array(
                            'style' => PHPExcel_Style_Border::BORDER_THIN
                        )
                    ),
                    'font' => array(
                        'bold' => true,
                        'color' => array('rgb' => '1A00C6'),
                        'size' => 10,
                    ),
                )
        );

        $objPHPExcel->setActiveSheetIndex(0)->getStyle('A2:F' . $row)->applyFromArray(
                array(
                    'borders' => array(
                        'allborders' => array(
                            'style' => PHPExcel_Style_Border::BORDER_THIN
                        )
                    ),
                )
        );
        //نهاية الستايلات


        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);

        //Orientation and Paper Size
        $objPHPExcel->getActiveSheet()
                ->getPageSetup()
                ->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
        $objPHPExcel->getActiveSheet()
                ->getPageSetup()
                ->setPaperSize(PHPExcel_Worksheet_PageSetup::PAPERSIZE_A4);

        $objPHPExcel->getActiveSheet()
                ->setShowGridlines(true);

        $system_title = ORM::factory('Variables', 2)->{'value_' . $lang};
        $objPHPExcel->getProperties()
                ->setCreator($system_title)
                ->setLastModifiedBy($system_title)
                ->setTitle($system_title)
                ->setSubject($system_title)
                ->setDescription($system_title)
                ->setKeywords($system_title)
                ->setCategory($system_title);


        if ($dir == 'rtl') {
            $objPHPExcel->getActiveSheet()->setRightToLeft(true); //للنسخة العربية
        }

        /*
         * Determaine type of export
         */

        switch ($File_Type) {
            case 'Excel':
                $method = 'Excel2007';
                $ext = 'xlsx';
                break;

            case 'PDF':
                $method = 'PDF';
                $ext = 'pdf';
                break;
            case 'Print':
                $method = 'HTML';
                $ext = 'html';
                break;

            default:
                break;
        }

        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, $method);
        $folder_path = 'files/users/' . $user_id . '/' . $ext . '/';
        $file_path = $folder_path . Text::random('alnum', rand(10, 50)) . '.' . $ext;

        if (!file_exists(DOCROOT . $folder_path)) {
            mkdir(DOCROOT . $folder_path, 0777, true);
        }

        $objWriter->save(DOCROOT . $file_path);
        return $file_path;
    }

    /*
     * تصدير وطباعة قيد منفرد
     */

    public function action_SingleExp($File_Type = NULL, $TransID = NULL) {
        $lang = $this->lang;
        $dir = 'ltr';
        if ($lang == 'ar') {
            $dir = 'rtl';
        }
        $user_id = $this->user_online->id;

        $File_Type = mb_strtolower($this->request->param('par1'));
        $TransID = intval($this->request->param('par2'));
        $Trans = ORM::factory('Financials_Accounts_Trans', $TransID);
        $objPHPExcel = new PHPExcel();

        $All_data = $objPHPExcel->setActiveSheetIndex(0);

        //بداية  اعداد معلومات التقرير
        $All_data->mergeCells('A1:F1');
        $Center_String = "";
        $Center_String.= ORM::factory('Variables', 2)->{'value_' . $lang} . "\n";
        $Center_String.= ORM::factory('Variables', 3)->{'value_' . $lang} . "\n";
        $Center_String.= Lang::__('Phone') . ": " . ORM::factory('Variables', 4)->value . "     " . Lang::__('Fax') . ": " . ORM::factory('Variables', 5)->value . "\n";
        $Center_String.= Lang::__('Print_date') . ": " . date("Y-m-d") . " ( " . Covertdate::GregorianToHijri(date("Y-m-d")) . "هـ ) " . "         " . Lang::__('Time') . ": " . date("h:i:s") . " " . Lang::__(date("a")) . "\n";
        $Center_String.= Lang::__('Daily_Trans') . "\n";
        $Center_String.= Lang::__('trans_id') . ": " . $Trans->id . "\n";
        $Center_String.= Lang::__('Trans_Date') . ": " . $Trans->Gregorian_date . " ( $Trans->Hijri_date هـ ) ";

        $All_data->setCellValue('A1', $Center_String);

        $All_data->mergeCells('A2:F2');
        $All_data->setCellValue('A2', Lang::__('Statement') . ": " . $Trans->Description);

        $All_data->setCellValue('A3', Lang::__('id'));
        $All_data->setCellValue('B3', Lang::__('AccNo'));
        $All_data->setCellValue('C3', Lang::__('account_name'));
        $All_data->setCellValue('D3', Lang::__('Statement'));
        $All_data->setCellValue('E3', Lang::__('Debit'));
        $All_data->setCellValue('F3', Lang::__('Credit'));
        //نهاية  اعداد معلومات التقرير

        $row = 4;
        $Trans_Details_Array = Search::action_FindAll_To_Array(ORM::factory('Financials_Accounts_Transdetail')->find_all());
        $Account_Array = Search::action_FindAll_To_Array(ORM::factory('Financials_Accounts')->find_all());
        $this_trans_dital =  Search::action_GetALL($Trans_Details_Array, 'TransNo', $Trans->id);
        foreach ($this_trans_dital as $value) {
            $All_data->setCellValue('A' . $row, $value['id']);
            $All_data->setCellValue('B' . $row, $value['AccNo']);
            $All_data->setCellValue('C' . $row, Search::action_GetOne($Account_Array, 'id', $value['AccNo'])['AccName_' . $lang]);
            $All_data->setCellValue('D' . $row, $value['Description']);
            $All_data->setCellValue('E' . $row, $value['debit']);
            $All_data->setCellValue('F' . $row, $value['credit']);
            $row++;
        }

        //اعداد السطر الاخير
        $All_data->setCellValue('A' . $row, '');
        $All_data->setCellValue('B' . $row, '');
        $All_data->setCellValue('C' . $row, '');
        $All_data->setCellValue('D' . $row, Lang::__('Total') . ": ");
        $All_data->setCellValue('E' . $row, "=SUM(E4:E" . ($row - 1) . ")");
        $All_data->setCellValue('F' . $row, "=SUM(F4:F" . ($row - 1) . ")");

        $row3 = $row + 2;
        $All_data->mergeCells('A' . $row3 . ':B' . $row3);
        $All_data->setCellValue('A' . $row3, Lang::__('Accounts'));
        $All_data->mergeCells('C' . $row3 . ':D' . $row3);
        $All_data->setCellValue('C' . $row3, Lang::__('Review'));
        $All_data->mergeCells('E' . $row3 . ':F' . $row3);
        $All_data->setCellValue('E' . $row3, Lang::__('Credence'));

        //بداية الستايلات
        $objPHPExcel->getDefaultStyle()->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $objPHPExcel->getDefaultStyle()->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);
        $objPHPExcel->setActiveSheetIndex(0)->getStyle('A1:F1')->applyFromArray(
                array(
                    'fill' => array(
                        'type' => PHPExcel_Style_Fill::FILL_SOLID,
                        'color' => array('rgb' => 'FFFFFF')
                    ),
                    'borders' => array(
                        'bottom' => array(
                            'style' => PHPExcel_Style_Border::BORDER_DOUBLE,
                        ),
                    ),
                    'font' => array(
                        'bold' => true,
                        'color' => array('rgb' => '1A00C6'),
                        'size' => 9,
                    ),
                )
        );
        $objPHPExcel->setActiveSheetIndex(0)->getStyle('A2:F2')->applyFromArray(
                array(
                    'alignment' => array(
                        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_JUSTIFY,
                    ),
                    'font' => array(
                        'bold' => true,
                        'color' => array('rgb' => '000000'),
                        'size' => 8,
                    ),
                    'borders' => array(
                        'bottom' => array(
                            'style' => PHPExcel_Style_Border::BORDER_THIN
                        ),
                    ),
                )
        );

        $objPHPExcel->setActiveSheetIndex(0)->getStyle('A3:F3')->applyFromArray(
                array(
                    'borders' => array(
                        'bottom' => array(
                            'style' => PHPExcel_Style_Border::BORDER_THIN
                        ),
                    ),
                )
        );
        $objPHPExcel->setActiveSheetIndex(0)->getStyle('A3:F' . ($row))->applyFromArray(
                array(
                    'borders' => array(
                        'allborders' => array(
                            'style' => PHPExcel_Style_Border::BORDER_THIN
                        ),
                    ),
                )
        );
        $objPHPExcel->setActiveSheetIndex(0)->getStyle('A' . $row . ':c' . ($row))->applyFromArray(
                array(
                    'borders' => array(
                        'left' => array(
                            'style' => PHPExcel_Style_Border::BORDER_NONE
                        ),
                        'right' => array(
                            'style' => PHPExcel_Style_Border::BORDER_NONE
                        ),
                        'bottom' => array(
                            'style' => PHPExcel_Style_Border::BORDER_NONE
                        ),
                        'top' => array(
                            'style' => PHPExcel_Style_Border::BORDER_DASHDOTDOT
                        ),
                    ),
                )
        );
        $objPHPExcel->setActiveSheetIndex(0)->getStyle('A' . ($row + 1) . ':F' . ($row + 1))->applyFromArray(
                array(
                    'borders' => array(
                        'left' => array(
                            'style' => PHPExcel_Style_Border::BORDER_NONE
                        ),
                        'right' => array(
                            'style' => PHPExcel_Style_Border::BORDER_NONE
                        ),
                        'bottom' => array(
                            'style' => PHPExcel_Style_Border::BORDER_NONE
                        ),
                        'top' => array(
                            'style' => PHPExcel_Style_Border::BORDER_DASHDOTDOT
                        ),
                    ),
                    'fill' => array(
                        'type' => PHPExcel_Style_Fill::FILL_SOLID,
                        'color' => array('rgb' => 'FFFFFF')
                    ),
                )
        );
        $objPHPExcel->setActiveSheetIndex(0)->getStyle('A' . ($row + 2) . ':F' . ($row + 2))->applyFromArray(
                array(
                    'borders' => array(
                        'allborders' => array(
                            'style' => PHPExcel_Style_Border::BORDER_NONE
                        ),
                    ),
                    'font' => array(
                        'bold' => true,
                        'color' => array('rgb' => '000000'),
                        'size' => 11,
                    ),
                )
        );
        //نهاية الستايلات


        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);

        //Orientation and Paper Size
        $objPHPExcel->getActiveSheet()
                ->getPageSetup()
                ->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
        $objPHPExcel->getActiveSheet()
                ->getPageSetup()
                ->setPaperSize(PHPExcel_Worksheet_PageSetup::PAPERSIZE_A4);

        $objPHPExcel->getActiveSheet()
                ->setShowGridlines(true);

        $system_title = ORM::factory('Variables', 2)->{'value_' . $lang};
        $objPHPExcel->getProperties()
                ->setCreator($system_title)
                ->setLastModifiedBy($system_title)
                ->setTitle($system_title)
                ->setSubject($system_title)
                ->setDescription($system_title)
                ->setKeywords($system_title)
                ->setCategory($system_title);


        if ($dir == 'rtl') {
            $objPHPExcel->getActiveSheet()->setRightToLeft(true); //للنسخة العربية
        }

        /*
         * Determaine type of export
         */

        switch ($File_Type) {
            case 'ecxel':
                $method = 'Excel2007';
                $ext = 'xlsx';
                break;

            case 'pdf':
                $method = 'PDF';
                $ext = 'pdf';
                break;
            case 'print':
                $method = 'HTML';
                $ext = 'html';
                break;

            default:
                break;
        }


        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, $method);
        $folder_path = 'files/users/' . $user_id . '/' . $ext . '/';
        $file_path = $folder_path . Text::random('alnum', rand(10, 50)) . '.' . $ext;

        if (!file_exists(DOCROOT . $folder_path)) {
            mkdir(DOCROOT . $folder_path, 0777, true);
        }

        $objWriter->save(DOCROOT . $file_path);
        $this->redirect($file_path, 302);
    }

    /*
     * تنقية النصوص والمتغيرات من أي أكواد خبيثة
     */

    public function action_safehtml($srt) {
        require_once DOCROOT . 'htmlpurifier/library/HTMLPurifier.auto.php';
        $config = HTMLPurifier_Config::createDefault();
        $purifier = new HTMLPurifier($config);
        return $purifier->purify($srt);
    }

    /*
     * صفحة عرض الاخطاء
     */

    public function action_error($error) {
        $view = View::factory('errors')
                ->set('error', $error);
        $this->response->body($view);
    }

}

/*
 * All Description for Reports
 * post_trans_done قام بترحيل القيد 
 * add اضاف
 * edit عدل
 * reversed_trans عكس قيد
 */

