<?php

defined('SYSPATH') or die('No direct script access.');

class Controller_Contactcp extends Controller_Template_Base {

    public $Read_Contact_Messages = FALSE;
    public $Delete_Contact_Messages = FALSE;

    public function __construct(Request $request, Response $response) {
        // You must call parent::__construct at some point in your function
        parent::__construct($request, $response);
        // Do whatever else you want
        $this->Read_Contact_Messages = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'Read_Contact_Messages')));
        $this->Delete_Contact_Messages = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'Delete_Contact_Messages')));
    }

    public function action_index() {
        if ($this->Read_Contact_Messages) {
            $this->template->title = Lang::__('contact');
            $this->template->layout = new View('system/contact/view_all');
        } else {
            $this->redirect('/', 302);
        }
    }

    public function action_View() {
        if ($this->Read_Contact_Messages) {
            $view = View::factory('system/contact/View');

            $process_type = 'add_new';
            $par1 = $this->request->param('par1');
            $Obj = ORM::factory('Contact', $par1);

            if ($Obj->loaded()) {
                $Obj->readed = 1;
                $Obj->save();
                $view->set('Obj', $Obj);
                $process_type = 'view';
            }
            $view->set('title', Lang::__($process_type));
            $view->set('lang', $this->lang);
            $this->response->body($view);
        }
    }

    public function action_Settings() {
        if ($this->Read_Contact_Messages) {
            $view = View::factory('system/contact/Settings');
            $view->set('title', Lang::__('contact'));
            $view->set('lang', $this->lang);
            $this->response->body($view);
        }
    }

    public function action_Delete($id) {
        if ($this->Delete_Contact_Messages) {
            $objj = ORM::factory('Contact', $id);
            if ($objj->loaded()) {

                if ($objj->delete()) {
                    
                } else {
                    return FALSE;
                }
            }
        }
    }

    public function action_ToDB() {
        if ($this->Read_Contact_Messages) {
            $results = array();

            $req = Request::current(); //fillter requset
            $Filtered_array = Search::action_Filtered_array($req->post());
            $obj_id = $Filtered_array['par1'];
            $objj = ORM::factory('Contact', $obj_id);

            if ($objj->loaded()) {
                $objj->last_update_by = $this->user_online->id;
                $objj->last_update_date = date("Y-m-d H:i:s");
            } else {
                $objj->Created_by = $this->user_online->id;
                $objj->Created_date = date("Y-m-d H:i:s");
            }

            $objj->values($Filtered_array);

            try {
                if ($objj->save()) {
                    if ($objj->admin_reply_status != 1) {
                        //Send MSG here
                        $Sent_results = TRUE;
                        if ($Sent_results == TRUE) {
                            $objj->admin_reply_status = 1;
                            $objj->save();
                        }
                        //End Send MSG
                    }
                    $results['Success'] = '';
                }
            } catch (ORM_Validation_Exception $e) {
                $errors = $e->errors('');
                $Lang_Error = array();
                foreach ($errors as $key => $value) {
                    $srting = '';
                    $errr = explode('*', $value);
                    if (count($errr) > 0) {
                        foreach ($errr as $aaa) {
                            $srting .= Lang::__($aaa) . ' ';
                        }
                        array_push($Lang_Error, $srting);
                    }
                }
                $results['Errors'] = $Lang_Error;
            }
            echo json_encode($results);
        }
    }

    public function action_GetData() {
        if ($this->Read_Contact_Messages) {
            $post = $this->request->post();
            $order = $post['order']; //Get how table order from datatable

            /*
             * All coulums will shown in table
             */
            $ALL_coulums = array(
                1 => "id",
            );

            $All_ORM = ORM::factory('Contact')
                    ->order_by($ALL_coulums[$order[0]['column']], $order[0]['dir']);


            $Succesful_msg = Lang::__('Action_successfully_has_been_completed_Well_done');
            $C_Acti_status = "OK";

            /*
             * If Action exists
             */
            if (isset($post['customActionName'])) {
                switch ($post['customActionName']) {
                    case 'Delete':
                        $ids = array();
                        foreach ($post['id'] as $value) {
                            if ($this->action_Delete($value) === FALSE) {
                                array_push($ids, $value);
                            }
                        }

                        break;


                    default:
                        break;
                }
            }


            /*
             * if search exists
             */
            if (isset($post['action']) && (!is_array($post['action'])) && mb_strtolower($post['action']) == 'filter') {
                
            }

            /*
             * Paging
             */
            $All_ORM->reset(FALSE);
            $iTotalRecords = $All_ORM->count_all();

            $iDisplayLength = intval($post['length']);
            $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
            $iDisplayStart = intval($post['start']);
            $sEcho = intval($post['draw']);

            $records = array();
            $records["data"] = array();

            $end = $iDisplayStart + $iDisplayLength;
            $end = $end > $iTotalRecords ? $iTotalRecords : $end;

            $All_ORM->offset($iDisplayStart);
            $All_ORM->limit($iDisplayLength);


            /*
             * Prepare JSON Array
             */
            foreach ($All_ORM->find_all() as $value) {
                $records["data"][] = array(
                    '<input type="checkbox" name="id[]" value="' . $value->id . '">',
                    $value->name,
                    $value->email,
                    $value->mobile,
                    $value->Created_date,
                    '<a data-url="' . URL::base() . 'Contactcp/View/' . $value->id . '" class="btn btn-xs default EDIT" data-toggle="modal"><i class="fa fa-view"></i> ' . Lang::__('view') . '</a>',
                );
            }
            if (isset($post["customActionType"]) && $post["customActionType"] == "group_action") {
                $records["customActionStatus"] = $C_Acti_status; // pass custom message(useful for getting status of group actions)
                $records["customActionMessage"] = $Succesful_msg; // pass custom message(useful for getting status of group actions)
            }

            $records["draw"] = $sEcho;
            $records["recordsTotal"] = $iTotalRecords;
            $records["recordsFiltered"] = $iTotalRecords;

            echo json_encode($records);
        }
    }

}

// End Contactcp
