<?php

defined('SYSPATH') or die('No direct script access.');

class Controller_Admission_Employment extends Controller_Template_Site
{

    public function action_AppSec()
    {
        $this->template->title = Lang::__('Follow up employment application');
        $this->template->layout = new View('site/admission/employment/appsec');
    }

    public function action_AppSecToDB()
    {
        $results = array();

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());

        $id = !empty($Filtered_array['id']) ? $Filtered_array['id'] : NULL;
        $password = !empty($Filtered_array['password']) ? $Filtered_array['password'] : NULL;

        $Obj = ORM::factory('Hr_Employment_Applications')
            ->where('app_id', '=', $id)
            ->where('app_password', '=', $password)
            ->find();
        if ($Obj->loaded()) {
            $session = Session::instance();

            // Find existing data
            $data = $session->get('Emp_Arr');

            // Add new array
            $data[] = array('id' => $Obj->app_id, 'password' => $Obj->app_password);

            // Resave it
            if ($session->set('Emp_Arr', $data)) {
                $results['Success'] = array(
                    "Redirect_url" => URL::base() . 'Admission_Employment/App/' . $Obj->id,
                );
            }
        } else {
            $results['Errors'] = array(
                "title" => Lang::__('Error'),
                "content" => Lang::__('Wrong_user_name_or_password'),
            );
        }

        echo json_encode($results);
    }

    public function action_App()
    {

        $session = Session::instance();


        $par1 = $this->request->param('par1');
        $Obj = ORM::factory('Hr_Employment_Applications', $par1);

        $NewAppState = (ORM::factory('Variables', 86)->value == "Open") ? TRUE : FALSE;

        $Access = FALSE;
        if ($Obj->loaded()) {
            // Find existing data
            $data = $session->get('Emp_Arr');
            if (is_array($data)) {
                foreach ($data as $elm) {
                    $id_ = !empty($elm['id']) ? $elm['id'] : NULL;
                    $password_ = !empty($elm['password']) ? $elm['password'] : NULL;

                    if ((mb_strtolower($id_) == mb_strtolower($Obj->app_id)) && mb_strtolower($password_) == mb_strtolower($Obj->app_password)) {
                        $Access = TRUE;
                    }
                }
            }
        }
        if ((!$Obj->loaded() && $NewAppState) || ($Obj->loaded() && $Access == TRUE)) {
            $this->template->layout = new View('site/admission/employment/ae_application');

            $title = Lang::__("Admission_Employment");
            if ($Obj->loaded()) {
                $this->template->layout->Obj = $Obj;
                $this->template->layout->date_of_birth = explode('-', $Obj->date_of_birth);
                $this->template->layout->date_of_birth_higri = explode('-', $Obj->date_of_birth_higri);
                $this->template->layout->passport_expiration_date = explode('-', $Obj->passport_expiration_date);
                $this->template->layout->passport_expiration_date_higri = explode('-', $Obj->passport_expiration_date_higri);
                $this->template->layout->id_expiry_date_higri = explode('-', $Obj->id_expiry_date_higri);
                $this->template->layout->id_expiry_date = explode('-', $Obj->id_expiry_date);
                $this->template->layout->id_expiry_date_higri = explode('-', $Obj->id_expiry_date_higri);
                $this->template->layout->starting_date = explode('-', $Obj->starting_date);
            }
            $this->template->layout->Maritalstatus = ORM::factory('General_Maritalstatus')->where('is_active', '=', 1)->where('is_deleted', '=', NULL)->find_all();
            $this->template->layout->Nationalities = ORM::factory('General_Countries')->where('is_active', '=', 1)->where('is_deleted', '=', NULL)->find_all();
            $this->template->layout->Religions = ORM::factory('General_Religions')->where('is_active', '=', 1)->where('is_deleted', '=', NULL)->find_all();
            $this->template->layout->Genders = ORM::factory('General_Genders')->where('is_active', '=', 1)->where('is_deleted', '=', NULL)->find_all();
            $this->template->layout->Banks = ORM::factory('General_Banks')->where('is_active', '=', 1)->where('is_deleted', '=', NULL)->find_all();
            $this->template->layout->Sections = ORM::factory('General_Hr_Sections')->where('is_active', '=', 1)->where('is_deleted', '=', NULL)->find_all();
            $this->template->layout->Employee_Types = ORM::factory('General_Hr_Employee_Types')->where('is_active', '=', 1)->where('is_deleted', '=', NULL)->find_all();
            $this->template->layout->Departments = ORM::factory('General_Hr_Departments')->where('is_active', '=', 1)->where('is_deleted', '=', NULL)->find_all();
            $this->template->layout->Positions = ORM::factory('General_Hr_Positions')->where('is_active', '=', 1)->where('is_deleted', '=', NULL)->find_all();

            $this->template->layout->Qualifications = $Obj->Qualifications->where('is_deleted', '=', NULL)->find_all();
            $this->template->layout->Certificates = $Obj->Certificates->where('is_deleted', '=', NULL)->find_all();
            $this->template->layout->Experiances = $Obj->Experiances->where('is_deleted', '=', NULL)->find_all();

            $this->template->layout->title = $title;
            $this->template->title = $title;

            $this->template->layout->lang = $this->lang;
        } else {
            if ($Obj->loaded()) {
                $this->redirect('Admission_Employment/AppSec', 302);
            } elseif (!$Obj->loaded() && !$NewAppState) {
                $this->template->layout = new View('site/error');
                $this->template->layout->MSG = nl2br(ORM::factory('Variables', 87)->{'text_' . $this->lang});
            }
        }
    }

    public function action_ToDB()
    {
        $results = array();

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());

        $par1 = empty($Filtered_array['par1']) ? NULL : $Filtered_array['par1'];
        $par2 = empty($Filtered_array['par2']) ? NULL : $Filtered_array['par2'];


        //Path of upload images
        $directory = 'files/hr/' . date('Y') . '/' . date("m") . '/';
        $directory_thumbs = $directory . 'thumbs/';

        $objj = ORM::factory('Hr_Employment_Applications', $par1);

        $session = Session::instance();

        $Access = FALSE;
        if ($objj->loaded()) {
            // Find existing data
            $data = $session->get('Emp_Arr');
            if (is_array($data)) {
                foreach ($data as $elm) {
                    $id_ = !empty($elm['id']) ? $elm['id'] : NULL;
                    $password_ = !empty($elm['password']) ? $elm['password'] : NULL;

                    if ((mb_strtolower($id_) == mb_strtolower($objj->app_id)) && mb_strtolower($password_) == mb_strtolower($objj->app_password)) {
                        $Access = TRUE;
                    }
                }
            }
        }
        $NewAppState = (ORM::factory('Variables', 86)->value == "Open") ? TRUE : FALSE;
        if ((!$objj->loaded() && $NewAppState) || ($objj->loaded() && $Access == TRUE)) {
            $New_App = TRUE;
            if (!$objj->loaded()) {
                $objj->Created_by = !empty($this->user_online->id) ? $this->user_online->id : NULL;
                $objj->Created_date = date("Y-m-d H:i:s");
                //Generate App id
                $app_id = date('y') . Text::random('nozero', 8);
                while (TRUE) {
                    $check = ORM::factory('Hr_Employment_Applications')->where('app_id', '=', $app_id)->find();
                    if ($check->loaded()) {
                        $app_id = date('y') . Text::random('nozero', rand(4, 7));
                    } else {
                        break;
                    }
                }
                //End Generate App id
                $objj->app_id = $app_id;
                $objj->app_password = mb_strtolower(Text::random('nozero', rand(4, 7)));
            } else {
                $objj->last_update_by = !empty($this->user_online->id) ? $this->user_online->id : NULL;
                $objj->last_update_date = date("Y-m-d H:i:s");
                $New_App = FALSE;
            }

            if (isset($Filtered_array['bd_year_gregorian']) && isset($Filtered_array['bd_month_gregorian']) && isset($Filtered_array['bd_day_gregorian'])) {
                $Filtered_array['date_of_birth'] = $Filtered_array['bd_year_gregorian'] . '-' . $Filtered_array['bd_month_gregorian'] . '-' . $Filtered_array['bd_day_gregorian'];
            }
            if (isset($Filtered_array['bd_year']) && isset($Filtered_array['bd_month']) && isset($Filtered_array['bd_day'])) {
                $Filtered_array['date_of_birth_higri'] = $Filtered_array['bd_year'] . '-' . $Filtered_array['bd_month'] . '-' . $Filtered_array['bd_day'];
            }
            if (isset($Filtered_array['passport_expiration_date_year_gregorian']) && isset($Filtered_array['passport_expiration_date_month_gregorian']) && isset($Filtered_array['passport_expiration_date_day_gregorian'])) {

                $Filtered_array['passport_expiration_date'] = $Filtered_array['passport_expiration_date_year_gregorian'] . '-' . $Filtered_array['passport_expiration_date_month_gregorian'] . '-' . $Filtered_array['passport_expiration_date_day_gregorian'];
            }
            if (isset($Filtered_array['passport_expiration_date_year_higri']) && isset($Filtered_array['passport_expiration_date_month_higri']) && isset($Filtered_array['passport_expiration_date_day_higri'])) {
                $Filtered_array['passport_expiration_date_higri'] = $Filtered_array['passport_expiration_date_year_higri'] . '-' . $Filtered_array['passport_expiration_date_month_higri'] . '-' . $Filtered_array['passport_expiration_date_day_higri'];
            }
            if (isset($Filtered_array['id_expiry_year_gregorian']) && isset($Filtered_array['id_expiry_month_gregorian']) && isset($Filtered_array['id_expiry_day_gregorian'])) {
                $Filtered_array['id_expiry_date'] = $Filtered_array['id_expiry_year_gregorian'] . '-' . $Filtered_array['id_expiry_month_gregorian'] . '-' . $Filtered_array['id_expiry_day_gregorian'];
            }
            if (isset($Filtered_array['id_expiry_year']) && isset($Filtered_array['id_expiry_month']) && isset($Filtered_array['id_expiry_day'])) {
                $Filtered_array['id_expiry_date_higri'] = $Filtered_array['id_expiry_year'] . '-' . $Filtered_array['id_expiry_month'] . '-' . $Filtered_array['id_expiry_day'];
            }
            if (isset($Filtered_array['starting_date_year']) && isset($Filtered_array['starting_date_month']) && isset($Filtered_array['starting_date_day'])) {
                $Filtered_array['starting_date'] = $Filtered_array['starting_date_year'] . '-' . $Filtered_array['starting_date_month'] . '-' . $Filtered_array['starting_date_day'];
            }

            $Jquery_Rules = $objj->VisitorRules($objj, FALSE);

            $upload_images_error = array();
            if ($this->request->method() == Request::POST) {
                $FileS = isset($_FILES['id_copy']) ? $_FILES['id_copy'] : NULL;
                if (!empty($FileS) && Upload::valid($FileS) && Upload::not_empty($FileS)) {

                    $allowed_ext = isset($Jquery_Rules['id_copy']['accept']) ? explode('|', $Jquery_Rules['id_copy']['accept']) : array();
                    $max_size = isset($Jquery_Rules['id_copy']['filesize']) ? $Jquery_Rules['id_copy']['filesize'] : 5000000;
                    $id_copy = $this->_save_image($_FILES['id_copy'], NULL, NULL, $directory, NULL, $allowed_ext, $max_size . 'B');
                    if ($id_copy) {

                        foreach (array('id_copy') as $value) {
                            if (!empty($objj->$value)) {
                                $DelFilePath = DOCROOT . $objj->$value;
                                if (is_file($DelFilePath)) {
                                    unlink($DelFilePath);
                                }
                            }
                        }
                        $Filtered_array['id_copy'] = $directory . $id_copy;
                    } else {
                        array_push($upload_images_error, Lang::__('id_copy'));
                    }
                }
                $cv_file = isset($_FILES['cv_file']) ? $_FILES['cv_file'] : NULL;
                if (!empty($cv_file) && Upload::valid($cv_file) && Upload::not_empty($cv_file)) {
                    $allowed_ext = isset($Jquery_Rules['cv_file']['accept']) ? explode('|', $Jquery_Rules['cv_file']['accept']) : array();
                    $max_size = isset($Jquery_Rules['cv_file']['filesize']) ? $Jquery_Rules['cv_file']['filesize'] : 5000000;
                    $cv_file = $this->_save_image($_FILES['cv_file'], NULL, NULL, $directory, NULL, $allowed_ext, $max_size . 'B');
                    if ($cv_file) {

                        foreach (array('cv_file') as $value) {
                            if (!empty($objj->$value)) {
                                $DelFilePath = DOCROOT . $objj->$value;
                                if (is_file($DelFilePath)) {
                                    unlink($DelFilePath);
                                }
                            }
                        }
                        $Filtered_array['cv_file'] = $directory . $cv_file;
                    } else {
                        array_push($upload_images_error, Lang::__('cv_file'));
                    }
                }
            }
            //Start allowed fields check
            $ArrayOfPrevents = array("app_status", "notes", "app_id", "app_password", "hr_section", "employee_type", "department", "insurance_number", "hr_position", "starting_date", "employee_not_in_payroll", "job_title", "basic_salary", "bank", "iban", "is_deleted", "deleted_by", "deleted_date", "Created_by", "Created_date", "last_update_by", "last_update_date", "approved_date", "approved_by", "rejected_date", "rejected_by");
            foreach ($Filtered_array as $key => $value) {
                if (in_array($key, $ArrayOfPrevents)) {
                    unset($Filtered_array[$key]);
                }
            }
            //End allowed fields check
            $objj->values($Filtered_array);
            $extra_rules = General::Jquery_To_ORM_Rules($Filtered_array, $Jquery_Rules);

            if (empty($upload_images_error)) {
                try {

                    if ($objj->save($extra_rules)) {
                        //Start dealing with with Qualifications
                        $Qualifications = isset($Filtered_array['Qualifications']) ? $Filtered_array['Qualifications'] : NULL;
                        if (!empty($Qualifications)) {
                            foreach ($Qualifications as $keyQ => $Qualification) {

                                $This_File = array();
                                if (isset($_FILES['Qualifications']['name'][$keyQ]['attachment_file'])) {
                                    $This_File['name'] = $_FILES['Qualifications']['name'][$keyQ]['attachment_file'];
                                }
                                if (isset($_FILES['Qualifications']['type'][$keyQ]['attachment_file'])) {
                                    $This_File['type'] = $_FILES['Qualifications']['type'][$keyQ]['attachment_file'];
                                }
                                if (isset($_FILES['Qualifications']['tmp_name'][$keyQ]['attachment_file'])) {
                                    $This_File['tmp_name'] = $_FILES['Qualifications']['tmp_name'][$keyQ]['attachment_file'];
                                }
                                if (isset($_FILES['Qualifications']['error'][$keyQ]['attachment_file'])) {
                                    $This_File['error'] = $_FILES['Qualifications']['error'][$keyQ]['attachment_file'];
                                }
                                if (isset($_FILES['Qualifications']['size'][$keyQ]['attachment_file'])) {
                                    $This_File['size'] = $_FILES['Qualifications']['size'][$keyQ]['attachment_file'];
                                }

                                if (isset($This_File) && Upload::valid($This_File) && Upload::not_empty($This_File)) {
                                    $allowed_ext = array("jpg", "jpeg", "png", "gif", "pdf");
                                    $max_size = 5000000;
                                    $File = $this->_save_image($This_File, NULL, NULL, $directory, NULL, $allowed_ext, $max_size . 'B');
                                    if ($File) {
                                        foreach (array('attachment_file') as $value) {
                                            if (!empty($objj->$value)) {
                                                $DelFilePath = DOCROOT . $objj->$value;
                                                if (is_file($DelFilePath)) {
                                                    unlink($DelFilePath);
                                                }
                                            }
                                        }
                                        $Qualification['attachment_file'] = $directory . $File;
                                    } else {
                                        //array_push($upload_images_error, Lang::__('attachment_file'));
                                    }
                                }
                                //To check if any of field exist
                                $all_empty = TRUE;
                                foreach ($Qualification as $key => $value) {
                                    if (!empty($value)) {
                                        $all_empty = FALSE;
                                        break;
                                    }
                                }
                                //End check if any of field exist
                                if ($all_empty == FALSE) {
                                    $id_this = isset($Qualification['id']) ? $Qualification['id'] : NULL;
                                    $Packagesadditional = ORM::factory('Hr_Employment_Applications_Qualifications', $id_this);
                                    $Packagesadditional->values($Qualification);
                                    if (!$Packagesadditional->loaded()) {
                                        $Packagesadditional->application_id = $objj->id;
                                    }
                                    $Packagesadditional->save();
                                }
                            }
                        }
                        //End dealing with with Qualifications
                        //Start dealing with with Certificates
                        $Certificates = isset($Filtered_array['Certificates']) ? $Filtered_array['Certificates'] : NULL;
                        if (!empty($Certificates)) {
                            foreach ($Certificates as $keyQ => $Certificate) {

                                $This_File = array();
                                if (isset($_FILES['Certificates']['name'][$keyQ]['attachment_file'])) {
                                    $This_File['name'] = $_FILES['Certificates']['name'][$keyQ]['attachment_file'];
                                }
                                if (isset($_FILES['Certificates']['type'][$keyQ]['attachment_file'])) {
                                    $This_File['type'] = $_FILES['Certificates']['type'][$keyQ]['attachment_file'];
                                }
                                if (isset($_FILES['Certificates']['tmp_name'][$keyQ]['attachment_file'])) {
                                    $This_File['tmp_name'] = $_FILES['Certificates']['tmp_name'][$keyQ]['attachment_file'];
                                }
                                if (isset($_FILES['Certificates']['error'][$keyQ]['attachment_file'])) {
                                    $This_File['error'] = $_FILES['Certificates']['error'][$keyQ]['attachment_file'];
                                }
                                if (isset($_FILES['Certificates']['size'][$keyQ]['attachment_file'])) {
                                    $This_File['size'] = $_FILES['Certificates']['size'][$keyQ]['attachment_file'];
                                }

                                if (isset($This_File) && Upload::valid($This_File) && Upload::not_empty($This_File)) {
                                    $allowed_ext = array("jpg", "jpeg", "png", "gif", "pdf");
                                    $max_size = 5000000;
                                    $File = $this->_save_image($This_File, NULL, NULL, $directory, NULL, $allowed_ext, $max_size . 'B');
                                    if ($File) {
                                        foreach (array('attachment_file') as $value) {
                                            if (!empty($objj->$value)) {
                                                $DelFilePath = DOCROOT . $objj->$value;
                                                if (is_file($DelFilePath)) {
                                                    unlink($DelFilePath);
                                                }
                                            }
                                        }
                                        $Certificate['attachment_file'] = $directory . $File;
                                    } else {
                                        //array_push($upload_images_error, Lang::__('attachment_file'));
                                    }
                                }
                                //To check if any of field exist
                                $all_empty = TRUE;
                                foreach ($Certificate as $key => $value) {
                                    if (!empty($value)) {
                                        $all_empty = FALSE;
                                        break;
                                    }
                                }
                                //End check if any of field exist
                                if ($all_empty == FALSE) {
                                    $id_this = isset($Certificate['id']) ? $Certificate['id'] : NULL;
                                    $Certifica = ORM::factory('Hr_Employment_Applications_Certificates', $id_this);
                                    $Certifica->values($Certificate);
                                    if (!$Certifica->loaded()) {
                                        $Certifica->application_id = $objj->id;
                                    }
                                    $Certifica->save();
                                }
                            }
                        }
                        //End dealing with with Certificates
                        //Start dealing with with Experiances
                        $Experiances = isset($Filtered_array['Experiances']) ? $Filtered_array['Experiances'] : NULL;
                        if (!empty($Experiances)) {
                            foreach ($Experiances as $keyQ => $Experiance) {

                                $This_File = array();
                                if (isset($_FILES['Experiances']['name'][$keyQ]['attachment_file'])) {
                                    $This_File['name'] = $_FILES['Experiances']['name'][$keyQ]['attachment_file'];
                                }
                                if (isset($_FILES['Experiances']['type'][$keyQ]['attachment_file'])) {
                                    $This_File['type'] = $_FILES['Experiances']['type'][$keyQ]['attachment_file'];
                                }
                                if (isset($_FILES['Experiances']['tmp_name'][$keyQ]['attachment_file'])) {
                                    $This_File['tmp_name'] = $_FILES['Experiances']['tmp_name'][$keyQ]['attachment_file'];
                                }
                                if (isset($_FILES['Experiances']['error'][$keyQ]['attachment_file'])) {
                                    $This_File['error'] = $_FILES['Experiances']['error'][$keyQ]['attachment_file'];
                                }
                                if (isset($_FILES['Experiances']['size'][$keyQ]['attachment_file'])) {
                                    $This_File['size'] = $_FILES['Experiances']['size'][$keyQ]['attachment_file'];
                                }

                                if (isset($This_File) && Upload::valid($This_File) && Upload::not_empty($This_File)) {
                                    $allowed_ext = array("jpg", "jpeg", "png", "gif", "pdf");
                                    $max_size = 5000000;
                                    $File = $this->_save_image($This_File, NULL, NULL, $directory, NULL, $allowed_ext, $max_size . 'B');
                                    if ($File) {
                                        foreach (array('attachment_file') as $value) {
                                            if (!empty($objj->$value)) {
                                                $DelFilePath = DOCROOT . $objj->$value;
                                                if (is_file($DelFilePath)) {
                                                    unlink($DelFilePath);
                                                }
                                            }
                                        }
                                        $Experiance['attachment_file'] = $directory . $File;
                                    } else {
                                        //array_push($upload_images_error, Lang::__('attachment_file'));
                                    }
                                }
                                //To check if any of field exist
                                $all_empty = TRUE;
                                foreach ($Experiance as $key => $value) {
                                    if (!empty($value)) {
                                        $all_empty = FALSE;
                                        break;
                                    }
                                }
                                //End check if any of field exist
                                if ($all_empty == FALSE) {
                                    $id_this = isset($Experiance['id']) ? $Experiance['id'] : NULL;
                                    $Ex = ORM::factory('Hr_Employment_Applications_Experiances', $id_this);
                                    $Ex->values($Experiance);
                                    if (!$Ex->loaded()) {
                                        $Ex->application_id = $objj->id;
                                    }
                                    $Ex->save();
                                }
                            }
                        }
                        //End dealing with with Experiances
                        if ($New_App == TRUE) {
                            $HtmlMsg = View::factory("site/admission/employment/sucess_msg_first_time")->set('app_id', $objj->app_id)->set('app_password', $objj->app_password)->render();
                            $results['Success'] = array(
                                'HtmlMsg' => $HtmlMsg,
                            );
                        } else {
                            $results['SuccessR'] = array(
                                'title' => Lang::__('Done'),
                                'content' => Lang::__('Saved_successfully'),
                                'Redirect' => URL::base() . "Admission_Employment/App/" . $objj->id,
                            );
                        }
                    }
                } catch (ORM_Validation_Exception $e) {
                    $errors = $e->errors('');
                    $results['Errors'] = array(
                        'title' => Lang::__('Error'),
                        'content' => General::ArrayToString(General::CatchErrorMSGSAjax($errors))
                    );
                }
            } else {
                $results['Errors'] = array(
                    'title' => Lang::__('Error'),
                    'content' => Lang::__('The following images or files could not be uploaded') . '</br>' . General::ArrayToString($upload_images_error)
                );
            }
        } else {
            if (!$objj->loaded() && !$NewAppState) {
                $results['Errors'] = array(
                    'title' => Lang::__('Error'),
                    'content' => nl2br(ORM::factory('Variables', 87)->{'text_' . $this->lang})
                );
            }
        }


        echo json_encode($results);
    }

    public function action_DeleteDetails()
    {
        $results = array();

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());

        $id = isset($Filtered_array['id']) ? $Filtered_array['id'] : NULL;
        $par2 = isset($Filtered_array['par2']) ? $Filtered_array['par2'] : NULL;

        if (in_array($par2, array('Qualifications', 'Certificates', 'Experiances'))) {
            $Obj = ORM::factory('Hr_Employment_Applications_' . $par2, $id);
            if ($Obj->loaded()) {
                $session = Session::instance();

                $Access = FALSE;
                // Find existing data
                $data = $session->get('Emp_Arr');
                if (is_array($data)) {
                    foreach ($data as $elm) {
                        $id_ = !empty($elm['id']) ? $elm['id'] : NULL;
                        $password_ = !empty($elm['password']) ? $elm['password'] : NULL;

                        if ((mb_strtolower($id_) == mb_strtolower($Obj->Hr_Employment_Application->app_id)) && mb_strtolower($password_) == mb_strtolower($Obj->Hr_Employment_Application->app_password)) {
                            $Access = TRUE;
                        }
                    }
                }


                if ($Access) {
                    $Obj->is_deleted = 1;
                    $Obj->deleted_by = $this->user_online->id;
                    $Obj->deleted_date = date("Y-m-d H:i:s");
                    if ($Obj->save()) {
                        $results['Success'] = array(
                            'title' => Lang::__('Done'),
                            'content' => Lang::__('Deletion has been successfully'),
                        );
                    }
                } else {
                    $results['Errors'] = array(
                        'title' => Lang::__('Error'),
                        'content' => Lang::__('You_dont_have_permission_to_do_this_action'),
                    );
                }
            } else {

                $results['Errors'] = array(
                    'title' => Lang::__('Error'),
                    'content' => Lang::__('Not_found_the_desired_item'),
                );
            }
        } else {

            $results['Errors'] = array(
                'title' => Lang::__('Error'),
                'content' => Lang::__('Not_found_the_desired_item'),
            );
        }

        $Obj = ORM::factory('Hr_Employment_Applications_' . $par2, $id);


        echo json_encode($results);
    }

    /*
     * Send Json of rules to jquery validation
     */

    public function action_GetRules()
    {
        $results = array();

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());

        $par1 = empty($Filtered_array['par1']) ? NULL : $Filtered_array['par1'];
        $par2 = empty($Filtered_array['par2']) ? NULL : $Filtered_array['par2'];

        $ORM = ORM::factory('Hr_Employment_Applications', $par1);

        $results['Rules'] = $ORM->AdminRules($ORM);


        echo json_encode($results);
    }

    protected function _save_image($image, $width = NULL, $height = NULL, $directory, $directory_thumbs, $extensions, $max_file_size)
    {
        if (!Upload::valid($image) OR !Upload::not_empty($image) OR !Upload::type($image, $extensions) OR !Upload::size($image, $max_file_size)) {
            return FALSE;
        }

        if (!empty($directory)) {
            $directory_D = DOCROOT . str_replace("\\", "/", $directory);
            if (!file_exists($directory_D)) {
                mkdir($directory_D, 0777, true);
            }
        }

        if (!empty($directory_thumbs)) {
            $directory_thumbs_D = DOCROOT . str_replace("\\", "/", $directory_thumbs);
            if (!file_exists($directory_thumbs_D)) {
                mkdir($directory_thumbs_D, 0777, true);
            }
        }

        $ext = pathinfo($image['name'], PATHINFO_EXTENSION);
        $filename = mb_strtolower(Text::random('alnum', rand(10, 30))) . '.' . $ext;

        if (in_array(mb_strtolower($ext), array("gif", "jpeg", "jpg", "png", "bmp"))) {
            if ($file = Upload::save($image, NULL, $directory)) {
                $img = Image::factory($file);
                $img->save($directory . $filename, 100);
                if (!empty($directory_thumbs)) {
                    $img->resize($width, $height, Image::INVERSE);
                    $img->save($directory_thumbs . $filename, 100);
                }
                // Delete the temporary file
                unlink($file);

                return $filename;
            }
        } else {
            if ($file = Upload::save($image, $filename, $directory)) {

                return $filename;
            }
        }
    }

}

// End Onlinereg
