<?php

defined('SYSPATH') or die('No direct script access.');

class Controller_Announcements extends Controller_Template_Site {

    public function action_index() {
        $id = $this->request->param('par1');
        $Obj = ORM::factory('Announcements', $id);
        if ($Obj->loaded() && $Obj->is_deleted == NULL) {
            $this->template->layout = new View('site/announcements/view_one');
            $this->template->layout->Obj = $Obj;

            $this->template->title = $Obj->{'title_' . $this->lang};

            //Start Get Keywords
            $K = $Obj->Tags->where('name_' . $this->lang, '!=', NULL)->find_all();
            $keywords = array();
            foreach ($K as $value) {
                array_push($keywords, $value->{'name_' . $this->lang});
            }
            $this->template->keywords = implode(Lang::__(','), $keywords);
            $this->template->description = $Obj->{'desc_'.  $this->lang};
            
            $this->template->layout->lang = $this->lang;
        } else {
            $this->template->layout = new View('site/error');
            $this->template->title = Lang::__('error');
            $this->template->layout->MSG = Lang::__('You tracked wrong or expired link');
        }
    }

    public function action_ShowAll() {
        $par1 = $this->request->param("par1");

        //first calc average count
        $News = ORM::factory('Announcements');
        $News->where('is_deleted', '=', NULL);

        $News->reset(FALSE); // useful to keep the existing query conditions for another query
        //you can change items_per_page
        $num = 8;

        //you can configure routes and custom routes params
        $pagination = Pagination::factory(array(
                    'total_items' => $News->count_all(),
                    'items_per_page' => $num,
                        //'current_page'   => Request::current()->param("page"),
                        )
                )->route_params(array(
            'directory' => Request::current()->directory(),
            'controller' => Request::current()->controller(),
            'action' => Request::current()->action(),
            "par1" => NULL,
            "par2" => NULL,
                )
        );
        //now select from your DB using calculated offset
        $Objs = $News->order_by("id", "DESC")
                ->limit($pagination->items_per_page)
                ->offset($pagination->offset)
                ->find_all();

        //and finally set view variables
        $title = Lang::__('Announcements');
        $this->template->title = $title;
        $this->template->layout = new View('site/announcements/view_all');
        $this->template->layout->title = $title;
        $this->template->layout->Objs = $Objs;
        $this->template->layout->pagination = $pagination;

        $this->template->layout->lang = $this->lang;
        $this->template->layout->user_online = $this->user_online;
    }

}

// End Dalel
