<?php

defined('SYSPATH') or die('No direct script access.');

class Controller_Accounting_Receivables extends Controller_Template_Base {

    public $Add = FALSE;
    public $Browse = FALSE;
    public $Edit = FALSE;
    public $Delete = FALSE;

    public function __construct(Request $request, Response $response) {
        // You must call parent::__construct at some point in your function
        parent::__construct($request, $response);
        // Do whatever else you want

        $this->Add = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'A_Receivables')));
        $this->Edit = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'E_Receivables')));
        $this->Browse = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'B_Receivables')));
        $this->Delete = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'D_Receivables')));
    }

    public function action_index() {

        if ($this->Add || $this->Browse || $this->Edit || $this->Delete) {
            $msg = mb_strtolower($this->request->param('par1'));
            $title = Lang::__('Receivables');
            $this->template->title = $title;
            $this->template->layout = new View('system/accounting/receivables/view_all');
            $this->template->layout->title = $title;
            $this->template->layout->msg = $msg;
            $this->template->layout->Add = $this->Add;

            $this->template->layout->lang = $this->lang;
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }

    public function action_DeleteNode($id = NULL) {
        $post = $this->request->post();
        if (isset($id) && is_numeric($id)) { //الحساب من الجدول
            $obj = ORM::factory('Accounting_Accounts', $id);
        } else { //الحساب من الشجرة
            $id_of_element = explode(':', $post['id']);
            $obj = ORM::factory('Accounting_Accounts', $id_of_element[0]);
            $From_tree = TRUE;
        }
        if ($obj->loaded()) {
            $All_acount = ORM::factory('Accounting_Accounts')
                    ->where('ParentNo', '=', $obj->id)
                    ->count_all();
            if ($All_acount > 0) { //node has chlids
                if (isset($From_tree)) { //اذا كان العنصر من الشجرة
                    $result['Error'] = Lang::__('The_accounts_have_not_been_deleted_since_it_falls_below_sons');
                    echo json_encode($result);
                } else {
                    return FALSE;
                }
            } else {
                if (Accounts::Move_on_account($obj) === FALSE) { //النفي يعني انه لم يحدث عليه حركات
                    $id_acc = $obj->id;
                    $obj->delete();
                    //Reports::AddReport('Accounts', 'delete', $id_acc); //تسجيل تقرير بالعملية
                } else {
                    if (isset($From_tree)) { //اذا كان العنصر من الشجرة
                        $result['Error'] = Lang::__('Account_have_not_been_deleted_since_it_was_conducted_by_movements');
                        echo json_encode($result);
                    } else {
                        return FALSE;
                    }
                }
            }
        }

    }

    /*
     * انشاء جدول الحسابات
     */

    public function action_GetDateToTable() {
        $post = $this->request->post();
        $order = $post['order']; //Get how table order from datatable

        /*
         * All coulums will shown in table
         */
        $ALL_coulums = array(
            1 => "AccNo",
            2 => "AccName_ar",
            3 => "AccName_en",
            4 => "bank",
            5 => "id",
        );


        $All_ORM = ORM::factory('Accounting_Accounts')
                ->where('type_of_account', '=', 1)
                ->order_by($ALL_coulums[$order[0]['column']], $order[0]['dir']);


        $Succesful_msg = Lang::__('Action_successfully_has_been_completed_Well_done');
        $C_Acti_status = "OK";


        /*
         * If Action exists
         */
        if (isset($post['customActionName'])) {
            switch ($post['customActionName']) {
                case 'Delete':
                    $error_nodes = array();
                    foreach ($post['id'] as $value) {
                        if ($this->action_DeleteNode($value) === FALSE) {
                            array_push($error_nodes, $value);
                        }
                    }

                    if (count($error_nodes) > 0) {
                        $C_Acti_status = "NotOK"; // pass custom message(useful for getting status of group actions)
                        $Succesful_msg = Lang::__('The_following_accounts_have_not_been_deleted_since_it_falls_below_sons') . ":";

                        foreach ($error_nodes as $value1) {
                            $Succesful_msg .= "<div> <i class='fa fa-times icon-default'></i> " . Lang::__('AccNo') . ": " . ORM::factory('Accounting_Accounts', $value1)->AccNo . "</div>";
                        }
                    }

                    break;

                default:
                    break;
            }
        }


        /*
         * if search exists
         */

        if (isset($post['action']) && (!is_array($post['action'])) && mb_strtolower($post['action']) == 'filter') {

            if (!empty($post['AccNo'])) {
                $AccNo = $post['AccNo'];
                $All_ORM->where(DB::expr('lower(AccNo)'), 'LIKE', mb_strtolower("%$AccNo%"));
            }
            if (!empty($post['AccName_ar'])) {
                $AccName_ar = $post['AccName_ar'];
                $All_ORM->where(DB::expr('lower(AccName_ar)'), 'LIKE', mb_strtolower("%$AccName_ar%"));
            }
            if (!empty($post['AccName_en'])) {
                $AccName_en = $post['AccName_en'];
                $All_ORM->where(DB::expr('lower(AccName_en)'), 'LIKE', mb_strtolower("%$AccName_en%"));
            }


            if (!empty($post['bank'])) {
                $All_ORM->where('bank', '=', $post['bank']);
            }
        }
        /*
         * Paging
         */

        $All_ORM->reset(FALSE);
        $iTotalRecords = $All_ORM->count_all();

        $iDisplayLength = intval($post['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($post['start']);
        $sEcho = intval($post['draw']);

        $records = array();
        $records["data"] = array();

        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;

        $All_ORM->offset($iDisplayStart);
        $All_ORM->limit($iDisplayLength);


        /*
         * All account type
         */
        $AccType = array(
            '1' => Lang::__('Profits_and_losses'),
            '2' => Lang::__('budget'),
        );

        /*
         * Prepare JSON Array
         */
        foreach ($All_ORM->find_all() as $value) {
            $buttons = '';
            $buttons .= '<button Accid="' . $value->id . '" class="btn btn-xs blue AEView">' . Lang::__('Edit') . '</button>';
            $buttons .= '<button Accid="' . $value->id . '" class="btn btn-xs blue-madison ViewAccount">' . Lang::__('View') . '</button>';

            $records["data"][] = array(
                '<input type="checkbox" name="id[]" value="' . $value->id . '">',
                $value->AccNo,
                $value->AccName_ar,
                $value->AccName_en,
                $value->Bank->{'name_' . $this->lang},
                $buttons,
            );
        }
        if (isset($post["customActionType"]) && $post["customActionType"] == "group_action") {
            $records["customActionStatus"] = $C_Acti_status; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = $Succesful_msg; // pass custom message(useful for getting status of group actions)
        }

        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;

        echo json_encode($records);
    }

}

/*
 * All Description for Reports
 * delete حذف حساب 
 * add اضاف
 * edit عدل
 */

// End Accounts
