<?php

defined('SYSPATH') or die('No direct script access.');

class Controller_Accounting_Payments extends Controller_Template_Base {

    public $Add = FALSE;
    public $Browse = FALSE;
    public $Edit = FALSE;
    public $Delete = FALSE;

    public function __construct(Request $request, Response $response) {
        // You must call parent::__construct at some point in your function
        parent::__construct($request, $response);
        // Do whatever else you want

        $this->Add =  $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'A_Financials_Payments')));
        $this->Browse =  $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'B_Financials_Payments')));
        // $this->Edit =  $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'E_Financials_Payments')));
        //$this->Delete =  $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'D_Financials_Payments')));
    }

    public function action_index() {
        if ($this->Add || $this->Browse || $this->Edit || $this->Delete) {
            $title = Lang::__('Accounting_Payments');
            $this->template->title = $title;
            $this->template->layout = new View('system/accounting/payments/view_all');
            $this->template->layout->title = $title;
            $this->template->layout->Add = $this->Add;
            $this->template->layout->lang = $this->lang;
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }

    public function action_AE() {

        $par1 = $this->request->param('par1');
        $par2 = $this->request->param('par2');

        $process_type = 'add_new';
        $Obj = ORM::factory('Accounting_Payments', $par1);

        if ($Obj->loaded()) {
            $process_type = 'modify';
        }

        if ((($this->Add && $process_type == 'add_new') || ($this->Edit && $process_type == 'modify')) && ($Obj->is_deleted == NULL)) {
            if ($process_type == 'add_new') {
                $Current_Term = ORM::factory('Study_Terms', ORM::factory('Variables', 78)->value);
            } elseif ($process_type == 'modify') {
                $Current_Term = ORM::factory('Study_Terms', $Obj->term);
            }
            if ($Current_Term->loaded()) {
                $this->template->layout = new View('system/accounting/payments/AE');

                if ($Obj->loaded()) {
                    $this->template->layout->Obj = $Obj;
                }
                $this->template->layout->title = Lang::__($process_type);
                $this->template->title = Lang::__($process_type);
                $this->template->layout->lang = $this->lang;
                $this->template->layout->Current_Term = $Current_Term;
                $this->template->layout->Users = Search::action_FindAll_To_Array(ORM::factory('User')->find_all());
            } else {
                $this->template->layout = new View('system/show_msg');
                $this->template->layout->class_color = 'danger';
                $this->template->layout->msg = Lang::__('undefined_current_term');
            }
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }

    public function action_Delete() {
        $results = array();

        if ($this->Delete) {
            $req = Request::current(); //fillter requset
            $Filtered_array = Search::action_Filtered_array($req->post());

            $Obj = ORM::factory('Accounting_Payments', $Filtered_array['id']);

            $CheckDeleteRules = $Obj->CheckDeleteRules();
            if ($CheckDeleteRules === TRUE) {
                try {
                    $Obj->is_deleted = 1;
                    $Obj->deleted_by = $this->user_online->id;
                    $Obj->deleted_date = date("Y-m-d H:i:s");
                    if ($Obj->save()) {
                        $results['Success'] = array(
                            'title' => Lang::__('Done'),
                            'content' => Lang::__('Deletion has been successfully'),
                        );
                    }
                } catch (ORM_Validation_Exception $e) {

                    $errors = $e->errors('');
                    $results['Errors'] = array(
                        'title' => Lang::__('Error'),
                        'content' => General::CatchErrorMSGSAjax($errors),
                    );
                }
            } else {
                if (is_array($CheckDeleteRules)) {

                    $results['Errors'] = array(
                        'title' => Lang::__('Error'),
                        'content' => General::ArrayToString($CheckDeleteRules),
                    );
                }
            }
        } else {
            $results['Errors'] = array(
                'title' => Lang::__('Error'),
                'content' => Lang::__('You_dont_have_permission_to_do_this_action'),
            );
        }

        echo json_encode($results);
    }

    public function action_ToDB() {
        $results = array();

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());
        $par1 = empty($Filtered_array['par1']) ? NULL : $Filtered_array['par1'];
        $par2 = empty($Filtered_array['par2']) ? NULL : $Filtered_array['par2'];

        $objj = ORM::factory('Accounting_Payments', $par1);
        if (!$objj->loaded()) {
            $objj->Created_by = $this->user_online->id;
            $objj->Created_date = date("Y-m-d H:i:s");
            $objj->term = ORM::factory('Study_Terms', ORM::factory('Variables', 78)->value)->id;
        } else {
            $objj->last_update_by = $this->user_online->id;
            $objj->last_update_date = date("Y-m-d H:i:s");

            $CurrentCash = $objj->Cash;
            $CurrentBank_Transfer = $objj->Bank_Transfer;
            $CurrentATM = $objj->ATM;
            $CurrentCheque = $objj->Cheque;
        }



        $objj->student = $Filtered_array['student'];




        $Current_Term = ORM::factory('Study_Terms', ORM::factory('Variables', 78)->value);
        $Prev_Payments = ORM::factory('Accounting_Payments')
                ->where('student', '=', $Filtered_array['student'])
                ->where('term', '=', $Current_Term->id)
                ->where('is_deleted', '=', NULL)
                ->find();
        if (!$Prev_Payments->loaded()) {
            $Current_Term_Cost = Model_Accounting_Payments::CalculateTermCost($Filtered_array['student'], $Current_Term);
            $min_to_pay = Model_Accounting_Payments::Check_min_Payment($Current_Term_Cost, $Current_Term, $Filtered_array['student']);
        }



        $Total_Paid = $Filtered_array['Cash'] + $Filtered_array['Bank_Transfer'] + $Filtered_array['ATM'] + $Filtered_array['Cheque'];
        //اذا كان الدفع الادنى مش مطلوب، او اذا كانت الدفعة اكثر من الحد الادنى في حال كان مطلوب
        if ((isset($min_to_pay) && ($Total_Paid >= $min_to_pay)) || !isset($min_to_pay)) {
            $objj->Cash = $Filtered_array['Cash'];
            $objj->Bank_Transfer = $Filtered_array['Bank_Transfer'];
            $objj->ATM = $Filtered_array['ATM'];
            $objj->Cheque = $Filtered_array['Cheque'];

            $objj->check_bank = $Filtered_array['check_bank'];
            $objj->check_number = $Filtered_array['check_number'];
            $objj->check_maturity_date = $Filtered_array['check_maturity_date'];

            //$objj->values($Filtered_array);

            try {
                if ($objj->save()) {

                    if (isset($CurrentCash) && $CurrentCash != $objj->Cash) {
                        $Log = ORM::factory('Students_Logs');
                        $Log->operation = 13;
                        $Log->old_int_val = $CurrentCash;
                        $Log->new_int_val = $objj->Cash;
                        $Log->ref_id = $objj->id;
                        $Log->Created_by = $this->user_online->id;
                        $Log->Created_date = date("Y-m-d H:i:s");
                        $Log->save();
                    }
                    if (isset($CurrentBank_Transfer) && $CurrentBank_Transfer != $objj->Bank_Transfer) {
                        $Log = ORM::factory('Students_Logs');
                        $Log->operation = 14;
                        $Log->old_int_val = $CurrentBank_Transfer;
                        $Log->new_int_val = $objj->Bank_Transfer;
                        $Log->ref_id = $objj->id;
                        $Log->Created_by = $this->user_online->id;
                        $Log->Created_date = date("Y-m-d H:i:s");
                        $Log->save();
                    }
                    if (isset($CurrentATM) && $CurrentATM != $objj->ATM) {
                        $Log = ORM::factory('Students_Logs');
                        $Log->operation = 15;
                        $Log->old_int_val = $CurrentATM;
                        $Log->new_int_val = $objj->ATM;
                        $Log->ref_id = $objj->id;
                        $Log->Created_by = $this->user_online->id;
                        $Log->Created_date = date("Y-m-d H:i:s");
                        $Log->save();
                    }
                    if (isset($CurrentCheque) && $CurrentCheque != $objj->Cheque) {
                        $Log = ORM::factory('Students_Logs');
                        $Log->operation = 16;
                        $Log->old_int_val = $CurrentCheque;
                        $Log->new_int_val = $objj->Cheque;
                        $Log->ref_id = $objj->id;
                        $Log->Created_by = $this->user_online->id;
                        $Log->Created_date = date("Y-m-d H:i:s");
                        $Log->save();
                    }

                    $Total_amount_paid = $objj->Cash + $objj->Bank_Transfer + $objj->ATM + $objj->Cheque;
                    $Term = ORM::factory('Study_Terms', $objj->term);
                    $amount_to_pay = Model_Accounting_Payments::CalculateTermCost($objj->student, $Term);
                    $amount_to_pay_after_discount = $amount_to_pay;
                    if (!empty($objj->discount_percent)) {
                        $amount_to_pay_after_discount = $amount_to_pay - (($amount_to_pay * $objj->discount_percent) / 100);
                    } elseif (!empty($objj->discount_amount)) {
                        $amount_to_pay_after_discount = $amount_to_pay - $objj->discount_amount;
                    }
                    $Remaining_amount = $amount_to_pay_after_discount - $Total_amount_paid;


                    $results['Success'] = array(
                        'theme' => 'lime', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
                        'horizontalEdge' => 'top', //top,bottom
                        'verticalEdge' => 'right', //right,left
                        'heading' => '',
                        'life' => '2000', //1000 is 1 second
                        'text' => Lang::__('Saved_successfully'),
                    );
                }
            } catch (ORM_Validation_Exception $e) {

                $errors = $e->errors('');
                $results['Errors'] = array(
                    'title' => Lang::__('Error'),
                    'content' => General::ArrayToString(General::CatchErrorMSGSAjax($errors))
                );
            }
        } else {
            $results['Errors'] = array(
                'title' => Lang::__('Error'),
                'content' => Lang::__('total_paid') . ' (' . $Total_Paid . ') ' . Lang::__('less_than_required_amount') . ' (' . $min_to_pay . ')'
            );
        }


        echo json_encode($results);
    }

    public function action_GetStudentFinancialInfo() {
        $results = array();

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());

        $id = empty($Filtered_array['id']) ? NULL : $Filtered_array['id']; //STUDENT ID

        $results['balance'] = Model_Accounting_Payments::CalculateStudentBalance($id);

        $Current_Term = ORM::factory('Study_Terms', ORM::factory('Variables', 78)->value);
        $results['amount_to_pay'] = Model_Accounting_Payments::CalculateTermCost($id, $Current_Term);

        $balance = Model_Accounting_Payments::CalculateStudentBalance($id);
        $results["balance"] = $balance;
        $Current_Term_Cost = Model_Accounting_Payments::CalculateTermCost($id, $Current_Term);
        $results["Current_Term_Cost"] = $Current_Term_Cost;
        $AmountReqToReg = $Current_Term_Cost - $balance;
        if ($AmountReqToReg < 0) {
            $AmountReqToReg = 0;
        }
        $RegTerm = ORM::factory('Students_Terms')
                ->where('student', '=', $id)
                ->where('term', '=', $Current_Term->id)
                ->where('is_deleted', '=', NULL)
                ->find();

        if ($RegTerm->loaded()) {
            $AmountReqToReg = 0;
        }

        //فحص الحد الادنى للدفع
        //فحص اذا قام بدفع دفعات سابقة
        $Prev_Payments = ORM::factory('Accounting_Payments')
                ->where('student', '=', $id)
                ->where('term', '=', $Current_Term->id)
                ->where('is_deleted', '=', NULL)
                ->find();
        if (!$Prev_Payments->loaded()) {
            $results["min_to_pay"] = Model_Accounting_Payments::Check_min_Payment($Current_Term_Cost, $Current_Term, $id);
        }




        $results["amount_to_pay"] = $AmountReqToReg;



        echo json_encode($results);
    }

    public function action_GetDiscountInfo() {
        $results = array();

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());

        $id = empty($Filtered_array['id']) ? NULL : $Filtered_array['id']; //Discount ID

        $Accounting_Discount = ORM::factory('Accounting_Discounts', $id);
        if ($Accounting_Discount->loaded()) {
            $results['discount_percent'] = $Accounting_Discount->discount_percent;
            $results['discount_amount'] = $Accounting_Discount->discount_amount;
        }



        echo json_encode($results);
    }

    public function action_GetData() {
        $post = $this->request->post();
        $order = $post['order']; //Get how table order from datatable
        /*
         * All coulums will shown in table
         */
        $ALL_coulums = array(
            1 => "id",
        );

        $All_ORM = ORM::factory('Accounting_Payments')
                ->where('is_deleted', '=', NULL)
                ->order_by($ALL_coulums[$order[0]['column']], $order[0]['dir']);



        $Succesful_msg = Lang::__('Action_successfully_has_been_completed_Well_done');
        $C_Acti_status = "OK";

        /*
         * If Action exists
         */
        if (isset($post['customActionName'])) {
            switch ($post['customActionName']) {
                case 'Delete':


                    break;


                default:
                    break;
            }
        }


        /*
         * if search exists
         */
        if (isset($post['action']) && (!is_array($post['action'])) && mb_strtolower($post['action']) == 'filter') {
            if (!empty($post['ID_No'])) {
                $ID_No = $post['ID_No'];
                $All_ORM->where(DB::expr('lower(`Student:Student_Information`.`ID_No`)'), 'LIKE', mb_strtolower("%$ID_No%"));
            }
            if (!empty($post['academic_no'])) {
                $academic_no = $post['academic_no'];
                $All_ORM->where(DB::expr('lower(`student`.`username`)'), 'LIKE', mb_strtolower("%$academic_no%"));
            }
            if (!empty($post['student'])) {
                $All_ORM->where('financials_payments.student', '=', $post['student']);
            }
            if (!empty($post['term'])) {
                $All_ORM->where('financials_payments.term', '=', $post['term']);
            }

            if (!empty($post['amount_from'])) {
                $All_ORM->where(DB::expr('`financials_payments`.`Cash`+`financials_payments`.`Bank_Transfer`+`financials_payments`.`ATM`+`financials_payments`.`Cheque`'), '>=', $post['amount_from']);
            }
            if (!empty($post['amount_to'])) {

                $All_ORM->where(DB::expr('`financials_payments`.`Cash`+`financials_payments`.`Bank_Transfer`+`financials_payments`.`ATM`+`financials_payments`.`Cheque`'), '<=', $post['amount_to']);
            }
        }

        /*
         * Paging
         */
        $All_ORM->reset(FALSE);
        $iTotalRecords = $All_ORM->count_all();

        $iDisplayLength = intval($post['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($post['start']);
        $sEcho = intval($post['draw']);

        $records = array();
        $records["data"] = array();

        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;

        $All_ORM->offset($iDisplayStart);
        $All_ORM->limit($iDisplayLength);



        /*
         * Prepare JSON Array
         */

        foreach ($All_ORM->find_all() as $value) {
            $buttons = '';
            ($this->Edit) ? $buttons.='<a href="' . URL::base() . 'Accounting_Payments/AE/' . $value->id . '" class="btn btn-xs default"><i class="fa fa-edit"></i> ' . Lang::__('Edit') . '</a>' : NULL;
            ($this->Delete && ($value->CheckDeleteRules() === TRUE)) ? $buttons.='<a par1="' . $value->id . '" Dtitle="' . Lang::__('Alert') . '" Dcontent="' . Lang::__('Are_you_sure_you_want_to_delete_it') . '" confirmButton="' . Lang::__('Yes') . '" cancelButton="' . Lang::__('Cancel') . '" class="btn btn-xs red Delete"> ' . Lang::__('Delete') . '</a>' : NULL;

            $records["data"][] = array(
                '<input type="checkbox" name="id[]" value="' . $value->id . '">',
                $value->Student->Student_Information->ID_No,
                $value->Student->{'name_' . $this->lang},
                $value->Student->username,
                $value->Term->{'name_' . $this->lang},
                $value->Cash + $value->Bank_Transfer + $value->ATM + $value->Cheque,
                $buttons,
            );
        }
        if (isset($post["customActionType"]) && $post["customActionType"] == "group_action") {
            $records["customActionStatus"] = $C_Acti_status; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = $Succesful_msg; // pass custom message(useful for getting status of group actions)
        }

        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;

        echo json_encode($records);
    }

}
