<?php

defined('SYSPATH') or die('No direct script access.');

class Controller_Accounting_links extends Controller_Template_Base {

    public $Link_Accounts = FALSE;

    public function __construct(Request $request, Response $response) {
        // You must call parent::__construct at some point in your function
        parent::__construct($request, $response);
        // Do whatever else you want

        $this->Link_Accounts = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'Link_Accounts')));
    }

    public function action_index() {
        if ($this->Link_Accounts) {
            $title = Lang::__('Link accounts');
            $this->template->title = $title;
            $this->template->layout = new View('system/accounting/link/link_page');
            $this->template->layout->title = $title;
            $this->template->layout->Accounts = ORM::factory('Accounting_Accounts')->where('is_deleted', '=', NULL)->find_all();
            $this->template->layout->Accounting_Links = ORM::factory('Accounting_Links')->where('is_deleted', '=', NULL)->find_all();
            $this->template->layout->lang = $this->lang;
        }
    }

    public function action_ToDB() {
        if ($this->Link_Accounts) {
            $results = array();

            $req = Request::current(); //fillter requset
            $Filtered_array = Search::action_Filtered_array($req->post());
            $par1 = empty($Filtered_array['par1']) ? NULL : $Filtered_array['par1'];
            $par2 = empty($Filtered_array['par2']) ? NULL : $Filtered_array['par2'];

            foreach ($Filtered_array as $key => $value) {
                $exp = explode('_', $key);
                if (!empty($exp[1])) {
                    $objj = ORM::factory('Accounting_Links', $exp[1]);
                    if (!$objj->loaded()) {
                        $objj->Created_by = $this->user_online->id;
                        $objj->Created_date = date("Y-m-d H:i:s");
                    } else {
                        $objj->last_update_by = $this->user_online->id;
                        $objj->last_update_date = date("Y-m-d H:i:s");
                    }
                    $objj->account_id = $value;


                    try {
                        if ($objj->save()) {

                            $results['Success'] = array(
                                'theme' => 'lime', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
                                'horizontalEdge' => 'top', //top,bottom
                                'verticalEdge' => 'right', //right,left
                                'heading' => '',
                                'life' => '2000', //1000 is 1 second
                                'text' => Lang::__('Saved_successfully'),
                            );
                        }
                    } catch (ORM_Validation_Exception $e) {

                        $errors = $e->errors('');
                        $results['Errors'] = array(
                            "title" => Lang::__('Error'),
                            "content" => General::CatchErrorMSGSAjax($errors),
                        );
                    }
                }
            }





            echo json_encode($results);
        }
    }

}

// End Settings
