

jQuery(document).ready(function () {
    $('.date-picker').datepicker({
            rtl: App.isRTL(),
            autoclose: true
        });
    var form3 = $('#contactForm');
    form3.submit(function(e){
        e.preventDefault();
        
        
         var data = new FormData(form3[0]);
                data.append('attachments', $('input[type=file]')[0].files[0]);
                data.append('par1', form3.attr("par1"));
                data.append('par2', form3.attr("par2"));
                $.ajax({
                    type: "POST",
                    url: URLBase + "Messages/Send",
                    data: data,
                    //async: false,
                    cache: false,
                    contentType: false,
                    processData: false,
                    dataType: "JSON",
                    beforeSend: function () {
                        $("#contactForm :input").prop("disabled", true);
                        $("#submit-buttons").addClass('hidden');
                        $("#spinner").removeClass('hidden');
                        App.blockUI({
                            target: '#SForm',
                            overlayColor: 'none',
                            cenrerY: true,
                            animate: true
                        });
                    },
                    complete: function () {
                        $("#SForm :input").prop("disabled", false);
                        $("#submit-buttons").removeClass('hidden');
                        $("#spinner").addClass('hidden');
                        App.unblockUI('#SForm');
                    },
                    success: function (response)
                    {
                        if (response !== null && response.hasOwnProperty("Errors")) {
                                //console.log(response['Errors']);
                            var obj = response["Errors"];
                            var stringerror = '';
                            for (var prop in obj) {
                                stringerror += '* ' + obj[prop] + '</br>';
                            }
                            $('#Server_alerts').html(stringerror);
                            $('.Server_alerts').removeClass('hidden');
                            $("html,body").animate({scrollTop: $('#Server_alerts').offset().top - 100}, "slow");

                        }

                        else if (response !== null && response.hasOwnProperty("Success")) {
                            $('.Server_alerts').addClass('hidden');
                            $("#submit-buttons").remove();
                            var Res = response['Success'];
                            
                            $('#Server_alerts').html(Res.text);
                            $('.Server_alerts').removeClass('hidden');
                            $("html,body").animate({scrollTop: $('#Server_alerts').offset().top - 100}, "slow");
                            setTimeout(function () {
                                window.location.replace(URLBase );
                            }, 3000);
                        }
                    }
                });
       
    });
});