var ValidationFunctions = function () {

    var Cancel_Application = function () {
        $(document).on('click', '.Cancel_Application', function () {
            var el = $(this);
            $.confirm({
                title: el.attr('Dtitle'),
                content: el.attr('Dcontent'),
                type: 'red',
                buttons: {
                    confirm: {
                        text: el.attr('confirmButton'),
                        btnClass: 'btn-danger',
                        keys: ['enter'],
                        action: function () {
                            $.ajax({
                                type: "POST",
                                url: URLBase + "Onlinereg/Cancel_Adm_App",
                                data: {par1: $("#SForm").attr('par1')},
                                //async: false,
                                cache: false,
                                dataType: "JSON",
                                beforeSend: function () {
                                    $.blockUI({
                                        message: Lang.Please_wait,
                                        css: {
                                            border: 'none',
                                            padding: '15px',
                                            backgroundColor: '#000',
                                            '-webkit-border-radius': '10px',
                                            '-moz-border-radius': '10px',
                                            opacity: .5,
                                            color: '#fff'
                                        }});
                                },
                                complete: function () {
                                    $.unblockUI();
                                },
                                error: function (xhr, ajaxOptions, thrownError) {
                                    $.alert({
                                        title: Lang.Error,
                                        content: xhr.status + " - " + thrownError,
                                        type: 'red',
                                        rtl: App.isRTL(),
                                        closeIcon: true,
                                        buttons: {
                                            cancel: {
                                                text: Lang.Ok,
                                                action: function () {
                                                }
                                            }
                                        }
                                    });
                                },
                                success: function (response)
                                {
                                    if (response !== null && response.hasOwnProperty("Success")) {

                                        var Res = response['Success'];
                                        $.alert({
                                            title: Res.title,
                                            content: Res.content,
                                            autoClose: 'cancel|10000',
                                            type: 'green',
                                            rtl: App.isRTL(),
                                            closeIcon: true,
                                            buttons: {
                                                cancel: {
                                                    text: Lang.Ok,
                                                    action: function () {
                                                        location.reload();
                                                    }
                                                }
                                            }
                                        });

                                    } else if (response !== null && response.hasOwnProperty("Errors")) {


                                        var Error = response['Errors'];
                                        $.alert({
                                            title: Error.title,
                                            content: Error.content,
                                            type: 'red',
                                            rtl: App.isRTL(),
                                            closeIcon: true,
                                            buttons: {
                                                cancel: {
                                                    text: Lang.Ok,
                                                    action: function () {
                                                    }
                                                }
                                            }
                                        });

                                    }

                                }
                            });
                        }
                    },
                    cancel: {
                        text: el.attr('cancelButton'),
                        keys: ['esc'],
                        action: function () {
                        }
                    },
                }
            });
            $.ajax({
                type: "POST",
                url: URLBase + "Onlinereg/UpdateField",
                data: {field_selector: field_selector, field_val: field_val, par1: $("#SForm").attr('par1')},
                //async: false,
                cache: false,
                dataType: "JSON",
                beforeSend: function () {
                    $.blockUI({
                        message: Lang.Please_wait,
                        css: {
                            border: 'none',
                            padding: '15px',
                            backgroundColor: '#000',
                            '-webkit-border-radius': '10px',
                            '-moz-border-radius': '10px',
                            opacity: .5,
                            color: '#fff'
                        }});
                },
                complete: function () {
                    $.unblockUI();
                },
                error: function (xhr, ajaxOptions, thrownError) {
                    $.alert({
                        title: Lang.Error,
                        content: xhr.status + " - " + thrownError,
                        type: 'red',
                        rtl: App.isRTL(),
                        closeIcon: true,
                        buttons: {
                            cancel: {
                                text: Lang.Ok,
                                action: function () {
                                }
                            }
                        }
                    });
                },
                success: function (response)
                {
                    if (response !== null && response.hasOwnProperty("Success")) {

                        var Res = response['Success'];
                        $.alert({
                            title: Res.title,
                            content: Res.content,
                            autoClose: 'cancel|10000',
                            type: 'green',
                            rtl: App.isRTL(),
                            closeIcon: true,
                            buttons: {
                                cancel: {
                                    text: Lang.Ok,
                                    action: function () {
                                    }
                                }
                            }
                        });

                    } else if (response !== null && response.hasOwnProperty("Errors")) {


                        var Error = response['Errors'];
                        $.alert({
                            title: Error.title,
                            content: Error.content,
                            type: 'red',
                            rtl: App.isRTL(),
                            closeIcon: true,
                            buttons: {
                                cancel: {
                                    text: Lang.Ok,
                                    action: function () {
                                    }
                                }
                            }
                        });

                    }

                }
            });

        });
    }
    var UpdateFields = function () {
        $(document).on('click', '.update_field', function () {
            var el = $(this);
            var field_selector = el.attr('field');
            var field_val = $('#' + field_selector).val();

            $.ajax({
                type: "POST",
                url: URLBase + "Onlinereg/UpdateField",
                data: {field_selector: field_selector, field_val: field_val, par1: $("#SForm").attr('par1')},
                //async: false,
                cache: false,
                dataType: "JSON",
                beforeSend: function () {
                    $.blockUI({
                        message: Lang.Please_wait,
                        css: {
                            border: 'none',
                            padding: '15px',
                            backgroundColor: '#000',
                            '-webkit-border-radius': '10px',
                            '-moz-border-radius': '10px',
                            opacity: .5,
                            color: '#fff'
                        }});
                },
                complete: function () {
                    $.unblockUI();
                },
                error: function (xhr, ajaxOptions, thrownError) {
                    $.alert({
                        title: Lang.Error,
                        content: xhr.status + " - " + thrownError,
                        type: 'red',
                        rtl: App.isRTL(),
                        closeIcon: true,
                        buttons: {
                            cancel: {
                                text: Lang.Ok,
                                action: function () {
                                }
                            }
                        }
                    });
                },
                success: function (response)
                {
                    if (response !== null && response.hasOwnProperty("Success")) {

                        var Res = response['Success'];
                        $.alert({
                            title: Res.title,
                            content: Res.content,
                            autoClose: 'cancel|10000',
                            type: 'green',
                            rtl: App.isRTL(),
                            closeIcon: true,
                            buttons: {
                                cancel: {
                                    text: Lang.Ok,
                                    action: function () {
                                    }
                                }
                            }
                        });

                    } else if (response !== null && response.hasOwnProperty("Errors")) {


                        var Error = response['Errors'];
                        $.alert({
                            title: Error.title,
                            content: Error.content,
                            type: 'red',
                            rtl: App.isRTL(),
                            closeIcon: true,
                            buttons: {
                                cancel: {
                                    text: Lang.Ok,
                                    action: function () {
                                    }
                                }
                            }
                        });

                    }

                }
            });

        });
    }
    var DateConverter = function () {
        function convertDates(calender, selector) {
            try {
                var jd = $.calendars.instance(calender).newDate(
                        parseInt($('#' + selector + 'year').val(), 10),
                        parseInt($('#' + selector + 'month').val(), 10),
                        parseInt($('#' + selector + 'day').val(), 10)).toJD();
            } catch (e) {
                alert(e);
                return;
            }
            //$('#jDate').val(jd);

            showDate('gregorian', jd, selector);


        }

        function showDate(name, jd, selector) {
            try {

                var date = $.calendars.instance(name).fromJD(jd);
                $('#' + selector + 'year_gregorian').val(date.formatYear());
                $('#' + selector + 'month_gregorian').val(date.month());
                $('#' + selector + 'day_gregorian').val(date.day());

                return date.extraInfo();
            } catch (e) {
                alert(e);
                return null;
            }
        }
        function convertDatesToHigri(calender, selector) {
            try {
                var jd = $.calendars.instance(calender).newDate(
                        parseInt($('#' + selector + 'year_gregorian').val(), 10),
                        parseInt($('#' + selector + 'month_gregorian').val(), 10),
                        parseInt($('#' + selector + 'day_gregorian').val(), 10)).toJD();
            } catch (e) {
                alert(e);
                return;
            }
            //$('#jDate').val(jd);

            showDateToHigri('ummalqura', jd, selector);


        }

        function showDateToHigri(name, jd, selector) {
            try {

                var date = $.calendars.instance(name).fromJD(jd);
                $('#' + selector + 'year').val(date.formatYear());
                $('#' + selector + 'month').val(date.month());
                $('#' + selector + 'day').val(date.day());

                return date.extraInfo();
            } catch (e) {
                alert(e);
                return null;
            }
        }
        $('#bd_day, #bd_month, #bd_year').change(function () {
            var bd_day = parseInt($('#bd_day').val());
            var bd_month = parseInt($('#bd_month').val());
            var bd_year = parseInt($('#bd_year').val());

            if ((Math.floor(bd_day) == bd_day && $.isNumeric(bd_day) && bd_day > 0) && (Math.floor(bd_month) == bd_month && $.isNumeric(bd_month) && bd_month > 0) && (Math.floor(bd_year) == bd_year && $.isNumeric(bd_year) && bd_year > 0)) {
                convertDates("ummalqura", "bd_");

            }
        });
        $('#bd_day_gregorian, #bd_month_gregorian, #bd_year_gregorian').change(function () {
            var bd_day_gregorian = parseInt($('#bd_day_gregorian').val());
            var bd_month_gregorian = parseInt($('#bd_month_gregorian').val());
            var bd_year_gregorian = parseInt($('#bd_year_gregorian').val());

            if ((Math.floor(bd_day_gregorian) == bd_day_gregorian && $.isNumeric(bd_day_gregorian) && bd_day_gregorian > 0) && (Math.floor(bd_month_gregorian) == bd_month_gregorian && $.isNumeric(bd_month_gregorian) && bd_month_gregorian > 0) && (Math.floor(bd_year_gregorian) == bd_year_gregorian && $.isNumeric(bd_year_gregorian) && bd_year_gregorian > 0)) {
                convertDatesToHigri("gregorian", "bd_");

            }
        });
        $('#ID_Expiry_day, #ID_Expiry_month, #ID_Expiry_year').change(function () {
            var ID_Expiry_day = parseInt($('#ID_Expiry_day').val());
            var ID_Expiry_month = parseInt($('#ID_Expiry_month').val());
            var ID_Expiry_year = parseInt($('#ID_Expiry_year').val());

            if ((Math.floor(ID_Expiry_day) == ID_Expiry_day && $.isNumeric(ID_Expiry_day) && ID_Expiry_day > 0) && (Math.floor(ID_Expiry_month) == ID_Expiry_month && $.isNumeric(ID_Expiry_month) && ID_Expiry_month > 0) && (Math.floor(ID_Expiry_year) == ID_Expiry_year && $.isNumeric(ID_Expiry_year) && ID_Expiry_year > 0)) {
                convertDates("ummalqura", "ID_Expiry_");

            }
        });
        $('#ID_Expiry_day_gregorian, #ID_Expiry_month_gregorian, #ID_Expiry_year_gregorian').change(function () {
            var ID_Expiry_day_gregorian = parseInt($('#ID_Expiry_day_gregorian').val());
            var ID_Expiry_month_gregorian = parseInt($('#ID_Expiry_month_gregorian').val());
            var ID_Expiry_year_gregorian = parseInt($('#ID_Expiry_year_gregorian').val());

            if ((Math.floor(ID_Expiry_day_gregorian) == ID_Expiry_day_gregorian && $.isNumeric(ID_Expiry_day_gregorian) && ID_Expiry_day_gregorian > 0) && (Math.floor(ID_Expiry_month_gregorian) == ID_Expiry_month_gregorian && $.isNumeric(ID_Expiry_month_gregorian) && ID_Expiry_month_gregorian > 0) && (Math.floor(ID_Expiry_year_gregorian) == ID_Expiry_year_gregorian && $.isNumeric(ID_Expiry_year_gregorian) && ID_Expiry_year_gregorian > 0)) {
                convertDatesToHigri("gregorian", "ID_Expiry_");

            }
        });

    }
    var StepA = function () {
        var StepA_Form = $('#StepA_Form');
        if (StepA_Form.length) {
            DateConverter();
            // for more info visit the official plugin documentation: 
            // http://docs.jquery.com/Plugins/Validation

            var error3 = $('.alert-danger', StepA_Form);
            var success3 = $('.alert-success', StepA_Form);

            //IMPORTANT: update CKEDITOR textarea with actual content before submit
//            StepA_Form.on('submit', function() {
//                for(var instanceName in CKEDITOR.instances) {
//                    CKEDITOR.instances[instanceName].updateElement();
//                }
//            })

            StepA_Form.validate({
                lang: Lang.theLang,
                onkeyup: function (element) {
                    this.element(element);  // <- "eager validation"
                },
                onfocusout: function (element) {
                    this.element(element);  // <- "eager validation"
                },
                errorElement: 'span', //default input error message container
                errorClass: 'help-block help-block-error', // default input error message class
                focusInvalid: false, // do not focus the last invalid input
                ignore: "", // validate all fields including form hidden input
                rules: App.GetFormRules("Onlinereg/StepRules", {par1: StepA_Form.attr("par1"), par2: 'A'}),
                messages: {// custom messages for radio buttons and checkboxes

                },
                errorPlacement: function (error, element) { // render error placement for each input type
                    if (element.parent(".input-group").size() > 0) {
                        error.insertAfter(element.parent(".input-group"));
                    } else if (element.attr("data-error-container")) {
                        error.appendTo(element.attr("data-error-container"));
                    } else if (element.parents('.radio-list').size() > 0) {
                        error.appendTo(element.parents('.radio-list').attr("data-error-container"));
                    } else if (element.parents('.radio-inline').size() > 0) {
                        error.appendTo(element.parents('.radio-inline').attr("data-error-container"));
                    } else if (element.parents('.checkbox-list').size() > 0) {
                        error.appendTo(element.parents('.checkbox-list').attr("data-error-container"));
                    } else if (element.parents('.checkbox-inline').size() > 0) {
                        error.appendTo(element.parents('.checkbox-inline').attr("data-error-container"));
                    } else {
                        error.insertAfter(element); // for other inputs, just perform default behavior
                    }
                },
                invalidHandler: function (event, validator) { //display error alert on form submit   
                    success3.addClass('hidden');
                    error3.removeClass('hidden');

                    $("html,body").animate({scrollTop: $('#StepA_Form').offset().top - 100}, "slow");
                    // $(".box-content").animate({ scrollTop: 0 }, "slow");
                },
                highlight: function (element) { // hightlight error inputs
                    $(element).parent().addClass('has-error'); // set error class to the control group
                },
                unhighlight: function (element) { // revert the change done by hightlight
                    $(element).parent().removeClass('has-error'); // set error class to the control group
                },
                success: function (label) {
                    label.parent().removeClass('has-error'); // set success class to the control group
                },
                submitHandler: function (form) {
                    success3.addClass('hidden');
                    error3.addClass('hidden');
                    var theForm = $('#StepA_Form');
                    //upload files
                    var data = new FormData(theForm[0]);

//                jQuery.each(jQuery('#file')[0].files, function (i, file) {
//                    data.append('file-' + i, file);
//                });
                    data.append('par1', StepA_Form.attr("par1"));
                    $.ajax({
                        type: "POST",
                        url: URLBase + "Onlinereg/StepAToDB",
                        data: data,
                        //async: false,
                        cache: false,
                        contentType: false,
                        processData: false,
                        dataType: "JSON",
                        beforeSend: function () {
                            $.blockUI({
                                message: Lang.Please_wait,
                                css: {
                                    border: 'none',
                                    padding: '15px',
                                    backgroundColor: '#000',
                                    '-webkit-border-radius': '10px',
                                    '-moz-border-radius': '10px',
                                    opacity: .5,
                                    color: '#fff'
                                }});
                            $("#StepA_Form :input").prop("disabled", true);
                            $("#submit-buttons").addClass('hidden');
                        },
                        complete: function () {
                            $.unblockUI();
                            $("#StepA_Form :input").prop("disabled", false);
                            $("#submit-buttons").removeClass('hidden');
                        },
                        error: function (xhr, ajaxOptions, thrownError) {
                            $.alert({
                                title: Lang.Error,
                                content: xhr.status + " - " + thrownError,
                                type: 'red',
                                rtl: App.isRTL(),
                                closeIcon: true,
                                buttons: {
                                    cancel: {
                                        text: Lang.Ok,
                                        action: function () {
                                        }
                                    }
                                }
                            });
                        },
                        success: function (response)
                        {
                            error3.addClass('hidden');
                            success3.addClass('hidden');

                            if (response !== null && response.hasOwnProperty("Errors")) {
                                //console.log(response['Errors']);
                                var obj = response["Errors"];
                                var stringerror = '';
                                for (var prop in obj) {
                                    stringerror += '* ' + obj[prop] + '</br>';
                                }
                                $('#Server_alerts').html(stringerror);
                                $('.Server_alerts').removeClass('hidden');

                            } else if (response !== null && response.hasOwnProperty("Success")) {
                                $('.Server_alerts').addClass('hidden');
                                Success = response.Success;
                                $('#StepA_Form').html('');

                                $('#Server_alerts_done').html(Success.text);
                                $('.Done-Alert').removeClass('hidden');
                                $("html,body").animate({scrollTop: $('#Server_alerts_done').offset().top - 130}, "slow");

                                window.location.replace(response.RedURL);


                            }
                        }
                    });
                    //form[0].submit(); // submit the form
                }

            });

            //apply validation on select2 dropdown value change, this only needed for chosen dropdown integration.
            $('.select2', StepA_Form).change(function () {
                StepA_Form.validate().element($(this)); //revalidate the chosen dropdown value and show error or success message for the input
            });

        }
    }
    var StepB = function () {


        var StepB_Form = $('#StepB_Form');
        if (StepB_Form.length) {
            var error3 = $('.alert-danger', StepB_Form);
            var success3 = $('.alert-success', StepB_Form);

            //IMPORTANT: update CKEDITOR textarea with actual content before submit
//            StepB_Form.on('submit', function() {
//                for(var instanceName in CKEDITOR.instances) {
//                    CKEDITOR.instances[instanceName].updateElement();
//                }
//            })

            StepB_Form.validate({
                lang: Lang.theLang,
                onkeyup: function (element) {
                    this.element(element);  // <- "eager validation"
                },
                onfocusout: function (element) {
                    this.element(element);  // <- "eager validation"
                },
                errorElement: 'span', //default input error message container
                errorClass: 'help-block help-block-error', // default input error message class
                focusInvalid: false, // do not focus the last invalid input
                ignore: "", // validate all fields including form hidden input
                rules: App.GetFormRules("Onlinereg/StepRules", {par1: StepB_Form.attr("par1"), par2: 'B'}),
                messages: {// custom messages for radio buttons and checkboxes

                },
                errorPlacement: function (error, element) { // render error placement for each input type
                    if (element.parent(".input-group").size() > 0) {
                        error.insertAfter(element.parent(".input-group"));
                    } else if (element.attr("data-error-container")) {
                        error.appendTo(element.attr("data-error-container"));
                    } else if (element.parents('.radio-list').size() > 0) {
                        error.appendTo(element.parents('.radio-list').attr("data-error-container"));
                    } else if (element.parents('.radio-inline').size() > 0) {
                        error.appendTo(element.parents('.radio-inline').attr("data-error-container"));
                    } else if (element.parents('.checkbox-list').size() > 0) {
                        error.appendTo(element.parents('.checkbox-list').attr("data-error-container"));
                    } else if (element.parents('.checkbox-inline').size() > 0) {
                        error.appendTo(element.parents('.checkbox-inline').attr("data-error-container"));
                    } else {
                        error.insertAfter(element); // for other inputs, just perform default behavior
                    }
                },
                invalidHandler: function (event, validator) { //display error alert on form submit   
                    success3.addClass('hidden');
                    error3.removeClass('hidden');

                    $("html,body").animate({scrollTop: $('#StepB_Form').offset().top - 100}, "slow");
                    // $(".box-content").animate({ scrollTop: 0 }, "slow");
                },
                highlight: function (element) { // hightlight error inputs
                    $(element).parent().addClass('has-error'); // set error class to the control group
                },
                unhighlight: function (element) { // revert the change done by hightlight
                    $(element).parent().removeClass('has-error'); // set error class to the control group
                },
                success: function (label) {
                    label.parent().removeClass('has-error'); // set success class to the control group
                },
                submitHandler: function (form) {
                    success3.addClass('hidden');
                    error3.addClass('hidden');
                    var theForm = $('#StepB_Form');
                    //upload files
                    var data = new FormData(theForm[0]);

//                jQuery.each(jQuery('#file')[0].files, function (i, file) {
//                    data.append('file-' + i, file);
//                });
                    data.append('par1', StepB_Form.attr("par1"));
                    $.ajax({
                        type: "POST",
                        url: URLBase + "Onlinereg/StepBToDB",
                        data: data,
                        //async: false,
                        cache: false,
                        contentType: false,
                        processData: false,
                        dataType: "JSON",
                        beforeSend: function () {
                            $.blockUI({
                                message: Lang.Please_wait,
                                css: {
                                    border: 'none',
                                    padding: '15px',
                                    backgroundColor: '#000',
                                    '-webkit-border-radius': '10px',
                                    '-moz-border-radius': '10px',
                                    opacity: .5,
                                    color: '#fff'
                                }});
                            $("#StepB_Form :input").prop("disabled", true);
                            $("#submit-buttons").addClass('hidden');
                        },
                        complete: function () {
                            $.unblockUI();
                            $("#StepB_Form :input").prop("disabled", false);
                            $("#submit-buttons").removeClass('hidden');
                        },
                        error: function (xhr, ajaxOptions, thrownError) {
                            $.alert({
                                title: Lang.Error,
                                content: xhr.status + " - " + thrownError,
                                type: 'red',
                                rtl: App.isRTL(),
                                closeIcon: true,
                                buttons: {
                                    cancel: {
                                        text: Lang.Ok,
                                        action: function () {
                                        }
                                    }
                                }
                            });
                        },
                        success: function (response)
                        {
                            error3.addClass('hidden');
                            success3.addClass('hidden');

                            if (response !== null && response.hasOwnProperty("Errors")) {
                                //console.log(response['Errors']);
                                var obj = response["Errors"];
                                var stringerror = '';
                                for (var prop in obj) {
                                    stringerror += '* ' + obj[prop] + '</br>';
                                }
                                $('#Server_alerts').html(stringerror);
                                $('.Server_alerts').removeClass('hidden');

                            } else if (response !== null && response.hasOwnProperty("Success")) {
                                $('.Server_alerts').addClass('hidden');
                                Success = response.Success;
                                $('#StepB_Form').html('');

                                $('#Server_alerts_done').html(Success.text);
                                $('.Done-Alert').removeClass('hidden');
                                $("html,body").animate({scrollTop: $('#Server_alerts_done').offset().top - 130}, "slow");

                                window.location.replace(response.RedURL);


                            }
                        }
                    });
                    //form[0].submit(); // submit the form
                }

            });

            //apply validation on select2 dropdown value change, this only needed for chosen dropdown integration.
            $('.select2', StepB_Form).change(function () {
                StepB_Form.validate().element($(this)); //revalidate the chosen dropdown value and show error or success message for the input
            });

        }
    }
    var StepC = function () {
        // for more info visit the official plugin documentation: 
        // http://docs.jquery.com/Plugins/Validation

        var StepC_Form = $('#StepC_Form');
        if (StepC_Form.length) {



            $("#hs_City").on("select2:open", function (e) {
                var hs_Country = $("#hs_Country").val();
                if (!hs_Country) {
                    $.alert({
                        title: Lang.Alert,
                        content: $("#hs_City").attr("msg1"),
                        type: 'orange',
                        autoClose: 'cancel|5000',
                        rtl: App.isRTL(),
                        closeIcon: true,
                        buttons: {
                            cancel: {
                                text: Lang.Ok,
                                action: function () {
                                }
                            }
                        }
                    });
                }
            });


            $("#hs_Country").on("change", function () {
                var id = $(this).val();
                if (id) {
                    $.ajax({
                        type: "POST",
                        url: URLBase + "Ajax/GetCities",
                        data: {id: id},
                        async: false,
                        cache: false,
                        dataType: "JSON",
                        beforeSend: function () {
                            $.blockUI({
                                message: Lang.Please_wait,
                                css: {
                                    border: 'none',
                                    padding: '15px',
                                    backgroundColor: '#000',
                                    '-webkit-border-radius': '10px',
                                    '-moz-border-radius': '10px',
                                    opacity: .5,
                                    color: '#fff'
                                }});
                        },
                        complete: function () {
                            $.unblockUI();
                        },
                        success: function (response)
                        {

                            if (response !== null && response.hasOwnProperty("Errors")) {
                                alert('Error!');
                            } else if (response !== null && response.hasOwnProperty("Cities")) {
                                var Cities = response['Cities'];
                                var html = '<option value=""></option>';
                                $.each(Cities, function (index, value) {
                                    html += '<option value="' + index + '">' + value + '</option>';
                                });

                                $("#hs_City").select2('val', 'All');
                                $("#hs_City").html(html);
                            }
                        }
                    });
                } else {
                    $("#hs_City").html("");
                }
            });

            var error3 = $('.alert-danger', StepC_Form);
            var success3 = $('.alert-success', StepC_Form);

            //IMPORTANT: update CKEDITOR textarea with actual content before submit
//            StepC_Form.on('submit', function() {
//                for(var instanceName in CKEDITOR.instances) {
//                    CKEDITOR.instances[instanceName].updateElement();
//                }
//            })

            StepC_Form.validate({
                lang: Lang.theLang,
                onkeyup: function (element) {
                    this.element(element);  // <- "eager validation"
                },
                onfocusout: function (element) {
                    this.element(element);  // <- "eager validation"
                },
                errorElement: 'span', //default input error message container
                errorClass: 'help-block help-block-error', // default input error message class
                focusInvalid: false, // do not focus the last invalid input
                ignore: "", // validate all fields including form hidden input
                rules: App.GetFormRules("Onlinereg/StepRules", {par1: StepC_Form.attr("par1"), par2: 'C'}),
                messages: {// custom messages for radio buttons and checkboxes

                },
                errorPlacement: function (error, element) { // render error placement for each input type
                    if (element.parent(".input-group").size() > 0) {
                        error.insertAfter(element.parent(".input-group"));
                    } else if (element.attr("data-error-container")) {
                        error.appendTo(element.attr("data-error-container"));
                    } else if (element.parents('.radio-list').size() > 0) {
                        error.appendTo(element.parents('.radio-list').attr("data-error-container"));
                    } else if (element.parents('.radio-inline').size() > 0) {
                        error.appendTo(element.parents('.radio-inline').attr("data-error-container"));
                    } else if (element.parents('.checkbox-list').size() > 0) {
                        error.appendTo(element.parents('.checkbox-list').attr("data-error-container"));
                    } else if (element.parents('.checkbox-inline').size() > 0) {
                        error.appendTo(element.parents('.checkbox-inline').attr("data-error-container"));
                    } else {
                        error.insertAfter(element); // for other inputs, just perform default behavior
                    }
                },
                invalidHandler: function (event, validator) { //display error alert on form submit   
                    success3.addClass('hidden');
                    error3.removeClass('hidden');

                    $("html,body").animate({scrollTop: $('#StepC_Form').offset().top - 100}, "slow");
                    // $(".box-content").animate({ scrollTop: 0 }, "slow");
                },
                highlight: function (element) { // hightlight error inputs
                    $(element).parent().addClass('has-error'); // set error class to the control group
                },
                unhighlight: function (element) { // revert the change done by hightlight
                    $(element).parent().removeClass('has-error'); // set error class to the control group
                },
                success: function (label) {
                    label.parent().removeClass('has-error'); // set success class to the control group
                },
                submitHandler: function (form) {
                    success3.addClass('hidden');
                    error3.addClass('hidden');
                    var theForm = $('#StepC_Form');
                    //upload files
                    var data = new FormData(theForm[0]);

//                jQuery.each(jQuery('#file')[0].files, function (i, file) {
//                    data.append('file-' + i, file);
//                });
                    data.append('par1', StepC_Form.attr("par1"));
                    $.ajax({
                        type: "POST",
                        url: URLBase + "Onlinereg/StepCToDB",
                        data: data,
                        //async: false,
                        cache: false,
                        contentType: false,
                        processData: false,
                        dataType: "JSON",
                        beforeSend: function () {
                            $.blockUI({
                                message: Lang.Please_wait,
                                css: {
                                    border: 'none',
                                    padding: '15px',
                                    backgroundColor: '#000',
                                    '-webkit-border-radius': '10px',
                                    '-moz-border-radius': '10px',
                                    opacity: .5,
                                    color: '#fff'
                                }});
                            $("#StepC_Form :input").prop("disabled", true);
                            $("#submit-buttons").addClass('hidden');
                        },
                        complete: function () {
                            $.unblockUI();
                            $("#StepC_Form :input").prop("disabled", false);
                            $("#submit-buttons").removeClass('hidden');
                        },
                        error: function (xhr, ajaxOptions, thrownError) {
                            $.alert({
                                title: Lang.Error,
                                content: xhr.status + " - " + thrownError,
                                type: 'red',
                                rtl: App.isRTL(),
                                closeIcon: true,
                                buttons: {
                                    cancel: {
                                        text: Lang.Ok,
                                        action: function () {
                                        }
                                    }
                                }
                            });
                        },
                        success: function (response)
                        {
                            error3.addClass('hidden');
                            success3.addClass('hidden');

                            if (response !== null && response.hasOwnProperty("Errors")) {
                                //console.log(response['Errors']);
                                var obj = response["Errors"];
                                var stringerror = '';
                                for (var prop in obj) {
                                    stringerror += '* ' + obj[prop] + '</br>';
                                }
                                $('#Server_alerts').html(stringerror);
                                $('.Server_alerts').removeClass('hidden');

                            } else if (response !== null && response.hasOwnProperty("Success")) {
                                $('.Server_alerts').addClass('hidden');
                                Success = response.Success;
                                $('#StepC_Form').html('');

                                $('#Server_alerts_done').html(Success.text);
                                $('.Done-Alert').removeClass('hidden');
                                $("html,body").animate({scrollTop: $('#Server_alerts_done').offset().top - 130}, "slow");

                                window.location.replace(response.RedURL);


                            }
                        }
                    });
                    //form[0].submit(); // submit the form
                }

            });

            //apply validation on select2 dropdown value change, this only needed for chosen dropdown integration.
            $('.select2', StepC_Form).change(function () {
                StepC_Form.validate().element($(this)); //revalidate the chosen dropdown value and show error or success message for the input
            });

        }
    }
    var StepD = function () {
        // for more info visit the official plugin documentation: 
        // http://docs.jquery.com/Plugins/Validation

        var StepD_Form = $('#StepD_Form');
        if (StepD_Form.length) {


            var error3 = $('.alert-danger', StepD_Form);
            var success3 = $('.alert-success', StepD_Form);

            //IMPORTANT: update CKEDITOR textarea with actual content before submit
//            StepD_Form.on('submit', function() {
//                for(var instanceName in CKEDITOR.instances) {
//                    CKEDITOR.instances[instanceName].updateElement();
//                }
//            })

            StepD_Form.validate({
                lang: Lang.theLang,
                onkeyup: function (element) {
                    this.element(element);  // <- "eager validation"
                },
                onfocusout: function (element) {
                    this.element(element);  // <- "eager validation"
                },
                errorElement: 'span', //default input error message container
                errorClass: 'help-block help-block-error', // default input error message class
                focusInvalid: false, // do not focus the last invalid input
                ignore: "", // validate all fields including form hidden input
                rules: App.GetFormRules("Onlinereg/StepRules", {par1: StepD_Form.attr("par1"), par2: 'D'}),
                messages: {// custom messages for radio buttons and checkboxes

                },
                errorPlacement: function (error, element) { // render error placement for each input type
                    if (element.parent(".input-group").size() > 0) {
                        error.insertAfter(element.parent(".input-group"));
                    } else if (element.attr("data-error-container")) {
                        error.appendTo(element.attr("data-error-container"));
                    } else if (element.parents('.radio-list').size() > 0) {
                        error.appendTo(element.parents('.radio-list').attr("data-error-container"));
                    } else if (element.parents('.radio-inline').size() > 0) {
                        error.appendTo(element.parents('.radio-inline').attr("data-error-container"));
                    } else if (element.parents('.checkbox-list').size() > 0) {
                        error.appendTo(element.parents('.checkbox-list').attr("data-error-container"));
                    } else if (element.parents('.checkbox-inline').size() > 0) {
                        error.appendTo(element.parents('.checkbox-inline').attr("data-error-container"));
                    } else {
                        error.insertAfter(element); // for other inputs, just perform default behavior
                    }
                },
                invalidHandler: function (event, validator) { //display error alert on form submit   
                    success3.addClass('hidden');
                    error3.removeClass('hidden');

                    $("html,body").animate({scrollTop: $('#StepD_Form').offset().top - 100}, "slow");
                    // $(".box-content").animate({ scrollTop: 0 }, "slow");
                },
                highlight: function (element) { // hightlight error inputs
                    $(element).parent().addClass('has-error'); // set error class to the control group
                },
                unhighlight: function (element) { // revert the change done by hightlight
                    $(element).parent().removeClass('has-error'); // set error class to the control group
                },
                success: function (label) {
                    label.parent().removeClass('has-error'); // set success class to the control group
                },
                submitHandler: function (form) {
                    success3.addClass('hidden');
                    error3.addClass('hidden');
                    var theForm = $('#StepD_Form');
                    //upload files
                    var data = new FormData(theForm[0]);

//                jQuery.each(jQuery('#file')[0].files, function (i, file) {
//                    data.append('file-' + i, file);
//                });
                    data.append('par1', StepD_Form.attr("par1"));
                    $.ajax({
                        type: "POST",
                        url: URLBase + "Onlinereg/StepDToDB",
                        data: data,
                        //async: false,
                        cache: false,
                        contentType: false,
                        processData: false,
                        dataType: "JSON",
                        beforeSend: function () {
                            $.blockUI({
                                message: Lang.Please_wait,
                                css: {
                                    border: 'none',
                                    padding: '15px',
                                    backgroundColor: '#000',
                                    '-webkit-border-radius': '10px',
                                    '-moz-border-radius': '10px',
                                    opacity: .5,
                                    color: '#fff'
                                }});
                            $("#StepD_Form :input").prop("disabled", true);
                            $("#submit-buttons").addClass('hidden');
                        },
                        complete: function () {
                            $.unblockUI();
                            $("#StepD_Form :input").prop("disabled", false);
                            $("#submit-buttons").removeClass('hidden');
                        },
                        error: function (xhr, ajaxOptions, thrownError) {
                            $.alert({
                                title: Lang.Error,
                                content: xhr.status + " - " + thrownError,
                                type: 'red',
                                rtl: App.isRTL(),
                                closeIcon: true,
                                buttons: {
                                    cancel: {
                                        text: Lang.Ok,
                                        action: function () {
                                        }
                                    }
                                }
                            });
                        },
                        success: function (response)
                        {
                            error3.addClass('hidden');
                            success3.addClass('hidden');

                            if (response !== null && response.hasOwnProperty("Errors")) {
                                //console.log(response['Errors']);
                                var obj = response["Errors"];
                                var stringerror = '';
                                for (var prop in obj) {
                                    stringerror += '* ' + obj[prop] + '</br>';
                                }
                                $('#Server_alerts').html(stringerror);
                                $('.Server_alerts').removeClass('hidden');

                            } else if (response !== null && response.hasOwnProperty("Success")) {
                                $('.Server_alerts').addClass('hidden');
                                Success = response.Success;
                                $('#StepD_Form').html('');

                                $('#Server_alerts_done').html(Success.text);
                                $('.Done-Alert').removeClass('hidden');
                                $("html,body").animate({scrollTop: $('#Server_alerts_done').offset().top - 130}, "slow");

                                window.location.replace(response.RedURL);


                            }
                        }
                    });
                    //form[0].submit(); // submit the form
                }

            });

            //apply validation on select2 dropdown value change, this only needed for chosen dropdown integration.
            $('.select2', StepD_Form).change(function () {
                StepD_Form.validate().element($(this)); //revalidate the chosen dropdown value and show error or success message for the input
            });

        }
    }
    var StepE = function () {
        // for more info visit the official plugin documentation: 
        // http://docs.jquery.com/Plugins/Validation

        var StepE_Form = $('#StepE_Form');
        if (StepE_Form.length) {


            $('#E_Employeed_no').click(function () {
                if ($('#E_Employeed_no').is(':checked')) {
                    $('#Work_Details').html('');
                }
            });
            $('#E_Employeed_yes').click(function () {
                if ($('#E_Employeed_yes').is(':checked')) {
                    var data = new FormData();
                    data.append('par1', StepE_Form.attr("par1"));
                    $.ajax({
                        type: "POST",
                        url: URLBase + "Onlinereg/StepEEmplyeeDetails",
                        data: data,
                        //async: false,
                        cache: false,
                        contentType: false,
                        processData: false,
                        dataType: "HTML",
                        beforeSend: function () {
                            $.blockUI({
                                message: Lang.Please_wait,
                                css: {
                                    border: 'none',
                                    padding: '15px',
                                    backgroundColor: '#000',
                                    '-webkit-border-radius': '10px',
                                    '-moz-border-radius': '10px',
                                    opacity: .5,
                                    color: '#fff'
                                }});
                            $("#submit-buttons").addClass('hidden');
                        },
                        complete: function () {
                            $.unblockUI();
                            $("#submit-buttons").removeClass('hidden');
                        },
                        error: function (xhr, ajaxOptions, thrownError) {
                            $.alert({
                                title: Lang.Error,
                                content: xhr.status + " - " + thrownError,
                                type: 'red',
                                rtl: App.isRTL(),
                                closeIcon: true,
                                buttons: {
                                    cancel: {
                                        text: Lang.Ok,
                                        action: function () {
                                        }
                                    }
                                }
                            });
                        },
                        success: function (response)
                        {
                            $('#Work_Details').html(response);
                        }
                    });
                }
            });

            var error3 = $('.alert-danger', StepE_Form);
            var success3 = $('.alert-success', StepE_Form);

            //IMPORTANT: update CKEDITOR textarea with actual content before submit
//            StepE_Form.on('submit', function() {
//                for(var instanceName in CKEDITOR.instances) {
//                    CKEDITOR.instances[instanceName].updateElement();
//                }
//            })

            StepE_Form.validate({
                lang: Lang.theLang,
                onkeyup: function (element) {
                    this.element(element);  // <- "eager validation"
                },
                onfocusout: function (element) {
                    this.element(element);  // <- "eager validation"
                },
                errorElement: 'span', //default input error message container
                errorClass: 'help-block help-block-error', // default input error message class
                focusInvalid: false, // do not focus the last invalid input
                ignore: "", // validate all fields including form hidden input
                rules: App.GetFormRules("Onlinereg/StepRules", {par1: StepE_Form.attr("par1"), par2: 'E'}),
                messages: {// custom messages for radio buttons and checkboxes

                },
                errorPlacement: function (error, element) { // render error placement for each input type
                    if (element.parent(".input-group").size() > 0) {
                        error.insertAfter(element.parent(".input-group"));
                    } else if (element.attr("data-error-container")) {
                        error.appendTo(element.attr("data-error-container"));
                    } else if (element.parents('.radio-list').size() > 0) {
                        error.appendTo(element.parents('.radio-list').attr("data-error-container"));
                    } else if (element.parents('.radio-inline').size() > 0) {
                        error.appendTo(element.parents('.radio-inline').attr("data-error-container"));
                    } else if (element.parents('.checkbox-list').size() > 0) {
                        error.appendTo(element.parents('.checkbox-list').attr("data-error-container"));
                    } else if (element.parents('.checkbox-inline').size() > 0) {
                        error.appendTo(element.parents('.checkbox-inline').attr("data-error-container"));
                    } else {
                        error.insertAfter(element); // for other inputs, just perform default behavior
                    }
                },
                invalidHandler: function (event, validator) { //display error alert on form submit   
                    success3.addClass('hidden');
                    error3.removeClass('hidden');

                    $("html,body").animate({scrollTop: $('#StepE_Form').offset().top - 100}, "slow");
                    // $(".box-content").animate({ scrollTop: 0 }, "slow");
                },
                highlight: function (element) { // hightlight error inputs
                    $(element).parent().addClass('has-error'); // set error class to the control group
                },
                unhighlight: function (element) { // revert the change done by hightlight
                    $(element).parent().removeClass('has-error'); // set error class to the control group
                },
                success: function (label) {
                    label.parent().removeClass('has-error'); // set success class to the control group
                },
                submitHandler: function (form) {
                    success3.addClass('hidden');
                    error3.addClass('hidden');
                    var theForm = $('#StepE_Form');
                    //upload files
                    var data = new FormData(theForm[0]);

//                jQuery.each(jQuery('#file')[0].files, function (i, file) {
//                    data.append('file-' + i, file);
//                });
                    data.append('par1', StepE_Form.attr("par1"));
                    $.ajax({
                        type: "POST",
                        url: URLBase + "Onlinereg/StepEToDB",
                        data: data,
                        //async: false,
                        cache: false,
                        contentType: false,
                        processData: false,
                        dataType: "JSON",
                        beforeSend: function () {
                            $.blockUI({
                                message: Lang.Please_wait,
                                css: {
                                    border: 'none',
                                    padding: '15px',
                                    backgroundColor: '#000',
                                    '-webkit-border-radius': '10px',
                                    '-moz-border-radius': '10px',
                                    opacity: .5,
                                    color: '#fff'
                                }});
                            $("#StepE_Form :input").prop("disabled", true);
                            $("#submit-buttons").addClass('hidden');
                        },
                        complete: function () {
                            $.unblockUI();
                            $("#StepE_Form :input").prop("disabled", false);
                            $("#submit-buttons").removeClass('hidden');
                        },
                        error: function (xhr, ajaxOptions, thrownError) {
                            $.alert({
                                title: Lang.Error,
                                content: xhr.status + " - " + thrownError,
                                type: 'red',
                                rtl: App.isRTL(),
                                closeIcon: true,
                                buttons: {
                                    cancel: {
                                        text: Lang.Ok,
                                        action: function () {
                                        }
                                    }
                                }
                            });
                        },
                        success: function (response)
                        {
                            error3.addClass('hidden');
                            success3.addClass('hidden');

                            if (response !== null && response.hasOwnProperty("Errors")) {
                                //console.log(response['Errors']);
                                var obj = response["Errors"];
                                var stringerror = '';
                                for (var prop in obj) {
                                    stringerror += '* ' + obj[prop] + '</br>';
                                }
                                $('#Server_alerts').html(stringerror);
                                $('.Server_alerts').removeClass('hidden');

                            } else if (response !== null && response.hasOwnProperty("Success")) {
                                $('.Server_alerts').addClass('hidden');
                                Success = response.Success;
                                $('#StepE_Form').html('');

                                $('#Server_alerts_done').html(Success.text);
                                $('.Done-Alert').removeClass('hidden');
                                $("html,body").animate({scrollTop: $('#Server_alerts_done').offset().top - 130}, "slow");

                                window.location.replace(response.RedURL);


                            }
                        }
                    });
                    //form[0].submit(); // submit the form
                }

            });

            //apply validation on select2 dropdown value change, this only needed for chosen dropdown integration.
            $('.select2', StepE_Form).change(function () {
                StepE_Form.validate().element($(this)); //revalidate the chosen dropdown value and show error or success message for the input
            });

        }
    }
    var StepF = function () {
        // for more info visit the official plugin documentation: 
        // http://docs.jquery.com/Plugins/Validation

        var StepF_Form = $('#StepF_Form');
        if (StepF_Form.length) {
            var error3 = $('.alert-danger', StepF_Form);
            var success3 = $('.alert-success', StepF_Form);

            //IMPORTANT: update CKEDITOR textarea with actual content before submit
//            StepF_Form.on('submit', function() {
//                for(var instanceName in CKEDITOR.instances) {
//                    CKEDITOR.instances[instanceName].updateElement();
//                }
//            })

            StepF_Form.validate({
                lang: Lang.theLang,
                onkeyup: function (element) {
                    this.element(element);  // <- "eager validation"
                },
                onfocusout: function (element) {
                    this.element(element);  // <- "eager validation"
                },
                errorElement: 'span', //default input error message container
                errorClass: 'help-block help-block-error', // default input error message class
                focusInvalid: false, // do not focus the last invalid input
                ignore: "", // validate all fields including form hidden input
                rules: App.GetFormRules("Onlinereg/StepRules", {par1: StepF_Form.attr("par1"), par2: 'F'}),
                messages: {// custom messages for radio buttons and checkboxes

                },
                errorPlacement: function (error, element) { // render error placement for each input type
                    if (element.parent(".input-group").size() > 0) {
                        error.insertAfter(element.parent(".input-group"));
                    } else if (element.attr("data-error-container")) {
                        error.appendTo(element.attr("data-error-container"));
                    } else if (element.parents('.radio-list').size() > 0) {
                        error.appendTo(element.parents('.radio-list').attr("data-error-container"));
                    } else if (element.parents('.radio-inline').size() > 0) {
                        error.appendTo(element.parents('.radio-inline').attr("data-error-container"));
                    } else if (element.parents('.checkbox-list').size() > 0) {
                        error.appendTo(element.parents('.checkbox-list').attr("data-error-container"));
                    } else if (element.parents('.checkbox-inline').size() > 0) {
                        error.appendTo(element.parents('.checkbox-inline').attr("data-error-container"));
                    } else {
                        error.insertAfter(element); // for other inputs, just perform default behavior
                    }
                },
                invalidHandler: function (event, validator) { //display error alert on form submit   
                    success3.addClass('hidden');
                    error3.removeClass('hidden');

                    $("html,body").animate({scrollTop: $('#StepF_Form').offset().top - 100}, "slow");
                    // $(".box-content").animate({ scrollTop: 0 }, "slow");
                },
                highlight: function (element) { // hightlight error inputs
                    $(element).parent().parent().addClass('has-error'); // set error class to the control group
                },
                unhighlight: function (element) { // revert the change done by hightlight
                    $(element).parent().parent().removeClass('has-error'); // set error class to the control group
                },
                success: function (label) {
                    label.parent().removeClass('has-error'); // set success class to the control group
                },
                submitHandler: function (form) {
                    success3.addClass('hidden');
                    error3.addClass('hidden');
                    var theForm = $('#StepF_Form');
                    //upload files
                    var data = new FormData(theForm[0]);

                    jQuery.each(jQuery('.documents')[0].files, function (i, file) {
                        data.append('file-' + i, file);
                    });
                    data.append('par1', StepF_Form.attr("par1"));
                    $.ajax({
                        type: "POST",
                        url: URLBase + "Onlinereg/StepFToDB",
                        data: data,
                        //async: false,
                        cache: false,
                        contentType: false,
                        processData: false,
                        dataType: "JSON",
                        beforeSend: function () {
                            $.blockUI({
                                message: Lang.Please_wait,
                                css: {
                                    border: 'none',
                                    padding: '15px',
                                    backgroundColor: '#000',
                                    '-webkit-border-radius': '10px',
                                    '-moz-border-radius': '10px',
                                    opacity: .5,
                                    color: '#fff'
                                }});
                            $("#StepF_Form :input").prop("disabled", true);
                            $("#submit-buttons").addClass('hidden');
                        },
                        complete: function () {
                            $.unblockUI();
                            $("#StepF_Form :input").prop("disabled", false);
                            $("#submit-buttons").removeClass('hidden');
                        },
                        error: function (xhr, ajaxOptions, thrownError) {
                            $.alert({
                                title: Lang.Error,
                                content: xhr.status + " - " + thrownError,
                                type: 'red',
                                rtl: App.isRTL(),
                                closeIcon: true,
                                buttons: {
                                    cancel: {
                                        text: Lang.Ok,
                                        action: function () {
                                        }
                                    }
                                }
                            });
                        },
                        success: function (response)
                        {
                            error3.addClass('hidden');
                            success3.addClass('hidden');

                            if (response !== null && response.hasOwnProperty("Errors")) {
                                //console.log(response['Errors']);
                                var obj = response["Errors"];
                                var stringerror = '';
                                for (var prop in obj) {
                                    stringerror += '* ' + obj[prop] + '</br>';
                                }
                                $('#Server_alerts').html(stringerror);
                                $('.Server_alerts').removeClass('hidden');

                            } else if (response !== null && response.hasOwnProperty("UploadUnSuccessfull")) {
                                var UploadUnSuccessfull = response.UploadUnSuccessfull;
                                $.alert({
                                    title: UploadUnSuccessfull.title,
                                    content: UploadUnSuccessfull.msg,
                                    type: 'red',
                                    rtl: App.isRTL(),
                                    closeIcon: true,
                                    buttons: {
                                        cancel: {
                                            text: Lang.Ok,
                                            action: function () {
                                                window.location.replace(UploadUnSuccessfull.RedURL);
                                            }
                                        }
                                    }
                                });



                            } else if (response !== null && response.hasOwnProperty("Success")) {

                                var Success = response.Success;
                                $("#FCont").html(Success.HtmlMsg);
                                App.scrollTo($("#FCont"), -200);



                            } else if (response !== null && response.hasOwnProperty("SuccessR")) {

                                var Success = response.SuccessR;

                                $.alert({
                                    title: Success.title,
                                    content: Success.content,
                                    autoClose: "cancel|10000",
                                    type: 'green',
                                    rtl: App.isRTL(),
                                    closeIcon: true,
                                    buttons: {
                                        cancel: {
                                            text: Lang.Ok,
                                            action: function () {
                                                window.location.href = Success.Redirect;
                                            }
                                        }
                                    }
                                });




                            }
                        }
                    });
                    //form[0].submit(); // submit the form
                }

            });

            //apply validation on select2 dropdown value change, this only needed for chosen dropdown integration.
            $('.select2', StepF_Form).change(function () {
                StepF_Form.validate().element($(this)); //revalidate the chosen dropdown value and show error or success message for the input
            });

        }
    }
    return {
        //main function to initiate the module
        init: function () {
            StepA();
            StepB();
            StepC();
            StepD();
            StepE();
            StepF();
            UpdateFields();
            Cancel_Application();
        }

    };

}();

jQuery(document).ready(function () {
    ValidationFunctions.init();
});