var Lang;
$.ajax({
    type: "POST",
    url: URLBase + 'General/jsLang',
    data: '',
    async: false,
    dataType: "json",
    success: function (data) {
        Lang = data;
    }
});

var TableDatatablesAjax = function () {

    var initPickers = function () {
        //init date pickers
        $('.date-picker').datepicker({
            rtl: App.isRTL(),
            autoclose: true
        });
    };

    var handleRecords = function () {
        var LngArr = {
            "metronicAjaxRequestGeneralError": Lang['Could_not_complete_request_Please_check_your_internet_connection'],
            "sProcessing": Lang['Please_wait'],
            "sLengthMenu": "&nbsp;&nbsp;&nbsp; " + Lang['Show'] + " _MENU_ " + Lang['entries'] + " &nbsp;&nbsp;&nbsp;",
            "sZeroRecords": Lang['No_matching_records_found'],
            "sInfo": Lang['Showing'] + " _START_ " + Lang['To'] + " _END_ " + Lang['of'] + " _TOTAL_ " + Lang['entries'],
            "sInfoEmpty": Lang['Showing'] + " 0 " + Lang['To'] + " 0 " + Lang['of'] + " 0 " + Lang['entries'],
            "sInfoFiltered": "(filtered from _MAX_ total entries)",
            "sInfoPostFix": "",
            "sSearch": "Search:",
            "emptyTable": Lang['No_matching_records_found'],
            "metronicGroupActions": "_TOTAL_ " + Lang['records_selected'] + ":",
            "paginate": {
                "previous": "Prev",
                "next": "Next",
                "last": "Last",
                "first": "First",
                "page": Lang['Page'],
                "pageOf": Lang['of']
            }
        };
        var grid = new Datatable();

        grid.init({
            src: $("#datatable_ajax"),
            onSuccess: function (grid, response) {
                // grid:        grid object
                // response:    json object of server side ajax response
                // execute some code after table records loaded
            },
            onError: function (grid) {
                // execute some code on network or other general error  
            },
            onDataLoad: function (grid) {
                // execute some code on ajax data load
            },
            loadingMessage: Lang.Please_wait,
            dataTable: {// here you can define a typical datatable settings from http://datatables.net/usage/options 
                "language": LngArr,
                // Uncomment below line("dom" parameter) to fix the dropdown overflow issue in the datatable cells. The default datatable layout
                // setup uses scrollable div(table-scrollable) with overflow:auto to enable vertical scroll(see: assets/global/scripts/datatable.js). 
                // So when dropdowns used the scrollable div should be removed. 
                //"dom": "<'row'<'col-md-8 col-sm-12'pli><'col-md-4 col-sm-12'<'table-group-actions pull-right'>>r>t<'row'<'col-md-8 col-sm-12'pli><'col-md-4 col-sm-12'>>",

                "bStateSave": true, // save datatable state(pagination, sort, etc) in cookie.

                "lengthMenu": [
                    [10, 20, 50, 100, 150, -1],
                    [10, 20, 50, 100, 150, "All"] // change per page values here
                ],
                "pageLength": 10, // default record count per page
                "ajax": {
                    "url": URLBase + "Users/GetData" // ajax source
                },
                "order": [
                    [1, "desc"]
                ], // set first column as a default sort by asc
                "columnDefs": [
                    {
                        'orderable': false,
                        sClass: "text-center",
                        'targets': [0]
                    },
                    {
                        'orderable': true,
                        sClass: "text-center",
                        'targets': [1]
                    },
                    {
                        'orderable': true,
                        sClass: "text-center",
                        'targets': [2]
                    },
                    {
                        'orderable': true,
                        sClass: "text-center",
                        'targets': [3]
                    },
                    {
                        'orderable': true,
                        sClass: "text-center",
                        'targets': [4]
                    },
                    {
                        'orderable': true,
                        sClass: "text-center",
                        'targets': [5]
                    },
                    {
                        'orderable': true,
                        sClass: "text-center",
                        'targets': [6]
                    },
                    {
                        'orderable': false,
                        sClass: "text-center",
                        'targets': [7]
                    },
                ]
            }
        });

        // handle group actionsubmit button click
        grid.getTableWrapper().on('click', '.table-group-action-submit', function (e) {
            e.preventDefault();
            var action = $(".table-group-action-input", grid.getTableWrapper());
            if (action.val() !== "" && grid.getSelectedRowsCount() > 0) {
                grid.setAjaxParam("customActionType", "group_action");
                grid.setAjaxParam("customActionName", action.val());
                grid.setAjaxParam("id", grid.getSelectedRows());
                grid.getDataTable().ajax.reload();
                grid.clearAjaxParams();
                //refresh table
                var table = $('#datatable_ajax').DataTable();
                table.ajax.reload();
            } else if (action.val() === "") {
                App.alert({
                    type: 'danger',
                    icon: 'warning',
                    message: Lang['Please_select_an_action'],
                    container: grid.getTableWrapper(),
                    place: 'prepend'
                });
            } else if (grid.getSelectedRowsCount() === 0) {
                App.alert({
                    type: 'danger',
                    icon: 'warning',
                    message: Lang['No_record_selected'],
                    container: grid.getTableWrapper(),
                    place: 'prepend'
                });
            }
        });

        grid.setAjaxParam("customActionType", "group_action");
        // grid.getDataTable().ajax.reload();
        grid.clearAjaxParams();
    }

    return {
        //main function to initiate the module
        init: function () {

            initPickers();
            handleRecords();
        }

    };

}();
var UIExtendedModals = function () {
    var handleValidation3 = function () {
        // for more info visit the official plugin documentation: 
        // http://docs.jquery.com/Plugins/Validation
        
         $(".select2-multiple").select2({
            rtl: App.isRTL(),
            width: null
        });
   
        var form3 = $('#SForm');
        var error3 = $('.alert-danger', form3);
        var success3 = $('.alert-success', form3);

        //IMPORTANT: update CKEDITOR textarea with actual content before submit
//            form3.on('submit', function() {
//                for(var instanceName in CKEDITOR.instances) {
//                    CKEDITOR.instances[instanceName].updateElement();
//                }
//            })

        form3.validate({
            lang: Lang.theLang,
            errorElement: 'span', //default input error message container
            errorClass: 'help-block help-block-error', // default input error message class
            focusInvalid: false, // do not focus the last invalid input
            ignore: "", // validate all fields including form hidden input
            rules: {
                name_ar: {
                    minlength: 3,
                    required: true
                },
                username: {
                    maxlength: 255,
                    required: true
                },
                user_groub: {
                    required: true,
                    number: true
                },
                email: {
                    required: true,
                    email: true
                }


            },
            messages: {// custom messages for radio buttons and checkboxes
                user_groub: {
                    number: Lang.Incorrect_user_groub
                },
            },
            errorPlacement: function (error, element) { // render error placement for each input type
                if (element.parent(".input-group").size() > 0) {
                    error.insertAfter(element.parent(".input-group"));
                } else if (element.attr("data-error-container")) {
                    error.appendTo(element.attr("data-error-container"));
                } else if (element.parents('.radio-list').size() > 0) {
                    error.appendTo(element.parents('.radio-list').attr("data-error-container"));
                } else if (element.parents('.radio-inline').size() > 0) {
                    error.appendTo(element.parents('.radio-inline').attr("data-error-container"));
                } else if (element.parents('.checkbox-list').size() > 0) {
                    error.appendTo(element.parents('.checkbox-list').attr("data-error-container"));
                } else if (element.parents('.checkbox-inline').size() > 0) {
                    error.appendTo(element.parents('.checkbox-inline').attr("data-error-container"));
                } else {
                    error.insertAfter(element); // for other inputs, just perform default behavior
                }
            },
            invalidHandler: function (event, validator) { //display error alert on form submit   
                success3.hide();
                error3.show();
                $('.modal-body').scrollTop(0);
            },
            highlight: function (element) { // hightlight error inputs
                $(element)
                        .parent().addClass('has-error'); // set error class to the control group
            },
            unhighlight: function (element) { // revert the change done by hightlight
                $(element)
                        .parent().removeClass('has-error'); // set error class to the control group
            },
            success: function (label) {
                label
                        .parent().removeClass('has-error'); // set success class to the control group
            },
            submitHandler: function (form) {
                success3.show();
                error3.hide();
                var theForm = $('#SForm');
                //upload files
                var data = new FormData(theForm[0]);
                jQuery.each(jQuery('#file')[0].files, function (i, file) {
                    data.append('file-' + i, file);
                });
                $.ajax({
                    type: "POST",
                    url: URLBase+"Users/ToDB" + '/' + $("#SForm").attr("ref"),
                    data: data,
                    //async: false,
                    cache: false,
                    contentType: false,
                    processData: false,
                    dataType: "JSON",
                    beforeSend: function () {
                        $("#SForm :input").prop("disabled", true);
                        $("#submit-buttons").addClass('hidden');
                        $("#spinner").removeClass('hidden');
                    },
                    complete: function () {
                        $("#SForm :input").prop("disabled", false);
                        $("#submit-buttons").removeClass('hidden');
                        $("#spinner").addClass('hidden');
                    },
                    success: function (response)
                    {
                        if (response !== null && response.hasOwnProperty("Errors")) {
                            success3.hide();
                            //console.log(response['Errors']);
                           
                            $('#Server_alerts').html(response["Errors"]);
                            $('.Server_alerts').removeClass('hidden');

                        }

                        else if (response !== null && response.hasOwnProperty("Success")) {
                            $('.Server_alerts').addClass('hidden');

                            $('#Level1').modal('toggle');

                            //refresh table
                            var table = $('#datatable_ajax').DataTable();
                            table.ajax.reload();
                            
                           var Res =response['Success'];
                           UINotific8.init(Res.theme,Res.horizontalEdge,Res.verticalEdge,Res.heading,Res.life,Res.text);
                        }
                    }
                });
                //form[0].submit(); // submit the form
            }

        });

        //apply validation on select2 dropdown value change, this only needed for chosen dropdown integration.
        $('.select2me', form3).change(function () {
            form3.validate().element($(this)); //revalidate the chosen dropdown value and show error or success message for the input
        });

        //initialize datepicker
        $('.date-picker').datepicker({
            rtl: App.isRTL(),
            autoclose: true
        });
        $('.date-picker .form-control').change(function () {
            form3.validate().element($(this)); //revalidate the chosen dropdown value and show error or success message for the input 
        })
    }

    return {
        //main function to initiate the module
        init: function () {

            // general settings
            $.fn.modal.defaults.spinner = $.fn.modalmanager.defaults.spinner =
                    '<div class="loading-spinner" style="width: 200px; margin-left: -100px;">' +
                    '<div class="progress progress-striped active">' +
                    '<div class="progress-bar" style="width: 100%;"></div>' +
                    '</div>' +
                    '</div>';

            $.fn.modalmanager.defaults.resize = true;

            //ajax demo:
            var $modal = $('#Level1');

            $('#AddNEW').on('click', function () {
                // create the backdrop and wait for next modal to be triggered
                $('body').modalmanager('loading');
                var el = $(this);

                setTimeout(function () {
                    $modal.load(el.attr('data-url'), '', function () {
                        $modal.modal();
                        handleValidation3();
                        App.initAjax();
                    });
                }, 1000);
            });
            $(document).on('click', '.EDIT', function () {
                // create the backdrop and wait for next modal to be triggered
                $('body').modalmanager('loading');
                var el = $(this);

                setTimeout(function () {
                    $modal.load(el.attr('data-url'), '', function () {
                        $modal.modal();
                        handleValidation3();
                        App.initAjax();
                    });
                }, 1000);
            });


        }

    };

}();

jQuery(document).ready(function () {
    UIExtendedModals.init();
    TableDatatablesAjax.init();
});