
var AppInbox = function () {

    var content = $('.inbox-content');
    var listListing = '';

    var loadInbox = function (el, name) {
        var url = 'Speeches/viewList';
        var title = el.attr('data-title');
        var type = el.attr('data-type');
        listListing = name;

        App.blockUI({
            target: content,
            overlayColor: 'none',
            animate: true
        });

        toggleButton(el);

        $.ajax({
            type: "GET",
            cache: false,
            url: url+'?type='+type,
            dataType: "html",
            success: function(res) 
            {
                toggleButton(el);

                App.unblockUI('.inbox-content');

                $('.inbox-nav > li.active').removeClass('active');
                el.closest('li').addClass('active');
                $('.inbox-header > h1').text(title);

                content.html(res);

                // if (Layout.fixContentHeight) {
                //     Layout.fixContentHeight();
                // }

                App.initUniform();
            },
            error: function(xhr, ajaxOptions, thrownError)
            {
                toggleButton(el);
            },
            async: false
        });

        // handle group checkbox:
        jQuery('body').on('change', '.mail-group-checkbox', function () {
            var set = jQuery('.mail-checkbox');
            var chbox = $(this);
            var checked  = false;
            if (chbox.prop('checked')) {
                checked  = true;
            }else{
                checked  = false;
            }
            jQuery(set).each(function () {
                $(this).prop("checked", checked);
                //$(this).attr("checked", checked);
            });
            jQuery.uniform.update(set);
        });
    };

    var loadMessage = function (el, name, resetMenu) {
        var url = 'Speeches/view';

        App.blockUI({
            target: content,
            overlayColor: 'none',
            animate: true
        });

        toggleButton(el);

        var message_id = el.parent('tr').attr("data-messageid");  
        
        $.ajax({
            type: "GET",
            cache: false,
            url: url,
            dataType: "html",
            data: {'message_id': message_id},
            success: function(res) 
            {
                App.unblockUI(content);

                toggleButton(el);

                if (resetMenu) {
                    $('.inbox-nav > li.active').removeClass('active');
                }
                $('.inbox-header > h1').text('');

                content.html(res);
                // Layout.fixContentHeight();
                App.initUniform();
            },
            error: function(xhr, ajaxOptions, thrownError)
            {
                toggleButton(el);
            },
            async: false
        });
    };

    // var initWysihtml5 = function () {
    //     $('.inbox-wysihtml5').wysihtml5({
    //         "stylesheets": ["../assets/global/plugins/bootstrap-wysihtml5/wysiwyg-color.css"]
    //     });
    // }
    
    $(document).on('click','#markasdeleted',function(e){
    e.preventDefault();
    var id = [];
    $('.mail-checkbox').each(function(){
        var checkBox = $(this);
        if (checkBox.prop('checked')) {
            id.push(checkBox.attr('data-id'));
        }
    });
    
    $.get( "Speeches/Delete",{ids:id.toString()}, function( data ) {
        location.reload();
    });
});
    $(document).on('click','#markasread',function(e){
    e.preventDefault();
    var id = [];
    $('.mail-checkbox').each(function(){
        var checkBox = $(this);
        if (checkBox.prop('checked')) {
            id.push(checkBox.attr('data-id'));
        }
    });
    
    $.get( "Speeches/markAsRead",{ids:id.toString()}, function( data ) {
        location.reload();
    });
});

    var initFileupload = function () {

        $('#fileupload').fileupload({
            // Uncomment the following to send cross-domain cookies:
            //xhrFields: {withCredentials: true},
            url: URLBase + 'Speeches/UploadAttachments',
            autoUpload: true
        });

        // Upload server status check for browsers with CORS support:
        if ($.support.cors) {
            $.ajax({
                url: URLBase + 'Speeches/UploadAttachments',
                type: 'HEAD',
                 
            }).fail(function () {
                $('<span class="alert alert-error"/>')
                    .text('Upload server currently unavailable - ' +
                    new Date())
                    .appendTo('#fileupload');
            });
        }

        ///////////////////////////

        var form3 = $(document).find('#fileupload');
        var error3 = $('.alert-danger', form3);
        var success3 = $('.alert-success', form3);

        //IMPORTANT: update CKEDITOR textarea with actual content before submit
        form3.on('submit', function(e) {
            var counter = 1;
            $('.uploaded_file').each(function(index , value){
                var inputs = $(this);
                inputs.attr('name','f_'+counter);
                counter++;
            });
            for(var instanceName in CKEDITOR.instances) {
                CKEDITOR.instances[instanceName].updateElement();
            }
        });

        form3.validate({
            lang: Lang.theLang,
            errorElement: 'span', //default input error message container
            errorClass: 'help-block help-block-error', // default input error message class
            focusInvalid: false, // do not focus the last invalid input
            ignore: "", // validate all fields including form hidden input
            rules: {

                name: {
                    required: true,
                    maxlength: 255,
                },
                
                email: {
                    required: true,
                },
                

            },
            messages: {// custom messages for radio buttons and checkboxes

            },
            errorPlacement: function (error, element) { // render error placement for each input type
                if (element.parent(".input-group").size() > 0) {
                    error.insertAfter(element.parent(".input-group"));
                } else if (element.attr("data-error-container")) {
                    error.appendTo(element.attr("data-error-container"));
                } else if (element.parents('.radio-list').size() > 0) {
                    error.appendTo(element.parents('.radio-list').attr("data-error-container"));
                } else if (element.parents('.radio-inline').size() > 0) {
                    error.appendTo(element.parents('.radio-inline').attr("data-error-container"));
                } else if (element.parents('.checkbox-list').size() > 0) {
                    error.appendTo(element.parents('.checkbox-list').attr("data-error-container"));
                } else if (element.parents('.checkbox-inline').size() > 0) {
                    error.appendTo(element.parents('.checkbox-inline').attr("data-error-container"));
                } else {
                    error.insertAfter(element); // for other inputs, just perform default behavior
                }
            },
            invalidHandler: function (event, validator) { //display error alert on form submit
                success3.hide();
                error3.show();
                App.scrollTo(error3, -200);
            },
            highlight: function (element) { // hightlight error inputs
                $(element)
                    .parent().addClass('has-error'); // set error class to the control group
            },
            unhighlight: function (element) { // revert the change done by hightlight
                $(element)
                    .parent().removeClass('has-error'); // set error class to the control group
            },
            success: function (label) {
                label
                    .parent().removeClass('has-error'); // set success class to the control group
            },
            submitHandler: function (form) {
                success3.show();
                error3.hide();

                //upload files
                var data = new FormData(form3[0]);
               
               /* jQuery.each(jQuery('.file')[0].files, function (i, file) {
                    data.append('file-' + i, file);
                    console.log('file-' + i);
                });*/
                
                data.append('par1', form3.attr("par1"));
                data.append('par2', form3.attr("par2"));
                $.ajax({
                    type: "POST",
                    url: URLBase + "Speeches/ToDB",
                    data: data,
                    //async: false,
                    cache: false,
                    contentType: false,
                    processData: false,
                    dataType: "JSON",
                    beforeSend: function () {
                        $("#fileupload :input").prop("disabled", true);
                        $("#submit-buttons").addClass('hidden');
                        $("#spinner").removeClass('hidden');
                        App.blockUI({
                            target: '#fileupload',
                            overlayColor: 'none',
                            cenrerY: true,
                            animate: true
                        });
                    },
                    complete: function () {
                        $("#fileupload :input").prop("disabled", false);
                        $("#submit-buttons").removeClass('hidden');
                        $("#spinner").addClass('hidden');
                        App.unblockUI('#fileupload');
                    },
                    success: function (response)
                    {
                        if (response !== null && response.hasOwnProperty("Errors")) {
                            //console.log(response['Errors']);
                            var obj = response["Errors"];
                            var stringerror = '';
                            for (var prop in obj) {
                                stringerror += '* ' + obj[prop] + '</br>';
                            }
                            $('#Server_alerts').html(stringerror);
                            $('.Server_alerts').removeClass('hidden');
                            $("html,body").animate({scrollTop: $('#Server_alerts').offset().top - 100}, "slow");

                        }

                        else if (response !== null && response.hasOwnProperty("Success")) {
                            $('.Server_alerts').addClass('hidden');
                            $("#submit-buttons").remove();
                            var Res = response['Success'];
                            //UINotific8.init(Res.theme, Res.horizontalEdge, Res.verticalEdge, Res.heading, Res.life, Res.text);

                            setTimeout(function () {
                               window.location.replace(URLBase + "Speeches");
                            }, 1000);
                        }
                    }
                });
                //form[0].submit(); // submit the form
            }

        });
        ///////////////////////////
    };

    var loadCompose = function (el) {
        var url = URLBase + 'Speeches/composeForm';

        App.blockUI({
            target: content,
            overlayColor: 'none',
            animate: true
        });

        toggleButton(el);

        // load the form via ajax
        $.ajax({
            type: "GET",
            cache: false,
            url: url,
            dataType: "html",
            success: function(res) 
            {
               App.unblockUI(content);
                toggleButton(el);

                $('.inbox-nav > li.active').removeClass('active');
                $('.inbox-header > h1').text(Lang.Compose_S);

                content.html(res);

                initFileupload();
               // initWysihtml5();
                $('[name="message"]').val($('.inbox-view').html());
                $('.inbox-wysihtml5').focus();
                // Layout.fixContentHeight();
                App.initUniform();
                
                
            },
            error: function(xhr, ajaxOptions, thrownError)
            {
                toggleButton(el);
            },
            async: false
        });
    };

    var loadReply = function (el) {
        var messageid = $(el).attr("data-messageid");
        var url = 'Speeches/replaForm';
        
        App.blockUI({
            target: content,
            overlayColor: 'none',
            animate: true
        });

        toggleButton(el);

        // load the form via ajax
        $.ajax({
            type: "GET",
            cache: false,
            url: url,
            data:{messageid: messageid},
            dataType: "html",
            success: function(res) 
            {
                
                

                App.unblockUI(content);
                toggleButton(el);

                $('.inbox-nav > li.active').removeClass('active');
                $('.inbox-header > h1').text(Lang.Compose_S);

                content.html(res);

                initFileupload();
               // initWysihtml5();
                $('[name="message"]').val($('.inbox-view').html());
                $('.inbox-wysihtml5').focus();
                $(document).find('.cke_editable').html($('[name="message"]').val());
                // Layout.fixContentHeight();
                App.initUniform();
            },
            error: function(xhr, ajaxOptions, thrownError)
            {
                toggleButton(el);
            },
            async: false
        });
    };

    var handleCCInput = function () {
        var the = $('.inbox-compose .mail-to .inbox-cc');
        var input = $('.inbox-compose .input-cc');
        the.hide();
        input.show();
        $('.close', input).click(function () {
            input.hide();
            the.show();
        });
    };

    var handleBCCInput = function () {

        var the = $('.inbox-compose .mail-to .inbox-bcc');
        var input = $('.inbox-compose .input-bcc');
        the.hide();
        input.show();
        $('.close', input).click(function () {
            input.hide();
            the.show();
        });
    };

    var toggleButton = function(el) {
        if (typeof el == 'undefined') {
            return;
        }
        if (el.attr("disabled")) {
            el.attr("disabled", false);
        } else {
            el.attr("disabled", true);
        }
    };

    return {
        //main function to initiate the module
        init: function () {

            

            // handle compose btn click
            $('.inbox').on('click', '.compose-btn', function () {
               for(var instanceName in CKEDITOR.instances) {
                var ckInstance = CKEDITOR.instances[instanceName];
                ckInstance.removeAllListeners();
                CKEDITOR.remove(ckInstance);
            }
                loadCompose($(this));
                $(".select2, .select2-multiple").select2({
                    placeholder: Lang.To,
                    width: null
                });
                CKEDITOR.replace("message",{
                    language: $("html").attr('lang'),
                });
                
                
            });

            // handle discard btn
            $('.inbox').on('click', '.inbox-discard-btn', function(e) {
                e.preventDefault();
                loadInbox($(this), listListing);
            });

            // handle reply and forward button click
            $('.inbox').on('click', '.reply-btn', function () {
                for(var instanceName in CKEDITOR.instances) {
                var ckInstance = CKEDITOR.instances[instanceName];
                ckInstance.removeAllListeners();
                CKEDITOR.remove(ckInstance);
            }
                
                loadReply($(this));
                $(".select2, .select2-multiple").select2({
                    placeholder: Lang.To,
                    width: null
                });

                CKEDITOR.replace("message",{
                    language: $("html").attr('lang'),
                });
                //loadCompose();
            });

            // handle view message
            $('.inbox').on('click', '.view-message', function () {
                loadMessage($(this));
            });

            // handle inbox listing
            $('.inbox-nav > li > a').click(function () {
                loadInbox($(this), 'inbox');
            });

            //handle compose/reply cc input toggle
            $('.inbox-content').on('click', '.mail-to .inbox-cc', function () {
                handleCCInput();
            });

            //handle compose/reply bcc input toggle
            $('.inbox-content').on('click', '.mail-to .inbox-bcc', function () {
                handleBCCInput();
            });

            //handle loading content based on URL parameter
            if (App.getURLParameter("a") === "view") {
                loadMessage();
            } else if (App.getURLParameter("a") === "compose") {
                loadCompose();
            } else {
               $('#compse_form').click();
            }




        }

    };

}();

jQuery(document).ready(function() {
    AppInbox.init();
    jQuery('body').on('change', '#message-type',function(){
        if($(this).val() == 0){
            $('.type-outer-message').addClass("hide");
             $('.type-inner-message').removeClass("hide");
             $('.inner').removeAttr('disabled');
             $('.outer').attr('disabled');
        }else{
            $.post(URLBase + "Speeches/GetLastRowNumber",function(e){
              var value = parseInt(e);
              if(value != 0){
                  $(document).find('.numbers_sender').html(value+1001);
              }else{
                  $(document).find('.numbers_sender').html("Error ... ");
              }
            });
            $('.type-outer-message').removeClass("hide");
             $('.type-inner-message').addClass("hide");
             $('.outer').removeAttr('disabled');
             $('.inner').attr('disabled');
        }
        
    });
});