var Lang;
var Login = function () {

    var handleLogin = function () {


        $('.login-form').validate({
            errorElement: 'span', //default input error message container
            errorClass: 'help-block', // default input error message class
            focusInvalid: false, // do not focus the last invalid input
            rules: {
                username: {
                    required: true
                },
                password: {
                    required: true
                },
                remember: {
                    required: false
                }
            },
            messages: {
                username: {
                    required: Lang.Username_is_required
                },
                password: {
                    required: Lang.Password_is_required
                }
            },
            invalidHandler: function (event, validator) { //display error alert on form submit   
                $('.alert-danger', $('.login-form')).show();
                $(".client_side").removeClass('hidden');
                $(".server_side").addClass('hidden');
            },
            highlight: function (element) { // hightlight error inputs
                $(element)
                        .closest('.form-group').addClass('has-error'); // set error class to the control group
            },
            success: function (label) {
                label.closest('.form-group').removeClass('has-error');
                label.remove();
            },
            errorPlacement: function (error, element) {
                error.insertAfter(element.closest('.input-icon'));
            },
            submitHandler: function (form) {
                // do other stuff for a valid form
                $.post(URLBase + 'login/ProcessLogin', $('.login-form').serialize(), function (response) {
                    if (response && response.hasOwnProperty("Errors")) {
                        $(".client_side").addClass('hidden');
                        $(".msg_from_server").html(response.Errors);
                        $(".server_side").removeClass('hidden');
                    } else if (response && response.hasOwnProperty("Success")) {
                        if (response.Success === 'redirect') {
                            if (response.hasOwnProperty("redirect_url")) {
                                window.location.replace(response.redirect_url);
                            } else {
                                location.reload();
                            }

                        }

                    }
                }, 'json');
            }
        });

        $('.login-form input').keypress(function (e) {
            if (e.which == 13) {
                if ($('.login-form').validate().form()) {
                    $('.login-form').submit(); //form validation success, call ajax form submit
                }
                return false;
            }
        });
    }

    var handleForgetPassword = function () {
        $('.forget-form').validate({
            errorElement: 'span', //default input error message container
            errorClass: 'help-block', // default input error message class
            focusInvalid: false, // do not focus the last invalid input
            ignore: "",
            rules: {
                email: {
                    required: true,
                    email: true
                }
            },
            messages: {
                email: {
                    required: "Email is required."
                }
            },
            invalidHandler: function (event, validator) { //display error alert on form submit   

            },
            highlight: function (element) { // hightlight error inputs
                $(element)
                        .closest('.form-group').addClass('has-error'); // set error class to the control group
            },
            success: function (label) {
                label.closest('.form-group').removeClass('has-error');
                label.remove();
            },
            errorPlacement: function (error, element) {
                error.insertAfter(element.closest('.input-icon'));
            },
            submitHandler: function (form) {
                form.submit();
            }
        });

        $('.forget-form input').keypress(function (e) {
            if (e.which == 13) {
                if ($('.forget-form').validate().form()) {
                    $('.forget-form').submit();
                }
                return false;
            }
        });

        jQuery('#forget-password').click(function () {
            jQuery('.login-form').hide();
            jQuery('.forget-form').show();
        });

        jQuery('#back-btn').click(function () {
            jQuery('.login-form').show();
            jQuery('.forget-form').hide();
        });

    }


    return {
        //main function to initiate the module
        init: function () {

            handleLogin();
            handleForgetPassword();

        }

    };

}();

jQuery(document).ready(function () {

    $.ajax({
        type: "POST",
        url: URLBase + 'General/jsLang',
        data: '',
        async: false,
        dataType: "json",
        success: function (data) {
            Lang = data;
        }
    });
    Login.init();

});

