function DeleteItemAjax(el,reqPath) {

    $.confirm({
        title: el.attr('Dtitle'),
        content: el.attr('Dcontent'),
        type: 'red',
        buttons: {
            confirm: {
                text: el.attr('confirmButton'),
                btnClass: 'btn-danger',
                keys: ['enter'],
                action: function () {
                    $.ajax({
                        type: "POST",
                        url: URLBase + reqPath ,
                        data: {id: el.attr('par1')},
                        //async: false,
                        dataType: "JSON",
                        beforeSend: function () {
                            App.blockUI({
                                target: '#datatable_ajax',
                                overlayColor: 'none',
                                cenrerY: true,
                                animate: true
                            });
                        },
                        complete: function () {
                            App.unblockUI('#datatable_ajax');
                        },
                        error: function (xhr, ajaxOptions, thrownError) {
                            $.alert({
                                title: Lang.Error,
                                content: xhr.status + " - " + thrownError,
                                type: 'red',
                                rtl: App.isRTL(),
                                closeIcon: true,
                                buttons: {
                                    cancel: {
                                        text: Lang.Ok,
                                        action: function () {
                                        }
                                    }
                                }
                            });
                        },
                        success: function (response)
                        {
                            if (response !== null && response.hasOwnProperty("Success")) {

                                //refresh table
                                var table = $('#datatable_ajax').DataTable();
                                table.ajax.reload();

                                var Res = response['Success'];
                                $.alert({
                                    title: Res.title,
                                    content: Res.content,
                                    autoClose: 'cancel|10000',
                                    type: 'green',
                                    rtl: App.isRTL(),
                                    closeIcon: true,
                                    buttons: {
                                        cancel: {
                                            text: Lang.Ok,
                                            action: function () {
                                            }
                                        }
                                    }
                                });

                            } else if (response !== null && response.hasOwnProperty("Errors")) {

                                //refresh table
                                var table = $('#datatable_ajax').DataTable();
                                table.ajax.reload();

                                var Error = response['Errors'];
                                $.alert({
                                    title: Error.title,
                                    content: Error.content,
                                    type: 'red',
                                    rtl: App.isRTL(),
                                    closeIcon: true,
                                    buttons: {
                                        cancel: {
                                            text: Lang.Ok,
                                            action: function () {
                                            }
                                        }
                                    }
                                });

                            }
                        }
                    });
                }
            },
            cancel: {
                text: el.attr('cancelButton'),
                keys: ['esc'],
                action: function () {
                }
            },
        }
    });
}

function DeleteItemAjaxFromDataTable(el,reqPath,data,datatable_id) {

    $.confirm({
        title: el.attr('Dtitle'),
        content: el.attr('Dcontent'),
        type: 'red',
        buttons: {
            confirm: {
                text: el.attr('confirmButton'),
                btnClass: 'btn-danger',
                keys: ['enter'],
                action: function () {
                    $.ajax({
                        type: "POST",
                        url: URLBase + reqPath ,
                        data: data,
                        //async: false,
                        dataType: "JSON",
                        beforeSend: function () {
                            App.blockUI({
                                target: datatable_id,
                                overlayColor: 'none',
                                cenrerY: true,
                                animate: true
                            });
                        },
                        complete: function () {
                            App.unblockUI(datatable_id);
                        },
                        error: function (xhr, ajaxOptions, thrownError) {
                            $.alert({
                                title: Lang.Error,
                                content: xhr.status + " - " + thrownError,
                                type: 'red',
                                rtl: App.isRTL(),
                                closeIcon: true,
                                buttons: {
                                    cancel: {
                                        text: Lang.Ok,
                                        action: function () {
                                        }
                                    }
                                }
                            });
                        },
                        success: function (response)
                        {
                            if (response !== null && response.hasOwnProperty("Success")) {

                                //refresh table
                                var table = $(datatable_id).DataTable();
                                table.ajax.reload();

                                var Res = response['Success'];
                                $.alert({
                                    title: Res.title,
                                    content: Res.content,
                                    autoClose: 'cancel|10000',
                                    type: 'green',
                                    rtl: App.isRTL(),
                                    closeIcon: true,
                                    buttons: {
                                        cancel: {
                                            text: Lang.Ok,
                                            action: function () {
                                            }
                                        }
                                    }
                                });

                            } else if (response !== null && response.hasOwnProperty("Errors")) {

                                //refresh table
                                var table = $(datatable_id).DataTable();
                                table.ajax.reload();

                                var Error = response['Errors'];
                                $.alert({
                                    title: Error.title,
                                    content: Error.content,
                                    type: 'red',
                                    rtl: App.isRTL(),
                                    closeIcon: true,
                                    buttons: {
                                        cancel: {
                                            text: Lang.Ok,
                                            action: function () {
                                            }
                                        }
                                    }
                                });

                            }
                        }
                    });
                }
            },
            cancel: {
                text: el.attr('cancelButton'),
                keys: ['esc'],
                action: function () {
                }
            },
        }
    });
}

