var UIExtendedModals = function () {
    
    var handleValidation3 = function () {
        // for more info visit the official plugin documentation: 
        // http://docs.jquery.com/Plugins/Validation

        var form3 = $('#SForm');
        var error3 = $('.alert-danger', form3);
        var success3 = $('.alert-success', form3);

        //IMPORTANT: update CKEDITOR textarea with actual content before submit
//        form3.on('submit', function () {
//            for (var instanceName in CKEDITOR.instances) {
//                CKEDITOR.instances[instanceName].updateElement();
//            }
//        })

        form3.validate({
            lang: Lang.theLang,
            errorElement: 'span', //default input error message container
            errorClass: 'help-block help-block-error', // default input error message class
            focusInvalid: false, // do not focus the last invalid input
            ignore: "", // validate all fields including form hidden input
            rules: {
                
                name_ar: {
                    required: true,
                    
                },
                name_en: {
                    required: true,
                    
                },
               
               
              
            },
            messages: {// custom messages for radio buttons and checkboxes

            },
            errorPlacement: function (error, element) { // render error placement for each input type
                if (element.parent(".input-group").size() > 0) {
                    error.insertAfter(element.parent(".input-group"));
                } else if (element.attr("data-error-container")) {
                    error.appendTo(element.attr("data-error-container"));
                } else if (element.parents('.radio-list').size() > 0) {
                    error.appendTo(element.parents('.radio-list').attr("data-error-container"));
                } else if (element.parents('.radio-inline').size() > 0) {
                    error.appendTo(element.parents('.radio-inline').attr("data-error-container"));
                } else if (element.parents('.checkbox-list').size() > 0) {
                    error.appendTo(element.parents('.checkbox-list').attr("data-error-container"));
                } else if (element.parents('.checkbox-inline').size() > 0) {
                    error.appendTo(element.parents('.checkbox-inline').attr("data-error-container"));
                } else {
                    error.insertAfter(element); // for other inputs, just perform default behavior
                }
            },
            invalidHandler: function (event, validator) { //display error alert on form submit   
                success3.hide();
                error3.show();
                App.scrollTo(error3, -200);
            },
            highlight: function (element) { // hightlight error inputs
                $(element)
                        .parent().addClass('has-error'); // set error class to the control group
            },
            unhighlight: function (element) { // revert the change done by hightlight
                $(element)
                        .parent().removeClass('has-error'); // set error class to the control group
            },
            success: function (label) {
                label
                        .parent().removeClass('has-error'); // set success class to the control group
            },
            submitHandler: function (form) {
                success3.show();
                error3.hide();

                //upload files
                var data = new FormData(form3[0]);
//                jQuery.each(jQuery('#file')[0].files, function (i, file) {
//                    data.append('file-' + i, file);
//                });
                data.append('par1', form3.attr("par1"));
                data.append('par2', form3.attr("par2"));
                data.append('cost_number', $('#cost_number').val());
                $.ajax({
                    type: "POST",
                    url: URLBase + "Accounting_Costcenter/ToDB",
                    data: data,
                    //async: false,
                    cache: false,
                    contentType: false,
                    processData: false,
                    dataType: "JSON",
                    beforeSend: function () {
                        $("#SForm :input").prop("disabled", true);
                        $("#submit-buttons").addClass('hidden');
                        $("#spinner").removeClass('hidden');
                        App.blockUI({
                            target: '#SForm',
                            overlayColor: 'none',
                            cenrerY: true,
                            animate: true
                        });
                    },
                    complete: function () {
                        $("#SForm :input").prop("disabled", false);
                        $("#submit-buttons").removeClass('hidden');
                        $("#spinner").addClass('hidden');
                        App.unblockUI('#SForm');
                    },
                    success: function (response)
                    {
                        if (response !== null && response.hasOwnProperty("Errors")) {
                            success3.hide();
                            //console.log(response['Errors']);
                            var obj = response["Errors"];
                            var stringerror = '';
                            for (var prop in obj) {
                                stringerror += '* ' + obj[prop] + '</br>';
                            }
                            $('#Server_alerts').html(stringerror);
                            $('.Server_alerts').removeClass('hidden');
                            $("html,body").animate({scrollTop: $('#Server_alerts').offset().top - 100}, "slow");

                        } else if (response !== null && response.hasOwnProperty("Success")) {
                            $('.Server_alerts').addClass('hidden');
                            $("#submit-buttons").remove();
                            var Res = response['Success'];
                            //UINotific8.init(Res.theme, Res.horizontalEdge, Res.verticalEdge, Res.heading, Res.life, Res.text);

                            setTimeout(function () {
                                window.location.replace(URLBase + "Accounting_Costcenter");
                            }, Res.life);
                        }
                    }
                });
                //form[0].submit(); // submit the form
            }

        });

        //apply validation on select2 dropdown value change, this only needed for chosen dropdown integration.
       
    }

    return {
        //main function to initiate the module
        init: function () {
            
            handleValidation3();


        }

    };

}();

jQuery(document).ready(function () {
    UIExtendedModals.init();
    $('#numbers').change(function(e){
        var selectoer = $(this);
        $.post(URLBase + "Accounting_Costcenter/GetCostDetails",{par1: selectoer.val()},function(data){
            data = $.parseJSON( data );
            $('#cost_number').val(data.Founded);
        })
    });
});