var TableAjaxAccStat = function () {


    var initPickers = function () {
        //init date pickers
        $(document).find('.date-picker').datepicker({
             format: 'yyyy-mm-dd',
            autoclose: true
        });
        console.log("initPickers");
    };
    var handleRecords1 = function (URL_ajax, Langarray, Ajax_URL_Short_Add) {

         var LngArr = {
            "metronicAjaxRequestGeneralError": Lang['Could_not_complete_request_Please_check_your_internet_connection'],
            "sProcessing": '...',
            "sLengthMenu": "&nbsp;&nbsp;&nbsp; " + Lang['Show'] + " _MENU_ " + Lang['entries'] + " &nbsp;&nbsp;&nbsp;",
            "sZeroRecords": Lang['No_matching_records_found'],
            "sInfo": Lang['Showing'] + " _START_ " + Lang['To'] + " _END_ " + Lang['of'] + " _TOTAL_ " + Lang['entries'],
            "sInfoEmpty": Lang['Showing'] + " 0 " + Lang['To'] + " 0 " + Lang['of'] + " 0 " + Lang['entries'],
            "sInfoFiltered": "(filtered from _MAX_ total entries)",
            "sInfoPostFix": "",
            "sSearch": "Search:",
            "emptyTable": Lang['No_matching_records_found'],
            "metronicGroupActions": "_TOTAL_ " + Lang['records_selected'] + ":",
            "paginate": {
                "previous": "Prev",
                "next": "Next",
                "last": "Last",
                "first": "First",
                "page": Lang['Page'],
                "pageOf": Lang['of']
            }
        };

        var grid = new Datatable();

        grid.init({
            src: $("#AccountStat"),
            onSuccess: function (grid) {
                // execute some code after table records loaded
            },
            onError: function (grid) {
                // execute some code on network or other general error  
            },
            onDataLoad: function (grid) {
                // execute some code on ajax data load
            },
            loadingMessage: '...',
            dataTable: {// here you can define a typical datatable settings from http://datatables.net/usage/options 
                "language": LngArr,
                // Uncomment below line("dom" parameter) to fix the dropdown overflow issue in the datatable cells. The default datatable layout
                // setup uses scrollable div(table-scrollable) with overflow:auto to enable vertical scroll(see: assets/global/scripts/datatable.js). 
                // So when dropdowns used the scrollable div should be removed. 
                //"dom": "<'row'<'col-md-8 col-sm-12'pli><'col-md-4 col-sm-12'<'table-group-actions pull-right'>>r>t<'row'<'col-md-8 col-sm-12'pli><'col-md-4 col-sm-12'>>",

                "bStateSave": false, // save datatable state(pagination, sort, etc) in cookie.
                "columnDefs": [
                    {
                        'orderable': false,
                        sClass: "text-center",
                        'targets': "_all"
                    },
                  
                 
                   
                   
                ],
                "lengthMenu": [
                    [10, 20, 50, 100, 150, -1],
                    [10, 20, 50, 100, 150, "All"] // change per page values here
                ],
                "pageLength": 10, // default record count per page
                
                "ajax": {
                 "url": URL_ajax// ajax source
                },
                "drawCallback": function(settings) {
               //do whatever
              console.log(settings.json.recordsTotal);
              $('.TotalNumber').html(settings.json.recordsTotal);
              $('.prev_balance').html(settings.json.prev_balance);
              $('.Current_Blnc').html(settings.json.Current_Blnc);
              $('.TotDebit').html(settings.json.TotDebit);
              $('.TotCredit').html(settings.json.TotCredit);
              $('.movement_balance').html(settings.json.TotDebit-settings.json.TotCredit);
                 },
                "order": [
                    [0, "desc"]
                ]// set first column as a default sort by asc
            }
        });

        // handle group actionsubmit button click
        grid.getTableWrapper().on('click', '.table-group-action-submit', function (e) {
            e.preventDefault();
            var action = $(".table-group-action-input", grid.getTableWrapper());
            if (action.val() !== "" && grid.getSelectedRowsCount() > 0) {
                grid.setAjaxParam("customActionType", "group_action");
                grid.setAjaxParam("customActionName", action.val());
                grid.setAjaxParam("id", grid.getSelectedRows());
                grid.getDataTable().ajax.reload();
                grid.clearAjaxParams();
            } else if (action.val() === "") {
                Metronic.alert({
                    type: 'danger',
                    icon: 'warning',
                    message: Langarray['Please_select_an_action'],
                    container: grid.getTableWrapper(),
                    place: 'prepend'
                });
            } else if (grid.getSelectedRowsCount() === 0) {
                Metronic.alert({
                    type: 'danger',
                    icon: 'warning',
                    message: Langarray['No_record_selected'],
                    container: grid.getTableWrapper(),
                    place: 'prepend'
                });
            }
        });



    };

    return {
        //main function to initiate the module
        init: function (URL_ajax, Langarray, Ajax_URL_Short_Add) {

            handleRecords1(URL_ajax, Langarray, Ajax_URL_Short_Add);
            
        }

    };

}();

jQuery(document).ready(function () {
    
    TableAjaxAccStat.init();
    
});