var FormImageCrop = function () {


    var demo8 = function () {
        var jcrop_api,
                boundx,
                boundy,
                // Grab some information about the preview pane
                $preview = $('#preview-pane'),
                $pcnt = $('#preview-pane .preview-container'),
                $pimg = $('#preview-pane .preview-container img'),
                xsize = $pcnt.width(),
                ysize = $pcnt.height();

        console.log('init', [xsize, ysize]);

        $('#demo8').Jcrop({
            onChange: updateCoords,
            aspectRatio: 1,
            onSelect: updateCoords,
            boxWidth: 400,
            boxHeight: 400,
            bgColor: ''

        }, function () {
            // Use the API to get the real image size
            var bounds = this.getBounds();
            boundx = bounds[0];
            boundy = bounds[1];
            // Store the API in the jcrop_api variable
            jcrop_api = this;
            // Move the preview into the jcrop container for css positioning
            $preview.appendTo(jcrop_api.ui.holder);
        });

        function updateCoords(coords)
        {
            $('#crop_x').val(coords.x);
            $('#crop_y').val(coords.y);
            $('#crop_w').val(coords.w);
            $('#crop_h').val(coords.h);

            //Start Preview

            if (parseInt(coords.w) > 0)
            {
                var rx = xsize / coords.w;
                var ry = ysize / coords.h;

                $pimg.css({
                    width: Math.round(rx * boundx) + 'px',
                    height: Math.round(ry * boundy) + 'px',
                    marginLeft: '-' + Math.round(rx * coords.x) + 'px',
                    marginTop: '-' + Math.round(ry * coords.y) + 'px'
                });
            }
        }
        ;

        // for more info visit the official plugin documentation: 
        // http://docs.jquery.com/Plugins/Validation

        var form3 = $('#CropForm');

        form3.validate({
            submitHandler: function (form) {
                var data = new FormData(form3[0]);
                $.ajax({
                    type: "POST",
                    url: URLBase + "Cropimage/DoCrop",
                    data: data,
                    //async: false,
                    cache: false,
                    contentType: false,
                    processData: false,
                    dataType: "JSON",
                    beforeSend: function () {
                        $.blockUI({
                            message: Lang.Please_wait,
                            css: {
                                border: 'none',
                                padding: '15px',
                                backgroundColor: '#000',
                                '-webkit-border-radius': '10px',
                                '-moz-border-radius': '10px',
                                opacity: .5,
                                color: '#fff'
                            }});
                    },
                    complete: function () {
                        $.unblockUI();
                    },
                    success: function (response)
                    {


                        if (response !== null && response.hasOwnProperty("Resp")) {
                            $('.Server_alerts').addClass('hidden');
                            $("#submit-buttons").remove();
                            var Res = response['Resp'];
                            Lobibox.notify(Res.theme, {
                                soundPath: URLBase + 'assets/site/vendor/jquery-notification/sounds/',
                                size: Res.size,
                                delay: Res.delay,
                                title: Res.heading,
                                msg: Res.text,
                            });

                            setTimeout(function () {
                                window.location.replace(response['Redirect']);
                            }, 3000);
                        }
                    }
                });
                //form[0].submit(); // submit the form
            }

        });


    }

    var handleResponsive = function () {
        if ($(window).width() <= 1024 && $(window).width() >= 678) {
            $('.responsive-1024').each(function () {
                $(this).attr("data-class", $(this).attr("class"));
                $(this).attr("class", 'responsive-1024 col-md-12');
            });
        } else {
            $('.responsive-1024').each(function () {
                if ($(this).attr("data-class")) {
                    $(this).attr("class", $(this).attr("data-class"));
                    $(this).removeAttr("data-class");
                }
            });
        }
    }

    return {
        //main function to initiate the module
        init: function () {

            if (!jQuery().Jcrop) {
                ;
                return;
            }

            //App.addResizeHandler(handleResponsive);
            handleResponsive();

            demo8();
        }

    };

}();

jQuery(document).ready(function () {
    FormImageCrop.init();
});