

var DatatablesAjax = function () {

    var initPickers = function () {
        //init date pickers
        $('.date-picker').datepicker({
            rtl: App.isRTL(),
            autoclose: true
        });
    };

    var handleRecords = function () {
        var LngArr = {
            "metronicAjaxRequestGeneralError": Lang['Could_not_complete_request_Please_check_your_internet_connection'],
            "sProcessing": Lang['Please_wait'],
            "sLengthMenu": "&nbsp;&nbsp;&nbsp; " + Lang['Show'] + " _MENU_ " + Lang['entries'] + " &nbsp;&nbsp;&nbsp;",
            "sZeroRecords": Lang['No_matching_records_found'],
            "sInfo": Lang['Showing'] + " _START_ " + Lang['To'] + " _END_ " + Lang['of'] + " _TOTAL_ " + Lang['entries'],
            "sInfoEmpty": Lang['Showing'] + " 0 " + Lang['To'] + " 0 " + Lang['of'] + " 0 " + Lang['entries'],
            "sInfoFiltered": "(filtered from _MAX_ total entries)",
            "sInfoPostFix": "",
            "sSearch": "Search:",
            "emptyTable": Lang['No_matching_records_found'],
            "metronicGroupActions": "_TOTAL_ " + Lang['records_selected'] + ":",
            "paginate": {
                "previous": "Prev",
                "next": "Next",
                "last": "Last",
                "first": "First",
                "page": Lang['Page'],
                "pageOf": Lang['of']
            }
        };
        var grid = new Datatable();

        grid.init({
            src: $("#datatable_ajax"),
            onSuccess: function (grid, response) {
                // grid:        grid object
                // response:    json object of server side ajax response
                // execute some code after table records loaded
            },
            onError: function (grid) {
                // execute some code on network or other general error  
            },
            onDataLoad: function (grid) {
                // execute some code on ajax data load
            },
            loadingMessage: Lang.Please_wait,
            dataTable: {// here you can define a typical datatable settings from http://datatables.net/usage/options 
                "language": LngArr,
                // Uncomment below line("dom" parameter) to fix the dropdown overflow issue in the datatable cells. The default datatable layout
                // setup uses scrollable div(table-scrollable) with overflow:auto to enable vertical scroll(see: assets/global/scripts/datatable.js). 
                // So when dropdowns used the scrollable div should be removed. 
                //"dom": "<'row'<'col-md-8 col-sm-12'pli><'col-md-4 col-sm-12'<'table-group-actions pull-right'>>r>t<'row'<'col-md-8 col-sm-12'pli><'col-md-4 col-sm-12'>>",

                "bStateSave": true, // save datatable state(pagination, sort, etc) in cookie.

                "lengthMenu": [
                    [10, 20, 50, 100, 150, -1],
                    [10, 20, 50, 100, 150, "All"] // change per page values here
                ],
                "pageLength": 10, // default record count per page
                "ajax": {
                    "url": URLBase + "acceptinbox/GetData", // ajax source
                },
                "order": [
                    [1, "desc"]
                ], // set first column as a default sort by asc
                "columnDefs": [
                    {
                        'orderable': false,
                        sClass: "text-center",
                        'targets': [0]
                    },
                    {
                        'orderable': false,
                        sClass: "text-center",
                        'targets': [1]
                    },
                    {
                        'orderable': false,
                        sClass: "text-center",
                        'targets': [2]
                    },
                    {
                        'orderable': false,
                        sClass: "text-center",
                        'targets': [3]
                    },
                    {
                        'orderable': false,
                        sClass: "text-center",
                        'targets': [4]
                    },
                    {
                        'orderable': false,
                        sClass: "text-center",
                        'targets': [5]
                    },
                    {
                        'orderable': false,
                        sClass: "text-center",
                        'targets': [6]
                    },
                    
                    
                ]
            }
        });

        // handle group actionsubmit button click
        grid.getTableWrapper().on('click', '.table-group-action-submit', function (e) {
            e.preventDefault();
            var action = $(".table-group-action-input", grid.getTableWrapper());
            if (action.val() !== "" && grid.getSelectedRowsCount() > 0) {
                grid.setAjaxParam("customActionType", "group_action");
                grid.setAjaxParam("customActionName", action.val());
                grid.setAjaxParam("id", grid.getSelectedRows());
                grid.getDataTable().ajax.reload();
                grid.clearAjaxParams();
                //refresh table
                var table = $('#datatable_ajax').DataTable();
                table.ajax.reload();
            } else if (action.val() === "") {
                App.alert({
                    type: 'danger',
                    icon: 'warning',
                    message: Lang['Please_select_an_action'],
                    container: grid.getTableWrapper(),
                    place: 'prepend'
                });
            } else if (grid.getSelectedRowsCount() === 0) {
                App.alert({
                    type: 'danger',
                    icon: 'warning',
                    message: Lang['No_record_selected'],
                    container: grid.getTableWrapper(),
                    place: 'prepend'
                });
            }
        });

        grid.setAjaxParam("customActionType", "group_action");
        // grid.getDataTable().ajax.reload();
        grid.clearAjaxParams();
    }

    return {
        //main function to initiate the module
        init: function () {

            initPickers();
            handleRecords();
        }

    };

}();
var Admission_Applications = function () {
    var PageMethods = function () {
        $(document).on('click', '.Delete', function () {
            var el = $(this);
            DeleteItemAjax(el, "6/Delete");

        });

    }

    return {
        //main function to initiate the module
        init: function () {
            PageMethods();



        }

    };

}();
var Approve = function(){
    console.log('Approve');
    $.post(URLBase + "acceptinbox/ToDB",{"part1":
                $(document).find('#accept_to_redirect').attr("part1")
        ,"target":
                $(document).find('.select2me').val()
    },function(response){
        response = JSON.parse(response);
        if (response !== null && response.hasOwnProperty("Errors")) {
                            //console.log(response['Errors']);
                            $('#Server_alerts').html(response["Errors"]);
                            $('.Server_alerts').removeClass('hidden');

                        } else if (response !== null && response.hasOwnProperty("Success")) {
                            $('.Server_alerts').addClass('hidden');

                            $('#Level1').modal('toggle');

                            $.alert({
                                title: response.Success.title,
                                content: response.Success.content,
                                type: 'green',
                                rtl: App.isRTL(),
                                closeIcon: true,
                                buttons: {
                                    cancel: {
                                        text: Lang.Ok,
                                        action: function () {
                                        }
                                    }
                                }
                            });
                        }
    });
    
    
    
};
var ViewDetails = function () {
        // general settings
        $.fn.modal.defaults.spinner = $.fn.modalmanager.defaults.spinner =
                '<div class="loading-spinner" style="width: 200px; margin-left: -100px;">' +
                '<div class="progress progress-striped active">' +
                '<div class="progress-bar" style="width: 100%;"></div>' +
                '</div>' +
                '</div>';

        $.fn.modalmanager.defaults.resize = true;

        //ajax demo:
        var $modal = $('#Level1');

        $(document).on('click', '.ViewD', function () {
            // create the backdrop and wait for next modal to be triggered
            $('body').modalmanager('loading');
            var el = $(this);

            setTimeout(function () {
                $modal.load(el.attr('data-url'), '', function () {
                    $modal.modal();
                    App.initAjax();

   $(document).find('#accept_to_redirect').on('click',function(){
 
       Approve();
       
   });
                });
            }, 1000);
        });

        $(document).on('click', '.Deputy', function () {
            // create the backdrop and wait for next modal to be triggered
            $('body').modalmanager('loading');
            var el = $(this);

            setTimeout(function () {
                $modal.load(URLBase + 'Acceptinbox/details', '', function () {
                    $modal.modal();
                    App.initAjax();
                 
                });
            }, 1000);
        });
        
        
    };
jQuery(document).ready(function () {
    Admission_Applications.init();
    DatatablesAjax.init();
   ViewDetails();
   
});