var TableDatatablesAjax = function () {
    var initPickers = function () {

        //init date pickers
        $('.date-picker').datepicker({
            rtl: App.isRTL(),
            autoclose: true
        });
    };


    var handleRecords = function () {


        var LngArr = {
            "metronicAjaxRequestGeneralError": Lang['Could_not_complete_request_Please_check_your_internet_connection'],
            "sProcessing": Lang['Please_wait'],
            "sLengthMenu": "&nbsp;&nbsp;&nbsp; " + Lang['Show'] + " _MENU_ " + Lang['entries'] + " &nbsp;&nbsp;&nbsp;",
            "sZeroRecords": Lang['No_matching_records_found'],
            "sInfo": Lang['Showing'] + " _START_ " + Lang['To'] + " _END_ " + Lang['of'] + " _TOTAL_ " + Lang['entries'],
            "sInfoEmpty": Lang['Showing'] + " 0 " + Lang['To'] + " 0 " + Lang['of'] + " 0 " + Lang['entries'],
            "sInfoFiltered": "(filtered from _MAX_ total entries)",
            "sInfoPostFix": "",
            "sSearch": "Search:",
            "emptyTable": Lang['No_matching_records_found'],
            "metronicGroupActions": "_TOTAL_ " + Lang['records_selected'] + ":",
            "paginate": {
                "previous": "Prev",
                "next": "Next",
                "last": "Last",
                "first": "First",
                "page": Lang['Page'],
                "pageOf": Lang['of']
            }
        };


        var grid = new Datatable();

        grid.init({
            src: $("#datatable_ajax"),
            onSuccess: function (grid, response) {
                // grid:        grid object
                // response:    json object of server side ajax response
                // execute some code after table records loaded
                if (response !== null && response.hasOwnProperty("TableFoot")) {
                    $("#TFoot").html(response.TableFoot);
                }

                if (response !== null && response.hasOwnProperty("recordsTotal") && (response.recordsTotal > 0)) {
                    $('.table-container').removeClass('hidden');
                }

            },
            onError: function (grid) {
                // execute some code on network or other general error  
            },
            onDataLoad: function (grid) {
                // execute some code on ajax data load
            },
            loadingMessage: Lang.Please_wait,
            dataTable: {// here you can define a typical datatable settings from http://datatables.net/usage/options 
                "language": LngArr,
                // Uncomment below line("dom" parameter) to fix the dropdown overflow issue in the datatable cells. The default datatable layout
                // setup uses scrollable div(table-scrollable) with overflow:auto to enable vertical scroll(see: assets/global/scripts/datatable.js). 
                // So when dropdowns used the scrollable div should be removed. 
                //"dom": "<'row'<'col-md-8 col-sm-12'pli><'col-md-4 col-sm-12'<'table-group-actions pull-right'>>r>t<'row'<'col-md-8 col-sm-12'pli><'col-md-4 col-sm-12'>>",
                "bPaginate": false,
                "bLengthChange": false,
                "bFilter": true,
                "bStateSave": false, // save datatable state(pagination, sort, etc) in cookie.


                "lengthMenu": [
                    [-1],
                    ["All"] // change per page values here
                ],
                "pageLength": -1, // default record count per page
                "ajax": {
                    "url": URLBase + "Accounting_Salaries/GetData", // ajax source
                },
                "order": [
                    [2, "desc"]
                ], // set first column as a default sort by asc
                "columnDefs": [
                    {
                        'orderable': false,
                        sClass: "text-center VM",
                        'targets': "_all",

                    },
                ],
            }
        });

        $(document).on('click', '.filter-submit', function (e) {
            e.preventDefault();
            grid.UpdateFilterAllDoc(); //لتحديث الفلاتر من كل الجدول
            grid.getthe().submitFilter();

        });
        $(document).on('click', '.print', function (e) {
            e.preventDefault();
            console.log(".print");
            $('#theForm').attr({"action":URLBase + "Print/Salaries"});
            $('#theForm').submit();
            
            //grid.UpdateFilterAllDoc(); //لتحديث الفلاتر من كل الجدول
            //grid.getthe().submitFilter();

        });
        // handle filter cancel button click
        $(document).on('click', '.filter-cancel', function (e) {
            e.preventDefault();
            grid.getthe().resetFilterAllDocument();
        });

        $(document).on('click', '.action-submit', function (e) {
            e.preventDefault();
            var action = $(".action-submit", $(document));
            console.log("ewew");
            if (action.attr("action") !== "" && grid.getSelectedRowsCount() > 0) {
                if (action.attr("action") === "Post_Salaries") {
                    //        grid.setAjaxParam("CalActionType", "CalActions");
                    //        grid.setAjaxParam("ActionName", action.attr("action"));
                    //        grid.setAjaxParam("id", grid.getSelectedRows());
                    //
                    //        grid.getDataTable().ajax.reload();
                    //        grid.clearAjaxParams();
                    grid.UpdateFilterAllDoc(); // لتحديث مصفوفة البيانات من الحقول المختارة
                    var el = $(this);
                    var Parms = grid.getajaxParams();

                    var month = '';
                    var year = '';

                    if ('month' in Parms) {
                        month = Parms.month;
                    }
                    if ('year' in Parms) {
                        year = Parms.year;
                    }
                    if (year !== '' && month !== '') {
                        var a = $.confirm({
                            title: el.attr('Dtitle'),
                            animation: 'scale',
                            boxWidth: '80%',
                            closeAnimation: 'scale',
                            useBootstrap: false,

                            content: function () {
                                var self = this;

                                return $.ajax({
                                    url: URLBase + "Accounting_Salaries/Post_Salaries_Confirmation",
                                    dataType: 'json',
                                    method: 'POST',
                                    data: {ids: grid.getSelectedRows(), ajaxParams: Parms}
                                }).done(function (response) {
                                    if (response !== null && response.hasOwnProperty("Success")) {
                                        var Response = response.Success;
                                        self.setContentAppend('<p>' + Response.Text + '</p>');
                                        if (Response.PostButton === false) {
                                            a.buttons.Post.hide();
                                        }
                                    } else if (response !== null && response.hasOwnProperty("Error")) {
                                        a.close();
                                        Error = response.Error;
                                        $.alert({
                                            type: 'orange',
                                            title: Error.Title,
                                            content: Error.Content,
                                            buttons: {
                                                cancel: {
                                                    text: Lang.Ok,
                                                    action: function () {
                                                    }
                                                }

                                            }
                                        });
                                    }
                                }).fail(function () {
                                    self.setContentAppend('<div>Fail!</div>');
                                }).always(function () {

                                    //self.setContentAppend('<div>Always!</div>');
                                });
                            },
                            contentLoaded: function (data, status, xhr) {
                                //var self = this;
                                //self.setContentAppend('<div>Content loaded!</div>');
                            },
                            onContentReady: function () {
                                //this.setContentAppend('<div>Content ready!</div>');
                            },
                            buttons: {

                                Post: {
                                    btnClass: 'btn-green',
                                    text: el.attr('PostButton'),
                                    action: function () {
                                        $.ajax({
                                            url: URLBase + "Accounting_Salaries/Post_Salaries",
                                            dataType: 'json',
                                            method: 'POST',
                                            data: {ids: grid.getSelectedRows(), ajaxParams: Parms}
                                        }).done(function (response) {
                                            if (response !== null && response.hasOwnProperty("Errors")) {
                                                a.close();
                                                Errors = response.Errors;
                                                $.alert({
                                                    type: 'orange',
                                                    title: Errors.title,
                                                    content: Errors.content,
                                                    buttons: {
                                                        cancel: {
                                                            text: Lang.Ok,
                                                            action: function () {
                                                            }
                                                        }

                                                    }
                                                });
                                            } else if (response !== null && response.hasOwnProperty("Success")) {
                                                response = response.Success;
                                                $.alert({
                                                    type: 'green',
                                                    title: response.title,
                                                    content: response.content,
                                                    buttons: {
                                                        cancel: {
                                                            text: Lang.Ok,
                                                            action: function () {
                                                            }
                                                        }

                                                    }
                                                });
                                            }
                                        }).fail(function () {
                                            //self.setContentAppend('<div>Fail!</div>');
                                        }).always(function () {
                                            //self.setContentAppend('<div>Always!</div>');
                                        });
                                    }
                                },
                                cancel: {
                                    text: Lang.Cancel,
                                    action: function () {
                                    }
                                }
                            }
                        });
                    } else {
                        $.alert({
                            type: 'orange',
                            title: Lang.Alert,
                            content: el.attr('NoDate'),
                            buttons: {
                                cancel: {
                                    text: Lang.Ok,
                                    action: function () {
                                    }
                                }

                            }
                        });
                    }


                }
            } else if (action.attr("action") === "") {
                App.alert({
                    type: 'danger',
                    icon: 'warning',
                    message: Lang['Please_select_an_action'],
                    container: grid.getTableWrapper(),
                    place: 'prepend'
                });
            } else if (grid.getSelectedRowsCount() === 0) {
                App.alert({
                    type: 'danger',
                    icon: 'warning',
                    message: Lang['No_record_selected'],
                    container: grid.getTableWrapper(),
                    place: 'prepend'
                });
            }
        });

        grid.setAjaxParam("customActionType", "group_action");
        // grid.getDataTable().ajax.reload();
        grid.clearAjaxParams();

    }

    return {
        //main function to initiate the module
        init: function () {

            initPickers();
            handleRecords();
        }

    };

}();
var UIExtendedModals = function () {
    var PageMethods = function () {

        $(document).on('click', '.explain_salary', function () {
            var el = $(this);
            var a = $.confirm({
                title: false,
                animation: 'scale',
                boxWidth: '80%',
                closeAnimation: 'scale',
                useBootstrap: false,

                content: function () {
                    var self = this;

                    return $.ajax({
                        url: URLBase + "Accounting_Salaries/Explain_Salarie",
                        dataType: 'json',
                        method: 'POST',
                        data: {employee: el.attr('employee'), year: el.attr('year'), month: el.attr('month')}
                    }).done(function (response) {
                        if (response !== null && response.hasOwnProperty("Success")) {
                            var Response = response.Success;
                            self.setContentPrepend('<h4>' + Response.title + '</h4>');
                            self.setContentAppend('<p>' + Response.content + '</p>');

                        } else if (response !== null && response.hasOwnProperty("Error")) {
                            a.close();
                            Error = response.Error;
                            $.alert({
                                type: 'red',
                                title: Error.title,
                                content: Error.content,
                                buttons: {
                                    cancel: {
                                        text: Lang.Ok,
                                        action: function () {
                                        }
                                    }

                                }
                            });
                        }
                    }).fail(function () {
                        self.setContentAppend('<div>Fail!</div>');
                    }).always(function () {

                        //self.setContentAppend('<div>Always!</div>');
                    });
                },
                contentLoaded: function (data, status, xhr) {
                    //var self = this;
                    //self.setContentAppend('<div>Content loaded!</div>');
                },
                onContentReady: function () {
                    //this.setContentAppend('<div>Content ready!</div>');
                },
                buttons: {

                    cancel: {
                        text: Lang.Cancel,
                        action: function () {
                        }
                    }
                }
            });

        });

    }

    return {
        //main function to initiate the module
        init: function () {
            PageMethods();



        }

    };

}();

jQuery(document).ready(function () {
    UIExtendedModals.init();
    TableDatatablesAjax.init();
});